# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetControlsResult',
    'AwaitableGetControlsResult',
    'get_controls',
    'get_controls_output',
]

@pulumi.output_type
class GetControlsResult:
    """
    A collection of values returned by getControls.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, operator_control_collections=None, resource_type=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if operator_control_collections and not isinstance(operator_control_collections, list):
            raise TypeError("Expected argument 'operator_control_collections' to be a list")
        pulumi.set(__self__, "operator_control_collections", operator_control_collections)
        if resource_type and not isinstance(resource_type, str):
            raise TypeError("Expected argument 'resource_type' to be a str")
        pulumi.set(__self__, "resource_type", resource_type)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment that contains the operator control.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetControlsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="operatorControlCollections")
    def operator_control_collections(self) -> Sequence['outputs.GetControlsOperatorControlCollectionResult']:
        """
        The list of operator_control_collection.
        """
        return pulumi.get(self, "operator_control_collections")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[_builtins.str]:
        """
        resourceType for which the OperatorControl is applicable
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current lifecycle state of the operator control.
        """
        return pulumi.get(self, "state")


class AwaitableGetControlsResult(GetControlsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetControlsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            operator_control_collections=self.operator_control_collections,
            resource_type=self.resource_type,
            state=self.state)


def get_controls(compartment_id: Optional[_builtins.str] = None,
                 display_name: Optional[_builtins.str] = None,
                 filters: Optional[Sequence[Union['GetControlsFilterArgs', 'GetControlsFilterArgsDict']]] = None,
                 resource_type: Optional[_builtins.str] = None,
                 state: Optional[_builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetControlsResult:
    """
    This data source provides the list of Operator Controls in Oracle Cloud Infrastructure Operator Access Control service.

    Lists the operator controls in the compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_operator_controls = oci.OperatorAccessControl.get_controls(compartment_id=compartment_id,
        display_name=operator_control_display_name,
        resource_type=operator_control_resource_type,
        state=operator_control_state)
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param _builtins.str display_name: A filter to return OperatorControl that match the entire display name given.
    :param _builtins.str resource_type: A filter to return only lists of resources that match the entire given service type.
    :param _builtins.str state: A filter to return only resources whose lifecycleState matches the given OperatorControl lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['resourceType'] = resource_type
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OperatorAccessControl/getControls:getControls', __args__, opts=opts, typ=GetControlsResult).value

    return AwaitableGetControlsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        operator_control_collections=pulumi.get(__ret__, 'operator_control_collections'),
        resource_type=pulumi.get(__ret__, 'resource_type'),
        state=pulumi.get(__ret__, 'state'))
def get_controls_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                        display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        filters: Optional[pulumi.Input[Optional[Sequence[Union['GetControlsFilterArgs', 'GetControlsFilterArgsDict']]]]] = None,
                        resource_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetControlsResult]:
    """
    This data source provides the list of Operator Controls in Oracle Cloud Infrastructure Operator Access Control service.

    Lists the operator controls in the compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_operator_controls = oci.OperatorAccessControl.get_controls(compartment_id=compartment_id,
        display_name=operator_control_display_name,
        resource_type=operator_control_resource_type,
        state=operator_control_state)
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param _builtins.str display_name: A filter to return OperatorControl that match the entire display name given.
    :param _builtins.str resource_type: A filter to return only lists of resources that match the entire given service type.
    :param _builtins.str state: A filter to return only resources whose lifecycleState matches the given OperatorControl lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['resourceType'] = resource_type
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:OperatorAccessControl/getControls:getControls', __args__, opts=opts, typ=GetControlsResult)
    return __ret__.apply(lambda __response__: GetControlsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        operator_control_collections=pulumi.get(__response__, 'operator_control_collections'),
        resource_type=pulumi.get(__response__, 'resource_type'),
        state=pulumi.get(__response__, 'state')))
