# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetHostInsightsResult',
    'AwaitableGetHostInsightsResult',
    'get_host_insights',
    'get_host_insights_output',
]

@pulumi.output_type
class GetHostInsightsResult:
    """
    A collection of values returned by getHostInsights.
    """
    def __init__(__self__, compartment_id=None, compartment_id_in_subtree=None, enterprise_manager_bridge_id=None, exadata_insight_id=None, filters=None, host_insight_summary_collections=None, host_types=None, id=None, states=None, statuses=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if enterprise_manager_bridge_id and not isinstance(enterprise_manager_bridge_id, str):
            raise TypeError("Expected argument 'enterprise_manager_bridge_id' to be a str")
        pulumi.set(__self__, "enterprise_manager_bridge_id", enterprise_manager_bridge_id)
        if exadata_insight_id and not isinstance(exadata_insight_id, str):
            raise TypeError("Expected argument 'exadata_insight_id' to be a str")
        pulumi.set(__self__, "exadata_insight_id", exadata_insight_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if host_insight_summary_collections and not isinstance(host_insight_summary_collections, list):
            raise TypeError("Expected argument 'host_insight_summary_collections' to be a list")
        pulumi.set(__self__, "host_insight_summary_collections", host_insight_summary_collections)
        if host_types and not isinstance(host_types, list):
            raise TypeError("Expected argument 'host_types' to be a list")
        pulumi.set(__self__, "host_types", host_types)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if states and not isinstance(states, list):
            raise TypeError("Expected argument 'states' to be a list")
        pulumi.set(__self__, "states", states)
        if statuses and not isinstance(statuses, list):
            raise TypeError("Expected argument 'statuses' to be a list")
        pulumi.set(__self__, "statuses", statuses)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @_builtins.property
    @pulumi.getter(name="enterpriseManagerBridgeId")
    def enterprise_manager_bridge_id(self) -> Optional[_builtins.str]:
        """
        OPSI Enterprise Manager Bridge OCID
        """
        return pulumi.get(self, "enterprise_manager_bridge_id")

    @_builtins.property
    @pulumi.getter(name="exadataInsightId")
    def exadata_insight_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata insight.
        """
        return pulumi.get(self, "exadata_insight_id")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetHostInsightsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter(name="hostInsightSummaryCollections")
    def host_insight_summary_collections(self) -> Sequence['outputs.GetHostInsightsHostInsightSummaryCollectionResult']:
        """
        The list of host_insight_summary_collection.
        """
        return pulumi.get(self, "host_insight_summary_collections")

    @_builtins.property
    @pulumi.getter(name="hostTypes")
    def host_types(self) -> Optional[Sequence[_builtins.str]]:
        """
        Ops Insights internal representation of the host type. Possible value is EXTERNAL-HOST.
        """
        return pulumi.get(self, "host_types")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the host insight resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def states(self) -> Optional[Sequence[_builtins.str]]:
        """
        The current state of the host.
        """
        return pulumi.get(self, "states")

    @_builtins.property
    @pulumi.getter
    def statuses(self) -> Optional[Sequence[_builtins.str]]:
        """
        Indicates the status of a host insight in Operations Insights
        """
        return pulumi.get(self, "statuses")


class AwaitableGetHostInsightsResult(GetHostInsightsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetHostInsightsResult(
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            enterprise_manager_bridge_id=self.enterprise_manager_bridge_id,
            exadata_insight_id=self.exadata_insight_id,
            filters=self.filters,
            host_insight_summary_collections=self.host_insight_summary_collections,
            host_types=self.host_types,
            id=self.id,
            states=self.states,
            statuses=self.statuses)


def get_host_insights(compartment_id: Optional[_builtins.str] = None,
                      compartment_id_in_subtree: Optional[_builtins.bool] = None,
                      enterprise_manager_bridge_id: Optional[_builtins.str] = None,
                      exadata_insight_id: Optional[_builtins.str] = None,
                      filters: Optional[Sequence[Union['GetHostInsightsFilterArgs', 'GetHostInsightsFilterArgsDict']]] = None,
                      host_types: Optional[Sequence[_builtins.str]] = None,
                      id: Optional[_builtins.str] = None,
                      states: Optional[Sequence[_builtins.str]] = None,
                      statuses: Optional[Sequence[_builtins.str]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetHostInsightsResult:
    """
    This data source provides the list of Host Insights in Oracle Cloud Infrastructure Opsi service.

    Gets a list of host insights based on the query parameters specified. Either compartmentId or id query parameter must be specified.
    When both compartmentId and compartmentIdInSubtree are specified, a list of host insights in that compartment and in all sub-compartments will be returned.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_host_insights = oci.Opsi.get_host_insights(compartment_id=compartment_id,
        compartment_id_in_subtree=host_insight_compartment_id_in_subtree,
        enterprise_manager_bridge_id=test_enterprise_manager_bridge["id"],
        exadata_insight_id=test_exadata_insight["id"],
        host_types=host_insight_host_type,
        id=host_insight_id,
        states=host_insight_state,
        statuses=host_insight_status)
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.bool compartment_id_in_subtree: A flag to search all resources within a given compartment and all sub-compartments.
    :param _builtins.str enterprise_manager_bridge_id: Unique Enterprise Manager bridge identifier
    :param _builtins.str exadata_insight_id: [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of exadata insight resource.
    :param Sequence[_builtins.str] host_types: Filter by one or more host types. Possible values are CLOUD-HOST, EXTERNAL-HOST, COMANAGED-VM-HOST, COMANAGED-BM-HOST, COMANAGED-EXACS-HOST, COMANAGED-EXACC-HOST
    :param _builtins.str id: Optional list of host insight resource [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param Sequence[_builtins.str] states: Lifecycle states
    :param Sequence[_builtins.str] statuses: Resource Status
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['enterpriseManagerBridgeId'] = enterprise_manager_bridge_id
    __args__['exadataInsightId'] = exadata_insight_id
    __args__['filters'] = filters
    __args__['hostTypes'] = host_types
    __args__['id'] = id
    __args__['states'] = states
    __args__['statuses'] = statuses
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Opsi/getHostInsights:getHostInsights', __args__, opts=opts, typ=GetHostInsightsResult).value

    return AwaitableGetHostInsightsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        enterprise_manager_bridge_id=pulumi.get(__ret__, 'enterprise_manager_bridge_id'),
        exadata_insight_id=pulumi.get(__ret__, 'exadata_insight_id'),
        filters=pulumi.get(__ret__, 'filters'),
        host_insight_summary_collections=pulumi.get(__ret__, 'host_insight_summary_collections'),
        host_types=pulumi.get(__ret__, 'host_types'),
        id=pulumi.get(__ret__, 'id'),
        states=pulumi.get(__ret__, 'states'),
        statuses=pulumi.get(__ret__, 'statuses'))
def get_host_insights_output(compartment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             compartment_id_in_subtree: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                             enterprise_manager_bridge_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             exadata_insight_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             filters: Optional[pulumi.Input[Optional[Sequence[Union['GetHostInsightsFilterArgs', 'GetHostInsightsFilterArgsDict']]]]] = None,
                             host_types: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                             id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             states: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                             statuses: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetHostInsightsResult]:
    """
    This data source provides the list of Host Insights in Oracle Cloud Infrastructure Opsi service.

    Gets a list of host insights based on the query parameters specified. Either compartmentId or id query parameter must be specified.
    When both compartmentId and compartmentIdInSubtree are specified, a list of host insights in that compartment and in all sub-compartments will be returned.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_host_insights = oci.Opsi.get_host_insights(compartment_id=compartment_id,
        compartment_id_in_subtree=host_insight_compartment_id_in_subtree,
        enterprise_manager_bridge_id=test_enterprise_manager_bridge["id"],
        exadata_insight_id=test_exadata_insight["id"],
        host_types=host_insight_host_type,
        id=host_insight_id,
        states=host_insight_state,
        statuses=host_insight_status)
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.bool compartment_id_in_subtree: A flag to search all resources within a given compartment and all sub-compartments.
    :param _builtins.str enterprise_manager_bridge_id: Unique Enterprise Manager bridge identifier
    :param _builtins.str exadata_insight_id: [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of exadata insight resource.
    :param Sequence[_builtins.str] host_types: Filter by one or more host types. Possible values are CLOUD-HOST, EXTERNAL-HOST, COMANAGED-VM-HOST, COMANAGED-BM-HOST, COMANAGED-EXACS-HOST, COMANAGED-EXACC-HOST
    :param _builtins.str id: Optional list of host insight resource [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param Sequence[_builtins.str] states: Lifecycle states
    :param Sequence[_builtins.str] statuses: Resource Status
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['enterpriseManagerBridgeId'] = enterprise_manager_bridge_id
    __args__['exadataInsightId'] = exadata_insight_id
    __args__['filters'] = filters
    __args__['hostTypes'] = host_types
    __args__['id'] = id
    __args__['states'] = states
    __args__['statuses'] = statuses
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Opsi/getHostInsights:getHostInsights', __args__, opts=opts, typ=GetHostInsightsResult)
    return __ret__.apply(lambda __response__: GetHostInsightsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        enterprise_manager_bridge_id=pulumi.get(__response__, 'enterprise_manager_bridge_id'),
        exadata_insight_id=pulumi.get(__response__, 'exadata_insight_id'),
        filters=pulumi.get(__response__, 'filters'),
        host_insight_summary_collections=pulumi.get(__response__, 'host_insight_summary_collections'),
        host_types=pulumi.get(__response__, 'host_types'),
        id=pulumi.get(__response__, 'id'),
        states=pulumi.get(__response__, 'states'),
        statuses=pulumi.get(__response__, 'statuses')))
