# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetManagedInstanceModulesResult',
    'AwaitableGetManagedInstanceModulesResult',
    'get_managed_instance_modules',
    'get_managed_instance_modules_output',
]

@pulumi.output_type
class GetManagedInstanceModulesResult:
    """
    A collection of values returned by getManagedInstanceModules.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, managed_instance_id=None, managed_instance_module_collections=None, name=None, name_contains=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if managed_instance_id and not isinstance(managed_instance_id, str):
            raise TypeError("Expected argument 'managed_instance_id' to be a str")
        pulumi.set(__self__, "managed_instance_id", managed_instance_id)
        if managed_instance_module_collections and not isinstance(managed_instance_module_collections, list):
            raise TypeError("Expected argument 'managed_instance_module_collections' to be a list")
        pulumi.set(__self__, "managed_instance_module_collections", managed_instance_module_collections)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if name_contains and not isinstance(name_contains, str):
            raise TypeError("Expected argument 'name_contains' to be a str")
        pulumi.set(__self__, "name_contains", name_contains)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetManagedInstanceModulesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> _builtins.str:
        return pulumi.get(self, "managed_instance_id")

    @_builtins.property
    @pulumi.getter(name="managedInstanceModuleCollections")
    def managed_instance_module_collections(self) -> Sequence['outputs.GetManagedInstanceModulesManagedInstanceModuleCollectionResult']:
        """
        The list of managed_instance_module_collection.
        """
        return pulumi.get(self, "managed_instance_module_collections")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The module name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nameContains")
    def name_contains(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_contains")


class AwaitableGetManagedInstanceModulesResult(GetManagedInstanceModulesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedInstanceModulesResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            managed_instance_id=self.managed_instance_id,
            managed_instance_module_collections=self.managed_instance_module_collections,
            name=self.name,
            name_contains=self.name_contains)


def get_managed_instance_modules(compartment_id: Optional[_builtins.str] = None,
                                 filters: Optional[Sequence[Union['GetManagedInstanceModulesFilterArgs', 'GetManagedInstanceModulesFilterArgsDict']]] = None,
                                 managed_instance_id: Optional[_builtins.str] = None,
                                 name: Optional[_builtins.str] = None,
                                 name_contains: Optional[_builtins.str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedInstanceModulesResult:
    """
    This data source provides the list of Managed Instance Modules in Oracle Cloud Infrastructure Os Management Hub service.

    Retrieves a list of modules, along with streams of the modules, from a managed instance. Filters may be applied to select a subset of modules based on the filter criteria.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_instance_modules = oci.OsManagementHub.get_managed_instance_modules(managed_instance_id=test_managed_instance["id"],
        compartment_id=compartment_id,
        name=managed_instance_module_name,
        name_contains=managed_instance_module_name_contains)
    ```


    :param _builtins.str compartment_id: The OCID of the compartment that contains the resources to list. This filter returns only resources contained within the specified compartment.
    :param _builtins.str managed_instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance.
    :param _builtins.str name: The resource name.
    :param _builtins.str name_contains: A filter to return resources that may partially match the name given.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['managedInstanceId'] = managed_instance_id
    __args__['name'] = name
    __args__['nameContains'] = name_contains
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OsManagementHub/getManagedInstanceModules:getManagedInstanceModules', __args__, opts=opts, typ=GetManagedInstanceModulesResult).value

    return AwaitableGetManagedInstanceModulesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        managed_instance_id=pulumi.get(__ret__, 'managed_instance_id'),
        managed_instance_module_collections=pulumi.get(__ret__, 'managed_instance_module_collections'),
        name=pulumi.get(__ret__, 'name'),
        name_contains=pulumi.get(__ret__, 'name_contains'))
def get_managed_instance_modules_output(compartment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                        filters: Optional[pulumi.Input[Optional[Sequence[Union['GetManagedInstanceModulesFilterArgs', 'GetManagedInstanceModulesFilterArgsDict']]]]] = None,
                                        managed_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                                        name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                        name_contains: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetManagedInstanceModulesResult]:
    """
    This data source provides the list of Managed Instance Modules in Oracle Cloud Infrastructure Os Management Hub service.

    Retrieves a list of modules, along with streams of the modules, from a managed instance. Filters may be applied to select a subset of modules based on the filter criteria.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_instance_modules = oci.OsManagementHub.get_managed_instance_modules(managed_instance_id=test_managed_instance["id"],
        compartment_id=compartment_id,
        name=managed_instance_module_name,
        name_contains=managed_instance_module_name_contains)
    ```


    :param _builtins.str compartment_id: The OCID of the compartment that contains the resources to list. This filter returns only resources contained within the specified compartment.
    :param _builtins.str managed_instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance.
    :param _builtins.str name: The resource name.
    :param _builtins.str name_contains: A filter to return resources that may partially match the name given.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['managedInstanceId'] = managed_instance_id
    __args__['name'] = name
    __args__['nameContains'] = name_contains
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:OsManagementHub/getManagedInstanceModules:getManagedInstanceModules', __args__, opts=opts, typ=GetManagedInstanceModulesResult)
    return __ret__.apply(lambda __response__: GetManagedInstanceModulesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        managed_instance_id=pulumi.get(__response__, 'managed_instance_id'),
        managed_instance_module_collections=pulumi.get(__response__, 'managed_instance_module_collections'),
        name=pulumi.get(__response__, 'name'),
        name_contains=pulumi.get(__response__, 'name_contains')))
