# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetOciCacheConfigSetResult',
    'AwaitableGetOciCacheConfigSetResult',
    'get_oci_cache_config_set',
    'get_oci_cache_config_set_output',
]

@pulumi.output_type
class GetOciCacheConfigSetResult:
    """
    A collection of values returned by getOciCacheConfigSet.
    """
    def __init__(__self__, compartment_id=None, configuration_details=None, default_config_set_id=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, id=None, oci_cache_config_set_id=None, software_version=None, state=None, system_tags=None, time_created=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if configuration_details and not isinstance(configuration_details, list):
            raise TypeError("Expected argument 'configuration_details' to be a list")
        pulumi.set(__self__, "configuration_details", configuration_details)
        if default_config_set_id and not isinstance(default_config_set_id, str):
            raise TypeError("Expected argument 'default_config_set_id' to be a str")
        pulumi.set(__self__, "default_config_set_id", default_config_set_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if oci_cache_config_set_id and not isinstance(oci_cache_config_set_id, str):
            raise TypeError("Expected argument 'oci_cache_config_set_id' to be a str")
        pulumi.set(__self__, "oci_cache_config_set_id", oci_cache_config_set_id)
        if software_version and not isinstance(software_version, str):
            raise TypeError("Expected argument 'software_version' to be a str")
        pulumi.set(__self__, "software_version", software_version)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the compartment that contains the Oracle Cloud Infrastructure Cache Config Set.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="configurationDetails")
    def configuration_details(self) -> Sequence['outputs.GetOciCacheConfigSetConfigurationDetailResult']:
        """
        List of Oracle Cloud Infrastructure Cache Config Set Values.
        """
        return pulumi.get(self, "configuration_details")

    @_builtins.property
    @pulumi.getter(name="defaultConfigSetId")
    def default_config_set_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the default Oracle Cloud Infrastructure Cache Config Set which the custom Oracle Cloud Infrastructure Cache Config Set is based upon.
        """
        return pulumi.get(self, "default_config_set_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A description of the Oracle Cloud Infrastructure Cache Config Set.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the Oracle Cloud Infrastructure Cache Config Set.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ociCacheConfigSetId")
    def oci_cache_config_set_id(self) -> _builtins.str:
        return pulumi.get(self, "oci_cache_config_set_id")

    @_builtins.property
    @pulumi.getter(name="softwareVersion")
    def software_version(self) -> _builtins.str:
        """
        The Oracle Cloud Infrastructure Cache engine version that the cluster is running.
        """
        return pulumi.get(self, "software_version")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the Oracle Cloud Infrastructure Cache Config Set.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the Oracle Cloud Infrastructure Cache Config Set was created. An [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the Oracle Cloud Infrastructure Cache Config Set was updated. An [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetOciCacheConfigSetResult(GetOciCacheConfigSetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOciCacheConfigSetResult(
            compartment_id=self.compartment_id,
            configuration_details=self.configuration_details,
            default_config_set_id=self.default_config_set_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            oci_cache_config_set_id=self.oci_cache_config_set_id,
            software_version=self.software_version,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_oci_cache_config_set(oci_cache_config_set_id: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOciCacheConfigSetResult:
    """
    This data source provides details about a specific Oci Cache Config Set resource in Oracle Cloud Infrastructure Redis service.

    Retrieves the specified Oracle Cloud Infrastructure Cache Config Set.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_oci_cache_config_set = oci.Redis.get_oci_cache_config_set(oci_cache_config_set_id=test_oci_cache_config_set_oci_redis_oci_cache_config_set["id"])
    ```


    :param _builtins.str oci_cache_config_set_id: Unique Oracle Cloud Infrastructure Cache Config Set identifier.
    """
    __args__ = dict()
    __args__['ociCacheConfigSetId'] = oci_cache_config_set_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Redis/getOciCacheConfigSet:getOciCacheConfigSet', __args__, opts=opts, typ=GetOciCacheConfigSetResult).value

    return AwaitableGetOciCacheConfigSetResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        configuration_details=pulumi.get(__ret__, 'configuration_details'),
        default_config_set_id=pulumi.get(__ret__, 'default_config_set_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        oci_cache_config_set_id=pulumi.get(__ret__, 'oci_cache_config_set_id'),
        software_version=pulumi.get(__ret__, 'software_version'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_oci_cache_config_set_output(oci_cache_config_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOciCacheConfigSetResult]:
    """
    This data source provides details about a specific Oci Cache Config Set resource in Oracle Cloud Infrastructure Redis service.

    Retrieves the specified Oracle Cloud Infrastructure Cache Config Set.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_oci_cache_config_set = oci.Redis.get_oci_cache_config_set(oci_cache_config_set_id=test_oci_cache_config_set_oci_redis_oci_cache_config_set["id"])
    ```


    :param _builtins.str oci_cache_config_set_id: Unique Oracle Cloud Infrastructure Cache Config Set identifier.
    """
    __args__ = dict()
    __args__['ociCacheConfigSetId'] = oci_cache_config_set_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Redis/getOciCacheConfigSet:getOciCacheConfigSet', __args__, opts=opts, typ=GetOciCacheConfigSetResult)
    return __ret__.apply(lambda __response__: GetOciCacheConfigSetResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        configuration_details=pulumi.get(__response__, 'configuration_details'),
        default_config_set_id=pulumi.get(__response__, 'default_config_set_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        oci_cache_config_set_id=pulumi.get(__response__, 'oci_cache_config_set_id'),
        software_version=pulumi.get(__response__, 'software_version'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
