# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ConnectorSource',
    'ConnectorSourceCursor',
    'ConnectorSourceLogSource',
    'ConnectorSourceMonitoringSource',
    'ConnectorSourceMonitoringSourceNamespaceDetails',
    'ConnectorSourceMonitoringSourceNamespaceDetailsNamespace',
    'ConnectorSourceMonitoringSourceNamespaceDetailsNamespaceMetrics',
    'ConnectorSourcePrivateEndpointMetadata',
    'ConnectorTarget',
    'ConnectorTargetDimension',
    'ConnectorTargetDimensionDimensionValue',
    'ConnectorTargetPrivateEndpointMetadata',
    'ConnectorTask',
    'ConnectorTaskPrivateEndpointMetadata',
    'GetConnectorPluginsConnectorPluginCollectionResult',
    'GetConnectorPluginsConnectorPluginCollectionItemResult',
    'GetConnectorPluginsFilterResult',
    'GetServiceConnectorSourceResult',
    'GetServiceConnectorSourceCursorResult',
    'GetServiceConnectorSourceLogSourceResult',
    'GetServiceConnectorSourceMonitoringSourceResult',
    'GetServiceConnectorSourceMonitoringSourceNamespaceDetailResult',
    'GetServiceConnectorSourceMonitoringSourceNamespaceDetailNamespaceResult',
    'GetServiceConnectorSourceMonitoringSourceNamespaceDetailNamespaceMetricResult',
    'GetServiceConnectorSourcePrivateEndpointMetadataResult',
    'GetServiceConnectorTargetResult',
    'GetServiceConnectorTargetDimensionResult',
    'GetServiceConnectorTargetDimensionDimensionValueResult',
    'GetServiceConnectorTargetPrivateEndpointMetadataResult',
    'GetServiceConnectorTaskResult',
    'GetServiceConnectorTaskPrivateEndpointMetadataResult',
    'GetServiceConnectorsFilterResult',
    'GetServiceConnectorsServiceConnectorCollectionResult',
    'GetServiceConnectorsServiceConnectorCollectionItemResult',
    'GetServiceConnectorsServiceConnectorCollectionItemSourceResult',
    'GetServiceConnectorsServiceConnectorCollectionItemSourceCursorResult',
    'GetServiceConnectorsServiceConnectorCollectionItemSourceLogSourceResult',
    'GetServiceConnectorsServiceConnectorCollectionItemSourceMonitoringSourceResult',
    'GetServiceConnectorsServiceConnectorCollectionItemSourceMonitoringSourceNamespaceDetailResult',
    'GetServiceConnectorsServiceConnectorCollectionItemSourceMonitoringSourceNamespaceDetailNamespaceResult',
    'GetServiceConnectorsServiceConnectorCollectionItemSourceMonitoringSourceNamespaceDetailNamespaceMetricResult',
    'GetServiceConnectorsServiceConnectorCollectionItemSourcePrivateEndpointMetadataResult',
    'GetServiceConnectorsServiceConnectorCollectionItemTargetResult',
    'GetServiceConnectorsServiceConnectorCollectionItemTargetDimensionResult',
    'GetServiceConnectorsServiceConnectorCollectionItemTargetDimensionDimensionValueResult',
    'GetServiceConnectorsServiceConnectorCollectionItemTargetPrivateEndpointMetadataResult',
    'GetServiceConnectorsServiceConnectorCollectionItemTaskResult',
    'GetServiceConnectorsServiceConnectorCollectionItemTaskPrivateEndpointMetadataResult',
]

@pulumi.output_type
class ConnectorSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configMap":
            suggest = "config_map"
        elif key == "logSources":
            suggest = "log_sources"
        elif key == "monitoringSources":
            suggest = "monitoring_sources"
        elif key == "pluginName":
            suggest = "plugin_name"
        elif key == "privateEndpointMetadatas":
            suggest = "private_endpoint_metadatas"
        elif key == "streamId":
            suggest = "stream_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kind: _builtins.str,
                 config_map: Optional[_builtins.str] = None,
                 cursor: Optional['outputs.ConnectorSourceCursor'] = None,
                 log_sources: Optional[Sequence['outputs.ConnectorSourceLogSource']] = None,
                 monitoring_sources: Optional[Sequence['outputs.ConnectorSourceMonitoringSource']] = None,
                 plugin_name: Optional[_builtins.str] = None,
                 private_endpoint_metadatas: Optional[Sequence['outputs.ConnectorSourcePrivateEndpointMetadata']] = None,
                 stream_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str kind: (Updatable) The type discriminator.
        :param _builtins.str config_map: (Updatable) The configuration map for the connector plugin. This map includes parameters specific to the connector plugin type.  For example, for `QueueSource`, the map lists the OCID of the selected queue. To find the parameters for a connector plugin, get the plugin using [GetConnectorPlugin](https://docs.cloud.oracle.com/iaas/api/#/en/serviceconnectors/latest/ConnectorPlugin/GetConnectorPlugin) and review its schema value.
        :param 'ConnectorSourceCursorArgs' cursor: (Updatable) The [read setting](https://docs.cloud.oracle.com/iaas/Content/connector-hub/create-service-connector-streaming-source.htm), which determines where in the stream to start moving data. For configuration instructions, see [Creating a Connector with a Streaming Source](https://docs.cloud.oracle.com/iaas/Content/connector-hub/create-service-connector-streaming-source.htm).
        :param Sequence['ConnectorSourceLogSourceArgs'] log_sources: (Updatable) The logs for this Logging source.
        :param Sequence['ConnectorSourceMonitoringSourceArgs'] monitoring_sources: (Updatable) One or more compartment-specific lists of metric namespaces to retrieve data from.
        :param _builtins.str plugin_name: (Updatable) The name of the connector plugin. This name indicates the service to be called by the connector plugin. For example, `QueueSource` indicates the Queue service. To find names of connector plugins, list the plugin using [ListConnectorPlugin](https://docs.cloud.oracle.com/iaas/api/#/en/serviceconnectors/latest/ConnectorPluginSummary/ListConnectorPlugins).
        :param Sequence['ConnectorSourcePrivateEndpointMetadataArgs'] private_endpoint_metadatas: The private endpoint metadata for the connector's source or target.
        :param _builtins.str stream_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the stream.
        """
        pulumi.set(__self__, "kind", kind)
        if config_map is not None:
            pulumi.set(__self__, "config_map", config_map)
        if cursor is not None:
            pulumi.set(__self__, "cursor", cursor)
        if log_sources is not None:
            pulumi.set(__self__, "log_sources", log_sources)
        if monitoring_sources is not None:
            pulumi.set(__self__, "monitoring_sources", monitoring_sources)
        if plugin_name is not None:
            pulumi.set(__self__, "plugin_name", plugin_name)
        if private_endpoint_metadatas is not None:
            pulumi.set(__self__, "private_endpoint_metadatas", private_endpoint_metadatas)
        if stream_id is not None:
            pulumi.set(__self__, "stream_id", stream_id)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> _builtins.str:
        """
        (Updatable) The type discriminator.
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter(name="configMap")
    def config_map(self) -> Optional[_builtins.str]:
        """
        (Updatable) The configuration map for the connector plugin. This map includes parameters specific to the connector plugin type.  For example, for `QueueSource`, the map lists the OCID of the selected queue. To find the parameters for a connector plugin, get the plugin using [GetConnectorPlugin](https://docs.cloud.oracle.com/iaas/api/#/en/serviceconnectors/latest/ConnectorPlugin/GetConnectorPlugin) and review its schema value.
        """
        return pulumi.get(self, "config_map")

    @_builtins.property
    @pulumi.getter
    def cursor(self) -> Optional['outputs.ConnectorSourceCursor']:
        """
        (Updatable) The [read setting](https://docs.cloud.oracle.com/iaas/Content/connector-hub/create-service-connector-streaming-source.htm), which determines where in the stream to start moving data. For configuration instructions, see [Creating a Connector with a Streaming Source](https://docs.cloud.oracle.com/iaas/Content/connector-hub/create-service-connector-streaming-source.htm).
        """
        return pulumi.get(self, "cursor")

    @_builtins.property
    @pulumi.getter(name="logSources")
    def log_sources(self) -> Optional[Sequence['outputs.ConnectorSourceLogSource']]:
        """
        (Updatable) The logs for this Logging source.
        """
        return pulumi.get(self, "log_sources")

    @_builtins.property
    @pulumi.getter(name="monitoringSources")
    def monitoring_sources(self) -> Optional[Sequence['outputs.ConnectorSourceMonitoringSource']]:
        """
        (Updatable) One or more compartment-specific lists of metric namespaces to retrieve data from.
        """
        return pulumi.get(self, "monitoring_sources")

    @_builtins.property
    @pulumi.getter(name="pluginName")
    def plugin_name(self) -> Optional[_builtins.str]:
        """
        (Updatable) The name of the connector plugin. This name indicates the service to be called by the connector plugin. For example, `QueueSource` indicates the Queue service. To find names of connector plugins, list the plugin using [ListConnectorPlugin](https://docs.cloud.oracle.com/iaas/api/#/en/serviceconnectors/latest/ConnectorPluginSummary/ListConnectorPlugins).
        """
        return pulumi.get(self, "plugin_name")

    @_builtins.property
    @pulumi.getter(name="privateEndpointMetadatas")
    def private_endpoint_metadatas(self) -> Optional[Sequence['outputs.ConnectorSourcePrivateEndpointMetadata']]:
        """
        The private endpoint metadata for the connector's source or target.
        """
        return pulumi.get(self, "private_endpoint_metadatas")

    @_builtins.property
    @pulumi.getter(name="streamId")
    def stream_id(self) -> Optional[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the stream.
        """
        return pulumi.get(self, "stream_id")


@pulumi.output_type
class ConnectorSourceCursor(dict):
    def __init__(__self__, *,
                 kind: Optional[_builtins.str] = None):
        """
        :param _builtins.str kind: (Updatable) The type discriminator.
        """
        if kind is not None:
            pulumi.set(__self__, "kind", kind)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[_builtins.str]:
        """
        (Updatable) The type discriminator.
        """
        return pulumi.get(self, "kind")


@pulumi.output_type
class ConnectorSourceLogSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "compartmentId":
            suggest = "compartment_id"
        elif key == "logGroupId":
            suggest = "log_group_id"
        elif key == "logId":
            suggest = "log_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorSourceLogSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorSourceLogSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorSourceLogSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compartment_id: Optional[_builtins.str] = None,
                 log_group_id: Optional[_builtins.str] = None,
                 log_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the log source.
        :param _builtins.str log_group_id: (Updatable) Identifier of the log group. Either `_Audit` or the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the log group. Note: For the Notifications target, only `_Audit` is allowed.
        :param _builtins.str log_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the log.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if log_group_id is not None:
            pulumi.set(__self__, "log_group_id", log_group_id)
        if log_id is not None:
            pulumi.set(__self__, "log_id", log_id)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the log source.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> Optional[_builtins.str]:
        """
        (Updatable) Identifier of the log group. Either `_Audit` or the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the log group. Note: For the Notifications target, only `_Audit` is allowed.
        """
        return pulumi.get(self, "log_group_id")

    @_builtins.property
    @pulumi.getter(name="logId")
    def log_id(self) -> Optional[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the log.
        """
        return pulumi.get(self, "log_id")


@pulumi.output_type
class ConnectorSourceMonitoringSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "compartmentId":
            suggest = "compartment_id"
        elif key == "namespaceDetails":
            suggest = "namespace_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorSourceMonitoringSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorSourceMonitoringSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorSourceMonitoringSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compartment_id: Optional[_builtins.str] = None,
                 namespace_details: Optional['outputs.ConnectorSourceMonitoringSourceNamespaceDetails'] = None):
        """
        :param _builtins.str compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a compartment containing metric namespaces you want to use for the Monitoring source.
        :param 'ConnectorSourceMonitoringSourceNamespaceDetailsArgs' namespace_details: (Updatable) Discriminator for namespaces in the compartment-specific list.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if namespace_details is not None:
            pulumi.set(__self__, "namespace_details", namespace_details)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a compartment containing metric namespaces you want to use for the Monitoring source.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="namespaceDetails")
    def namespace_details(self) -> Optional['outputs.ConnectorSourceMonitoringSourceNamespaceDetails']:
        """
        (Updatable) Discriminator for namespaces in the compartment-specific list.
        """
        return pulumi.get(self, "namespace_details")


@pulumi.output_type
class ConnectorSourceMonitoringSourceNamespaceDetails(dict):
    def __init__(__self__, *,
                 kind: _builtins.str,
                 namespaces: Sequence['outputs.ConnectorSourceMonitoringSourceNamespaceDetailsNamespace']):
        """
        :param _builtins.str kind: (Updatable) The type discriminator.
        :param Sequence['ConnectorSourceMonitoringSourceNamespaceDetailsNamespaceArgs'] namespaces: (Updatable) The namespaces for the compartment-specific list.
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "namespaces", namespaces)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> _builtins.str:
        """
        (Updatable) The type discriminator.
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def namespaces(self) -> Sequence['outputs.ConnectorSourceMonitoringSourceNamespaceDetailsNamespace']:
        """
        (Updatable) The namespaces for the compartment-specific list.
        """
        return pulumi.get(self, "namespaces")


@pulumi.output_type
class ConnectorSourceMonitoringSourceNamespaceDetailsNamespace(dict):
    def __init__(__self__, *,
                 metrics: 'outputs.ConnectorSourceMonitoringSourceNamespaceDetailsNamespaceMetrics',
                 namespace: _builtins.str):
        """
        :param 'ConnectorSourceMonitoringSourceNamespaceDetailsNamespaceMetricsArgs' metrics: (Updatable) The metrics to query for the specified metric namespace.
        :param _builtins.str namespace: (Updatable) The source service or application to use when querying for metric data points. Must begin with `oci_`.  Example: `oci_computeagent`
        """
        pulumi.set(__self__, "metrics", metrics)
        pulumi.set(__self__, "namespace", namespace)

    @_builtins.property
    @pulumi.getter
    def metrics(self) -> 'outputs.ConnectorSourceMonitoringSourceNamespaceDetailsNamespaceMetrics':
        """
        (Updatable) The metrics to query for the specified metric namespace.
        """
        return pulumi.get(self, "metrics")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        (Updatable) The source service or application to use when querying for metric data points. Must begin with `oci_`.  Example: `oci_computeagent`
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class ConnectorSourceMonitoringSourceNamespaceDetailsNamespaceMetrics(dict):
    def __init__(__self__, *,
                 kind: _builtins.str):
        """
        :param _builtins.str kind: (Updatable) The type discriminator.
        """
        pulumi.set(__self__, "kind", kind)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> _builtins.str:
        """
        (Updatable) The type discriminator.
        """
        return pulumi.get(self, "kind")


@pulumi.output_type
class ConnectorSourcePrivateEndpointMetadata(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rceDnsProxyIpAddress":
            suggest = "rce_dns_proxy_ip_address"
        elif key == "rceTrafficIpAddress":
            suggest = "rce_traffic_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorSourcePrivateEndpointMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorSourcePrivateEndpointMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorSourcePrivateEndpointMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rce_dns_proxy_ip_address: Optional[_builtins.str] = None,
                 rce_traffic_ip_address: Optional[_builtins.str] = None):
        """
        :param _builtins.str rce_dns_proxy_ip_address: The reverse connection endpoint (RCE) IP address for DNS lookups.
        :param _builtins.str rce_traffic_ip_address: The reverse connection endpoint (RCE) IP address for primary flow of traffic in the subnet.
        """
        if rce_dns_proxy_ip_address is not None:
            pulumi.set(__self__, "rce_dns_proxy_ip_address", rce_dns_proxy_ip_address)
        if rce_traffic_ip_address is not None:
            pulumi.set(__self__, "rce_traffic_ip_address", rce_traffic_ip_address)

    @_builtins.property
    @pulumi.getter(name="rceDnsProxyIpAddress")
    def rce_dns_proxy_ip_address(self) -> Optional[_builtins.str]:
        """
        The reverse connection endpoint (RCE) IP address for DNS lookups.
        """
        return pulumi.get(self, "rce_dns_proxy_ip_address")

    @_builtins.property
    @pulumi.getter(name="rceTrafficIpAddress")
    def rce_traffic_ip_address(self) -> Optional[_builtins.str]:
        """
        The reverse connection endpoint (RCE) IP address for primary flow of traffic in the subnet.
        """
        return pulumi.get(self, "rce_traffic_ip_address")


@pulumi.output_type
class ConnectorTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "batchRolloverSizeInMbs":
            suggest = "batch_rollover_size_in_mbs"
        elif key == "batchRolloverTimeInMs":
            suggest = "batch_rollover_time_in_ms"
        elif key == "batchSizeInKbs":
            suggest = "batch_size_in_kbs"
        elif key == "batchSizeInNum":
            suggest = "batch_size_in_num"
        elif key == "batchTimeInSec":
            suggest = "batch_time_in_sec"
        elif key == "compartmentId":
            suggest = "compartment_id"
        elif key == "enableFormattedMessaging":
            suggest = "enable_formatted_messaging"
        elif key == "functionId":
            suggest = "function_id"
        elif key == "logGroupId":
            suggest = "log_group_id"
        elif key == "logSourceIdentifier":
            suggest = "log_source_identifier"
        elif key == "metricNamespace":
            suggest = "metric_namespace"
        elif key == "objectNamePrefix":
            suggest = "object_name_prefix"
        elif key == "privateEndpointMetadatas":
            suggest = "private_endpoint_metadatas"
        elif key == "streamId":
            suggest = "stream_id"
        elif key == "topicId":
            suggest = "topic_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kind: _builtins.str,
                 batch_rollover_size_in_mbs: Optional[_builtins.int] = None,
                 batch_rollover_time_in_ms: Optional[_builtins.int] = None,
                 batch_size_in_kbs: Optional[_builtins.int] = None,
                 batch_size_in_num: Optional[_builtins.int] = None,
                 batch_time_in_sec: Optional[_builtins.int] = None,
                 bucket: Optional[_builtins.str] = None,
                 compartment_id: Optional[_builtins.str] = None,
                 dimensions: Optional[Sequence['outputs.ConnectorTargetDimension']] = None,
                 enable_formatted_messaging: Optional[_builtins.bool] = None,
                 function_id: Optional[_builtins.str] = None,
                 log_group_id: Optional[_builtins.str] = None,
                 log_source_identifier: Optional[_builtins.str] = None,
                 metric: Optional[_builtins.str] = None,
                 metric_namespace: Optional[_builtins.str] = None,
                 namespace: Optional[_builtins.str] = None,
                 object_name_prefix: Optional[_builtins.str] = None,
                 private_endpoint_metadatas: Optional[Sequence['outputs.ConnectorTargetPrivateEndpointMetadata']] = None,
                 stream_id: Optional[_builtins.str] = None,
                 topic_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str kind: (Updatable) The type discriminator.
        :param _builtins.int batch_rollover_size_in_mbs: (Updatable) The batch rollover size in megabytes.
        :param _builtins.int batch_rollover_time_in_ms: (Updatable) The batch rollover time in milliseconds.
        :param _builtins.int batch_size_in_kbs: (Updatable) The batch rollover size in kilobytes. Only one size option can be specified: `batchSizeInKbs` or `batchSizeInNum`.
        :param _builtins.int batch_size_in_num: (Updatable) The batch rollover size in number of messages. Only one size option can be specified: `batchSizeInKbs` or `batchSizeInNum`.
        :param _builtins.int batch_time_in_sec: (Updatable) The batch rollover time in seconds.
        :param _builtins.str bucket: (Updatable) The name of the bucket. Valid characters are letters (upper or lower case), numbers, hyphens (-), underscores(_), and periods (.). Bucket names must be unique within an Object Storage namespace. Avoid entering confidential information. Example: my-new-bucket1
        :param _builtins.str compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the metric.
        :param Sequence['ConnectorTargetDimensionArgs'] dimensions: (Updatable) List of dimension names and values.
        :param _builtins.bool enable_formatted_messaging: (Updatable) Whether to apply a simplified, user-friendly format to the message. Applies only when friendly formatting is supported by the connector source and the subscription protocol. Example: `true`
        :param _builtins.str function_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the function.
        :param _builtins.str log_group_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Logging Analytics log group.
        :param _builtins.str log_source_identifier: (Updatable) Identifier of the log source that you want to use for processing data received from the connector source. Applies to `StreamingSource` only. Equivalent to `name` at [LogAnalyticsSource](https://docs.cloud.oracle.com/iaas/api/#/en/logan-api-spec/latest/LogAnalyticsSource/).
        :param _builtins.str metric: (Updatable) The name of the metric. Example: `CpuUtilization`
        :param _builtins.str metric_namespace: (Updatable) The namespace of the metric. Example: `oci_computeagent`
        :param _builtins.str namespace: (Updatable) The namespace.
        :param _builtins.str object_name_prefix: (Updatable) The prefix of the objects. Avoid entering confidential information.
        :param Sequence['ConnectorTargetPrivateEndpointMetadataArgs'] private_endpoint_metadatas: The private endpoint metadata for the connector's source or target.
        :param _builtins.str stream_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the stream.
        :param _builtins.str topic_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the topic.
        """
        pulumi.set(__self__, "kind", kind)
        if batch_rollover_size_in_mbs is not None:
            pulumi.set(__self__, "batch_rollover_size_in_mbs", batch_rollover_size_in_mbs)
        if batch_rollover_time_in_ms is not None:
            pulumi.set(__self__, "batch_rollover_time_in_ms", batch_rollover_time_in_ms)
        if batch_size_in_kbs is not None:
            pulumi.set(__self__, "batch_size_in_kbs", batch_size_in_kbs)
        if batch_size_in_num is not None:
            pulumi.set(__self__, "batch_size_in_num", batch_size_in_num)
        if batch_time_in_sec is not None:
            pulumi.set(__self__, "batch_time_in_sec", batch_time_in_sec)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if enable_formatted_messaging is not None:
            pulumi.set(__self__, "enable_formatted_messaging", enable_formatted_messaging)
        if function_id is not None:
            pulumi.set(__self__, "function_id", function_id)
        if log_group_id is not None:
            pulumi.set(__self__, "log_group_id", log_group_id)
        if log_source_identifier is not None:
            pulumi.set(__self__, "log_source_identifier", log_source_identifier)
        if metric is not None:
            pulumi.set(__self__, "metric", metric)
        if metric_namespace is not None:
            pulumi.set(__self__, "metric_namespace", metric_namespace)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object_name_prefix is not None:
            pulumi.set(__self__, "object_name_prefix", object_name_prefix)
        if private_endpoint_metadatas is not None:
            pulumi.set(__self__, "private_endpoint_metadatas", private_endpoint_metadatas)
        if stream_id is not None:
            pulumi.set(__self__, "stream_id", stream_id)
        if topic_id is not None:
            pulumi.set(__self__, "topic_id", topic_id)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> _builtins.str:
        """
        (Updatable) The type discriminator.
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter(name="batchRolloverSizeInMbs")
    def batch_rollover_size_in_mbs(self) -> Optional[_builtins.int]:
        """
        (Updatable) The batch rollover size in megabytes.
        """
        return pulumi.get(self, "batch_rollover_size_in_mbs")

    @_builtins.property
    @pulumi.getter(name="batchRolloverTimeInMs")
    def batch_rollover_time_in_ms(self) -> Optional[_builtins.int]:
        """
        (Updatable) The batch rollover time in milliseconds.
        """
        return pulumi.get(self, "batch_rollover_time_in_ms")

    @_builtins.property
    @pulumi.getter(name="batchSizeInKbs")
    def batch_size_in_kbs(self) -> Optional[_builtins.int]:
        """
        (Updatable) The batch rollover size in kilobytes. Only one size option can be specified: `batchSizeInKbs` or `batchSizeInNum`.
        """
        return pulumi.get(self, "batch_size_in_kbs")

    @_builtins.property
    @pulumi.getter(name="batchSizeInNum")
    def batch_size_in_num(self) -> Optional[_builtins.int]:
        """
        (Updatable) The batch rollover size in number of messages. Only one size option can be specified: `batchSizeInKbs` or `batchSizeInNum`.
        """
        return pulumi.get(self, "batch_size_in_num")

    @_builtins.property
    @pulumi.getter(name="batchTimeInSec")
    def batch_time_in_sec(self) -> Optional[_builtins.int]:
        """
        (Updatable) The batch rollover time in seconds.
        """
        return pulumi.get(self, "batch_time_in_sec")

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[_builtins.str]:
        """
        (Updatable) The name of the bucket. Valid characters are letters (upper or lower case), numbers, hyphens (-), underscores(_), and periods (.). Bucket names must be unique within an Object Storage namespace. Avoid entering confidential information. Example: my-new-bucket1
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the metric.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def dimensions(self) -> Optional[Sequence['outputs.ConnectorTargetDimension']]:
        """
        (Updatable) List of dimension names and values.
        """
        return pulumi.get(self, "dimensions")

    @_builtins.property
    @pulumi.getter(name="enableFormattedMessaging")
    def enable_formatted_messaging(self) -> Optional[_builtins.bool]:
        """
        (Updatable) Whether to apply a simplified, user-friendly format to the message. Applies only when friendly formatting is supported by the connector source and the subscription protocol. Example: `true`
        """
        return pulumi.get(self, "enable_formatted_messaging")

    @_builtins.property
    @pulumi.getter(name="functionId")
    def function_id(self) -> Optional[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the function.
        """
        return pulumi.get(self, "function_id")

    @_builtins.property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> Optional[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Logging Analytics log group.
        """
        return pulumi.get(self, "log_group_id")

    @_builtins.property
    @pulumi.getter(name="logSourceIdentifier")
    def log_source_identifier(self) -> Optional[_builtins.str]:
        """
        (Updatable) Identifier of the log source that you want to use for processing data received from the connector source. Applies to `StreamingSource` only. Equivalent to `name` at [LogAnalyticsSource](https://docs.cloud.oracle.com/iaas/api/#/en/logan-api-spec/latest/LogAnalyticsSource/).
        """
        return pulumi.get(self, "log_source_identifier")

    @_builtins.property
    @pulumi.getter
    def metric(self) -> Optional[_builtins.str]:
        """
        (Updatable) The name of the metric. Example: `CpuUtilization`
        """
        return pulumi.get(self, "metric")

    @_builtins.property
    @pulumi.getter(name="metricNamespace")
    def metric_namespace(self) -> Optional[_builtins.str]:
        """
        (Updatable) The namespace of the metric. Example: `oci_computeagent`
        """
        return pulumi.get(self, "metric_namespace")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        """
        (Updatable) The namespace.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="objectNamePrefix")
    def object_name_prefix(self) -> Optional[_builtins.str]:
        """
        (Updatable) The prefix of the objects. Avoid entering confidential information.
        """
        return pulumi.get(self, "object_name_prefix")

    @_builtins.property
    @pulumi.getter(name="privateEndpointMetadatas")
    def private_endpoint_metadatas(self) -> Optional[Sequence['outputs.ConnectorTargetPrivateEndpointMetadata']]:
        """
        The private endpoint metadata for the connector's source or target.
        """
        return pulumi.get(self, "private_endpoint_metadatas")

    @_builtins.property
    @pulumi.getter(name="streamId")
    def stream_id(self) -> Optional[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the stream.
        """
        return pulumi.get(self, "stream_id")

    @_builtins.property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> Optional[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the topic.
        """
        return pulumi.get(self, "topic_id")


@pulumi.output_type
class ConnectorTargetDimension(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dimensionValue":
            suggest = "dimension_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorTargetDimension. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorTargetDimension.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorTargetDimension.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dimension_value: Optional['outputs.ConnectorTargetDimensionDimensionValue'] = None,
                 name: Optional[_builtins.str] = None):
        """
        :param 'ConnectorTargetDimensionDimensionValueArgs' dimension_value: (Updatable) Instructions for extracting the value corresponding to the specified dimension key: Either extract the value as-is (static) or derive the value from a path (evaluated).
        :param _builtins.str name: (Updatable) Dimension key. A valid dimension key includes only printable ASCII, excluding periods (.) and spaces. Custom dimension keys are acceptable. Avoid entering confidential information. Due to use by Connector Hub, the following dimension names are reserved: `connectorId`, `connectorName`, `connectorSourceType`. For information on valid dimension keys and values, see [MetricDataDetails Reference](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/MetricDataDetails). Example: `type`
        """
        if dimension_value is not None:
            pulumi.set(__self__, "dimension_value", dimension_value)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="dimensionValue")
    def dimension_value(self) -> Optional['outputs.ConnectorTargetDimensionDimensionValue']:
        """
        (Updatable) Instructions for extracting the value corresponding to the specified dimension key: Either extract the value as-is (static) or derive the value from a path (evaluated).
        """
        return pulumi.get(self, "dimension_value")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        (Updatable) Dimension key. A valid dimension key includes only printable ASCII, excluding periods (.) and spaces. Custom dimension keys are acceptable. Avoid entering confidential information. Due to use by Connector Hub, the following dimension names are reserved: `connectorId`, `connectorName`, `connectorSourceType`. For information on valid dimension keys and values, see [MetricDataDetails Reference](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/MetricDataDetails). Example: `type`
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ConnectorTargetDimensionDimensionValue(dict):
    def __init__(__self__, *,
                 kind: _builtins.str,
                 path: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str kind: (Updatable) The type of dimension value: static or evaluated.
        :param _builtins.str path: (Updatable) The location to use for deriving the dimension value (evaluated). The path must start with `logContent` in an acceptable notation style with supported [JMESPath selectors](https://jmespath.org/specification.html): expression with dot and index operator (`.` and `[]`). Example with dot notation: `logContent.data` Example with index notation: `logContent.data[0].content` For information on valid dimension keys and values, see [MetricDataDetails Reference](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/MetricDataDetails). The returned value depends on the results of evaluation. If the evaluated value is valid, then the evaluated value is returned without double quotes. (Any front or trailing double quotes are trimmed before returning the value. For example, the evaluated value `"compartmentId"` is returned as `compartmentId`.) If the evaluated value is invalid, then the returned value is `SCH_EVAL_INVALID_VALUE`. If the evaluated value is empty, then the returned value is `SCH_EVAL_VALUE_EMPTY`.
        :param _builtins.str value: (Updatable) The data extracted from the specified dimension value (passed as-is). Unicode characters only. For information on valid dimension keys and values, see [MetricDataDetails Reference](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/MetricDataDetails).
        """
        pulumi.set(__self__, "kind", kind)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> _builtins.str:
        """
        (Updatable) The type of dimension value: static or evaluated.
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        (Updatable) The location to use for deriving the dimension value (evaluated). The path must start with `logContent` in an acceptable notation style with supported [JMESPath selectors](https://jmespath.org/specification.html): expression with dot and index operator (`.` and `[]`). Example with dot notation: `logContent.data` Example with index notation: `logContent.data[0].content` For information on valid dimension keys and values, see [MetricDataDetails Reference](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/MetricDataDetails). The returned value depends on the results of evaluation. If the evaluated value is valid, then the evaluated value is returned without double quotes. (Any front or trailing double quotes are trimmed before returning the value. For example, the evaluated value `"compartmentId"` is returned as `compartmentId`.) If the evaluated value is invalid, then the returned value is `SCH_EVAL_INVALID_VALUE`. If the evaluated value is empty, then the returned value is `SCH_EVAL_VALUE_EMPTY`.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        (Updatable) The data extracted from the specified dimension value (passed as-is). Unicode characters only. For information on valid dimension keys and values, see [MetricDataDetails Reference](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/MetricDataDetails).
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ConnectorTargetPrivateEndpointMetadata(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rceDnsProxyIpAddress":
            suggest = "rce_dns_proxy_ip_address"
        elif key == "rceTrafficIpAddress":
            suggest = "rce_traffic_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorTargetPrivateEndpointMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorTargetPrivateEndpointMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorTargetPrivateEndpointMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rce_dns_proxy_ip_address: Optional[_builtins.str] = None,
                 rce_traffic_ip_address: Optional[_builtins.str] = None):
        """
        :param _builtins.str rce_dns_proxy_ip_address: The reverse connection endpoint (RCE) IP address for DNS lookups.
        :param _builtins.str rce_traffic_ip_address: The reverse connection endpoint (RCE) IP address for primary flow of traffic in the subnet.
        """
        if rce_dns_proxy_ip_address is not None:
            pulumi.set(__self__, "rce_dns_proxy_ip_address", rce_dns_proxy_ip_address)
        if rce_traffic_ip_address is not None:
            pulumi.set(__self__, "rce_traffic_ip_address", rce_traffic_ip_address)

    @_builtins.property
    @pulumi.getter(name="rceDnsProxyIpAddress")
    def rce_dns_proxy_ip_address(self) -> Optional[_builtins.str]:
        """
        The reverse connection endpoint (RCE) IP address for DNS lookups.
        """
        return pulumi.get(self, "rce_dns_proxy_ip_address")

    @_builtins.property
    @pulumi.getter(name="rceTrafficIpAddress")
    def rce_traffic_ip_address(self) -> Optional[_builtins.str]:
        """
        The reverse connection endpoint (RCE) IP address for primary flow of traffic in the subnet.
        """
        return pulumi.get(self, "rce_traffic_ip_address")


@pulumi.output_type
class ConnectorTask(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "batchSizeInKbs":
            suggest = "batch_size_in_kbs"
        elif key == "batchTimeInSec":
            suggest = "batch_time_in_sec"
        elif key == "functionId":
            suggest = "function_id"
        elif key == "privateEndpointMetadatas":
            suggest = "private_endpoint_metadatas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorTask. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorTask.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorTask.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kind: _builtins.str,
                 batch_size_in_kbs: Optional[_builtins.int] = None,
                 batch_time_in_sec: Optional[_builtins.int] = None,
                 condition: Optional[_builtins.str] = None,
                 function_id: Optional[_builtins.str] = None,
                 private_endpoint_metadatas: Optional[Sequence['outputs.ConnectorTaskPrivateEndpointMetadata']] = None):
        """
        :param _builtins.str kind: (Updatable) The type descriminator.
        :param _builtins.int batch_size_in_kbs: (Updatable) Size limit (kilobytes) for batch sent to invoke the function.
        :param _builtins.int batch_time_in_sec: (Updatable) Time limit (seconds) for batch sent to invoke the function.
        :param _builtins.str condition: (Updatable) A filter or mask to limit the source used in the flow defined by the connector.
        :param _builtins.str function_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the function to be used as a task.
        :param Sequence['ConnectorTaskPrivateEndpointMetadataArgs'] private_endpoint_metadatas: The private endpoint metadata for the connector's source or target.
        """
        pulumi.set(__self__, "kind", kind)
        if batch_size_in_kbs is not None:
            pulumi.set(__self__, "batch_size_in_kbs", batch_size_in_kbs)
        if batch_time_in_sec is not None:
            pulumi.set(__self__, "batch_time_in_sec", batch_time_in_sec)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if function_id is not None:
            pulumi.set(__self__, "function_id", function_id)
        if private_endpoint_metadatas is not None:
            pulumi.set(__self__, "private_endpoint_metadatas", private_endpoint_metadatas)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> _builtins.str:
        """
        (Updatable) The type descriminator.
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter(name="batchSizeInKbs")
    def batch_size_in_kbs(self) -> Optional[_builtins.int]:
        """
        (Updatable) Size limit (kilobytes) for batch sent to invoke the function.
        """
        return pulumi.get(self, "batch_size_in_kbs")

    @_builtins.property
    @pulumi.getter(name="batchTimeInSec")
    def batch_time_in_sec(self) -> Optional[_builtins.int]:
        """
        (Updatable) Time limit (seconds) for batch sent to invoke the function.
        """
        return pulumi.get(self, "batch_time_in_sec")

    @_builtins.property
    @pulumi.getter
    def condition(self) -> Optional[_builtins.str]:
        """
        (Updatable) A filter or mask to limit the source used in the flow defined by the connector.
        """
        return pulumi.get(self, "condition")

    @_builtins.property
    @pulumi.getter(name="functionId")
    def function_id(self) -> Optional[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the function to be used as a task.
        """
        return pulumi.get(self, "function_id")

    @_builtins.property
    @pulumi.getter(name="privateEndpointMetadatas")
    def private_endpoint_metadatas(self) -> Optional[Sequence['outputs.ConnectorTaskPrivateEndpointMetadata']]:
        """
        The private endpoint metadata for the connector's source or target.
        """
        return pulumi.get(self, "private_endpoint_metadatas")


@pulumi.output_type
class ConnectorTaskPrivateEndpointMetadata(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rceDnsProxyIpAddress":
            suggest = "rce_dns_proxy_ip_address"
        elif key == "rceTrafficIpAddress":
            suggest = "rce_traffic_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorTaskPrivateEndpointMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorTaskPrivateEndpointMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorTaskPrivateEndpointMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rce_dns_proxy_ip_address: Optional[_builtins.str] = None,
                 rce_traffic_ip_address: Optional[_builtins.str] = None):
        """
        :param _builtins.str rce_dns_proxy_ip_address: The reverse connection endpoint (RCE) IP address for DNS lookups.
        :param _builtins.str rce_traffic_ip_address: The reverse connection endpoint (RCE) IP address for primary flow of traffic in the subnet.
        """
        if rce_dns_proxy_ip_address is not None:
            pulumi.set(__self__, "rce_dns_proxy_ip_address", rce_dns_proxy_ip_address)
        if rce_traffic_ip_address is not None:
            pulumi.set(__self__, "rce_traffic_ip_address", rce_traffic_ip_address)

    @_builtins.property
    @pulumi.getter(name="rceDnsProxyIpAddress")
    def rce_dns_proxy_ip_address(self) -> Optional[_builtins.str]:
        """
        The reverse connection endpoint (RCE) IP address for DNS lookups.
        """
        return pulumi.get(self, "rce_dns_proxy_ip_address")

    @_builtins.property
    @pulumi.getter(name="rceTrafficIpAddress")
    def rce_traffic_ip_address(self) -> Optional[_builtins.str]:
        """
        The reverse connection endpoint (RCE) IP address for primary flow of traffic in the subnet.
        """
        return pulumi.get(self, "rce_traffic_ip_address")


@pulumi.output_type
class GetConnectorPluginsConnectorPluginCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetConnectorPluginsConnectorPluginCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetConnectorPluginsConnectorPluginCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetConnectorPluginsConnectorPluginCollectionItemResult(dict):
    def __init__(__self__, *,
                 display_name: _builtins.str,
                 estimated_throughput: _builtins.str,
                 kind: _builtins.str,
                 max_retention: _builtins.str,
                 name: _builtins.str,
                 schema: _builtins.str,
                 state: _builtins.str,
                 time_created: _builtins.str):
        """
        :param _builtins.str display_name: A filter to return only resources that match the given display name exactly.  Example: `example_service_connector`
        :param _builtins.str estimated_throughput: The estimated throughput range (LOW, MEDIUM, HIGH).
        :param _builtins.str kind: The plugin type discriminator.
        :param _builtins.str max_retention: The estimated maximum period of time the data will be kept at the source. The duration is specified as a string in ISO 8601 format (P1D for one day or P30D for thrity days).
        :param _builtins.str name: A filter to return only resources that match the given connector plugin name ignoring case.  Example: `QueueSource`
        :param _builtins.str schema: Gets the specified connector plugin configuration information in OpenAPI specification format.
        :param _builtins.str state: A filter to return only resources that match the given lifecycle state.  Example: `ACTIVE`
        :param _builtins.str time_created: The date and time when this plugin became available. Format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2023-09-09T21:10:29.600Z`
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "estimated_throughput", estimated_throughput)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "max_retention", max_retention)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "schema", schema)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only resources that match the given display name exactly.  Example: `example_service_connector`
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="estimatedThroughput")
    def estimated_throughput(self) -> _builtins.str:
        """
        The estimated throughput range (LOW, MEDIUM, HIGH).
        """
        return pulumi.get(self, "estimated_throughput")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> _builtins.str:
        """
        The plugin type discriminator.
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter(name="maxRetention")
    def max_retention(self) -> _builtins.str:
        """
        The estimated maximum period of time the data will be kept at the source. The duration is specified as a string in ISO 8601 format (P1D for one day or P30D for thrity days).
        """
        return pulumi.get(self, "max_retention")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A filter to return only resources that match the given connector plugin name ignoring case.  Example: `QueueSource`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def schema(self) -> _builtins.str:
        """
        Gets the specified connector plugin configuration information in OpenAPI specification format.
        """
        return pulumi.get(self, "schema")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter to return only resources that match the given lifecycle state.  Example: `ACTIVE`
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time when this plugin became available. Format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2023-09-09T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetConnectorPluginsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: A filter to return only resources that match the given connector plugin name ignoring case.  Example: `QueueSource`
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A filter to return only resources that match the given connector plugin name ignoring case.  Example: `QueueSource`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetServiceConnectorSourceResult(dict):
    def __init__(__self__, *,
                 config_map: _builtins.str,
                 cursors: Sequence['outputs.GetServiceConnectorSourceCursorResult'],
                 kind: _builtins.str,
                 log_sources: Sequence['outputs.GetServiceConnectorSourceLogSourceResult'],
                 monitoring_sources: Sequence['outputs.GetServiceConnectorSourceMonitoringSourceResult'],
                 plugin_name: _builtins.str,
                 private_endpoint_metadatas: Sequence['outputs.GetServiceConnectorSourcePrivateEndpointMetadataResult'],
                 stream_id: _builtins.str):
        """
        :param _builtins.str config_map: The configuration map for the connector plugin. This map includes parameters specific to the connector plugin type.  For example, for `QueueSource`, the map lists the OCID of the selected queue. To find the parameters for a connector plugin, get the plugin using [GetConnectorPlugin](https://docs.cloud.oracle.com/iaas/api/#/en/serviceconnectors/latest/ConnectorPlugin/GetConnectorPlugin) and review its schema value.
        :param Sequence['GetServiceConnectorSourceCursorArgs'] cursors: The [read setting](https://docs.cloud.oracle.com/iaas/Content/connector-hub/create-service-connector-streaming-source.htm), which determines where in the stream to start moving data. For configuration instructions, see [Creating a Connector with a Streaming Source](https://docs.cloud.oracle.com/iaas/Content/connector-hub/create-service-connector-streaming-source.htm).
        :param _builtins.str kind: The type of dimension value: static or evaluated.
        :param Sequence['GetServiceConnectorSourceLogSourceArgs'] log_sources: The logs for this Logging source.
        :param Sequence['GetServiceConnectorSourceMonitoringSourceArgs'] monitoring_sources: One or more compartment-specific lists of metric namespaces to retrieve data from.
        :param _builtins.str plugin_name: The name of the connector plugin. This name indicates the service to be called by the connector plugin. For example, `QueueSource` indicates the Queue service. To find names of connector plugins, list the plugin using [ListConnectorPlugin](https://docs.cloud.oracle.com/iaas/api/#/en/serviceconnectors/latest/ConnectorPluginSummary/ListConnectorPlugins).
        :param Sequence['GetServiceConnectorSourcePrivateEndpointMetadataArgs'] private_endpoint_metadatas: The private endpoint metadata for the connector's source or target.
        :param _builtins.str stream_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the stream.
        """
        pulumi.set(__self__, "config_map", config_map)
        pulumi.set(__self__, "cursors", cursors)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "log_sources", log_sources)
        pulumi.set(__self__, "monitoring_sources", monitoring_sources)
        pulumi.set(__self__, "plugin_name", plugin_name)
        pulumi.set(__self__, "private_endpoint_metadatas", private_endpoint_metadatas)
        pulumi.set(__self__, "stream_id", stream_id)

    @_builtins.property
    @pulumi.getter(name="configMap")
    def config_map(self) -> _builtins.str:
        """
        The configuration map for the connector plugin. This map includes parameters specific to the connector plugin type.  For example, for `QueueSource`, the map lists the OCID of the selected queue. To find the parameters for a connector plugin, get the plugin using [GetConnectorPlugin](https://docs.cloud.oracle.com/iaas/api/#/en/serviceconnectors/latest/ConnectorPlugin/GetConnectorPlugin) and review its schema value.
        """
        return pulumi.get(self, "config_map")

    @_builtins.property
    @pulumi.getter
    def cursors(self) -> Sequence['outputs.GetServiceConnectorSourceCursorResult']:
        """
        The [read setting](https://docs.cloud.oracle.com/iaas/Content/connector-hub/create-service-connector-streaming-source.htm), which determines where in the stream to start moving data. For configuration instructions, see [Creating a Connector with a Streaming Source](https://docs.cloud.oracle.com/iaas/Content/connector-hub/create-service-connector-streaming-source.htm).
        """
        return pulumi.get(self, "cursors")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> _builtins.str:
        """
        The type of dimension value: static or evaluated.
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter(name="logSources")
    def log_sources(self) -> Sequence['outputs.GetServiceConnectorSourceLogSourceResult']:
        """
        The logs for this Logging source.
        """
        return pulumi.get(self, "log_sources")

    @_builtins.property
    @pulumi.getter(name="monitoringSources")
    def monitoring_sources(self) -> Sequence['outputs.GetServiceConnectorSourceMonitoringSourceResult']:
        """
        One or more compartment-specific lists of metric namespaces to retrieve data from.
        """
        return pulumi.get(self, "monitoring_sources")

    @_builtins.property
    @pulumi.getter(name="pluginName")
    def plugin_name(self) -> _builtins.str:
        """
        The name of the connector plugin. This name indicates the service to be called by the connector plugin. For example, `QueueSource` indicates the Queue service. To find names of connector plugins, list the plugin using [ListConnectorPlugin](https://docs.cloud.oracle.com/iaas/api/#/en/serviceconnectors/latest/ConnectorPluginSummary/ListConnectorPlugins).
        """
        return pulumi.get(self, "plugin_name")

    @_builtins.property
    @pulumi.getter(name="privateEndpointMetadatas")
    def private_endpoint_metadatas(self) -> Sequence['outputs.GetServiceConnectorSourcePrivateEndpointMetadataResult']:
        """
        The private endpoint metadata for the connector's source or target.
        """
        return pulumi.get(self, "private_endpoint_metadatas")

    @_builtins.property
    @pulumi.getter(name="streamId")
    def stream_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the stream.
        """
        return pulumi.get(self, "stream_id")


@pulumi.output_type
class GetServiceConnectorSourceCursorResult(dict):
    def __init__(__self__, *,
                 kind: _builtins.str):
        """
        :param _builtins.str kind: The type of dimension value: static or evaluated.
        """
        pulumi.set(__self__, "kind", kind)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> _builtins.str:
        """
        The type of dimension value: static or evaluated.
        """
        return pulumi.get(self, "kind")


@pulumi.output_type
class GetServiceConnectorSourceLogSourceResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 log_group_id: _builtins.str,
                 log_id: _builtins.str):
        """
        :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the metric.
        :param _builtins.str log_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Logging Analytics log group.
        :param _builtins.str log_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the log.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "log_group_id", log_group_id)
        pulumi.set(__self__, "log_id", log_id)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the metric.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Logging Analytics log group.
        """
        return pulumi.get(self, "log_group_id")

    @_builtins.property
    @pulumi.getter(name="logId")
    def log_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the log.
        """
        return pulumi.get(self, "log_id")


@pulumi.output_type
class GetServiceConnectorSourceMonitoringSourceResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 namespace_details: Sequence['outputs.GetServiceConnectorSourceMonitoringSourceNamespaceDetailResult']):
        """
        :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the metric.
        :param Sequence['GetServiceConnectorSourceMonitoringSourceNamespaceDetailArgs'] namespace_details: Discriminator for namespaces in the compartment-specific list.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "namespace_details", namespace_details)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the metric.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="namespaceDetails")
    def namespace_details(self) -> Sequence['outputs.GetServiceConnectorSourceMonitoringSourceNamespaceDetailResult']:
        """
        Discriminator for namespaces in the compartment-specific list.
        """
        return pulumi.get(self, "namespace_details")


@pulumi.output_type
class GetServiceConnectorSourceMonitoringSourceNamespaceDetailResult(dict):
    def __init__(__self__, *,
                 kind: _builtins.str,
                 namespaces: Sequence['outputs.GetServiceConnectorSourceMonitoringSourceNamespaceDetailNamespaceResult']):
        """
        :param _builtins.str kind: The type of dimension value: static or evaluated.
        :param Sequence['GetServiceConnectorSourceMonitoringSourceNamespaceDetailNamespaceArgs'] namespaces: The namespaces for the compartment-specific list.
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "namespaces", namespaces)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> _builtins.str:
        """
        The type of dimension value: static or evaluated.
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def namespaces(self) -> Sequence['outputs.GetServiceConnectorSourceMonitoringSourceNamespaceDetailNamespaceResult']:
        """
        The namespaces for the compartment-specific list.
        """
        return pulumi.get(self, "namespaces")


@pulumi.output_type
class GetServiceConnectorSourceMonitoringSourceNamespaceDetailNamespaceResult(dict):
    def __init__(__self__, *,
                 metrics: Sequence['outputs.GetServiceConnectorSourceMonitoringSourceNamespaceDetailNamespaceMetricResult'],
                 namespace: _builtins.str):
        """
        :param Sequence['GetServiceConnectorSourceMonitoringSourceNamespaceDetailNamespaceMetricArgs'] metrics: The metrics to query for the specified metric namespace.
        :param _builtins.str namespace: The namespace.
        """
        pulumi.set(__self__, "metrics", metrics)
        pulumi.set(__self__, "namespace", namespace)

    @_builtins.property
    @pulumi.getter
    def metrics(self) -> Sequence['outputs.GetServiceConnectorSourceMonitoringSourceNamespaceDetailNamespaceMetricResult']:
        """
        The metrics to query for the specified metric namespace.
        """
        return pulumi.get(self, "metrics")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        The namespace.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class GetServiceConnectorSourceMonitoringSourceNamespaceDetailNamespaceMetricResult(dict):
    def __init__(__self__, *,
                 kind: _builtins.str):
        """
        :param _builtins.str kind: The type of dimension value: static or evaluated.
        """
        pulumi.set(__self__, "kind", kind)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> _builtins.str:
        """
        The type of dimension value: static or evaluated.
        """
        return pulumi.get(self, "kind")


@pulumi.output_type
class GetServiceConnectorSourcePrivateEndpointMetadataResult(dict):
    def __init__(__self__, *,
                 rce_dns_proxy_ip_address: _builtins.str,
                 rce_traffic_ip_address: _builtins.str):
        """
        :param _builtins.str rce_dns_proxy_ip_address: The reverse connection endpoint (RCE) IP address for DNS lookups.
        :param _builtins.str rce_traffic_ip_address: The reverse connection endpoint (RCE) IP address for primary flow of traffic in the subnet.
        """
        pulumi.set(__self__, "rce_dns_proxy_ip_address", rce_dns_proxy_ip_address)
        pulumi.set(__self__, "rce_traffic_ip_address", rce_traffic_ip_address)

    @_builtins.property
    @pulumi.getter(name="rceDnsProxyIpAddress")
    def rce_dns_proxy_ip_address(self) -> _builtins.str:
        """
        The reverse connection endpoint (RCE) IP address for DNS lookups.
        """
        return pulumi.get(self, "rce_dns_proxy_ip_address")

    @_builtins.property
    @pulumi.getter(name="rceTrafficIpAddress")
    def rce_traffic_ip_address(self) -> _builtins.str:
        """
        The reverse connection endpoint (RCE) IP address for primary flow of traffic in the subnet.
        """
        return pulumi.get(self, "rce_traffic_ip_address")


@pulumi.output_type
class GetServiceConnectorTargetResult(dict):
    def __init__(__self__, *,
                 batch_rollover_size_in_mbs: _builtins.int,
                 batch_rollover_time_in_ms: _builtins.int,
                 batch_size_in_kbs: _builtins.int,
                 batch_size_in_num: _builtins.int,
                 batch_time_in_sec: _builtins.int,
                 bucket: _builtins.str,
                 compartment_id: _builtins.str,
                 dimensions: Sequence['outputs.GetServiceConnectorTargetDimensionResult'],
                 enable_formatted_messaging: _builtins.bool,
                 function_id: _builtins.str,
                 kind: _builtins.str,
                 log_group_id: _builtins.str,
                 log_source_identifier: _builtins.str,
                 metric: _builtins.str,
                 metric_namespace: _builtins.str,
                 namespace: _builtins.str,
                 object_name_prefix: _builtins.str,
                 private_endpoint_metadatas: Sequence['outputs.GetServiceConnectorTargetPrivateEndpointMetadataResult'],
                 stream_id: _builtins.str,
                 topic_id: _builtins.str):
        """
        :param _builtins.int batch_rollover_size_in_mbs: The batch rollover size in megabytes.
        :param _builtins.int batch_rollover_time_in_ms: The batch rollover time in milliseconds.
        :param _builtins.int batch_size_in_kbs: Size limit (kilobytes) for batch sent to invoke the function.
        :param _builtins.int batch_size_in_num: The batch rollover size in number of messages. Only one size option can be specified: `batchSizeInKbs` or `batchSizeInNum`.
        :param _builtins.int batch_time_in_sec: Time limit (seconds) for batch sent to invoke the function.
        :param _builtins.str bucket: The name of the bucket. Valid characters are letters (upper or lower case), numbers, hyphens (-), underscores(_), and periods (.). Bucket names must be unique within an Object Storage namespace. Avoid entering confidential information. Example: my-new-bucket1
        :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the metric.
        :param Sequence['GetServiceConnectorTargetDimensionArgs'] dimensions: List of dimension names and values.
        :param _builtins.bool enable_formatted_messaging: Whether to apply a simplified, user-friendly format to the message. Applies only when friendly formatting is supported by the connector source and the subscription protocol. Example: `true`
        :param _builtins.str function_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the function to be used as a task.
        :param _builtins.str kind: The type of dimension value: static or evaluated.
        :param _builtins.str log_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Logging Analytics log group.
        :param _builtins.str log_source_identifier: Identifier of the log source that you want to use for processing data received from the connector source. Applies to `StreamingSource` only. Equivalent to `name` at [LogAnalyticsSource](https://docs.cloud.oracle.com/iaas/api/#/en/logan-api-spec/latest/LogAnalyticsSource/).
        :param _builtins.str metric: The name of the metric. Example: `CpuUtilization`
        :param _builtins.str metric_namespace: The namespace of the metric. Example: `oci_computeagent`
        :param _builtins.str namespace: The namespace.
        :param _builtins.str object_name_prefix: The prefix of the objects. Avoid entering confidential information.
        :param Sequence['GetServiceConnectorTargetPrivateEndpointMetadataArgs'] private_endpoint_metadatas: The private endpoint metadata for the connector's source or target.
        :param _builtins.str stream_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the stream.
        :param _builtins.str topic_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the topic.
        """
        pulumi.set(__self__, "batch_rollover_size_in_mbs", batch_rollover_size_in_mbs)
        pulumi.set(__self__, "batch_rollover_time_in_ms", batch_rollover_time_in_ms)
        pulumi.set(__self__, "batch_size_in_kbs", batch_size_in_kbs)
        pulumi.set(__self__, "batch_size_in_num", batch_size_in_num)
        pulumi.set(__self__, "batch_time_in_sec", batch_time_in_sec)
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "dimensions", dimensions)
        pulumi.set(__self__, "enable_formatted_messaging", enable_formatted_messaging)
        pulumi.set(__self__, "function_id", function_id)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "log_group_id", log_group_id)
        pulumi.set(__self__, "log_source_identifier", log_source_identifier)
        pulumi.set(__self__, "metric", metric)
        pulumi.set(__self__, "metric_namespace", metric_namespace)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object_name_prefix", object_name_prefix)
        pulumi.set(__self__, "private_endpoint_metadatas", private_endpoint_metadatas)
        pulumi.set(__self__, "stream_id", stream_id)
        pulumi.set(__self__, "topic_id", topic_id)

    @_builtins.property
    @pulumi.getter(name="batchRolloverSizeInMbs")
    def batch_rollover_size_in_mbs(self) -> _builtins.int:
        """
        The batch rollover size in megabytes.
        """
        return pulumi.get(self, "batch_rollover_size_in_mbs")

    @_builtins.property
    @pulumi.getter(name="batchRolloverTimeInMs")
    def batch_rollover_time_in_ms(self) -> _builtins.int:
        """
        The batch rollover time in milliseconds.
        """
        return pulumi.get(self, "batch_rollover_time_in_ms")

    @_builtins.property
    @pulumi.getter(name="batchSizeInKbs")
    def batch_size_in_kbs(self) -> _builtins.int:
        """
        Size limit (kilobytes) for batch sent to invoke the function.
        """
        return pulumi.get(self, "batch_size_in_kbs")

    @_builtins.property
    @pulumi.getter(name="batchSizeInNum")
    def batch_size_in_num(self) -> _builtins.int:
        """
        The batch rollover size in number of messages. Only one size option can be specified: `batchSizeInKbs` or `batchSizeInNum`.
        """
        return pulumi.get(self, "batch_size_in_num")

    @_builtins.property
    @pulumi.getter(name="batchTimeInSec")
    def batch_time_in_sec(self) -> _builtins.int:
        """
        Time limit (seconds) for batch sent to invoke the function.
        """
        return pulumi.get(self, "batch_time_in_sec")

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        The name of the bucket. Valid characters are letters (upper or lower case), numbers, hyphens (-), underscores(_), and periods (.). Bucket names must be unique within an Object Storage namespace. Avoid entering confidential information. Example: my-new-bucket1
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the metric.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def dimensions(self) -> Sequence['outputs.GetServiceConnectorTargetDimensionResult']:
        """
        List of dimension names and values.
        """
        return pulumi.get(self, "dimensions")

    @_builtins.property
    @pulumi.getter(name="enableFormattedMessaging")
    def enable_formatted_messaging(self) -> _builtins.bool:
        """
        Whether to apply a simplified, user-friendly format to the message. Applies only when friendly formatting is supported by the connector source and the subscription protocol. Example: `true`
        """
        return pulumi.get(self, "enable_formatted_messaging")

    @_builtins.property
    @pulumi.getter(name="functionId")
    def function_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the function to be used as a task.
        """
        return pulumi.get(self, "function_id")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> _builtins.str:
        """
        The type of dimension value: static or evaluated.
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Logging Analytics log group.
        """
        return pulumi.get(self, "log_group_id")

    @_builtins.property
    @pulumi.getter(name="logSourceIdentifier")
    def log_source_identifier(self) -> _builtins.str:
        """
        Identifier of the log source that you want to use for processing data received from the connector source. Applies to `StreamingSource` only. Equivalent to `name` at [LogAnalyticsSource](https://docs.cloud.oracle.com/iaas/api/#/en/logan-api-spec/latest/LogAnalyticsSource/).
        """
        return pulumi.get(self, "log_source_identifier")

    @_builtins.property
    @pulumi.getter
    def metric(self) -> _builtins.str:
        """
        The name of the metric. Example: `CpuUtilization`
        """
        return pulumi.get(self, "metric")

    @_builtins.property
    @pulumi.getter(name="metricNamespace")
    def metric_namespace(self) -> _builtins.str:
        """
        The namespace of the metric. Example: `oci_computeagent`
        """
        return pulumi.get(self, "metric_namespace")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        The namespace.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="objectNamePrefix")
    def object_name_prefix(self) -> _builtins.str:
        """
        The prefix of the objects. Avoid entering confidential information.
        """
        return pulumi.get(self, "object_name_prefix")

    @_builtins.property
    @pulumi.getter(name="privateEndpointMetadatas")
    def private_endpoint_metadatas(self) -> Sequence['outputs.GetServiceConnectorTargetPrivateEndpointMetadataResult']:
        """
        The private endpoint metadata for the connector's source or target.
        """
        return pulumi.get(self, "private_endpoint_metadatas")

    @_builtins.property
    @pulumi.getter(name="streamId")
    def stream_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the stream.
        """
        return pulumi.get(self, "stream_id")

    @_builtins.property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the topic.
        """
        return pulumi.get(self, "topic_id")


@pulumi.output_type
class GetServiceConnectorTargetDimensionResult(dict):
    def __init__(__self__, *,
                 dimension_values: Sequence['outputs.GetServiceConnectorTargetDimensionDimensionValueResult'],
                 name: _builtins.str):
        """
        :param Sequence['GetServiceConnectorTargetDimensionDimensionValueArgs'] dimension_values: Instructions for extracting the value corresponding to the specified dimension key: Either extract the value as-is (static) or derive the value from a path (evaluated).
        :param _builtins.str name: Dimension key. A valid dimension key includes only printable ASCII, excluding periods (.) and spaces. Custom dimension keys are acceptable. Avoid entering confidential information. Due to use by Connector Hub, the following dimension names are reserved: `connectorId`, `connectorName`, `connectorSourceType`. For information on valid dimension keys and values, see [MetricDataDetails Reference](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/MetricDataDetails). Example: `type`
        """
        pulumi.set(__self__, "dimension_values", dimension_values)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="dimensionValues")
    def dimension_values(self) -> Sequence['outputs.GetServiceConnectorTargetDimensionDimensionValueResult']:
        """
        Instructions for extracting the value corresponding to the specified dimension key: Either extract the value as-is (static) or derive the value from a path (evaluated).
        """
        return pulumi.get(self, "dimension_values")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Dimension key. A valid dimension key includes only printable ASCII, excluding periods (.) and spaces. Custom dimension keys are acceptable. Avoid entering confidential information. Due to use by Connector Hub, the following dimension names are reserved: `connectorId`, `connectorName`, `connectorSourceType`. For information on valid dimension keys and values, see [MetricDataDetails Reference](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/MetricDataDetails). Example: `type`
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetServiceConnectorTargetDimensionDimensionValueResult(dict):
    def __init__(__self__, *,
                 kind: _builtins.str,
                 path: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str kind: The type of dimension value: static or evaluated.
        :param _builtins.str path: The location to use for deriving the dimension value (evaluated). The path must start with `logContent` in an acceptable notation style with supported [JMESPath selectors](https://jmespath.org/specification.html): expression with dot and index operator (`.` and `[]`). Example with dot notation: `logContent.data` Example with index notation: `logContent.data[0].content` For information on valid dimension keys and values, see [MetricDataDetails Reference](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/MetricDataDetails). The returned value depends on the results of evaluation. If the evaluated value is valid, then the evaluated value is returned without double quotes. (Any front or trailing double quotes are trimmed before returning the value. For example, the evaluated value `"compartmentId"` is returned as `compartmentId`.) If the evaluated value is invalid, then the returned value is `SCH_EVAL_INVALID_VALUE`. If the evaluated value is empty, then the returned value is `SCH_EVAL_VALUE_EMPTY`.
        :param _builtins.str value: The data extracted from the specified dimension value (passed as-is). Unicode characters only. For information on valid dimension keys and values, see [MetricDataDetails Reference](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/MetricDataDetails).
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> _builtins.str:
        """
        The type of dimension value: static or evaluated.
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The location to use for deriving the dimension value (evaluated). The path must start with `logContent` in an acceptable notation style with supported [JMESPath selectors](https://jmespath.org/specification.html): expression with dot and index operator (`.` and `[]`). Example with dot notation: `logContent.data` Example with index notation: `logContent.data[0].content` For information on valid dimension keys and values, see [MetricDataDetails Reference](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/MetricDataDetails). The returned value depends on the results of evaluation. If the evaluated value is valid, then the evaluated value is returned without double quotes. (Any front or trailing double quotes are trimmed before returning the value. For example, the evaluated value `"compartmentId"` is returned as `compartmentId`.) If the evaluated value is invalid, then the returned value is `SCH_EVAL_INVALID_VALUE`. If the evaluated value is empty, then the returned value is `SCH_EVAL_VALUE_EMPTY`.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The data extracted from the specified dimension value (passed as-is). Unicode characters only. For information on valid dimension keys and values, see [MetricDataDetails Reference](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/MetricDataDetails).
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetServiceConnectorTargetPrivateEndpointMetadataResult(dict):
    def __init__(__self__, *,
                 rce_dns_proxy_ip_address: _builtins.str,
                 rce_traffic_ip_address: _builtins.str):
        """
        :param _builtins.str rce_dns_proxy_ip_address: The reverse connection endpoint (RCE) IP address for DNS lookups.
        :param _builtins.str rce_traffic_ip_address: The reverse connection endpoint (RCE) IP address for primary flow of traffic in the subnet.
        """
        pulumi.set(__self__, "rce_dns_proxy_ip_address", rce_dns_proxy_ip_address)
        pulumi.set(__self__, "rce_traffic_ip_address", rce_traffic_ip_address)

    @_builtins.property
    @pulumi.getter(name="rceDnsProxyIpAddress")
    def rce_dns_proxy_ip_address(self) -> _builtins.str:
        """
        The reverse connection endpoint (RCE) IP address for DNS lookups.
        """
        return pulumi.get(self, "rce_dns_proxy_ip_address")

    @_builtins.property
    @pulumi.getter(name="rceTrafficIpAddress")
    def rce_traffic_ip_address(self) -> _builtins.str:
        """
        The reverse connection endpoint (RCE) IP address for primary flow of traffic in the subnet.
        """
        return pulumi.get(self, "rce_traffic_ip_address")


@pulumi.output_type
class GetServiceConnectorTaskResult(dict):
    def __init__(__self__, *,
                 batch_size_in_kbs: _builtins.int,
                 batch_time_in_sec: _builtins.int,
                 condition: _builtins.str,
                 function_id: _builtins.str,
                 kind: _builtins.str,
                 private_endpoint_metadatas: Sequence['outputs.GetServiceConnectorTaskPrivateEndpointMetadataResult']):
        """
        :param _builtins.int batch_size_in_kbs: Size limit (kilobytes) for batch sent to invoke the function.
        :param _builtins.int batch_time_in_sec: Time limit (seconds) for batch sent to invoke the function.
        :param _builtins.str condition: A filter or mask to limit the source used in the flow defined by the connector.
        :param _builtins.str function_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the function to be used as a task.
        :param _builtins.str kind: The type of dimension value: static or evaluated.
        :param Sequence['GetServiceConnectorTaskPrivateEndpointMetadataArgs'] private_endpoint_metadatas: The private endpoint metadata for the connector's source or target.
        """
        pulumi.set(__self__, "batch_size_in_kbs", batch_size_in_kbs)
        pulumi.set(__self__, "batch_time_in_sec", batch_time_in_sec)
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "function_id", function_id)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "private_endpoint_metadatas", private_endpoint_metadatas)

    @_builtins.property
    @pulumi.getter(name="batchSizeInKbs")
    def batch_size_in_kbs(self) -> _builtins.int:
        """
        Size limit (kilobytes) for batch sent to invoke the function.
        """
        return pulumi.get(self, "batch_size_in_kbs")

    @_builtins.property
    @pulumi.getter(name="batchTimeInSec")
    def batch_time_in_sec(self) -> _builtins.int:
        """
        Time limit (seconds) for batch sent to invoke the function.
        """
        return pulumi.get(self, "batch_time_in_sec")

    @_builtins.property
    @pulumi.getter
    def condition(self) -> _builtins.str:
        """
        A filter or mask to limit the source used in the flow defined by the connector.
        """
        return pulumi.get(self, "condition")

    @_builtins.property
    @pulumi.getter(name="functionId")
    def function_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the function to be used as a task.
        """
        return pulumi.get(self, "function_id")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> _builtins.str:
        """
        The type of dimension value: static or evaluated.
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter(name="privateEndpointMetadatas")
    def private_endpoint_metadatas(self) -> Sequence['outputs.GetServiceConnectorTaskPrivateEndpointMetadataResult']:
        """
        The private endpoint metadata for the connector's source or target.
        """
        return pulumi.get(self, "private_endpoint_metadatas")


@pulumi.output_type
class GetServiceConnectorTaskPrivateEndpointMetadataResult(dict):
    def __init__(__self__, *,
                 rce_dns_proxy_ip_address: _builtins.str,
                 rce_traffic_ip_address: _builtins.str):
        """
        :param _builtins.str rce_dns_proxy_ip_address: The reverse connection endpoint (RCE) IP address for DNS lookups.
        :param _builtins.str rce_traffic_ip_address: The reverse connection endpoint (RCE) IP address for primary flow of traffic in the subnet.
        """
        pulumi.set(__self__, "rce_dns_proxy_ip_address", rce_dns_proxy_ip_address)
        pulumi.set(__self__, "rce_traffic_ip_address", rce_traffic_ip_address)

    @_builtins.property
    @pulumi.getter(name="rceDnsProxyIpAddress")
    def rce_dns_proxy_ip_address(self) -> _builtins.str:
        """
        The reverse connection endpoint (RCE) IP address for DNS lookups.
        """
        return pulumi.get(self, "rce_dns_proxy_ip_address")

    @_builtins.property
    @pulumi.getter(name="rceTrafficIpAddress")
    def rce_traffic_ip_address(self) -> _builtins.str:
        """
        The reverse connection endpoint (RCE) IP address for primary flow of traffic in the subnet.
        """
        return pulumi.get(self, "rce_traffic_ip_address")


@pulumi.output_type
class GetServiceConnectorsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: Dimension key. A valid dimension key includes only printable ASCII, excluding periods (.) and spaces. Custom dimension keys are acceptable. Avoid entering confidential information. Due to use by Connector Hub, the following dimension names are reserved: `connectorId`, `connectorName`, `connectorSourceType`. For information on valid dimension keys and values, see [MetricDataDetails Reference](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/MetricDataDetails). Example: `type`
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Dimension key. A valid dimension key includes only printable ASCII, excluding periods (.) and spaces. Custom dimension keys are acceptable. Avoid entering confidential information. Due to use by Connector Hub, the following dimension names are reserved: `connectorId`, `connectorName`, `connectorSourceType`. For information on valid dimension keys and values, see [MetricDataDetails Reference](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/MetricDataDetails). Example: `type`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetServiceConnectorsServiceConnectorCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetServiceConnectorsServiceConnectorCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetServiceConnectorsServiceConnectorCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetServiceConnectorsServiceConnectorCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 description: _builtins.str,
                 display_name: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 lifecycle_details: _builtins.str,
                 lifecyle_details: _builtins.str,
                 sources: Sequence['outputs.GetServiceConnectorsServiceConnectorCollectionItemSourceResult'],
                 state: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 targets: Sequence['outputs.GetServiceConnectorsServiceConnectorCollectionItemTargetResult'],
                 tasks: Sequence['outputs.GetServiceConnectorsServiceConnectorCollectionItemTaskResult'],
                 time_created: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment for this request.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param _builtins.str description: The description of the resource. Avoid entering confidential information.
        :param _builtins.str display_name: A filter to return only resources that match the given display name exactly.  Example: `example_service_connector`
        :param Mapping[str, _builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param _builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the connector.
        :param _builtins.str lifecycle_details: A message describing the current state in more detail. For example, the message might provide actionable information for a resource in a `FAILED` state.
        :param _builtins.str lifecyle_details: *Please note this property is deprecated and will be removed on January 27, 2026. Use `lifecycleDetails` instead.* A message describing the current state in more detail. For example, the message might provide actionable information for a resource in a `FAILED` state.
        :param _builtins.str state: A filter to return only resources that match the given lifecycle state.  Example: `ACTIVE`
        :param Mapping[str, _builtins.str] system_tags: The system tags associated with this resource, if any. The system tags are set by Oracle Cloud Infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        :param Sequence['GetServiceConnectorsServiceConnectorCollectionItemTaskArgs'] tasks: The list of tasks.
        :param _builtins.str time_created: The date and time when the connector was created. Format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2020-01-25T21:10:29.600Z`
        :param _builtins.str time_updated: The date and time when the connector was updated. Format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2020-01-25T21:10:29.600Z`
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "lifecyle_details", lifecyle_details)
        pulumi.set(__self__, "sources", sources)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "targets", targets)
        pulumi.set(__self__, "tasks", tasks)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment for this request.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the resource. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only resources that match the given display name exactly.  Example: `example_service_connector`
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the connector.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message describing the current state in more detail. For example, the message might provide actionable information for a resource in a `FAILED` state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="lifecyleDetails")
    def lifecyle_details(self) -> _builtins.str:
        """
        *Please note this property is deprecated and will be removed on January 27, 2026. Use `lifecycleDetails` instead.* A message describing the current state in more detail. For example, the message might provide actionable information for a resource in a `FAILED` state.
        """
        return pulumi.get(self, "lifecyle_details")

    @_builtins.property
    @pulumi.getter
    def sources(self) -> Sequence['outputs.GetServiceConnectorsServiceConnectorCollectionItemSourceResult']:
        return pulumi.get(self, "sources")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter to return only resources that match the given lifecycle state.  Example: `ACTIVE`
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        The system tags associated with this resource, if any. The system tags are set by Oracle Cloud Infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter
    def targets(self) -> Sequence['outputs.GetServiceConnectorsServiceConnectorCollectionItemTargetResult']:
        return pulumi.get(self, "targets")

    @_builtins.property
    @pulumi.getter
    def tasks(self) -> Sequence['outputs.GetServiceConnectorsServiceConnectorCollectionItemTaskResult']:
        """
        The list of tasks.
        """
        return pulumi.get(self, "tasks")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time when the connector was created. Format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2020-01-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time when the connector was updated. Format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2020-01-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetServiceConnectorsServiceConnectorCollectionItemSourceResult(dict):
    def __init__(__self__, *,
                 config_map: _builtins.str,
                 cursors: Sequence['outputs.GetServiceConnectorsServiceConnectorCollectionItemSourceCursorResult'],
                 kind: _builtins.str,
                 log_sources: Sequence['outputs.GetServiceConnectorsServiceConnectorCollectionItemSourceLogSourceResult'],
                 monitoring_sources: Sequence['outputs.GetServiceConnectorsServiceConnectorCollectionItemSourceMonitoringSourceResult'],
                 plugin_name: _builtins.str,
                 private_endpoint_metadatas: Sequence['outputs.GetServiceConnectorsServiceConnectorCollectionItemSourcePrivateEndpointMetadataResult'],
                 stream_id: _builtins.str):
        """
        :param _builtins.str config_map: The configuration map for the connector plugin. This map includes parameters specific to the connector plugin type.  For example, for `QueueSource`, the map lists the OCID of the selected queue. To find the parameters for a connector plugin, get the plugin using [GetConnectorPlugin](https://docs.cloud.oracle.com/iaas/api/#/en/serviceconnectors/latest/ConnectorPlugin/GetConnectorPlugin) and review its schema value.
        :param Sequence['GetServiceConnectorsServiceConnectorCollectionItemSourceCursorArgs'] cursors: The [read setting](https://docs.cloud.oracle.com/iaas/Content/connector-hub/create-service-connector-streaming-source.htm), which determines where in the stream to start moving data. For configuration instructions, see [Creating a Connector with a Streaming Source](https://docs.cloud.oracle.com/iaas/Content/connector-hub/create-service-connector-streaming-source.htm).
        :param _builtins.str kind: The type of dimension value: static or evaluated.
        :param Sequence['GetServiceConnectorsServiceConnectorCollectionItemSourceLogSourceArgs'] log_sources: The logs for this Logging source.
        :param Sequence['GetServiceConnectorsServiceConnectorCollectionItemSourceMonitoringSourceArgs'] monitoring_sources: One or more compartment-specific lists of metric namespaces to retrieve data from.
        :param _builtins.str plugin_name: The name of the connector plugin. This name indicates the service to be called by the connector plugin. For example, `QueueSource` indicates the Queue service. To find names of connector plugins, list the plugin using [ListConnectorPlugin](https://docs.cloud.oracle.com/iaas/api/#/en/serviceconnectors/latest/ConnectorPluginSummary/ListConnectorPlugins).
        :param Sequence['GetServiceConnectorsServiceConnectorCollectionItemSourcePrivateEndpointMetadataArgs'] private_endpoint_metadatas: The private endpoint metadata for the connector's source or target.
        :param _builtins.str stream_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the stream.
        """
        pulumi.set(__self__, "config_map", config_map)
        pulumi.set(__self__, "cursors", cursors)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "log_sources", log_sources)
        pulumi.set(__self__, "monitoring_sources", monitoring_sources)
        pulumi.set(__self__, "plugin_name", plugin_name)
        pulumi.set(__self__, "private_endpoint_metadatas", private_endpoint_metadatas)
        pulumi.set(__self__, "stream_id", stream_id)

    @_builtins.property
    @pulumi.getter(name="configMap")
    def config_map(self) -> _builtins.str:
        """
        The configuration map for the connector plugin. This map includes parameters specific to the connector plugin type.  For example, for `QueueSource`, the map lists the OCID of the selected queue. To find the parameters for a connector plugin, get the plugin using [GetConnectorPlugin](https://docs.cloud.oracle.com/iaas/api/#/en/serviceconnectors/latest/ConnectorPlugin/GetConnectorPlugin) and review its schema value.
        """
        return pulumi.get(self, "config_map")

    @_builtins.property
    @pulumi.getter
    def cursors(self) -> Sequence['outputs.GetServiceConnectorsServiceConnectorCollectionItemSourceCursorResult']:
        """
        The [read setting](https://docs.cloud.oracle.com/iaas/Content/connector-hub/create-service-connector-streaming-source.htm), which determines where in the stream to start moving data. For configuration instructions, see [Creating a Connector with a Streaming Source](https://docs.cloud.oracle.com/iaas/Content/connector-hub/create-service-connector-streaming-source.htm).
        """
        return pulumi.get(self, "cursors")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> _builtins.str:
        """
        The type of dimension value: static or evaluated.
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter(name="logSources")
    def log_sources(self) -> Sequence['outputs.GetServiceConnectorsServiceConnectorCollectionItemSourceLogSourceResult']:
        """
        The logs for this Logging source.
        """
        return pulumi.get(self, "log_sources")

    @_builtins.property
    @pulumi.getter(name="monitoringSources")
    def monitoring_sources(self) -> Sequence['outputs.GetServiceConnectorsServiceConnectorCollectionItemSourceMonitoringSourceResult']:
        """
        One or more compartment-specific lists of metric namespaces to retrieve data from.
        """
        return pulumi.get(self, "monitoring_sources")

    @_builtins.property
    @pulumi.getter(name="pluginName")
    def plugin_name(self) -> _builtins.str:
        """
        The name of the connector plugin. This name indicates the service to be called by the connector plugin. For example, `QueueSource` indicates the Queue service. To find names of connector plugins, list the plugin using [ListConnectorPlugin](https://docs.cloud.oracle.com/iaas/api/#/en/serviceconnectors/latest/ConnectorPluginSummary/ListConnectorPlugins).
        """
        return pulumi.get(self, "plugin_name")

    @_builtins.property
    @pulumi.getter(name="privateEndpointMetadatas")
    def private_endpoint_metadatas(self) -> Sequence['outputs.GetServiceConnectorsServiceConnectorCollectionItemSourcePrivateEndpointMetadataResult']:
        """
        The private endpoint metadata for the connector's source or target.
        """
        return pulumi.get(self, "private_endpoint_metadatas")

    @_builtins.property
    @pulumi.getter(name="streamId")
    def stream_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the stream.
        """
        return pulumi.get(self, "stream_id")


@pulumi.output_type
class GetServiceConnectorsServiceConnectorCollectionItemSourceCursorResult(dict):
    def __init__(__self__, *,
                 kind: _builtins.str):
        """
        :param _builtins.str kind: The type of dimension value: static or evaluated.
        """
        pulumi.set(__self__, "kind", kind)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> _builtins.str:
        """
        The type of dimension value: static or evaluated.
        """
        return pulumi.get(self, "kind")


@pulumi.output_type
class GetServiceConnectorsServiceConnectorCollectionItemSourceLogSourceResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 log_group_id: _builtins.str,
                 log_id: _builtins.str):
        """
        :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment for this request.
        :param _builtins.str log_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Logging Analytics log group.
        :param _builtins.str log_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the log.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "log_group_id", log_group_id)
        pulumi.set(__self__, "log_id", log_id)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment for this request.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Logging Analytics log group.
        """
        return pulumi.get(self, "log_group_id")

    @_builtins.property
    @pulumi.getter(name="logId")
    def log_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the log.
        """
        return pulumi.get(self, "log_id")


@pulumi.output_type
class GetServiceConnectorsServiceConnectorCollectionItemSourceMonitoringSourceResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 namespace_details: Sequence['outputs.GetServiceConnectorsServiceConnectorCollectionItemSourceMonitoringSourceNamespaceDetailResult']):
        """
        :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment for this request.
        :param Sequence['GetServiceConnectorsServiceConnectorCollectionItemSourceMonitoringSourceNamespaceDetailArgs'] namespace_details: Discriminator for namespaces in the compartment-specific list.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "namespace_details", namespace_details)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment for this request.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="namespaceDetails")
    def namespace_details(self) -> Sequence['outputs.GetServiceConnectorsServiceConnectorCollectionItemSourceMonitoringSourceNamespaceDetailResult']:
        """
        Discriminator for namespaces in the compartment-specific list.
        """
        return pulumi.get(self, "namespace_details")


@pulumi.output_type
class GetServiceConnectorsServiceConnectorCollectionItemSourceMonitoringSourceNamespaceDetailResult(dict):
    def __init__(__self__, *,
                 kind: _builtins.str,
                 namespaces: Sequence['outputs.GetServiceConnectorsServiceConnectorCollectionItemSourceMonitoringSourceNamespaceDetailNamespaceResult']):
        """
        :param _builtins.str kind: The type of dimension value: static or evaluated.
        :param Sequence['GetServiceConnectorsServiceConnectorCollectionItemSourceMonitoringSourceNamespaceDetailNamespaceArgs'] namespaces: The namespaces for the compartment-specific list.
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "namespaces", namespaces)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> _builtins.str:
        """
        The type of dimension value: static or evaluated.
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def namespaces(self) -> Sequence['outputs.GetServiceConnectorsServiceConnectorCollectionItemSourceMonitoringSourceNamespaceDetailNamespaceResult']:
        """
        The namespaces for the compartment-specific list.
        """
        return pulumi.get(self, "namespaces")


@pulumi.output_type
class GetServiceConnectorsServiceConnectorCollectionItemSourceMonitoringSourceNamespaceDetailNamespaceResult(dict):
    def __init__(__self__, *,
                 metrics: Sequence['outputs.GetServiceConnectorsServiceConnectorCollectionItemSourceMonitoringSourceNamespaceDetailNamespaceMetricResult'],
                 namespace: _builtins.str):
        """
        :param Sequence['GetServiceConnectorsServiceConnectorCollectionItemSourceMonitoringSourceNamespaceDetailNamespaceMetricArgs'] metrics: The metrics to query for the specified metric namespace.
        :param _builtins.str namespace: The namespace.
        """
        pulumi.set(__self__, "metrics", metrics)
        pulumi.set(__self__, "namespace", namespace)

    @_builtins.property
    @pulumi.getter
    def metrics(self) -> Sequence['outputs.GetServiceConnectorsServiceConnectorCollectionItemSourceMonitoringSourceNamespaceDetailNamespaceMetricResult']:
        """
        The metrics to query for the specified metric namespace.
        """
        return pulumi.get(self, "metrics")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        The namespace.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class GetServiceConnectorsServiceConnectorCollectionItemSourceMonitoringSourceNamespaceDetailNamespaceMetricResult(dict):
    def __init__(__self__, *,
                 kind: _builtins.str):
        """
        :param _builtins.str kind: The type of dimension value: static or evaluated.
        """
        pulumi.set(__self__, "kind", kind)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> _builtins.str:
        """
        The type of dimension value: static or evaluated.
        """
        return pulumi.get(self, "kind")


@pulumi.output_type
class GetServiceConnectorsServiceConnectorCollectionItemSourcePrivateEndpointMetadataResult(dict):
    def __init__(__self__, *,
                 rce_dns_proxy_ip_address: _builtins.str,
                 rce_traffic_ip_address: _builtins.str):
        """
        :param _builtins.str rce_dns_proxy_ip_address: The reverse connection endpoint (RCE) IP address for DNS lookups.
        :param _builtins.str rce_traffic_ip_address: The reverse connection endpoint (RCE) IP address for primary flow of traffic in the subnet.
        """
        pulumi.set(__self__, "rce_dns_proxy_ip_address", rce_dns_proxy_ip_address)
        pulumi.set(__self__, "rce_traffic_ip_address", rce_traffic_ip_address)

    @_builtins.property
    @pulumi.getter(name="rceDnsProxyIpAddress")
    def rce_dns_proxy_ip_address(self) -> _builtins.str:
        """
        The reverse connection endpoint (RCE) IP address for DNS lookups.
        """
        return pulumi.get(self, "rce_dns_proxy_ip_address")

    @_builtins.property
    @pulumi.getter(name="rceTrafficIpAddress")
    def rce_traffic_ip_address(self) -> _builtins.str:
        """
        The reverse connection endpoint (RCE) IP address for primary flow of traffic in the subnet.
        """
        return pulumi.get(self, "rce_traffic_ip_address")


@pulumi.output_type
class GetServiceConnectorsServiceConnectorCollectionItemTargetResult(dict):
    def __init__(__self__, *,
                 batch_rollover_size_in_mbs: _builtins.int,
                 batch_rollover_time_in_ms: _builtins.int,
                 batch_size_in_kbs: _builtins.int,
                 batch_size_in_num: _builtins.int,
                 batch_time_in_sec: _builtins.int,
                 bucket: _builtins.str,
                 compartment_id: _builtins.str,
                 dimensions: Sequence['outputs.GetServiceConnectorsServiceConnectorCollectionItemTargetDimensionResult'],
                 enable_formatted_messaging: _builtins.bool,
                 function_id: _builtins.str,
                 kind: _builtins.str,
                 log_group_id: _builtins.str,
                 log_source_identifier: _builtins.str,
                 metric: _builtins.str,
                 metric_namespace: _builtins.str,
                 namespace: _builtins.str,
                 object_name_prefix: _builtins.str,
                 private_endpoint_metadatas: Sequence['outputs.GetServiceConnectorsServiceConnectorCollectionItemTargetPrivateEndpointMetadataResult'],
                 stream_id: _builtins.str,
                 topic_id: _builtins.str):
        """
        :param _builtins.int batch_rollover_size_in_mbs: The batch rollover size in megabytes.
        :param _builtins.int batch_rollover_time_in_ms: The batch rollover time in milliseconds.
        :param _builtins.int batch_size_in_kbs: Size limit (kilobytes) for batch sent to invoke the function.
        :param _builtins.int batch_size_in_num: The batch rollover size in number of messages. Only one size option can be specified: `batchSizeInKbs` or `batchSizeInNum`.
        :param _builtins.int batch_time_in_sec: Time limit (seconds) for batch sent to invoke the function.
        :param _builtins.str bucket: The name of the bucket. Valid characters are letters (upper or lower case), numbers, hyphens (-), underscores(_), and periods (.). Bucket names must be unique within an Object Storage namespace. Avoid entering confidential information. Example: my-new-bucket1
        :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment for this request.
        :param Sequence['GetServiceConnectorsServiceConnectorCollectionItemTargetDimensionArgs'] dimensions: List of dimension names and values.
        :param _builtins.bool enable_formatted_messaging: Whether to apply a simplified, user-friendly format to the message. Applies only when friendly formatting is supported by the connector source and the subscription protocol. Example: `true`
        :param _builtins.str function_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the function to be used as a task.
        :param _builtins.str kind: The type of dimension value: static or evaluated.
        :param _builtins.str log_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Logging Analytics log group.
        :param _builtins.str log_source_identifier: Identifier of the log source that you want to use for processing data received from the connector source. Applies to `StreamingSource` only. Equivalent to `name` at [LogAnalyticsSource](https://docs.cloud.oracle.com/iaas/api/#/en/logan-api-spec/latest/LogAnalyticsSource/).
        :param _builtins.str metric: The name of the metric. Example: `CpuUtilization`
        :param _builtins.str metric_namespace: The namespace of the metric. Example: `oci_computeagent`
        :param _builtins.str namespace: The namespace.
        :param _builtins.str object_name_prefix: The prefix of the objects. Avoid entering confidential information.
        :param Sequence['GetServiceConnectorsServiceConnectorCollectionItemTargetPrivateEndpointMetadataArgs'] private_endpoint_metadatas: The private endpoint metadata for the connector's source or target.
        :param _builtins.str stream_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the stream.
        :param _builtins.str topic_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the topic.
        """
        pulumi.set(__self__, "batch_rollover_size_in_mbs", batch_rollover_size_in_mbs)
        pulumi.set(__self__, "batch_rollover_time_in_ms", batch_rollover_time_in_ms)
        pulumi.set(__self__, "batch_size_in_kbs", batch_size_in_kbs)
        pulumi.set(__self__, "batch_size_in_num", batch_size_in_num)
        pulumi.set(__self__, "batch_time_in_sec", batch_time_in_sec)
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "dimensions", dimensions)
        pulumi.set(__self__, "enable_formatted_messaging", enable_formatted_messaging)
        pulumi.set(__self__, "function_id", function_id)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "log_group_id", log_group_id)
        pulumi.set(__self__, "log_source_identifier", log_source_identifier)
        pulumi.set(__self__, "metric", metric)
        pulumi.set(__self__, "metric_namespace", metric_namespace)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object_name_prefix", object_name_prefix)
        pulumi.set(__self__, "private_endpoint_metadatas", private_endpoint_metadatas)
        pulumi.set(__self__, "stream_id", stream_id)
        pulumi.set(__self__, "topic_id", topic_id)

    @_builtins.property
    @pulumi.getter(name="batchRolloverSizeInMbs")
    def batch_rollover_size_in_mbs(self) -> _builtins.int:
        """
        The batch rollover size in megabytes.
        """
        return pulumi.get(self, "batch_rollover_size_in_mbs")

    @_builtins.property
    @pulumi.getter(name="batchRolloverTimeInMs")
    def batch_rollover_time_in_ms(self) -> _builtins.int:
        """
        The batch rollover time in milliseconds.
        """
        return pulumi.get(self, "batch_rollover_time_in_ms")

    @_builtins.property
    @pulumi.getter(name="batchSizeInKbs")
    def batch_size_in_kbs(self) -> _builtins.int:
        """
        Size limit (kilobytes) for batch sent to invoke the function.
        """
        return pulumi.get(self, "batch_size_in_kbs")

    @_builtins.property
    @pulumi.getter(name="batchSizeInNum")
    def batch_size_in_num(self) -> _builtins.int:
        """
        The batch rollover size in number of messages. Only one size option can be specified: `batchSizeInKbs` or `batchSizeInNum`.
        """
        return pulumi.get(self, "batch_size_in_num")

    @_builtins.property
    @pulumi.getter(name="batchTimeInSec")
    def batch_time_in_sec(self) -> _builtins.int:
        """
        Time limit (seconds) for batch sent to invoke the function.
        """
        return pulumi.get(self, "batch_time_in_sec")

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        The name of the bucket. Valid characters are letters (upper or lower case), numbers, hyphens (-), underscores(_), and periods (.). Bucket names must be unique within an Object Storage namespace. Avoid entering confidential information. Example: my-new-bucket1
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment for this request.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def dimensions(self) -> Sequence['outputs.GetServiceConnectorsServiceConnectorCollectionItemTargetDimensionResult']:
        """
        List of dimension names and values.
        """
        return pulumi.get(self, "dimensions")

    @_builtins.property
    @pulumi.getter(name="enableFormattedMessaging")
    def enable_formatted_messaging(self) -> _builtins.bool:
        """
        Whether to apply a simplified, user-friendly format to the message. Applies only when friendly formatting is supported by the connector source and the subscription protocol. Example: `true`
        """
        return pulumi.get(self, "enable_formatted_messaging")

    @_builtins.property
    @pulumi.getter(name="functionId")
    def function_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the function to be used as a task.
        """
        return pulumi.get(self, "function_id")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> _builtins.str:
        """
        The type of dimension value: static or evaluated.
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Logging Analytics log group.
        """
        return pulumi.get(self, "log_group_id")

    @_builtins.property
    @pulumi.getter(name="logSourceIdentifier")
    def log_source_identifier(self) -> _builtins.str:
        """
        Identifier of the log source that you want to use for processing data received from the connector source. Applies to `StreamingSource` only. Equivalent to `name` at [LogAnalyticsSource](https://docs.cloud.oracle.com/iaas/api/#/en/logan-api-spec/latest/LogAnalyticsSource/).
        """
        return pulumi.get(self, "log_source_identifier")

    @_builtins.property
    @pulumi.getter
    def metric(self) -> _builtins.str:
        """
        The name of the metric. Example: `CpuUtilization`
        """
        return pulumi.get(self, "metric")

    @_builtins.property
    @pulumi.getter(name="metricNamespace")
    def metric_namespace(self) -> _builtins.str:
        """
        The namespace of the metric. Example: `oci_computeagent`
        """
        return pulumi.get(self, "metric_namespace")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        The namespace.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="objectNamePrefix")
    def object_name_prefix(self) -> _builtins.str:
        """
        The prefix of the objects. Avoid entering confidential information.
        """
        return pulumi.get(self, "object_name_prefix")

    @_builtins.property
    @pulumi.getter(name="privateEndpointMetadatas")
    def private_endpoint_metadatas(self) -> Sequence['outputs.GetServiceConnectorsServiceConnectorCollectionItemTargetPrivateEndpointMetadataResult']:
        """
        The private endpoint metadata for the connector's source or target.
        """
        return pulumi.get(self, "private_endpoint_metadatas")

    @_builtins.property
    @pulumi.getter(name="streamId")
    def stream_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the stream.
        """
        return pulumi.get(self, "stream_id")

    @_builtins.property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the topic.
        """
        return pulumi.get(self, "topic_id")


@pulumi.output_type
class GetServiceConnectorsServiceConnectorCollectionItemTargetDimensionResult(dict):
    def __init__(__self__, *,
                 dimension_values: Sequence['outputs.GetServiceConnectorsServiceConnectorCollectionItemTargetDimensionDimensionValueResult'],
                 name: _builtins.str):
        """
        :param Sequence['GetServiceConnectorsServiceConnectorCollectionItemTargetDimensionDimensionValueArgs'] dimension_values: Instructions for extracting the value corresponding to the specified dimension key: Either extract the value as-is (static) or derive the value from a path (evaluated).
        :param _builtins.str name: Dimension key. A valid dimension key includes only printable ASCII, excluding periods (.) and spaces. Custom dimension keys are acceptable. Avoid entering confidential information. Due to use by Connector Hub, the following dimension names are reserved: `connectorId`, `connectorName`, `connectorSourceType`. For information on valid dimension keys and values, see [MetricDataDetails Reference](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/MetricDataDetails). Example: `type`
        """
        pulumi.set(__self__, "dimension_values", dimension_values)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="dimensionValues")
    def dimension_values(self) -> Sequence['outputs.GetServiceConnectorsServiceConnectorCollectionItemTargetDimensionDimensionValueResult']:
        """
        Instructions for extracting the value corresponding to the specified dimension key: Either extract the value as-is (static) or derive the value from a path (evaluated).
        """
        return pulumi.get(self, "dimension_values")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Dimension key. A valid dimension key includes only printable ASCII, excluding periods (.) and spaces. Custom dimension keys are acceptable. Avoid entering confidential information. Due to use by Connector Hub, the following dimension names are reserved: `connectorId`, `connectorName`, `connectorSourceType`. For information on valid dimension keys and values, see [MetricDataDetails Reference](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/MetricDataDetails). Example: `type`
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetServiceConnectorsServiceConnectorCollectionItemTargetDimensionDimensionValueResult(dict):
    def __init__(__self__, *,
                 kind: _builtins.str,
                 path: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str kind: The type of dimension value: static or evaluated.
        :param _builtins.str path: The location to use for deriving the dimension value (evaluated). The path must start with `logContent` in an acceptable notation style with supported [JMESPath selectors](https://jmespath.org/specification.html): expression with dot and index operator (`.` and `[]`). Example with dot notation: `logContent.data` Example with index notation: `logContent.data[0].content` For information on valid dimension keys and values, see [MetricDataDetails Reference](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/MetricDataDetails). The returned value depends on the results of evaluation. If the evaluated value is valid, then the evaluated value is returned without double quotes. (Any front or trailing double quotes are trimmed before returning the value. For example, the evaluated value `"compartmentId"` is returned as `compartmentId`.) If the evaluated value is invalid, then the returned value is `SCH_EVAL_INVALID_VALUE`. If the evaluated value is empty, then the returned value is `SCH_EVAL_VALUE_EMPTY`.
        :param _builtins.str value: The data extracted from the specified dimension value (passed as-is). Unicode characters only. For information on valid dimension keys and values, see [MetricDataDetails Reference](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/MetricDataDetails).
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> _builtins.str:
        """
        The type of dimension value: static or evaluated.
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The location to use for deriving the dimension value (evaluated). The path must start with `logContent` in an acceptable notation style with supported [JMESPath selectors](https://jmespath.org/specification.html): expression with dot and index operator (`.` and `[]`). Example with dot notation: `logContent.data` Example with index notation: `logContent.data[0].content` For information on valid dimension keys and values, see [MetricDataDetails Reference](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/MetricDataDetails). The returned value depends on the results of evaluation. If the evaluated value is valid, then the evaluated value is returned without double quotes. (Any front or trailing double quotes are trimmed before returning the value. For example, the evaluated value `"compartmentId"` is returned as `compartmentId`.) If the evaluated value is invalid, then the returned value is `SCH_EVAL_INVALID_VALUE`. If the evaluated value is empty, then the returned value is `SCH_EVAL_VALUE_EMPTY`.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The data extracted from the specified dimension value (passed as-is). Unicode characters only. For information on valid dimension keys and values, see [MetricDataDetails Reference](https://docs.cloud.oracle.com/iaas/api/#/en/monitoring/latest/datatypes/MetricDataDetails).
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetServiceConnectorsServiceConnectorCollectionItemTargetPrivateEndpointMetadataResult(dict):
    def __init__(__self__, *,
                 rce_dns_proxy_ip_address: _builtins.str,
                 rce_traffic_ip_address: _builtins.str):
        """
        :param _builtins.str rce_dns_proxy_ip_address: The reverse connection endpoint (RCE) IP address for DNS lookups.
        :param _builtins.str rce_traffic_ip_address: The reverse connection endpoint (RCE) IP address for primary flow of traffic in the subnet.
        """
        pulumi.set(__self__, "rce_dns_proxy_ip_address", rce_dns_proxy_ip_address)
        pulumi.set(__self__, "rce_traffic_ip_address", rce_traffic_ip_address)

    @_builtins.property
    @pulumi.getter(name="rceDnsProxyIpAddress")
    def rce_dns_proxy_ip_address(self) -> _builtins.str:
        """
        The reverse connection endpoint (RCE) IP address for DNS lookups.
        """
        return pulumi.get(self, "rce_dns_proxy_ip_address")

    @_builtins.property
    @pulumi.getter(name="rceTrafficIpAddress")
    def rce_traffic_ip_address(self) -> _builtins.str:
        """
        The reverse connection endpoint (RCE) IP address for primary flow of traffic in the subnet.
        """
        return pulumi.get(self, "rce_traffic_ip_address")


@pulumi.output_type
class GetServiceConnectorsServiceConnectorCollectionItemTaskResult(dict):
    def __init__(__self__, *,
                 batch_size_in_kbs: _builtins.int,
                 batch_time_in_sec: _builtins.int,
                 condition: _builtins.str,
                 function_id: _builtins.str,
                 kind: _builtins.str,
                 private_endpoint_metadatas: Sequence['outputs.GetServiceConnectorsServiceConnectorCollectionItemTaskPrivateEndpointMetadataResult']):
        """
        :param _builtins.int batch_size_in_kbs: Size limit (kilobytes) for batch sent to invoke the function.
        :param _builtins.int batch_time_in_sec: Time limit (seconds) for batch sent to invoke the function.
        :param _builtins.str condition: A filter or mask to limit the source used in the flow defined by the connector.
        :param _builtins.str function_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the function to be used as a task.
        :param _builtins.str kind: The type of dimension value: static or evaluated.
        :param Sequence['GetServiceConnectorsServiceConnectorCollectionItemTaskPrivateEndpointMetadataArgs'] private_endpoint_metadatas: The private endpoint metadata for the connector's source or target.
        """
        pulumi.set(__self__, "batch_size_in_kbs", batch_size_in_kbs)
        pulumi.set(__self__, "batch_time_in_sec", batch_time_in_sec)
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "function_id", function_id)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "private_endpoint_metadatas", private_endpoint_metadatas)

    @_builtins.property
    @pulumi.getter(name="batchSizeInKbs")
    def batch_size_in_kbs(self) -> _builtins.int:
        """
        Size limit (kilobytes) for batch sent to invoke the function.
        """
        return pulumi.get(self, "batch_size_in_kbs")

    @_builtins.property
    @pulumi.getter(name="batchTimeInSec")
    def batch_time_in_sec(self) -> _builtins.int:
        """
        Time limit (seconds) for batch sent to invoke the function.
        """
        return pulumi.get(self, "batch_time_in_sec")

    @_builtins.property
    @pulumi.getter
    def condition(self) -> _builtins.str:
        """
        A filter or mask to limit the source used in the flow defined by the connector.
        """
        return pulumi.get(self, "condition")

    @_builtins.property
    @pulumi.getter(name="functionId")
    def function_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the function to be used as a task.
        """
        return pulumi.get(self, "function_id")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> _builtins.str:
        """
        The type of dimension value: static or evaluated.
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter(name="privateEndpointMetadatas")
    def private_endpoint_metadatas(self) -> Sequence['outputs.GetServiceConnectorsServiceConnectorCollectionItemTaskPrivateEndpointMetadataResult']:
        """
        The private endpoint metadata for the connector's source or target.
        """
        return pulumi.get(self, "private_endpoint_metadatas")


@pulumi.output_type
class GetServiceConnectorsServiceConnectorCollectionItemTaskPrivateEndpointMetadataResult(dict):
    def __init__(__self__, *,
                 rce_dns_proxy_ip_address: _builtins.str,
                 rce_traffic_ip_address: _builtins.str):
        """
        :param _builtins.str rce_dns_proxy_ip_address: The reverse connection endpoint (RCE) IP address for DNS lookups.
        :param _builtins.str rce_traffic_ip_address: The reverse connection endpoint (RCE) IP address for primary flow of traffic in the subnet.
        """
        pulumi.set(__self__, "rce_dns_proxy_ip_address", rce_dns_proxy_ip_address)
        pulumi.set(__self__, "rce_traffic_ip_address", rce_traffic_ip_address)

    @_builtins.property
    @pulumi.getter(name="rceDnsProxyIpAddress")
    def rce_dns_proxy_ip_address(self) -> _builtins.str:
        """
        The reverse connection endpoint (RCE) IP address for DNS lookups.
        """
        return pulumi.get(self, "rce_dns_proxy_ip_address")

    @_builtins.property
    @pulumi.getter(name="rceTrafficIpAddress")
    def rce_traffic_ip_address(self) -> _builtins.str:
        """
        The reverse connection endpoint (RCE) IP address for primary flow of traffic in the subnet.
        """
        return pulumi.get(self, "rce_traffic_ip_address")


