# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSenderInvitationResult',
    'AwaitableGetSenderInvitationResult',
    'get_sender_invitation',
    'get_sender_invitation_output',
]

@pulumi.output_type
class GetSenderInvitationResult:
    """
    A collection of values returned by getSenderInvitation.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, recipient_email_address=None, recipient_invitation_id=None, recipient_tenancy_id=None, sender_invitation_id=None, state=None, status=None, subjects=None, system_tags=None, time_created=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if recipient_email_address and not isinstance(recipient_email_address, str):
            raise TypeError("Expected argument 'recipient_email_address' to be a str")
        pulumi.set(__self__, "recipient_email_address", recipient_email_address)
        if recipient_invitation_id and not isinstance(recipient_invitation_id, str):
            raise TypeError("Expected argument 'recipient_invitation_id' to be a str")
        pulumi.set(__self__, "recipient_invitation_id", recipient_invitation_id)
        if recipient_tenancy_id and not isinstance(recipient_tenancy_id, str):
            raise TypeError("Expected argument 'recipient_tenancy_id' to be a str")
        pulumi.set(__self__, "recipient_tenancy_id", recipient_tenancy_id)
        if sender_invitation_id and not isinstance(sender_invitation_id, str):
            raise TypeError("Expected argument 'sender_invitation_id' to be a str")
        pulumi.set(__self__, "sender_invitation_id", sender_invitation_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if subjects and not isinstance(subjects, list):
            raise TypeError("Expected argument 'subjects' to be a list")
        pulumi.set(__self__, "subjects", subjects)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        OCID of the sender tenancy.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A user-created name to describe the invitation. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="recipientEmailAddress")
    def recipient_email_address(self) -> _builtins.str:
        """
        Email address of the recipient.
        """
        return pulumi.get(self, "recipient_email_address")

    @_builtins.property
    @pulumi.getter(name="recipientInvitationId")
    def recipient_invitation_id(self) -> _builtins.str:
        """
        OCID of the corresponding recipient invitation.
        """
        return pulumi.get(self, "recipient_invitation_id")

    @_builtins.property
    @pulumi.getter(name="recipientTenancyId")
    def recipient_tenancy_id(self) -> _builtins.str:
        """
        OCID of the recipient tenancy.
        """
        return pulumi.get(self, "recipient_tenancy_id")

    @_builtins.property
    @pulumi.getter(name="senderInvitationId")
    def sender_invitation_id(self) -> _builtins.str:
        return pulumi.get(self, "sender_invitation_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        Lifecycle state of the sender invitation.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the sender invitation.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def subjects(self) -> Sequence[_builtins.str]:
        """
        The list of subjects the invitation contains.
        """
        return pulumi.get(self, "subjects")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        Date and time when the sender invitation was created.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        Date and time when the sender invitation was last updated.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetSenderInvitationResult(GetSenderInvitationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSenderInvitationResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            recipient_email_address=self.recipient_email_address,
            recipient_invitation_id=self.recipient_invitation_id,
            recipient_tenancy_id=self.recipient_tenancy_id,
            sender_invitation_id=self.sender_invitation_id,
            state=self.state,
            status=self.status,
            subjects=self.subjects,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_sender_invitation(sender_invitation_id: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSenderInvitationResult:
    """
    This data source provides details about a specific Sender Invitation resource in Oracle Cloud Infrastructure Tenantmanagercontrolplane service.

    Gets information about the sender invitation.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sender_invitation = oci.Tenantmanagercontrolplane.get_sender_invitation(sender_invitation_id=test_sender_invitation_oci_tenantmanagercontrolplane_sender_invitation["id"])
    ```


    :param _builtins.str sender_invitation_id: OCID of the sender invitation to retrieve.
    """
    __args__ = dict()
    __args__['senderInvitationId'] = sender_invitation_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Tenantmanagercontrolplane/getSenderInvitation:getSenderInvitation', __args__, opts=opts, typ=GetSenderInvitationResult).value

    return AwaitableGetSenderInvitationResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        recipient_email_address=pulumi.get(__ret__, 'recipient_email_address'),
        recipient_invitation_id=pulumi.get(__ret__, 'recipient_invitation_id'),
        recipient_tenancy_id=pulumi.get(__ret__, 'recipient_tenancy_id'),
        sender_invitation_id=pulumi.get(__ret__, 'sender_invitation_id'),
        state=pulumi.get(__ret__, 'state'),
        status=pulumi.get(__ret__, 'status'),
        subjects=pulumi.get(__ret__, 'subjects'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_sender_invitation_output(sender_invitation_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSenderInvitationResult]:
    """
    This data source provides details about a specific Sender Invitation resource in Oracle Cloud Infrastructure Tenantmanagercontrolplane service.

    Gets information about the sender invitation.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sender_invitation = oci.Tenantmanagercontrolplane.get_sender_invitation(sender_invitation_id=test_sender_invitation_oci_tenantmanagercontrolplane_sender_invitation["id"])
    ```


    :param _builtins.str sender_invitation_id: OCID of the sender invitation to retrieve.
    """
    __args__ = dict()
    __args__['senderInvitationId'] = sender_invitation_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Tenantmanagercontrolplane/getSenderInvitation:getSenderInvitation', __args__, opts=opts, typ=GetSenderInvitationResult)
    return __ret__.apply(lambda __response__: GetSenderInvitationResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        recipient_email_address=pulumi.get(__response__, 'recipient_email_address'),
        recipient_invitation_id=pulumi.get(__response__, 'recipient_invitation_id'),
        recipient_tenancy_id=pulumi.get(__response__, 'recipient_tenancy_id'),
        sender_invitation_id=pulumi.get(__response__, 'sender_invitation_id'),
        state=pulumi.get(__response__, 'state'),
        status=pulumi.get(__response__, 'status'),
        subjects=pulumi.get(__response__, 'subjects'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
