# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSecretsResult',
    'AwaitableGetSecretsResult',
    'get_secrets',
    'get_secrets_output',
]

@pulumi.output_type
class GetSecretsResult:
    """
    A collection of values returned by getSecrets.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, name=None, secrets=None, state=None, vault_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if secrets and not isinstance(secrets, list):
            raise TypeError("Expected argument 'secrets' to be a list")
        pulumi.set(__self__, "secrets", secrets)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if vault_id and not isinstance(vault_id, str):
            raise TypeError("Expected argument 'vault_id' to be a str")
        pulumi.set(__self__, "vault_id", vault_id)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment where you want to create the secret.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSecretsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def secrets(self) -> Sequence['outputs.GetSecretsSecretResult']:
        """
        The list of secrets.
        """
        return pulumi.get(self, "secrets")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current lifecycle state of the secret.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the Vault in which the secret exists
        """
        return pulumi.get(self, "vault_id")


class AwaitableGetSecretsResult(GetSecretsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecretsResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            name=self.name,
            secrets=self.secrets,
            state=self.state,
            vault_id=self.vault_id)


def get_secrets(compartment_id: Optional[_builtins.str] = None,
                filters: Optional[Sequence[Union['GetSecretsFilterArgs', 'GetSecretsFilterArgsDict']]] = None,
                name: Optional[_builtins.str] = None,
                state: Optional[_builtins.str] = None,
                vault_id: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecretsResult:
    """
    This data source provides the list of Secrets in Oracle Cloud Infrastructure Vault service.

    Lists all secrets in the specified vault and compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_secrets = oci.Vault.get_secrets(compartment_id=compartment_id,
        name=secret_name,
        state=secret_state,
        vault_id=test_vault["id"])
    ```


    :param _builtins.str compartment_id: The OCID of the compartment.
    :param _builtins.str name: The secret name.
    :param _builtins.str state: A filter that returns only resources that match the specified lifecycle state. The state value is case-insensitive.
    :param _builtins.str vault_id: The OCID of the vault.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['state'] = state
    __args__['vaultId'] = vault_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Vault/getSecrets:getSecrets', __args__, opts=opts, typ=GetSecretsResult).value

    return AwaitableGetSecretsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        secrets=pulumi.get(__ret__, 'secrets'),
        state=pulumi.get(__ret__, 'state'),
        vault_id=pulumi.get(__ret__, 'vault_id'))
def get_secrets_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                       filters: Optional[pulumi.Input[Optional[Sequence[Union['GetSecretsFilterArgs', 'GetSecretsFilterArgsDict']]]]] = None,
                       name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       vault_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecretsResult]:
    """
    This data source provides the list of Secrets in Oracle Cloud Infrastructure Vault service.

    Lists all secrets in the specified vault and compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_secrets = oci.Vault.get_secrets(compartment_id=compartment_id,
        name=secret_name,
        state=secret_state,
        vault_id=test_vault["id"])
    ```


    :param _builtins.str compartment_id: The OCID of the compartment.
    :param _builtins.str name: The secret name.
    :param _builtins.str state: A filter that returns only resources that match the specified lifecycle state. The state value is case-insensitive.
    :param _builtins.str vault_id: The OCID of the vault.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['state'] = state
    __args__['vaultId'] = vault_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Vault/getSecrets:getSecrets', __args__, opts=opts, typ=GetSecretsResult)
    return __ret__.apply(lambda __response__: GetSecretsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        secrets=pulumi.get(__response__, 'secrets'),
        state=pulumi.get(__response__, 'state'),
        vault_id=pulumi.get(__response__, 'vault_id')))
