# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetContainerScanTargetResult',
    'AwaitableGetContainerScanTargetResult',
    'get_container_scan_target',
    'get_container_scan_target_output',
]

@pulumi.output_type
class GetContainerScanTargetResult:
    """
    A collection of values returned by getContainerScanTarget.
    """
    def __init__(__self__, compartment_id=None, container_scan_recipe_id=None, container_scan_target_id=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, id=None, state=None, system_tags=None, target_registries=None, time_created=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if container_scan_recipe_id and not isinstance(container_scan_recipe_id, str):
            raise TypeError("Expected argument 'container_scan_recipe_id' to be a str")
        pulumi.set(__self__, "container_scan_recipe_id", container_scan_recipe_id)
        if container_scan_target_id and not isinstance(container_scan_target_id, str):
            raise TypeError("Expected argument 'container_scan_target_id' to be a str")
        pulumi.set(__self__, "container_scan_target_id", container_scan_target_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if target_registries and not isinstance(target_registries, list):
            raise TypeError("Expected argument 'target_registries' to be a list")
        pulumi.set(__self__, "target_registries", target_registries)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to perform the scans in. All listed repositories must be in the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="containerScanRecipeId")
    def container_scan_recipe_id(self) -> _builtins.str:
        """
        ID of the container scan recipe this target applies.
        """
        return pulumi.get(self, "container_scan_recipe_id")

    @_builtins.property
    @pulumi.getter(name="containerScanTargetId")
    def container_scan_target_id(self) -> _builtins.str:
        return pulumi.get(self, "container_scan_target_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Target description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        User friendly name of container scan target
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of container scan target. Immutable and generated on creation.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the config.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="targetRegistries")
    def target_registries(self) -> Sequence['outputs.GetContainerScanTargetTargetRegistryResult']:
        """
        Registry information for a container scan target
        """
        return pulumi.get(self, "target_registries")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        Date and time the target was created, format as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339)
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        Date and time the target was last updated, format as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339)
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetContainerScanTargetResult(GetContainerScanTargetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetContainerScanTargetResult(
            compartment_id=self.compartment_id,
            container_scan_recipe_id=self.container_scan_recipe_id,
            container_scan_target_id=self.container_scan_target_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            state=self.state,
            system_tags=self.system_tags,
            target_registries=self.target_registries,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_container_scan_target(container_scan_target_id: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetContainerScanTargetResult:
    """
    This data source provides details about a specific Container Scan Target resource in Oracle Cloud Infrastructure Vulnerability Scanning service.

    Gets a ContainerScanTarget identified by the target ID. A container scan target specifies a group of one or more Docker image repositories in Oracle Cloud Infrastructure Registry (OCIR) that you want routinely scanned for security vulnerabilities.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_container_scan_target = oci.VulnerabilityScanning.get_container_scan_target(container_scan_target_id=test_container_scan_target_oci_vulnerability_scanning_container_scan_target["id"])
    ```


    :param _builtins.str container_scan_target_id: unique ContainerScanTarget identifier
    """
    __args__ = dict()
    __args__['containerScanTargetId'] = container_scan_target_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:VulnerabilityScanning/getContainerScanTarget:getContainerScanTarget', __args__, opts=opts, typ=GetContainerScanTargetResult).value

    return AwaitableGetContainerScanTargetResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        container_scan_recipe_id=pulumi.get(__ret__, 'container_scan_recipe_id'),
        container_scan_target_id=pulumi.get(__ret__, 'container_scan_target_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        target_registries=pulumi.get(__ret__, 'target_registries'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_container_scan_target_output(container_scan_target_id: Optional[pulumi.Input[_builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetContainerScanTargetResult]:
    """
    This data source provides details about a specific Container Scan Target resource in Oracle Cloud Infrastructure Vulnerability Scanning service.

    Gets a ContainerScanTarget identified by the target ID. A container scan target specifies a group of one or more Docker image repositories in Oracle Cloud Infrastructure Registry (OCIR) that you want routinely scanned for security vulnerabilities.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_container_scan_target = oci.VulnerabilityScanning.get_container_scan_target(container_scan_target_id=test_container_scan_target_oci_vulnerability_scanning_container_scan_target["id"])
    ```


    :param _builtins.str container_scan_target_id: unique ContainerScanTarget identifier
    """
    __args__ = dict()
    __args__['containerScanTargetId'] = container_scan_target_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:VulnerabilityScanning/getContainerScanTarget:getContainerScanTarget', __args__, opts=opts, typ=GetContainerScanTargetResult)
    return __ret__.apply(lambda __response__: GetContainerScanTargetResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        container_scan_recipe_id=pulumi.get(__response__, 'container_scan_recipe_id'),
        container_scan_target_id=pulumi.get(__response__, 'container_scan_target_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        target_registries=pulumi.get(__response__, 'target_registries'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
