/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AppConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/app_configuration#data_plane_proxy_authentication_mode AppConfiguration#data_plane_proxy_authentication_mode}
    */
    readonly dataPlaneProxyAuthenticationMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/app_configuration#data_plane_proxy_private_link_delegation_enabled AppConfiguration#data_plane_proxy_private_link_delegation_enabled}
    */
    readonly dataPlaneProxyPrivateLinkDelegationEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/app_configuration#id AppConfiguration#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/app_configuration#local_auth_enabled AppConfiguration#local_auth_enabled}
    */
    readonly localAuthEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/app_configuration#location AppConfiguration#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/app_configuration#name AppConfiguration#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/app_configuration#public_network_access AppConfiguration#public_network_access}
    */
    readonly publicNetworkAccess?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/app_configuration#purge_protection_enabled AppConfiguration#purge_protection_enabled}
    */
    readonly purgeProtectionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/app_configuration#resource_group_name AppConfiguration#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/app_configuration#sku AppConfiguration#sku}
    */
    readonly sku?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/app_configuration#soft_delete_retention_days AppConfiguration#soft_delete_retention_days}
    */
    readonly softDeleteRetentionDays?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/app_configuration#tags AppConfiguration#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * encryption block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/app_configuration#encryption AppConfiguration#encryption}
    */
    readonly encryption?: AppConfigurationEncryption;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/app_configuration#identity AppConfiguration#identity}
    */
    readonly identity?: AppConfigurationIdentity;
    /**
    * replica block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/app_configuration#replica AppConfiguration#replica}
    */
    readonly replica?: AppConfigurationReplica[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/app_configuration#timeouts AppConfiguration#timeouts}
    */
    readonly timeouts?: AppConfigurationTimeouts;
}
export interface AppConfigurationPrimaryReadKey {
}
export declare function appConfigurationPrimaryReadKeyToTerraform(struct?: AppConfigurationPrimaryReadKey): any;
export declare function appConfigurationPrimaryReadKeyToHclTerraform(struct?: AppConfigurationPrimaryReadKey): any;
export declare class AppConfigurationPrimaryReadKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppConfigurationPrimaryReadKey | undefined;
    set internalValue(value: AppConfigurationPrimaryReadKey | undefined);
    get connectionString(): string;
    get id(): string;
    get secret(): string;
}
export declare class AppConfigurationPrimaryReadKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppConfigurationPrimaryReadKeyOutputReference;
}
export interface AppConfigurationPrimaryWriteKey {
}
export declare function appConfigurationPrimaryWriteKeyToTerraform(struct?: AppConfigurationPrimaryWriteKey): any;
export declare function appConfigurationPrimaryWriteKeyToHclTerraform(struct?: AppConfigurationPrimaryWriteKey): any;
export declare class AppConfigurationPrimaryWriteKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppConfigurationPrimaryWriteKey | undefined;
    set internalValue(value: AppConfigurationPrimaryWriteKey | undefined);
    get connectionString(): string;
    get id(): string;
    get secret(): string;
}
export declare class AppConfigurationPrimaryWriteKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppConfigurationPrimaryWriteKeyOutputReference;
}
export interface AppConfigurationSecondaryReadKey {
}
export declare function appConfigurationSecondaryReadKeyToTerraform(struct?: AppConfigurationSecondaryReadKey): any;
export declare function appConfigurationSecondaryReadKeyToHclTerraform(struct?: AppConfigurationSecondaryReadKey): any;
export declare class AppConfigurationSecondaryReadKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppConfigurationSecondaryReadKey | undefined;
    set internalValue(value: AppConfigurationSecondaryReadKey | undefined);
    get connectionString(): string;
    get id(): string;
    get secret(): string;
}
export declare class AppConfigurationSecondaryReadKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppConfigurationSecondaryReadKeyOutputReference;
}
export interface AppConfigurationSecondaryWriteKey {
}
export declare function appConfigurationSecondaryWriteKeyToTerraform(struct?: AppConfigurationSecondaryWriteKey): any;
export declare function appConfigurationSecondaryWriteKeyToHclTerraform(struct?: AppConfigurationSecondaryWriteKey): any;
export declare class AppConfigurationSecondaryWriteKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppConfigurationSecondaryWriteKey | undefined;
    set internalValue(value: AppConfigurationSecondaryWriteKey | undefined);
    get connectionString(): string;
    get id(): string;
    get secret(): string;
}
export declare class AppConfigurationSecondaryWriteKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppConfigurationSecondaryWriteKeyOutputReference;
}
export interface AppConfigurationEncryption {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/app_configuration#identity_client_id AppConfiguration#identity_client_id}
    */
    readonly identityClientId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/app_configuration#key_vault_key_identifier AppConfiguration#key_vault_key_identifier}
    */
    readonly keyVaultKeyIdentifier?: string;
}
export declare function appConfigurationEncryptionToTerraform(struct?: AppConfigurationEncryptionOutputReference | AppConfigurationEncryption): any;
export declare function appConfigurationEncryptionToHclTerraform(struct?: AppConfigurationEncryptionOutputReference | AppConfigurationEncryption): any;
export declare class AppConfigurationEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppConfigurationEncryption | undefined;
    set internalValue(value: AppConfigurationEncryption | undefined);
    private _identityClientId?;
    get identityClientId(): string;
    set identityClientId(value: string);
    resetIdentityClientId(): void;
    get identityClientIdInput(): string | undefined;
    private _keyVaultKeyIdentifier?;
    get keyVaultKeyIdentifier(): string;
    set keyVaultKeyIdentifier(value: string);
    resetKeyVaultKeyIdentifier(): void;
    get keyVaultKeyIdentifierInput(): string | undefined;
}
export interface AppConfigurationIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/app_configuration#identity_ids AppConfiguration#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/app_configuration#type AppConfiguration#type}
    */
    readonly type: string;
}
export declare function appConfigurationIdentityToTerraform(struct?: AppConfigurationIdentityOutputReference | AppConfigurationIdentity): any;
export declare function appConfigurationIdentityToHclTerraform(struct?: AppConfigurationIdentityOutputReference | AppConfigurationIdentity): any;
export declare class AppConfigurationIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppConfigurationIdentity | undefined;
    set internalValue(value: AppConfigurationIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface AppConfigurationReplica {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/app_configuration#location AppConfiguration#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/app_configuration#name AppConfiguration#name}
    */
    readonly name: string;
}
export declare function appConfigurationReplicaToTerraform(struct?: AppConfigurationReplica | cdktf.IResolvable): any;
export declare function appConfigurationReplicaToHclTerraform(struct?: AppConfigurationReplica | cdktf.IResolvable): any;
export declare class AppConfigurationReplicaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppConfigurationReplica | cdktf.IResolvable | undefined;
    set internalValue(value: AppConfigurationReplica | cdktf.IResolvable | undefined);
    get endpoint(): string;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class AppConfigurationReplicaList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppConfigurationReplica[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppConfigurationReplicaOutputReference;
}
export interface AppConfigurationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/app_configuration#create AppConfiguration#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/app_configuration#delete AppConfiguration#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/app_configuration#read AppConfiguration#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/app_configuration#update AppConfiguration#update}
    */
    readonly update?: string;
}
export declare function appConfigurationTimeoutsToTerraform(struct?: AppConfigurationTimeouts | cdktf.IResolvable): any;
export declare function appConfigurationTimeoutsToHclTerraform(struct?: AppConfigurationTimeouts | cdktf.IResolvable): any;
export declare class AppConfigurationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppConfigurationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AppConfigurationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/app_configuration azurerm_app_configuration}
*/
export declare class AppConfiguration extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_app_configuration";
    /**
    * Generates CDKTF code for importing a AppConfiguration resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AppConfiguration to import
    * @param importFromId The id of the existing AppConfiguration that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/app_configuration#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AppConfiguration to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/app_configuration azurerm_app_configuration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AppConfigurationConfig
    */
    constructor(scope: Construct, id: string, config: AppConfigurationConfig);
    private _dataPlaneProxyAuthenticationMode?;
    get dataPlaneProxyAuthenticationMode(): string;
    set dataPlaneProxyAuthenticationMode(value: string);
    resetDataPlaneProxyAuthenticationMode(): void;
    get dataPlaneProxyAuthenticationModeInput(): string | undefined;
    private _dataPlaneProxyPrivateLinkDelegationEnabled?;
    get dataPlaneProxyPrivateLinkDelegationEnabled(): boolean | cdktf.IResolvable;
    set dataPlaneProxyPrivateLinkDelegationEnabled(value: boolean | cdktf.IResolvable);
    resetDataPlaneProxyPrivateLinkDelegationEnabled(): void;
    get dataPlaneProxyPrivateLinkDelegationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get endpoint(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _localAuthEnabled?;
    get localAuthEnabled(): boolean | cdktf.IResolvable;
    set localAuthEnabled(value: boolean | cdktf.IResolvable);
    resetLocalAuthEnabled(): void;
    get localAuthEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _primaryReadKey;
    get primaryReadKey(): AppConfigurationPrimaryReadKeyList;
    private _primaryWriteKey;
    get primaryWriteKey(): AppConfigurationPrimaryWriteKeyList;
    private _publicNetworkAccess?;
    get publicNetworkAccess(): string;
    set publicNetworkAccess(value: string);
    resetPublicNetworkAccess(): void;
    get publicNetworkAccessInput(): string | undefined;
    private _purgeProtectionEnabled?;
    get purgeProtectionEnabled(): boolean | cdktf.IResolvable;
    set purgeProtectionEnabled(value: boolean | cdktf.IResolvable);
    resetPurgeProtectionEnabled(): void;
    get purgeProtectionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _secondaryReadKey;
    get secondaryReadKey(): AppConfigurationSecondaryReadKeyList;
    private _secondaryWriteKey;
    get secondaryWriteKey(): AppConfigurationSecondaryWriteKeyList;
    private _sku?;
    get sku(): string;
    set sku(value: string);
    resetSku(): void;
    get skuInput(): string | undefined;
    private _softDeleteRetentionDays?;
    get softDeleteRetentionDays(): number;
    set softDeleteRetentionDays(value: number);
    resetSoftDeleteRetentionDays(): void;
    get softDeleteRetentionDaysInput(): number | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _encryption;
    get encryption(): AppConfigurationEncryptionOutputReference;
    putEncryption(value: AppConfigurationEncryption): void;
    resetEncryption(): void;
    get encryptionInput(): AppConfigurationEncryption | undefined;
    private _identity;
    get identity(): AppConfigurationIdentityOutputReference;
    putIdentity(value: AppConfigurationIdentity): void;
    resetIdentity(): void;
    get identityInput(): AppConfigurationIdentity | undefined;
    private _replica;
    get replica(): AppConfigurationReplicaList;
    putReplica(value: AppConfigurationReplica[] | cdktf.IResolvable): void;
    resetReplica(): void;
    get replicaInput(): cdktf.IResolvable | AppConfigurationReplica[] | undefined;
    private _timeouts;
    get timeouts(): AppConfigurationTimeoutsOutputReference;
    putTimeouts(value: AppConfigurationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AppConfigurationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
