/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ArcResourceBridgeApplianceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/arc_resource_bridge_appliance#distro ArcResourceBridgeAppliance#distro}
    */
    readonly distro: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/arc_resource_bridge_appliance#id ArcResourceBridgeAppliance#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/arc_resource_bridge_appliance#infrastructure_provider ArcResourceBridgeAppliance#infrastructure_provider}
    */
    readonly infrastructureProvider: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/arc_resource_bridge_appliance#location ArcResourceBridgeAppliance#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/arc_resource_bridge_appliance#name ArcResourceBridgeAppliance#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/arc_resource_bridge_appliance#public_key_base64 ArcResourceBridgeAppliance#public_key_base64}
    */
    readonly publicKeyBase64?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/arc_resource_bridge_appliance#resource_group_name ArcResourceBridgeAppliance#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/arc_resource_bridge_appliance#tags ArcResourceBridgeAppliance#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/arc_resource_bridge_appliance#identity ArcResourceBridgeAppliance#identity}
    */
    readonly identity: ArcResourceBridgeApplianceIdentity;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/arc_resource_bridge_appliance#timeouts ArcResourceBridgeAppliance#timeouts}
    */
    readonly timeouts?: ArcResourceBridgeApplianceTimeouts;
}
export interface ArcResourceBridgeApplianceIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/arc_resource_bridge_appliance#type ArcResourceBridgeAppliance#type}
    */
    readonly type: string;
}
export declare function arcResourceBridgeApplianceIdentityToTerraform(struct?: ArcResourceBridgeApplianceIdentityOutputReference | ArcResourceBridgeApplianceIdentity): any;
export declare function arcResourceBridgeApplianceIdentityToHclTerraform(struct?: ArcResourceBridgeApplianceIdentityOutputReference | ArcResourceBridgeApplianceIdentity): any;
export declare class ArcResourceBridgeApplianceIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ArcResourceBridgeApplianceIdentity | undefined;
    set internalValue(value: ArcResourceBridgeApplianceIdentity | undefined);
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface ArcResourceBridgeApplianceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/arc_resource_bridge_appliance#create ArcResourceBridgeAppliance#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/arc_resource_bridge_appliance#delete ArcResourceBridgeAppliance#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/arc_resource_bridge_appliance#read ArcResourceBridgeAppliance#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/arc_resource_bridge_appliance#update ArcResourceBridgeAppliance#update}
    */
    readonly update?: string;
}
export declare function arcResourceBridgeApplianceTimeoutsToTerraform(struct?: ArcResourceBridgeApplianceTimeouts | cdktf.IResolvable): any;
export declare function arcResourceBridgeApplianceTimeoutsToHclTerraform(struct?: ArcResourceBridgeApplianceTimeouts | cdktf.IResolvable): any;
export declare class ArcResourceBridgeApplianceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ArcResourceBridgeApplianceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ArcResourceBridgeApplianceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/arc_resource_bridge_appliance azurerm_arc_resource_bridge_appliance}
*/
export declare class ArcResourceBridgeAppliance extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_arc_resource_bridge_appliance";
    /**
    * Generates CDKTF code for importing a ArcResourceBridgeAppliance resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ArcResourceBridgeAppliance to import
    * @param importFromId The id of the existing ArcResourceBridgeAppliance that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/arc_resource_bridge_appliance#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ArcResourceBridgeAppliance to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/arc_resource_bridge_appliance azurerm_arc_resource_bridge_appliance} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ArcResourceBridgeApplianceConfig
    */
    constructor(scope: Construct, id: string, config: ArcResourceBridgeApplianceConfig);
    private _distro?;
    get distro(): string;
    set distro(value: string);
    get distroInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _infrastructureProvider?;
    get infrastructureProvider(): string;
    set infrastructureProvider(value: string);
    get infrastructureProviderInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _publicKeyBase64?;
    get publicKeyBase64(): string;
    set publicKeyBase64(value: string);
    resetPublicKeyBase64(): void;
    get publicKeyBase64Input(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _identity;
    get identity(): ArcResourceBridgeApplianceIdentityOutputReference;
    putIdentity(value: ArcResourceBridgeApplianceIdentity): void;
    get identityInput(): ArcResourceBridgeApplianceIdentity | undefined;
    private _timeouts;
    get timeouts(): ArcResourceBridgeApplianceTimeoutsOutputReference;
    putTimeouts(value: ArcResourceBridgeApplianceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ArcResourceBridgeApplianceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
