/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AutomationPowershell72ModuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/automation_powershell72_module#automation_account_id AutomationPowershell72Module#automation_account_id}
    */
    readonly automationAccountId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/automation_powershell72_module#id AutomationPowershell72Module#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/automation_powershell72_module#name AutomationPowershell72Module#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/automation_powershell72_module#tags AutomationPowershell72Module#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * module_link block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/automation_powershell72_module#module_link AutomationPowershell72Module#module_link}
    */
    readonly moduleLink: AutomationPowershell72ModuleModuleLink;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/automation_powershell72_module#timeouts AutomationPowershell72Module#timeouts}
    */
    readonly timeouts?: AutomationPowershell72ModuleTimeouts;
}
export interface AutomationPowershell72ModuleModuleLinkHash {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/automation_powershell72_module#algorithm AutomationPowershell72Module#algorithm}
    */
    readonly algorithm: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/automation_powershell72_module#value AutomationPowershell72Module#value}
    */
    readonly value: string;
}
export declare function automationPowershell72ModuleModuleLinkHashToTerraform(struct?: AutomationPowershell72ModuleModuleLinkHashOutputReference | AutomationPowershell72ModuleModuleLinkHash): any;
export declare function automationPowershell72ModuleModuleLinkHashToHclTerraform(struct?: AutomationPowershell72ModuleModuleLinkHashOutputReference | AutomationPowershell72ModuleModuleLinkHash): any;
export declare class AutomationPowershell72ModuleModuleLinkHashOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AutomationPowershell72ModuleModuleLinkHash | undefined;
    set internalValue(value: AutomationPowershell72ModuleModuleLinkHash | undefined);
    private _algorithm?;
    get algorithm(): string;
    set algorithm(value: string);
    get algorithmInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export interface AutomationPowershell72ModuleModuleLink {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/automation_powershell72_module#uri AutomationPowershell72Module#uri}
    */
    readonly uri: string;
    /**
    * hash block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/automation_powershell72_module#hash AutomationPowershell72Module#hash}
    */
    readonly hash?: AutomationPowershell72ModuleModuleLinkHash;
}
export declare function automationPowershell72ModuleModuleLinkToTerraform(struct?: AutomationPowershell72ModuleModuleLinkOutputReference | AutomationPowershell72ModuleModuleLink): any;
export declare function automationPowershell72ModuleModuleLinkToHclTerraform(struct?: AutomationPowershell72ModuleModuleLinkOutputReference | AutomationPowershell72ModuleModuleLink): any;
export declare class AutomationPowershell72ModuleModuleLinkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AutomationPowershell72ModuleModuleLink | undefined;
    set internalValue(value: AutomationPowershell72ModuleModuleLink | undefined);
    private _uri?;
    get uri(): string;
    set uri(value: string);
    get uriInput(): string | undefined;
    private _hash;
    get hash(): AutomationPowershell72ModuleModuleLinkHashOutputReference;
    putHash(value: AutomationPowershell72ModuleModuleLinkHash): void;
    resetHash(): void;
    get hashInput(): AutomationPowershell72ModuleModuleLinkHash | undefined;
}
export interface AutomationPowershell72ModuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/automation_powershell72_module#create AutomationPowershell72Module#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/automation_powershell72_module#delete AutomationPowershell72Module#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/automation_powershell72_module#read AutomationPowershell72Module#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/automation_powershell72_module#update AutomationPowershell72Module#update}
    */
    readonly update?: string;
}
export declare function automationPowershell72ModuleTimeoutsToTerraform(struct?: AutomationPowershell72ModuleTimeouts | cdktf.IResolvable): any;
export declare function automationPowershell72ModuleTimeoutsToHclTerraform(struct?: AutomationPowershell72ModuleTimeouts | cdktf.IResolvable): any;
export declare class AutomationPowershell72ModuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AutomationPowershell72ModuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AutomationPowershell72ModuleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/automation_powershell72_module azurerm_automation_powershell72_module}
*/
export declare class AutomationPowershell72Module extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_automation_powershell72_module";
    /**
    * Generates CDKTF code for importing a AutomationPowershell72Module resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AutomationPowershell72Module to import
    * @param importFromId The id of the existing AutomationPowershell72Module that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/automation_powershell72_module#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AutomationPowershell72Module to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/automation_powershell72_module azurerm_automation_powershell72_module} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AutomationPowershell72ModuleConfig
    */
    constructor(scope: Construct, id: string, config: AutomationPowershell72ModuleConfig);
    private _automationAccountId?;
    get automationAccountId(): string;
    set automationAccountId(value: string);
    get automationAccountIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _moduleLink;
    get moduleLink(): AutomationPowershell72ModuleModuleLinkOutputReference;
    putModuleLink(value: AutomationPowershell72ModuleModuleLink): void;
    get moduleLinkInput(): AutomationPowershell72ModuleModuleLink | undefined;
    private _timeouts;
    get timeouts(): AutomationPowershell72ModuleTimeoutsOutputReference;
    putTimeouts(value: AutomationPowershell72ModuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AutomationPowershell72ModuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
