/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ConfidentialLedgerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/confidential_ledger#id ConfidentialLedger#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/confidential_ledger#ledger_type ConfidentialLedger#ledger_type}
    */
    readonly ledgerType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/confidential_ledger#location ConfidentialLedger#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/confidential_ledger#name ConfidentialLedger#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/confidential_ledger#resource_group_name ConfidentialLedger#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/confidential_ledger#tags ConfidentialLedger#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * azuread_based_service_principal block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/confidential_ledger#azuread_based_service_principal ConfidentialLedger#azuread_based_service_principal}
    */
    readonly azureadBasedServicePrincipal: ConfidentialLedgerAzureadBasedServicePrincipal[] | cdktf.IResolvable;
    /**
    * certificate_based_security_principal block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/confidential_ledger#certificate_based_security_principal ConfidentialLedger#certificate_based_security_principal}
    */
    readonly certificateBasedSecurityPrincipal?: ConfidentialLedgerCertificateBasedSecurityPrincipal[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/confidential_ledger#timeouts ConfidentialLedger#timeouts}
    */
    readonly timeouts?: ConfidentialLedgerTimeouts;
}
export interface ConfidentialLedgerAzureadBasedServicePrincipal {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/confidential_ledger#ledger_role_name ConfidentialLedger#ledger_role_name}
    */
    readonly ledgerRoleName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/confidential_ledger#principal_id ConfidentialLedger#principal_id}
    */
    readonly principalId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/confidential_ledger#tenant_id ConfidentialLedger#tenant_id}
    */
    readonly tenantId: string;
}
export declare function confidentialLedgerAzureadBasedServicePrincipalToTerraform(struct?: ConfidentialLedgerAzureadBasedServicePrincipal | cdktf.IResolvable): any;
export declare function confidentialLedgerAzureadBasedServicePrincipalToHclTerraform(struct?: ConfidentialLedgerAzureadBasedServicePrincipal | cdktf.IResolvable): any;
export declare class ConfidentialLedgerAzureadBasedServicePrincipalOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ConfidentialLedgerAzureadBasedServicePrincipal | cdktf.IResolvable | undefined;
    set internalValue(value: ConfidentialLedgerAzureadBasedServicePrincipal | cdktf.IResolvable | undefined);
    private _ledgerRoleName?;
    get ledgerRoleName(): string;
    set ledgerRoleName(value: string);
    get ledgerRoleNameInput(): string | undefined;
    private _principalId?;
    get principalId(): string;
    set principalId(value: string);
    get principalIdInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    get tenantIdInput(): string | undefined;
}
export declare class ConfidentialLedgerAzureadBasedServicePrincipalList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ConfidentialLedgerAzureadBasedServicePrincipal[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ConfidentialLedgerAzureadBasedServicePrincipalOutputReference;
}
export interface ConfidentialLedgerCertificateBasedSecurityPrincipal {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/confidential_ledger#ledger_role_name ConfidentialLedger#ledger_role_name}
    */
    readonly ledgerRoleName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/confidential_ledger#pem_public_key ConfidentialLedger#pem_public_key}
    */
    readonly pemPublicKey: string;
}
export declare function confidentialLedgerCertificateBasedSecurityPrincipalToTerraform(struct?: ConfidentialLedgerCertificateBasedSecurityPrincipal | cdktf.IResolvable): any;
export declare function confidentialLedgerCertificateBasedSecurityPrincipalToHclTerraform(struct?: ConfidentialLedgerCertificateBasedSecurityPrincipal | cdktf.IResolvable): any;
export declare class ConfidentialLedgerCertificateBasedSecurityPrincipalOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ConfidentialLedgerCertificateBasedSecurityPrincipal | cdktf.IResolvable | undefined;
    set internalValue(value: ConfidentialLedgerCertificateBasedSecurityPrincipal | cdktf.IResolvable | undefined);
    private _ledgerRoleName?;
    get ledgerRoleName(): string;
    set ledgerRoleName(value: string);
    get ledgerRoleNameInput(): string | undefined;
    private _pemPublicKey?;
    get pemPublicKey(): string;
    set pemPublicKey(value: string);
    get pemPublicKeyInput(): string | undefined;
}
export declare class ConfidentialLedgerCertificateBasedSecurityPrincipalList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ConfidentialLedgerCertificateBasedSecurityPrincipal[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ConfidentialLedgerCertificateBasedSecurityPrincipalOutputReference;
}
export interface ConfidentialLedgerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/confidential_ledger#create ConfidentialLedger#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/confidential_ledger#delete ConfidentialLedger#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/confidential_ledger#read ConfidentialLedger#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/confidential_ledger#update ConfidentialLedger#update}
    */
    readonly update?: string;
}
export declare function confidentialLedgerTimeoutsToTerraform(struct?: ConfidentialLedgerTimeouts | cdktf.IResolvable): any;
export declare function confidentialLedgerTimeoutsToHclTerraform(struct?: ConfidentialLedgerTimeouts | cdktf.IResolvable): any;
export declare class ConfidentialLedgerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ConfidentialLedgerTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ConfidentialLedgerTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/confidential_ledger azurerm_confidential_ledger}
*/
export declare class ConfidentialLedger extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_confidential_ledger";
    /**
    * Generates CDKTF code for importing a ConfidentialLedger resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ConfidentialLedger to import
    * @param importFromId The id of the existing ConfidentialLedger that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/confidential_ledger#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ConfidentialLedger to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/confidential_ledger azurerm_confidential_ledger} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ConfidentialLedgerConfig
    */
    constructor(scope: Construct, id: string, config: ConfidentialLedgerConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get identityServiceEndpoint(): string;
    get ledgerEndpoint(): string;
    private _ledgerType?;
    get ledgerType(): string;
    set ledgerType(value: string);
    get ledgerTypeInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _azureadBasedServicePrincipal;
    get azureadBasedServicePrincipal(): ConfidentialLedgerAzureadBasedServicePrincipalList;
    putAzureadBasedServicePrincipal(value: ConfidentialLedgerAzureadBasedServicePrincipal[] | cdktf.IResolvable): void;
    get azureadBasedServicePrincipalInput(): cdktf.IResolvable | ConfidentialLedgerAzureadBasedServicePrincipal[] | undefined;
    private _certificateBasedSecurityPrincipal;
    get certificateBasedSecurityPrincipal(): ConfidentialLedgerCertificateBasedSecurityPrincipalList;
    putCertificateBasedSecurityPrincipal(value: ConfidentialLedgerCertificateBasedSecurityPrincipal[] | cdktf.IResolvable): void;
    resetCertificateBasedSecurityPrincipal(): void;
    get certificateBasedSecurityPrincipalInput(): cdktf.IResolvable | ConfidentialLedgerCertificateBasedSecurityPrincipal[] | undefined;
    private _timeouts;
    get timeouts(): ConfidentialLedgerTimeoutsOutputReference;
    putTimeouts(value: ConfidentialLedgerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ConfidentialLedgerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
