/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ContainerRegistryCredentialSetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/container_registry_credential_set#container_registry_id ContainerRegistryCredentialSet#container_registry_id}
    */
    readonly containerRegistryId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/container_registry_credential_set#id ContainerRegistryCredentialSet#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/container_registry_credential_set#login_server ContainerRegistryCredentialSet#login_server}
    */
    readonly loginServer: string;
    /**
    * The name of the credential set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/container_registry_credential_set#name ContainerRegistryCredentialSet#name}
    */
    readonly name: string;
    /**
    * authentication_credentials block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/container_registry_credential_set#authentication_credentials ContainerRegistryCredentialSet#authentication_credentials}
    */
    readonly authenticationCredentials: ContainerRegistryCredentialSetAuthenticationCredentials;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/container_registry_credential_set#identity ContainerRegistryCredentialSet#identity}
    */
    readonly identity: ContainerRegistryCredentialSetIdentity;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/container_registry_credential_set#timeouts ContainerRegistryCredentialSet#timeouts}
    */
    readonly timeouts?: ContainerRegistryCredentialSetTimeouts;
}
export interface ContainerRegistryCredentialSetAuthenticationCredentials {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/container_registry_credential_set#password_secret_id ContainerRegistryCredentialSet#password_secret_id}
    */
    readonly passwordSecretId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/container_registry_credential_set#username_secret_id ContainerRegistryCredentialSet#username_secret_id}
    */
    readonly usernameSecretId: string;
}
export declare function containerRegistryCredentialSetAuthenticationCredentialsToTerraform(struct?: ContainerRegistryCredentialSetAuthenticationCredentialsOutputReference | ContainerRegistryCredentialSetAuthenticationCredentials): any;
export declare function containerRegistryCredentialSetAuthenticationCredentialsToHclTerraform(struct?: ContainerRegistryCredentialSetAuthenticationCredentialsOutputReference | ContainerRegistryCredentialSetAuthenticationCredentials): any;
export declare class ContainerRegistryCredentialSetAuthenticationCredentialsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerRegistryCredentialSetAuthenticationCredentials | undefined;
    set internalValue(value: ContainerRegistryCredentialSetAuthenticationCredentials | undefined);
    private _passwordSecretId?;
    get passwordSecretId(): string;
    set passwordSecretId(value: string);
    get passwordSecretIdInput(): string | undefined;
    private _usernameSecretId?;
    get usernameSecretId(): string;
    set usernameSecretId(value: string);
    get usernameSecretIdInput(): string | undefined;
}
export interface ContainerRegistryCredentialSetIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/container_registry_credential_set#type ContainerRegistryCredentialSet#type}
    */
    readonly type: string;
}
export declare function containerRegistryCredentialSetIdentityToTerraform(struct?: ContainerRegistryCredentialSetIdentityOutputReference | ContainerRegistryCredentialSetIdentity): any;
export declare function containerRegistryCredentialSetIdentityToHclTerraform(struct?: ContainerRegistryCredentialSetIdentityOutputReference | ContainerRegistryCredentialSetIdentity): any;
export declare class ContainerRegistryCredentialSetIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerRegistryCredentialSetIdentity | undefined;
    set internalValue(value: ContainerRegistryCredentialSetIdentity | undefined);
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface ContainerRegistryCredentialSetTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/container_registry_credential_set#create ContainerRegistryCredentialSet#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/container_registry_credential_set#delete ContainerRegistryCredentialSet#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/container_registry_credential_set#read ContainerRegistryCredentialSet#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/container_registry_credential_set#update ContainerRegistryCredentialSet#update}
    */
    readonly update?: string;
}
export declare function containerRegistryCredentialSetTimeoutsToTerraform(struct?: ContainerRegistryCredentialSetTimeouts | cdktf.IResolvable): any;
export declare function containerRegistryCredentialSetTimeoutsToHclTerraform(struct?: ContainerRegistryCredentialSetTimeouts | cdktf.IResolvable): any;
export declare class ContainerRegistryCredentialSetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerRegistryCredentialSetTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerRegistryCredentialSetTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/container_registry_credential_set azurerm_container_registry_credential_set}
*/
export declare class ContainerRegistryCredentialSet extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_container_registry_credential_set";
    /**
    * Generates CDKTF code for importing a ContainerRegistryCredentialSet resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ContainerRegistryCredentialSet to import
    * @param importFromId The id of the existing ContainerRegistryCredentialSet that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/container_registry_credential_set#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ContainerRegistryCredentialSet to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/container_registry_credential_set azurerm_container_registry_credential_set} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ContainerRegistryCredentialSetConfig
    */
    constructor(scope: Construct, id: string, config: ContainerRegistryCredentialSetConfig);
    private _containerRegistryId?;
    get containerRegistryId(): string;
    set containerRegistryId(value: string);
    get containerRegistryIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _loginServer?;
    get loginServer(): string;
    set loginServer(value: string);
    get loginServerInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _authenticationCredentials;
    get authenticationCredentials(): ContainerRegistryCredentialSetAuthenticationCredentialsOutputReference;
    putAuthenticationCredentials(value: ContainerRegistryCredentialSetAuthenticationCredentials): void;
    get authenticationCredentialsInput(): ContainerRegistryCredentialSetAuthenticationCredentials | undefined;
    private _identity;
    get identity(): ContainerRegistryCredentialSetIdentityOutputReference;
    putIdentity(value: ContainerRegistryCredentialSetIdentity): void;
    get identityInput(): ContainerRegistryCredentialSetIdentity | undefined;
    private _timeouts;
    get timeouts(): ContainerRegistryCredentialSetTimeoutsOutputReference;
    putTimeouts(value: ContainerRegistryCredentialSetTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ContainerRegistryCredentialSetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
