/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermAutomationAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/automation_account#id DataAzurermAutomationAccount#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/automation_account#name DataAzurermAutomationAccount#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/automation_account#resource_group_name DataAzurermAutomationAccount#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/automation_account#timeouts DataAzurermAutomationAccount#timeouts}
    */
    readonly timeouts?: DataAzurermAutomationAccountTimeouts;
}
export interface DataAzurermAutomationAccountIdentity {
}
export declare function dataAzurermAutomationAccountIdentityToTerraform(struct?: DataAzurermAutomationAccountIdentity): any;
export declare function dataAzurermAutomationAccountIdentityToHclTerraform(struct?: DataAzurermAutomationAccountIdentity): any;
export declare class DataAzurermAutomationAccountIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermAutomationAccountIdentity | undefined;
    set internalValue(value: DataAzurermAutomationAccountIdentity | undefined);
    get identityIds(): string[];
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermAutomationAccountIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermAutomationAccountIdentityOutputReference;
}
export interface DataAzurermAutomationAccountPrivateEndpointConnection {
}
export declare function dataAzurermAutomationAccountPrivateEndpointConnectionToTerraform(struct?: DataAzurermAutomationAccountPrivateEndpointConnection): any;
export declare function dataAzurermAutomationAccountPrivateEndpointConnectionToHclTerraform(struct?: DataAzurermAutomationAccountPrivateEndpointConnection): any;
export declare class DataAzurermAutomationAccountPrivateEndpointConnectionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermAutomationAccountPrivateEndpointConnection | undefined;
    set internalValue(value: DataAzurermAutomationAccountPrivateEndpointConnection | undefined);
    get id(): string;
    get name(): string;
}
export declare class DataAzurermAutomationAccountPrivateEndpointConnectionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermAutomationAccountPrivateEndpointConnectionOutputReference;
}
export interface DataAzurermAutomationAccountTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/automation_account#read DataAzurermAutomationAccount#read}
    */
    readonly read?: string;
}
export declare function dataAzurermAutomationAccountTimeoutsToTerraform(struct?: DataAzurermAutomationAccountTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermAutomationAccountTimeoutsToHclTerraform(struct?: DataAzurermAutomationAccountTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermAutomationAccountTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermAutomationAccountTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermAutomationAccountTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/automation_account azurerm_automation_account}
*/
export declare class DataAzurermAutomationAccount extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_automation_account";
    /**
    * Generates CDKTF code for importing a DataAzurermAutomationAccount resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermAutomationAccount to import
    * @param importFromId The id of the existing DataAzurermAutomationAccount that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/automation_account#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermAutomationAccount to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/automation_account azurerm_automation_account} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermAutomationAccountConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermAutomationAccountConfig);
    get endpoint(): string;
    get hybridServiceUrl(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identity;
    get identity(): DataAzurermAutomationAccountIdentityList;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get primaryKey(): string;
    private _privateEndpointConnection;
    get privateEndpointConnection(): DataAzurermAutomationAccountPrivateEndpointConnectionList;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get secondaryKey(): string;
    private _timeouts;
    get timeouts(): DataAzurermAutomationAccountTimeoutsOutputReference;
    putTimeouts(value: DataAzurermAutomationAccountTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermAutomationAccountTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
