/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermContainerRegistryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/container_registry#id DataAzurermContainerRegistry#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/container_registry#name DataAzurermContainerRegistry#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/container_registry#resource_group_name DataAzurermContainerRegistry#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/container_registry#timeouts DataAzurermContainerRegistry#timeouts}
    */
    readonly timeouts?: DataAzurermContainerRegistryTimeouts;
}
export interface DataAzurermContainerRegistryTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/container_registry#read DataAzurermContainerRegistry#read}
    */
    readonly read?: string;
}
export declare function dataAzurermContainerRegistryTimeoutsToTerraform(struct?: DataAzurermContainerRegistryTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermContainerRegistryTimeoutsToHclTerraform(struct?: DataAzurermContainerRegistryTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermContainerRegistryTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermContainerRegistryTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermContainerRegistryTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/container_registry azurerm_container_registry}
*/
export declare class DataAzurermContainerRegistry extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_container_registry";
    /**
    * Generates CDKTF code for importing a DataAzurermContainerRegistry resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermContainerRegistry to import
    * @param importFromId The id of the existing DataAzurermContainerRegistry that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/container_registry#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermContainerRegistry to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/container_registry azurerm_container_registry} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermContainerRegistryConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermContainerRegistryConfig);
    get adminEnabled(): cdktf.IResolvable;
    get adminPassword(): string;
    get adminUsername(): string;
    get dataEndpointEnabled(): cdktf.IResolvable;
    get dataEndpointHostNames(): string[];
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    get loginServer(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get sku(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurermContainerRegistryTimeoutsOutputReference;
    putTimeouts(value: DataAzurermContainerRegistryTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermContainerRegistryTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
