/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermDevCenterEnvironmentTypeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/dev_center_environment_type#dev_center_id DataAzurermDevCenterEnvironmentType#dev_center_id}
    */
    readonly devCenterId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/dev_center_environment_type#id DataAzurermDevCenterEnvironmentType#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/dev_center_environment_type#name DataAzurermDevCenterEnvironmentType#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/dev_center_environment_type#timeouts DataAzurermDevCenterEnvironmentType#timeouts}
    */
    readonly timeouts?: DataAzurermDevCenterEnvironmentTypeTimeouts;
}
export interface DataAzurermDevCenterEnvironmentTypeTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/dev_center_environment_type#read DataAzurermDevCenterEnvironmentType#read}
    */
    readonly read?: string;
}
export declare function dataAzurermDevCenterEnvironmentTypeTimeoutsToTerraform(struct?: DataAzurermDevCenterEnvironmentTypeTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermDevCenterEnvironmentTypeTimeoutsToHclTerraform(struct?: DataAzurermDevCenterEnvironmentTypeTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermDevCenterEnvironmentTypeTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermDevCenterEnvironmentTypeTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermDevCenterEnvironmentTypeTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/dev_center_environment_type azurerm_dev_center_environment_type}
*/
export declare class DataAzurermDevCenterEnvironmentType extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_dev_center_environment_type";
    /**
    * Generates CDKTF code for importing a DataAzurermDevCenterEnvironmentType resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermDevCenterEnvironmentType to import
    * @param importFromId The id of the existing DataAzurermDevCenterEnvironmentType that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/dev_center_environment_type#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermDevCenterEnvironmentType to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/dev_center_environment_type azurerm_dev_center_environment_type} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermDevCenterEnvironmentTypeConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermDevCenterEnvironmentTypeConfig);
    private _devCenterId?;
    get devCenterId(): string;
    set devCenterId(value: string);
    get devCenterIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurermDevCenterEnvironmentTypeTimeoutsOutputReference;
    putTimeouts(value: DataAzurermDevCenterEnvironmentTypeTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermDevCenterEnvironmentTypeTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
