/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermDevCenterProjectEnvironmentTypeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/dev_center_project_environment_type#dev_center_project_id DataAzurermDevCenterProjectEnvironmentType#dev_center_project_id}
    */
    readonly devCenterProjectId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/dev_center_project_environment_type#id DataAzurermDevCenterProjectEnvironmentType#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/dev_center_project_environment_type#name DataAzurermDevCenterProjectEnvironmentType#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/dev_center_project_environment_type#timeouts DataAzurermDevCenterProjectEnvironmentType#timeouts}
    */
    readonly timeouts?: DataAzurermDevCenterProjectEnvironmentTypeTimeouts;
}
export interface DataAzurermDevCenterProjectEnvironmentTypeIdentity {
}
export declare function dataAzurermDevCenterProjectEnvironmentTypeIdentityToTerraform(struct?: DataAzurermDevCenterProjectEnvironmentTypeIdentity): any;
export declare function dataAzurermDevCenterProjectEnvironmentTypeIdentityToHclTerraform(struct?: DataAzurermDevCenterProjectEnvironmentTypeIdentity): any;
export declare class DataAzurermDevCenterProjectEnvironmentTypeIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermDevCenterProjectEnvironmentTypeIdentity | undefined;
    set internalValue(value: DataAzurermDevCenterProjectEnvironmentTypeIdentity | undefined);
    get identityIds(): string[];
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermDevCenterProjectEnvironmentTypeIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermDevCenterProjectEnvironmentTypeIdentityOutputReference;
}
export interface DataAzurermDevCenterProjectEnvironmentTypeUserRoleAssignment {
}
export declare function dataAzurermDevCenterProjectEnvironmentTypeUserRoleAssignmentToTerraform(struct?: DataAzurermDevCenterProjectEnvironmentTypeUserRoleAssignment): any;
export declare function dataAzurermDevCenterProjectEnvironmentTypeUserRoleAssignmentToHclTerraform(struct?: DataAzurermDevCenterProjectEnvironmentTypeUserRoleAssignment): any;
export declare class DataAzurermDevCenterProjectEnvironmentTypeUserRoleAssignmentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermDevCenterProjectEnvironmentTypeUserRoleAssignment | undefined;
    set internalValue(value: DataAzurermDevCenterProjectEnvironmentTypeUserRoleAssignment | undefined);
    get roles(): string[];
    get userId(): string;
}
export declare class DataAzurermDevCenterProjectEnvironmentTypeUserRoleAssignmentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermDevCenterProjectEnvironmentTypeUserRoleAssignmentOutputReference;
}
export interface DataAzurermDevCenterProjectEnvironmentTypeTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/dev_center_project_environment_type#read DataAzurermDevCenterProjectEnvironmentType#read}
    */
    readonly read?: string;
}
export declare function dataAzurermDevCenterProjectEnvironmentTypeTimeoutsToTerraform(struct?: DataAzurermDevCenterProjectEnvironmentTypeTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermDevCenterProjectEnvironmentTypeTimeoutsToHclTerraform(struct?: DataAzurermDevCenterProjectEnvironmentTypeTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermDevCenterProjectEnvironmentTypeTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermDevCenterProjectEnvironmentTypeTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermDevCenterProjectEnvironmentTypeTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/dev_center_project_environment_type azurerm_dev_center_project_environment_type}
*/
export declare class DataAzurermDevCenterProjectEnvironmentType extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_dev_center_project_environment_type";
    /**
    * Generates CDKTF code for importing a DataAzurermDevCenterProjectEnvironmentType resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermDevCenterProjectEnvironmentType to import
    * @param importFromId The id of the existing DataAzurermDevCenterProjectEnvironmentType that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/dev_center_project_environment_type#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermDevCenterProjectEnvironmentType to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/dev_center_project_environment_type azurerm_dev_center_project_environment_type} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermDevCenterProjectEnvironmentTypeConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermDevCenterProjectEnvironmentTypeConfig);
    get creatorRoleAssignmentRoles(): string[];
    get deploymentTargetId(): string;
    private _devCenterProjectId?;
    get devCenterProjectId(): string;
    set devCenterProjectId(value: string);
    get devCenterProjectIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identity;
    get identity(): DataAzurermDevCenterProjectEnvironmentTypeIdentityList;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    private _userRoleAssignment;
    get userRoleAssignment(): DataAzurermDevCenterProjectEnvironmentTypeUserRoleAssignmentList;
    private _timeouts;
    get timeouts(): DataAzurermDevCenterProjectEnvironmentTypeTimeoutsOutputReference;
    putTimeouts(value: DataAzurermDevCenterProjectEnvironmentTypeTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermDevCenterProjectEnvironmentTypeTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
