/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermLogAnalyticsWorkspaceTableConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/log_analytics_workspace_table#id DataAzurermLogAnalyticsWorkspaceTable#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/log_analytics_workspace_table#name DataAzurermLogAnalyticsWorkspaceTable#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/log_analytics_workspace_table#workspace_id DataAzurermLogAnalyticsWorkspaceTable#workspace_id}
    */
    readonly workspaceId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/log_analytics_workspace_table#timeouts DataAzurermLogAnalyticsWorkspaceTable#timeouts}
    */
    readonly timeouts?: DataAzurermLogAnalyticsWorkspaceTableTimeouts;
}
export interface DataAzurermLogAnalyticsWorkspaceTableTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/log_analytics_workspace_table#read DataAzurermLogAnalyticsWorkspaceTable#read}
    */
    readonly read?: string;
}
export declare function dataAzurermLogAnalyticsWorkspaceTableTimeoutsToTerraform(struct?: DataAzurermLogAnalyticsWorkspaceTableTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermLogAnalyticsWorkspaceTableTimeoutsToHclTerraform(struct?: DataAzurermLogAnalyticsWorkspaceTableTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermLogAnalyticsWorkspaceTableTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermLogAnalyticsWorkspaceTableTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermLogAnalyticsWorkspaceTableTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/log_analytics_workspace_table azurerm_log_analytics_workspace_table}
*/
export declare class DataAzurermLogAnalyticsWorkspaceTable extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_log_analytics_workspace_table";
    /**
    * Generates CDKTF code for importing a DataAzurermLogAnalyticsWorkspaceTable resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermLogAnalyticsWorkspaceTable to import
    * @param importFromId The id of the existing DataAzurermLogAnalyticsWorkspaceTable that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/log_analytics_workspace_table#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermLogAnalyticsWorkspaceTable to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/log_analytics_workspace_table azurerm_log_analytics_workspace_table} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermLogAnalyticsWorkspaceTableConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermLogAnalyticsWorkspaceTableConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get plan(): string;
    get retentionInDays(): number;
    get totalRetentionInDays(): number;
    private _workspaceId?;
    get workspaceId(): string;
    set workspaceId(value: string);
    get workspaceIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermLogAnalyticsWorkspaceTableTimeoutsOutputReference;
    putTimeouts(value: DataAzurermLogAnalyticsWorkspaceTableTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermLogAnalyticsWorkspaceTableTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
