/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermMssqlManagedDatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/mssql_managed_database#id DataAzurermMssqlManagedDatabase#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/mssql_managed_database#managed_instance_id DataAzurermMssqlManagedDatabase#managed_instance_id}
    */
    readonly managedInstanceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/mssql_managed_database#name DataAzurermMssqlManagedDatabase#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/mssql_managed_database#timeouts DataAzurermMssqlManagedDatabase#timeouts}
    */
    readonly timeouts?: DataAzurermMssqlManagedDatabaseTimeouts;
}
export interface DataAzurermMssqlManagedDatabaseLongTermRetentionPolicy {
}
export declare function dataAzurermMssqlManagedDatabaseLongTermRetentionPolicyToTerraform(struct?: DataAzurermMssqlManagedDatabaseLongTermRetentionPolicy): any;
export declare function dataAzurermMssqlManagedDatabaseLongTermRetentionPolicyToHclTerraform(struct?: DataAzurermMssqlManagedDatabaseLongTermRetentionPolicy): any;
export declare class DataAzurermMssqlManagedDatabaseLongTermRetentionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMssqlManagedDatabaseLongTermRetentionPolicy | undefined;
    set internalValue(value: DataAzurermMssqlManagedDatabaseLongTermRetentionPolicy | undefined);
    get immutableBackupsEnabled(): cdktf.IResolvable;
    get monthlyRetention(): string;
    get weekOfYear(): number;
    get weeklyRetention(): string;
    get yearlyRetention(): string;
}
export declare class DataAzurermMssqlManagedDatabaseLongTermRetentionPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMssqlManagedDatabaseLongTermRetentionPolicyOutputReference;
}
export interface DataAzurermMssqlManagedDatabasePointInTimeRestore {
}
export declare function dataAzurermMssqlManagedDatabasePointInTimeRestoreToTerraform(struct?: DataAzurermMssqlManagedDatabasePointInTimeRestore): any;
export declare function dataAzurermMssqlManagedDatabasePointInTimeRestoreToHclTerraform(struct?: DataAzurermMssqlManagedDatabasePointInTimeRestore): any;
export declare class DataAzurermMssqlManagedDatabasePointInTimeRestoreOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMssqlManagedDatabasePointInTimeRestore | undefined;
    set internalValue(value: DataAzurermMssqlManagedDatabasePointInTimeRestore | undefined);
    get restorePointInTime(): string;
    get sourceDatabaseId(): string;
}
export declare class DataAzurermMssqlManagedDatabasePointInTimeRestoreList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMssqlManagedDatabasePointInTimeRestoreOutputReference;
}
export interface DataAzurermMssqlManagedDatabaseTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/mssql_managed_database#read DataAzurermMssqlManagedDatabase#read}
    */
    readonly read?: string;
}
export declare function dataAzurermMssqlManagedDatabaseTimeoutsToTerraform(struct?: DataAzurermMssqlManagedDatabaseTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermMssqlManagedDatabaseTimeoutsToHclTerraform(struct?: DataAzurermMssqlManagedDatabaseTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermMssqlManagedDatabaseTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermMssqlManagedDatabaseTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermMssqlManagedDatabaseTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/mssql_managed_database azurerm_mssql_managed_database}
*/
export declare class DataAzurermMssqlManagedDatabase extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_mssql_managed_database";
    /**
    * Generates CDKTF code for importing a DataAzurermMssqlManagedDatabase resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermMssqlManagedDatabase to import
    * @param importFromId The id of the existing DataAzurermMssqlManagedDatabase that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/mssql_managed_database#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermMssqlManagedDatabase to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/mssql_managed_database azurerm_mssql_managed_database} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermMssqlManagedDatabaseConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermMssqlManagedDatabaseConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _longTermRetentionPolicy;
    get longTermRetentionPolicy(): DataAzurermMssqlManagedDatabaseLongTermRetentionPolicyList;
    private _managedInstanceId?;
    get managedInstanceId(): string;
    set managedInstanceId(value: string);
    get managedInstanceIdInput(): string | undefined;
    get managedInstanceName(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _pointInTimeRestore;
    get pointInTimeRestore(): DataAzurermMssqlManagedDatabasePointInTimeRestoreList;
    get resourceGroupName(): string;
    get shortTermRetentionDays(): number;
    private _timeouts;
    get timeouts(): DataAzurermMssqlManagedDatabaseTimeoutsOutputReference;
    putTimeouts(value: DataAzurermMssqlManagedDatabaseTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermMssqlManagedDatabaseTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
