/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermNetappAccountEncryptionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/netapp_account_encryption#id DataAzurermNetappAccountEncryption#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The ID of the NetApp Account where encryption will be set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/netapp_account_encryption#netapp_account_id DataAzurermNetappAccountEncryption#netapp_account_id}
    */
    readonly netappAccountId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/netapp_account_encryption#timeouts DataAzurermNetappAccountEncryption#timeouts}
    */
    readonly timeouts?: DataAzurermNetappAccountEncryptionTimeouts;
}
export interface DataAzurermNetappAccountEncryptionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/netapp_account_encryption#read DataAzurermNetappAccountEncryption#read}
    */
    readonly read?: string;
}
export declare function dataAzurermNetappAccountEncryptionTimeoutsToTerraform(struct?: DataAzurermNetappAccountEncryptionTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermNetappAccountEncryptionTimeoutsToHclTerraform(struct?: DataAzurermNetappAccountEncryptionTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermNetappAccountEncryptionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermNetappAccountEncryptionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermNetappAccountEncryptionTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/netapp_account_encryption azurerm_netapp_account_encryption}
*/
export declare class DataAzurermNetappAccountEncryption extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_netapp_account_encryption";
    /**
    * Generates CDKTF code for importing a DataAzurermNetappAccountEncryption resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermNetappAccountEncryption to import
    * @param importFromId The id of the existing DataAzurermNetappAccountEncryption that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/netapp_account_encryption#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermNetappAccountEncryption to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/netapp_account_encryption azurerm_netapp_account_encryption} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermNetappAccountEncryptionConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermNetappAccountEncryptionConfig);
    get encryptionKey(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _netappAccountId?;
    get netappAccountId(): string;
    set netappAccountId(value: string);
    get netappAccountIdInput(): string | undefined;
    get systemAssignedIdentityPrincipalId(): string;
    get userAssignedIdentityId(): string;
    private _timeouts;
    get timeouts(): DataAzurermNetappAccountEncryptionTimeoutsOutputReference;
    putTimeouts(value: DataAzurermNetappAccountEncryptionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermNetappAccountEncryptionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
