/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermNetworkSecurityGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/network_security_group#id DataAzurermNetworkSecurityGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/network_security_group#name DataAzurermNetworkSecurityGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/network_security_group#resource_group_name DataAzurermNetworkSecurityGroup#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/network_security_group#timeouts DataAzurermNetworkSecurityGroup#timeouts}
    */
    readonly timeouts?: DataAzurermNetworkSecurityGroupTimeouts;
}
export interface DataAzurermNetworkSecurityGroupSecurityRule {
}
export declare function dataAzurermNetworkSecurityGroupSecurityRuleToTerraform(struct?: DataAzurermNetworkSecurityGroupSecurityRule): any;
export declare function dataAzurermNetworkSecurityGroupSecurityRuleToHclTerraform(struct?: DataAzurermNetworkSecurityGroupSecurityRule): any;
export declare class DataAzurermNetworkSecurityGroupSecurityRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermNetworkSecurityGroupSecurityRule | undefined;
    set internalValue(value: DataAzurermNetworkSecurityGroupSecurityRule | undefined);
    get access(): string;
    get description(): string;
    get destinationAddressPrefix(): string;
    get destinationAddressPrefixes(): string[];
    get destinationApplicationSecurityGroupIds(): string[];
    get destinationPortRange(): string;
    get destinationPortRanges(): string[];
    get direction(): string;
    get name(): string;
    get priority(): number;
    get protocol(): string;
    get sourceAddressPrefix(): string;
    get sourceAddressPrefixes(): string[];
    get sourceApplicationSecurityGroupIds(): string[];
    get sourcePortRange(): string;
    get sourcePortRanges(): string[];
}
export declare class DataAzurermNetworkSecurityGroupSecurityRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermNetworkSecurityGroupSecurityRuleOutputReference;
}
export interface DataAzurermNetworkSecurityGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/network_security_group#read DataAzurermNetworkSecurityGroup#read}
    */
    readonly read?: string;
}
export declare function dataAzurermNetworkSecurityGroupTimeoutsToTerraform(struct?: DataAzurermNetworkSecurityGroupTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermNetworkSecurityGroupTimeoutsToHclTerraform(struct?: DataAzurermNetworkSecurityGroupTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermNetworkSecurityGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermNetworkSecurityGroupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermNetworkSecurityGroupTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/network_security_group azurerm_network_security_group}
*/
export declare class DataAzurermNetworkSecurityGroup extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_network_security_group";
    /**
    * Generates CDKTF code for importing a DataAzurermNetworkSecurityGroup resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermNetworkSecurityGroup to import
    * @param importFromId The id of the existing DataAzurermNetworkSecurityGroup that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/network_security_group#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermNetworkSecurityGroup to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/network_security_group azurerm_network_security_group} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermNetworkSecurityGroupConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermNetworkSecurityGroupConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _securityRule;
    get securityRule(): DataAzurermNetworkSecurityGroupSecurityRuleList;
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurermNetworkSecurityGroupTimeoutsOutputReference;
    putTimeouts(value: DataAzurermNetworkSecurityGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermNetworkSecurityGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
