/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermPublicIpsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/public_ips#allocation_type DataAzurermPublicIps#allocation_type}
    */
    readonly allocationType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/public_ips#attachment_status DataAzurermPublicIps#attachment_status}
    */
    readonly attachmentStatus?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/public_ips#id DataAzurermPublicIps#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/public_ips#name_prefix DataAzurermPublicIps#name_prefix}
    */
    readonly namePrefix?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/public_ips#resource_group_name DataAzurermPublicIps#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/public_ips#timeouts DataAzurermPublicIps#timeouts}
    */
    readonly timeouts?: DataAzurermPublicIpsTimeouts;
}
export interface DataAzurermPublicIpsPublicIps {
}
export declare function dataAzurermPublicIpsPublicIpsToTerraform(struct?: DataAzurermPublicIpsPublicIps): any;
export declare function dataAzurermPublicIpsPublicIpsToHclTerraform(struct?: DataAzurermPublicIpsPublicIps): any;
export declare class DataAzurermPublicIpsPublicIpsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermPublicIpsPublicIps | undefined;
    set internalValue(value: DataAzurermPublicIpsPublicIps | undefined);
    get domainNameLabel(): string;
    get fqdn(): string;
    get id(): string;
    get ipAddress(): string;
    get name(): string;
}
export declare class DataAzurermPublicIpsPublicIpsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermPublicIpsPublicIpsOutputReference;
}
export interface DataAzurermPublicIpsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/public_ips#read DataAzurermPublicIps#read}
    */
    readonly read?: string;
}
export declare function dataAzurermPublicIpsTimeoutsToTerraform(struct?: DataAzurermPublicIpsTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermPublicIpsTimeoutsToHclTerraform(struct?: DataAzurermPublicIpsTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermPublicIpsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermPublicIpsTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermPublicIpsTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/public_ips azurerm_public_ips}
*/
export declare class DataAzurermPublicIps extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_public_ips";
    /**
    * Generates CDKTF code for importing a DataAzurermPublicIps resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermPublicIps to import
    * @param importFromId The id of the existing DataAzurermPublicIps that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/public_ips#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermPublicIps to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/public_ips azurerm_public_ips} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermPublicIpsConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermPublicIpsConfig);
    private _allocationType?;
    get allocationType(): string;
    set allocationType(value: string);
    resetAllocationType(): void;
    get allocationTypeInput(): string | undefined;
    private _attachmentStatus?;
    get attachmentStatus(): string;
    set attachmentStatus(value: string);
    resetAttachmentStatus(): void;
    get attachmentStatusInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _namePrefix?;
    get namePrefix(): string;
    set namePrefix(value: string);
    resetNamePrefix(): void;
    get namePrefixInput(): string | undefined;
    private _publicIps;
    get publicIps(): DataAzurermPublicIpsPublicIpsList;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermPublicIpsTimeoutsOutputReference;
    putTimeouts(value: DataAzurermPublicIpsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermPublicIpsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
