/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermRoleAssignmentsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/role_assignments#id DataAzurermRoleAssignments#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/role_assignments#limit_at_scope DataAzurermRoleAssignments#limit_at_scope}
    */
    readonly limitAtScope?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/role_assignments#principal_id DataAzurermRoleAssignments#principal_id}
    */
    readonly principalId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/role_assignments#scope DataAzurermRoleAssignments#scope}
    */
    readonly scope: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/role_assignments#tenant_id DataAzurermRoleAssignments#tenant_id}
    */
    readonly tenantId?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/role_assignments#timeouts DataAzurermRoleAssignments#timeouts}
    */
    readonly timeouts?: DataAzurermRoleAssignmentsTimeouts;
}
export interface DataAzurermRoleAssignmentsRoleAssignments {
}
export declare function dataAzurermRoleAssignmentsRoleAssignmentsToTerraform(struct?: DataAzurermRoleAssignmentsRoleAssignments): any;
export declare function dataAzurermRoleAssignmentsRoleAssignmentsToHclTerraform(struct?: DataAzurermRoleAssignmentsRoleAssignments): any;
export declare class DataAzurermRoleAssignmentsRoleAssignmentsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermRoleAssignmentsRoleAssignments | undefined;
    set internalValue(value: DataAzurermRoleAssignmentsRoleAssignments | undefined);
    get condition(): string;
    get conditionVersion(): string;
    get delegatedManagedIdentityResourceId(): string;
    get description(): string;
    get principalId(): string;
    get principalType(): string;
    get roleAssignmentId(): string;
    get roleAssignmentName(): string;
    get roleAssignmentScope(): string;
    get roleDefinitionId(): string;
}
export declare class DataAzurermRoleAssignmentsRoleAssignmentsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermRoleAssignmentsRoleAssignmentsOutputReference;
}
export interface DataAzurermRoleAssignmentsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/role_assignments#read DataAzurermRoleAssignments#read}
    */
    readonly read?: string;
}
export declare function dataAzurermRoleAssignmentsTimeoutsToTerraform(struct?: DataAzurermRoleAssignmentsTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermRoleAssignmentsTimeoutsToHclTerraform(struct?: DataAzurermRoleAssignmentsTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermRoleAssignmentsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermRoleAssignmentsTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermRoleAssignmentsTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/role_assignments azurerm_role_assignments}
*/
export declare class DataAzurermRoleAssignments extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_role_assignments";
    /**
    * Generates CDKTF code for importing a DataAzurermRoleAssignments resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermRoleAssignments to import
    * @param importFromId The id of the existing DataAzurermRoleAssignments that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/role_assignments#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermRoleAssignments to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/role_assignments azurerm_role_assignments} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermRoleAssignmentsConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermRoleAssignmentsConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _limitAtScope?;
    get limitAtScope(): boolean | cdktf.IResolvable;
    set limitAtScope(value: boolean | cdktf.IResolvable);
    resetLimitAtScope(): void;
    get limitAtScopeInput(): boolean | cdktf.IResolvable | undefined;
    private _principalId?;
    get principalId(): string;
    set principalId(value: string);
    resetPrincipalId(): void;
    get principalIdInput(): string | undefined;
    private _roleAssignments;
    get roleAssignments(): DataAzurermRoleAssignmentsRoleAssignmentsList;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    get scopeInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    resetTenantId(): void;
    get tenantIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermRoleAssignmentsTimeoutsOutputReference;
    putTimeouts(value: DataAzurermRoleAssignmentsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermRoleAssignmentsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
