/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermVirtualNetworkGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/virtual_network_gateway#id DataAzurermVirtualNetworkGateway#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/virtual_network_gateway#name DataAzurermVirtualNetworkGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/virtual_network_gateway#resource_group_name DataAzurermVirtualNetworkGateway#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/virtual_network_gateway#timeouts DataAzurermVirtualNetworkGateway#timeouts}
    */
    readonly timeouts?: DataAzurermVirtualNetworkGatewayTimeouts;
}
export interface DataAzurermVirtualNetworkGatewayBgpSettings {
}
export declare function dataAzurermVirtualNetworkGatewayBgpSettingsToTerraform(struct?: DataAzurermVirtualNetworkGatewayBgpSettings): any;
export declare function dataAzurermVirtualNetworkGatewayBgpSettingsToHclTerraform(struct?: DataAzurermVirtualNetworkGatewayBgpSettings): any;
export declare class DataAzurermVirtualNetworkGatewayBgpSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermVirtualNetworkGatewayBgpSettings | undefined;
    set internalValue(value: DataAzurermVirtualNetworkGatewayBgpSettings | undefined);
    get asn(): number;
    get peerWeight(): number;
    get peeringAddress(): string;
}
export declare class DataAzurermVirtualNetworkGatewayBgpSettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermVirtualNetworkGatewayBgpSettingsOutputReference;
}
export interface DataAzurermVirtualNetworkGatewayCustomRoute {
}
export declare function dataAzurermVirtualNetworkGatewayCustomRouteToTerraform(struct?: DataAzurermVirtualNetworkGatewayCustomRoute): any;
export declare function dataAzurermVirtualNetworkGatewayCustomRouteToHclTerraform(struct?: DataAzurermVirtualNetworkGatewayCustomRoute): any;
export declare class DataAzurermVirtualNetworkGatewayCustomRouteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermVirtualNetworkGatewayCustomRoute | undefined;
    set internalValue(value: DataAzurermVirtualNetworkGatewayCustomRoute | undefined);
    get addressPrefixes(): string[];
}
export declare class DataAzurermVirtualNetworkGatewayCustomRouteList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermVirtualNetworkGatewayCustomRouteOutputReference;
}
export interface DataAzurermVirtualNetworkGatewayIpConfiguration {
}
export declare function dataAzurermVirtualNetworkGatewayIpConfigurationToTerraform(struct?: DataAzurermVirtualNetworkGatewayIpConfiguration): any;
export declare function dataAzurermVirtualNetworkGatewayIpConfigurationToHclTerraform(struct?: DataAzurermVirtualNetworkGatewayIpConfiguration): any;
export declare class DataAzurermVirtualNetworkGatewayIpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermVirtualNetworkGatewayIpConfiguration | undefined;
    set internalValue(value: DataAzurermVirtualNetworkGatewayIpConfiguration | undefined);
    get id(): string;
    get name(): string;
    get privateIpAddress(): string;
    get privateIpAddressAllocation(): string;
    get publicIpAddressId(): string;
    get subnetId(): string;
}
export declare class DataAzurermVirtualNetworkGatewayIpConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermVirtualNetworkGatewayIpConfigurationOutputReference;
}
export interface DataAzurermVirtualNetworkGatewayVpnClientConfigurationRevokedCertificate {
}
export declare function dataAzurermVirtualNetworkGatewayVpnClientConfigurationRevokedCertificateToTerraform(struct?: DataAzurermVirtualNetworkGatewayVpnClientConfigurationRevokedCertificate): any;
export declare function dataAzurermVirtualNetworkGatewayVpnClientConfigurationRevokedCertificateToHclTerraform(struct?: DataAzurermVirtualNetworkGatewayVpnClientConfigurationRevokedCertificate): any;
export declare class DataAzurermVirtualNetworkGatewayVpnClientConfigurationRevokedCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermVirtualNetworkGatewayVpnClientConfigurationRevokedCertificate | undefined;
    set internalValue(value: DataAzurermVirtualNetworkGatewayVpnClientConfigurationRevokedCertificate | undefined);
    get name(): string;
    get thumbprint(): string;
}
export declare class DataAzurermVirtualNetworkGatewayVpnClientConfigurationRevokedCertificateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermVirtualNetworkGatewayVpnClientConfigurationRevokedCertificateOutputReference;
}
export interface DataAzurermVirtualNetworkGatewayVpnClientConfigurationRootCertificate {
}
export declare function dataAzurermVirtualNetworkGatewayVpnClientConfigurationRootCertificateToTerraform(struct?: DataAzurermVirtualNetworkGatewayVpnClientConfigurationRootCertificate): any;
export declare function dataAzurermVirtualNetworkGatewayVpnClientConfigurationRootCertificateToHclTerraform(struct?: DataAzurermVirtualNetworkGatewayVpnClientConfigurationRootCertificate): any;
export declare class DataAzurermVirtualNetworkGatewayVpnClientConfigurationRootCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermVirtualNetworkGatewayVpnClientConfigurationRootCertificate | undefined;
    set internalValue(value: DataAzurermVirtualNetworkGatewayVpnClientConfigurationRootCertificate | undefined);
    get name(): string;
    get publicCertData(): string;
}
export declare class DataAzurermVirtualNetworkGatewayVpnClientConfigurationRootCertificateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermVirtualNetworkGatewayVpnClientConfigurationRootCertificateOutputReference;
}
export interface DataAzurermVirtualNetworkGatewayVpnClientConfiguration {
}
export declare function dataAzurermVirtualNetworkGatewayVpnClientConfigurationToTerraform(struct?: DataAzurermVirtualNetworkGatewayVpnClientConfiguration): any;
export declare function dataAzurermVirtualNetworkGatewayVpnClientConfigurationToHclTerraform(struct?: DataAzurermVirtualNetworkGatewayVpnClientConfiguration): any;
export declare class DataAzurermVirtualNetworkGatewayVpnClientConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermVirtualNetworkGatewayVpnClientConfiguration | undefined;
    set internalValue(value: DataAzurermVirtualNetworkGatewayVpnClientConfiguration | undefined);
    get aadAudience(): string;
    get aadIssuer(): string;
    get aadTenant(): string;
    get addressSpace(): string[];
    get radiusServerAddress(): string;
    get radiusServerSecret(): string;
    private _revokedCertificate;
    get revokedCertificate(): DataAzurermVirtualNetworkGatewayVpnClientConfigurationRevokedCertificateList;
    private _rootCertificate;
    get rootCertificate(): DataAzurermVirtualNetworkGatewayVpnClientConfigurationRootCertificateList;
    get vpnClientProtocols(): string[];
}
export declare class DataAzurermVirtualNetworkGatewayVpnClientConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermVirtualNetworkGatewayVpnClientConfigurationOutputReference;
}
export interface DataAzurermVirtualNetworkGatewayTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/virtual_network_gateway#read DataAzurermVirtualNetworkGateway#read}
    */
    readonly read?: string;
}
export declare function dataAzurermVirtualNetworkGatewayTimeoutsToTerraform(struct?: DataAzurermVirtualNetworkGatewayTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermVirtualNetworkGatewayTimeoutsToHclTerraform(struct?: DataAzurermVirtualNetworkGatewayTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermVirtualNetworkGatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermVirtualNetworkGatewayTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermVirtualNetworkGatewayTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/virtual_network_gateway azurerm_virtual_network_gateway}
*/
export declare class DataAzurermVirtualNetworkGateway extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_virtual_network_gateway";
    /**
    * Generates CDKTF code for importing a DataAzurermVirtualNetworkGateway resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermVirtualNetworkGateway to import
    * @param importFromId The id of the existing DataAzurermVirtualNetworkGateway that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/virtual_network_gateway#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermVirtualNetworkGateway to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/virtual_network_gateway azurerm_virtual_network_gateway} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermVirtualNetworkGatewayConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermVirtualNetworkGatewayConfig);
    get activeActive(): cdktf.IResolvable;
    private _bgpSettings;
    get bgpSettings(): DataAzurermVirtualNetworkGatewayBgpSettingsList;
    private _customRoute;
    get customRoute(): DataAzurermVirtualNetworkGatewayCustomRouteList;
    get defaultLocalNetworkGatewayId(): string;
    get enableBgp(): cdktf.IResolvable;
    get generation(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ipConfiguration;
    get ipConfiguration(): DataAzurermVirtualNetworkGatewayIpConfigurationList;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get privateIpAddressEnabled(): cdktf.IResolvable;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get sku(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    get type(): string;
    private _vpnClientConfiguration;
    get vpnClientConfiguration(): DataAzurermVirtualNetworkGatewayVpnClientConfigurationList;
    get vpnType(): string;
    private _timeouts;
    get timeouts(): DataAzurermVirtualNetworkGatewayTimeoutsOutputReference;
    putTimeouts(value: DataAzurermVirtualNetworkGatewayTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermVirtualNetworkGatewayTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
