/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermWindowsWebAppConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/windows_web_app#id DataAzurermWindowsWebApp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/windows_web_app#name DataAzurermWindowsWebApp#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/windows_web_app#resource_group_name DataAzurermWindowsWebApp#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/windows_web_app#timeouts DataAzurermWindowsWebApp#timeouts}
    */
    readonly timeouts?: DataAzurermWindowsWebAppTimeouts;
}
export interface DataAzurermWindowsWebAppAuthSettingsActiveDirectory {
}
export declare function dataAzurermWindowsWebAppAuthSettingsActiveDirectoryToTerraform(struct?: DataAzurermWindowsWebAppAuthSettingsActiveDirectory): any;
export declare function dataAzurermWindowsWebAppAuthSettingsActiveDirectoryToHclTerraform(struct?: DataAzurermWindowsWebAppAuthSettingsActiveDirectory): any;
export declare class DataAzurermWindowsWebAppAuthSettingsActiveDirectoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppAuthSettingsActiveDirectory | undefined;
    set internalValue(value: DataAzurermWindowsWebAppAuthSettingsActiveDirectory | undefined);
    get allowedAudiences(): string[];
    get clientId(): string;
    get clientSecret(): string;
    get clientSecretSettingName(): string;
}
export declare class DataAzurermWindowsWebAppAuthSettingsActiveDirectoryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppAuthSettingsActiveDirectoryOutputReference;
}
export interface DataAzurermWindowsWebAppAuthSettingsFacebook {
}
export declare function dataAzurermWindowsWebAppAuthSettingsFacebookToTerraform(struct?: DataAzurermWindowsWebAppAuthSettingsFacebook): any;
export declare function dataAzurermWindowsWebAppAuthSettingsFacebookToHclTerraform(struct?: DataAzurermWindowsWebAppAuthSettingsFacebook): any;
export declare class DataAzurermWindowsWebAppAuthSettingsFacebookOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppAuthSettingsFacebook | undefined;
    set internalValue(value: DataAzurermWindowsWebAppAuthSettingsFacebook | undefined);
    get appId(): string;
    get appSecret(): string;
    get appSecretSettingName(): string;
    get oauthScopes(): string[];
}
export declare class DataAzurermWindowsWebAppAuthSettingsFacebookList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppAuthSettingsFacebookOutputReference;
}
export interface DataAzurermWindowsWebAppAuthSettingsGithub {
}
export declare function dataAzurermWindowsWebAppAuthSettingsGithubToTerraform(struct?: DataAzurermWindowsWebAppAuthSettingsGithub): any;
export declare function dataAzurermWindowsWebAppAuthSettingsGithubToHclTerraform(struct?: DataAzurermWindowsWebAppAuthSettingsGithub): any;
export declare class DataAzurermWindowsWebAppAuthSettingsGithubOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppAuthSettingsGithub | undefined;
    set internalValue(value: DataAzurermWindowsWebAppAuthSettingsGithub | undefined);
    get clientId(): string;
    get clientSecret(): string;
    get clientSecretSettingName(): string;
    get oauthScopes(): string[];
}
export declare class DataAzurermWindowsWebAppAuthSettingsGithubList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppAuthSettingsGithubOutputReference;
}
export interface DataAzurermWindowsWebAppAuthSettingsGoogle {
}
export declare function dataAzurermWindowsWebAppAuthSettingsGoogleToTerraform(struct?: DataAzurermWindowsWebAppAuthSettingsGoogle): any;
export declare function dataAzurermWindowsWebAppAuthSettingsGoogleToHclTerraform(struct?: DataAzurermWindowsWebAppAuthSettingsGoogle): any;
export declare class DataAzurermWindowsWebAppAuthSettingsGoogleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppAuthSettingsGoogle | undefined;
    set internalValue(value: DataAzurermWindowsWebAppAuthSettingsGoogle | undefined);
    get clientId(): string;
    get clientSecret(): string;
    get clientSecretSettingName(): string;
    get oauthScopes(): string[];
}
export declare class DataAzurermWindowsWebAppAuthSettingsGoogleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppAuthSettingsGoogleOutputReference;
}
export interface DataAzurermWindowsWebAppAuthSettingsMicrosoft {
}
export declare function dataAzurermWindowsWebAppAuthSettingsMicrosoftToTerraform(struct?: DataAzurermWindowsWebAppAuthSettingsMicrosoft): any;
export declare function dataAzurermWindowsWebAppAuthSettingsMicrosoftToHclTerraform(struct?: DataAzurermWindowsWebAppAuthSettingsMicrosoft): any;
export declare class DataAzurermWindowsWebAppAuthSettingsMicrosoftOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppAuthSettingsMicrosoft | undefined;
    set internalValue(value: DataAzurermWindowsWebAppAuthSettingsMicrosoft | undefined);
    get clientId(): string;
    get clientSecret(): string;
    get clientSecretSettingName(): string;
    get oauthScopes(): string[];
}
export declare class DataAzurermWindowsWebAppAuthSettingsMicrosoftList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppAuthSettingsMicrosoftOutputReference;
}
export interface DataAzurermWindowsWebAppAuthSettingsTwitter {
}
export declare function dataAzurermWindowsWebAppAuthSettingsTwitterToTerraform(struct?: DataAzurermWindowsWebAppAuthSettingsTwitter): any;
export declare function dataAzurermWindowsWebAppAuthSettingsTwitterToHclTerraform(struct?: DataAzurermWindowsWebAppAuthSettingsTwitter): any;
export declare class DataAzurermWindowsWebAppAuthSettingsTwitterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppAuthSettingsTwitter | undefined;
    set internalValue(value: DataAzurermWindowsWebAppAuthSettingsTwitter | undefined);
    get consumerKey(): string;
    get consumerSecret(): string;
    get consumerSecretSettingName(): string;
}
export declare class DataAzurermWindowsWebAppAuthSettingsTwitterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppAuthSettingsTwitterOutputReference;
}
export interface DataAzurermWindowsWebAppAuthSettings {
}
export declare function dataAzurermWindowsWebAppAuthSettingsToTerraform(struct?: DataAzurermWindowsWebAppAuthSettings): any;
export declare function dataAzurermWindowsWebAppAuthSettingsToHclTerraform(struct?: DataAzurermWindowsWebAppAuthSettings): any;
export declare class DataAzurermWindowsWebAppAuthSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppAuthSettings | undefined;
    set internalValue(value: DataAzurermWindowsWebAppAuthSettings | undefined);
    private _activeDirectory;
    get activeDirectory(): DataAzurermWindowsWebAppAuthSettingsActiveDirectoryList;
    private _additionalLoginParameters;
    get additionalLoginParameters(): cdktf.StringMap;
    get allowedExternalRedirectUrls(): string[];
    get defaultProvider(): string;
    get enabled(): cdktf.IResolvable;
    private _facebook;
    get facebook(): DataAzurermWindowsWebAppAuthSettingsFacebookList;
    private _github;
    get github(): DataAzurermWindowsWebAppAuthSettingsGithubList;
    private _google;
    get google(): DataAzurermWindowsWebAppAuthSettingsGoogleList;
    get issuer(): string;
    private _microsoft;
    get microsoft(): DataAzurermWindowsWebAppAuthSettingsMicrosoftList;
    get runtimeVersion(): string;
    get tokenRefreshExtensionHours(): number;
    get tokenStoreEnabled(): cdktf.IResolvable;
    private _twitter;
    get twitter(): DataAzurermWindowsWebAppAuthSettingsTwitterList;
    get unauthenticatedClientAction(): string;
}
export declare class DataAzurermWindowsWebAppAuthSettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppAuthSettingsOutputReference;
}
export interface DataAzurermWindowsWebAppAuthSettingsV2ActiveDirectoryV2 {
}
export declare function dataAzurermWindowsWebAppAuthSettingsV2ActiveDirectoryV2ToTerraform(struct?: DataAzurermWindowsWebAppAuthSettingsV2ActiveDirectoryV2): any;
export declare function dataAzurermWindowsWebAppAuthSettingsV2ActiveDirectoryV2ToHclTerraform(struct?: DataAzurermWindowsWebAppAuthSettingsV2ActiveDirectoryV2): any;
export declare class DataAzurermWindowsWebAppAuthSettingsV2ActiveDirectoryV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppAuthSettingsV2ActiveDirectoryV2 | undefined;
    set internalValue(value: DataAzurermWindowsWebAppAuthSettingsV2ActiveDirectoryV2 | undefined);
    get allowedApplications(): string[];
    get allowedAudiences(): string[];
    get allowedGroups(): string[];
    get allowedIdentities(): string[];
    get clientId(): string;
    get clientSecretCertificateThumbprint(): string;
    get clientSecretSettingName(): string;
    get jwtAllowedClientApplications(): string[];
    get jwtAllowedGroups(): string[];
    private _loginParameters;
    get loginParameters(): cdktf.StringMap;
    get tenantAuthEndpoint(): string;
    get wwwAuthenticationDisabled(): cdktf.IResolvable;
}
export declare class DataAzurermWindowsWebAppAuthSettingsV2ActiveDirectoryV2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppAuthSettingsV2ActiveDirectoryV2OutputReference;
}
export interface DataAzurermWindowsWebAppAuthSettingsV2AppleV2 {
}
export declare function dataAzurermWindowsWebAppAuthSettingsV2AppleV2ToTerraform(struct?: DataAzurermWindowsWebAppAuthSettingsV2AppleV2): any;
export declare function dataAzurermWindowsWebAppAuthSettingsV2AppleV2ToHclTerraform(struct?: DataAzurermWindowsWebAppAuthSettingsV2AppleV2): any;
export declare class DataAzurermWindowsWebAppAuthSettingsV2AppleV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppAuthSettingsV2AppleV2 | undefined;
    set internalValue(value: DataAzurermWindowsWebAppAuthSettingsV2AppleV2 | undefined);
    get clientId(): string;
    get clientSecretSettingName(): string;
    get loginScopes(): string[];
}
export declare class DataAzurermWindowsWebAppAuthSettingsV2AppleV2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppAuthSettingsV2AppleV2OutputReference;
}
export interface DataAzurermWindowsWebAppAuthSettingsV2AzureStaticWebAppV2 {
}
export declare function dataAzurermWindowsWebAppAuthSettingsV2AzureStaticWebAppV2ToTerraform(struct?: DataAzurermWindowsWebAppAuthSettingsV2AzureStaticWebAppV2): any;
export declare function dataAzurermWindowsWebAppAuthSettingsV2AzureStaticWebAppV2ToHclTerraform(struct?: DataAzurermWindowsWebAppAuthSettingsV2AzureStaticWebAppV2): any;
export declare class DataAzurermWindowsWebAppAuthSettingsV2AzureStaticWebAppV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppAuthSettingsV2AzureStaticWebAppV2 | undefined;
    set internalValue(value: DataAzurermWindowsWebAppAuthSettingsV2AzureStaticWebAppV2 | undefined);
    get clientId(): string;
}
export declare class DataAzurermWindowsWebAppAuthSettingsV2AzureStaticWebAppV2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppAuthSettingsV2AzureStaticWebAppV2OutputReference;
}
export interface DataAzurermWindowsWebAppAuthSettingsV2CustomOidcV2 {
}
export declare function dataAzurermWindowsWebAppAuthSettingsV2CustomOidcV2ToTerraform(struct?: DataAzurermWindowsWebAppAuthSettingsV2CustomOidcV2): any;
export declare function dataAzurermWindowsWebAppAuthSettingsV2CustomOidcV2ToHclTerraform(struct?: DataAzurermWindowsWebAppAuthSettingsV2CustomOidcV2): any;
export declare class DataAzurermWindowsWebAppAuthSettingsV2CustomOidcV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppAuthSettingsV2CustomOidcV2 | undefined;
    set internalValue(value: DataAzurermWindowsWebAppAuthSettingsV2CustomOidcV2 | undefined);
    get authorisationEndpoint(): string;
    get certificationUri(): string;
    get clientCredentialMethod(): string;
    get clientId(): string;
    get clientSecretSettingName(): string;
    get issuerEndpoint(): string;
    get name(): string;
    get nameClaimType(): string;
    get openidConfigurationEndpoint(): string;
    get scopes(): string[];
    get tokenEndpoint(): string;
}
export declare class DataAzurermWindowsWebAppAuthSettingsV2CustomOidcV2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppAuthSettingsV2CustomOidcV2OutputReference;
}
export interface DataAzurermWindowsWebAppAuthSettingsV2FacebookV2 {
}
export declare function dataAzurermWindowsWebAppAuthSettingsV2FacebookV2ToTerraform(struct?: DataAzurermWindowsWebAppAuthSettingsV2FacebookV2): any;
export declare function dataAzurermWindowsWebAppAuthSettingsV2FacebookV2ToHclTerraform(struct?: DataAzurermWindowsWebAppAuthSettingsV2FacebookV2): any;
export declare class DataAzurermWindowsWebAppAuthSettingsV2FacebookV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppAuthSettingsV2FacebookV2 | undefined;
    set internalValue(value: DataAzurermWindowsWebAppAuthSettingsV2FacebookV2 | undefined);
    get appId(): string;
    get appSecretSettingName(): string;
    get graphApiVersion(): string;
    get loginScopes(): string[];
}
export declare class DataAzurermWindowsWebAppAuthSettingsV2FacebookV2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppAuthSettingsV2FacebookV2OutputReference;
}
export interface DataAzurermWindowsWebAppAuthSettingsV2GithubV2 {
}
export declare function dataAzurermWindowsWebAppAuthSettingsV2GithubV2ToTerraform(struct?: DataAzurermWindowsWebAppAuthSettingsV2GithubV2): any;
export declare function dataAzurermWindowsWebAppAuthSettingsV2GithubV2ToHclTerraform(struct?: DataAzurermWindowsWebAppAuthSettingsV2GithubV2): any;
export declare class DataAzurermWindowsWebAppAuthSettingsV2GithubV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppAuthSettingsV2GithubV2 | undefined;
    set internalValue(value: DataAzurermWindowsWebAppAuthSettingsV2GithubV2 | undefined);
    get clientId(): string;
    get clientSecretSettingName(): string;
    get loginScopes(): string[];
}
export declare class DataAzurermWindowsWebAppAuthSettingsV2GithubV2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppAuthSettingsV2GithubV2OutputReference;
}
export interface DataAzurermWindowsWebAppAuthSettingsV2GoogleV2 {
}
export declare function dataAzurermWindowsWebAppAuthSettingsV2GoogleV2ToTerraform(struct?: DataAzurermWindowsWebAppAuthSettingsV2GoogleV2): any;
export declare function dataAzurermWindowsWebAppAuthSettingsV2GoogleV2ToHclTerraform(struct?: DataAzurermWindowsWebAppAuthSettingsV2GoogleV2): any;
export declare class DataAzurermWindowsWebAppAuthSettingsV2GoogleV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppAuthSettingsV2GoogleV2 | undefined;
    set internalValue(value: DataAzurermWindowsWebAppAuthSettingsV2GoogleV2 | undefined);
    get allowedAudiences(): string[];
    get clientId(): string;
    get clientSecretSettingName(): string;
    get loginScopes(): string[];
}
export declare class DataAzurermWindowsWebAppAuthSettingsV2GoogleV2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppAuthSettingsV2GoogleV2OutputReference;
}
export interface DataAzurermWindowsWebAppAuthSettingsV2Login {
}
export declare function dataAzurermWindowsWebAppAuthSettingsV2LoginToTerraform(struct?: DataAzurermWindowsWebAppAuthSettingsV2Login): any;
export declare function dataAzurermWindowsWebAppAuthSettingsV2LoginToHclTerraform(struct?: DataAzurermWindowsWebAppAuthSettingsV2Login): any;
export declare class DataAzurermWindowsWebAppAuthSettingsV2LoginOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppAuthSettingsV2Login | undefined;
    set internalValue(value: DataAzurermWindowsWebAppAuthSettingsV2Login | undefined);
    get allowedExternalRedirectUrls(): string[];
    get cookieExpirationConvention(): string;
    get cookieExpirationTime(): string;
    get logoutEndpoint(): string;
    get nonceExpirationTime(): string;
    get preserveUrlFragmentsForLogins(): cdktf.IResolvable;
    get tokenRefreshExtensionTime(): number;
    get tokenStoreEnabled(): cdktf.IResolvable;
    get tokenStorePath(): string;
    get tokenStoreSasSettingName(): string;
    get validateNonce(): cdktf.IResolvable;
}
export declare class DataAzurermWindowsWebAppAuthSettingsV2LoginList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppAuthSettingsV2LoginOutputReference;
}
export interface DataAzurermWindowsWebAppAuthSettingsV2MicrosoftV2 {
}
export declare function dataAzurermWindowsWebAppAuthSettingsV2MicrosoftV2ToTerraform(struct?: DataAzurermWindowsWebAppAuthSettingsV2MicrosoftV2): any;
export declare function dataAzurermWindowsWebAppAuthSettingsV2MicrosoftV2ToHclTerraform(struct?: DataAzurermWindowsWebAppAuthSettingsV2MicrosoftV2): any;
export declare class DataAzurermWindowsWebAppAuthSettingsV2MicrosoftV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppAuthSettingsV2MicrosoftV2 | undefined;
    set internalValue(value: DataAzurermWindowsWebAppAuthSettingsV2MicrosoftV2 | undefined);
    get allowedAudiences(): string[];
    get clientId(): string;
    get clientSecretSettingName(): string;
    get loginScopes(): string[];
}
export declare class DataAzurermWindowsWebAppAuthSettingsV2MicrosoftV2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppAuthSettingsV2MicrosoftV2OutputReference;
}
export interface DataAzurermWindowsWebAppAuthSettingsV2TwitterV2 {
}
export declare function dataAzurermWindowsWebAppAuthSettingsV2TwitterV2ToTerraform(struct?: DataAzurermWindowsWebAppAuthSettingsV2TwitterV2): any;
export declare function dataAzurermWindowsWebAppAuthSettingsV2TwitterV2ToHclTerraform(struct?: DataAzurermWindowsWebAppAuthSettingsV2TwitterV2): any;
export declare class DataAzurermWindowsWebAppAuthSettingsV2TwitterV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppAuthSettingsV2TwitterV2 | undefined;
    set internalValue(value: DataAzurermWindowsWebAppAuthSettingsV2TwitterV2 | undefined);
    get consumerKey(): string;
    get consumerSecretSettingName(): string;
}
export declare class DataAzurermWindowsWebAppAuthSettingsV2TwitterV2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppAuthSettingsV2TwitterV2OutputReference;
}
export interface DataAzurermWindowsWebAppAuthSettingsV2 {
}
export declare function dataAzurermWindowsWebAppAuthSettingsV2ToTerraform(struct?: DataAzurermWindowsWebAppAuthSettingsV2): any;
export declare function dataAzurermWindowsWebAppAuthSettingsV2ToHclTerraform(struct?: DataAzurermWindowsWebAppAuthSettingsV2): any;
export declare class DataAzurermWindowsWebAppAuthSettingsV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppAuthSettingsV2 | undefined;
    set internalValue(value: DataAzurermWindowsWebAppAuthSettingsV2 | undefined);
    private _activeDirectoryV2;
    get activeDirectoryV2(): DataAzurermWindowsWebAppAuthSettingsV2ActiveDirectoryV2List;
    private _appleV2;
    get appleV2(): DataAzurermWindowsWebAppAuthSettingsV2AppleV2List;
    get authEnabled(): cdktf.IResolvable;
    private _azureStaticWebAppV2;
    get azureStaticWebAppV2(): DataAzurermWindowsWebAppAuthSettingsV2AzureStaticWebAppV2List;
    get configFilePath(): string;
    private _customOidcV2;
    get customOidcV2(): DataAzurermWindowsWebAppAuthSettingsV2CustomOidcV2List;
    get defaultProvider(): string;
    get excludedPaths(): string[];
    private _facebookV2;
    get facebookV2(): DataAzurermWindowsWebAppAuthSettingsV2FacebookV2List;
    get forwardProxyConvention(): string;
    get forwardProxyCustomHostHeaderName(): string;
    get forwardProxyCustomSchemeHeaderName(): string;
    private _githubV2;
    get githubV2(): DataAzurermWindowsWebAppAuthSettingsV2GithubV2List;
    private _googleV2;
    get googleV2(): DataAzurermWindowsWebAppAuthSettingsV2GoogleV2List;
    get httpRouteApiPrefix(): string;
    private _login;
    get login(): DataAzurermWindowsWebAppAuthSettingsV2LoginList;
    private _microsoftV2;
    get microsoftV2(): DataAzurermWindowsWebAppAuthSettingsV2MicrosoftV2List;
    get requireAuthentication(): cdktf.IResolvable;
    get requireHttps(): cdktf.IResolvable;
    get runtimeVersion(): string;
    private _twitterV2;
    get twitterV2(): DataAzurermWindowsWebAppAuthSettingsV2TwitterV2List;
    get unauthenticatedAction(): string;
}
export declare class DataAzurermWindowsWebAppAuthSettingsV2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppAuthSettingsV2OutputReference;
}
export interface DataAzurermWindowsWebAppBackupSchedule {
}
export declare function dataAzurermWindowsWebAppBackupScheduleToTerraform(struct?: DataAzurermWindowsWebAppBackupSchedule): any;
export declare function dataAzurermWindowsWebAppBackupScheduleToHclTerraform(struct?: DataAzurermWindowsWebAppBackupSchedule): any;
export declare class DataAzurermWindowsWebAppBackupScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppBackupSchedule | undefined;
    set internalValue(value: DataAzurermWindowsWebAppBackupSchedule | undefined);
    get frequencyInterval(): number;
    get frequencyUnit(): string;
    get keepAtLeastOneBackup(): cdktf.IResolvable;
    get lastExecutionTime(): string;
    get retentionPeriodDays(): number;
    get startTime(): string;
}
export declare class DataAzurermWindowsWebAppBackupScheduleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppBackupScheduleOutputReference;
}
export interface DataAzurermWindowsWebAppBackup {
}
export declare function dataAzurermWindowsWebAppBackupToTerraform(struct?: DataAzurermWindowsWebAppBackup): any;
export declare function dataAzurermWindowsWebAppBackupToHclTerraform(struct?: DataAzurermWindowsWebAppBackup): any;
export declare class DataAzurermWindowsWebAppBackupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppBackup | undefined;
    set internalValue(value: DataAzurermWindowsWebAppBackup | undefined);
    get enabled(): cdktf.IResolvable;
    get name(): string;
    private _schedule;
    get schedule(): DataAzurermWindowsWebAppBackupScheduleList;
    get storageAccountUrl(): string;
}
export declare class DataAzurermWindowsWebAppBackupList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppBackupOutputReference;
}
export interface DataAzurermWindowsWebAppConnectionString {
}
export declare function dataAzurermWindowsWebAppConnectionStringToTerraform(struct?: DataAzurermWindowsWebAppConnectionString): any;
export declare function dataAzurermWindowsWebAppConnectionStringToHclTerraform(struct?: DataAzurermWindowsWebAppConnectionString): any;
export declare class DataAzurermWindowsWebAppConnectionStringOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppConnectionString | undefined;
    set internalValue(value: DataAzurermWindowsWebAppConnectionString | undefined);
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class DataAzurermWindowsWebAppConnectionStringList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppConnectionStringOutputReference;
}
export interface DataAzurermWindowsWebAppIdentity {
}
export declare function dataAzurermWindowsWebAppIdentityToTerraform(struct?: DataAzurermWindowsWebAppIdentity): any;
export declare function dataAzurermWindowsWebAppIdentityToHclTerraform(struct?: DataAzurermWindowsWebAppIdentity): any;
export declare class DataAzurermWindowsWebAppIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppIdentity | undefined;
    set internalValue(value: DataAzurermWindowsWebAppIdentity | undefined);
    get identityIds(): string[];
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermWindowsWebAppIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppIdentityOutputReference;
}
export interface DataAzurermWindowsWebAppLogsApplicationLogsAzureBlobStorage {
}
export declare function dataAzurermWindowsWebAppLogsApplicationLogsAzureBlobStorageToTerraform(struct?: DataAzurermWindowsWebAppLogsApplicationLogsAzureBlobStorage): any;
export declare function dataAzurermWindowsWebAppLogsApplicationLogsAzureBlobStorageToHclTerraform(struct?: DataAzurermWindowsWebAppLogsApplicationLogsAzureBlobStorage): any;
export declare class DataAzurermWindowsWebAppLogsApplicationLogsAzureBlobStorageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppLogsApplicationLogsAzureBlobStorage | undefined;
    set internalValue(value: DataAzurermWindowsWebAppLogsApplicationLogsAzureBlobStorage | undefined);
    get level(): string;
    get retentionInDays(): number;
    get sasUrl(): string;
}
export declare class DataAzurermWindowsWebAppLogsApplicationLogsAzureBlobStorageList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppLogsApplicationLogsAzureBlobStorageOutputReference;
}
export interface DataAzurermWindowsWebAppLogsApplicationLogs {
}
export declare function dataAzurermWindowsWebAppLogsApplicationLogsToTerraform(struct?: DataAzurermWindowsWebAppLogsApplicationLogs): any;
export declare function dataAzurermWindowsWebAppLogsApplicationLogsToHclTerraform(struct?: DataAzurermWindowsWebAppLogsApplicationLogs): any;
export declare class DataAzurermWindowsWebAppLogsApplicationLogsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppLogsApplicationLogs | undefined;
    set internalValue(value: DataAzurermWindowsWebAppLogsApplicationLogs | undefined);
    private _azureBlobStorage;
    get azureBlobStorage(): DataAzurermWindowsWebAppLogsApplicationLogsAzureBlobStorageList;
    get fileSystemLevel(): string;
}
export declare class DataAzurermWindowsWebAppLogsApplicationLogsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppLogsApplicationLogsOutputReference;
}
export interface DataAzurermWindowsWebAppLogsHttpLogsAzureBlobStorage {
}
export declare function dataAzurermWindowsWebAppLogsHttpLogsAzureBlobStorageToTerraform(struct?: DataAzurermWindowsWebAppLogsHttpLogsAzureBlobStorage): any;
export declare function dataAzurermWindowsWebAppLogsHttpLogsAzureBlobStorageToHclTerraform(struct?: DataAzurermWindowsWebAppLogsHttpLogsAzureBlobStorage): any;
export declare class DataAzurermWindowsWebAppLogsHttpLogsAzureBlobStorageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppLogsHttpLogsAzureBlobStorage | undefined;
    set internalValue(value: DataAzurermWindowsWebAppLogsHttpLogsAzureBlobStorage | undefined);
    get retentionInDays(): number;
    get sasUrl(): string;
}
export declare class DataAzurermWindowsWebAppLogsHttpLogsAzureBlobStorageList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppLogsHttpLogsAzureBlobStorageOutputReference;
}
export interface DataAzurermWindowsWebAppLogsHttpLogsFileSystem {
}
export declare function dataAzurermWindowsWebAppLogsHttpLogsFileSystemToTerraform(struct?: DataAzurermWindowsWebAppLogsHttpLogsFileSystem): any;
export declare function dataAzurermWindowsWebAppLogsHttpLogsFileSystemToHclTerraform(struct?: DataAzurermWindowsWebAppLogsHttpLogsFileSystem): any;
export declare class DataAzurermWindowsWebAppLogsHttpLogsFileSystemOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppLogsHttpLogsFileSystem | undefined;
    set internalValue(value: DataAzurermWindowsWebAppLogsHttpLogsFileSystem | undefined);
    get retentionInDays(): number;
    get retentionInMb(): number;
}
export declare class DataAzurermWindowsWebAppLogsHttpLogsFileSystemList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppLogsHttpLogsFileSystemOutputReference;
}
export interface DataAzurermWindowsWebAppLogsHttpLogs {
}
export declare function dataAzurermWindowsWebAppLogsHttpLogsToTerraform(struct?: DataAzurermWindowsWebAppLogsHttpLogs): any;
export declare function dataAzurermWindowsWebAppLogsHttpLogsToHclTerraform(struct?: DataAzurermWindowsWebAppLogsHttpLogs): any;
export declare class DataAzurermWindowsWebAppLogsHttpLogsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppLogsHttpLogs | undefined;
    set internalValue(value: DataAzurermWindowsWebAppLogsHttpLogs | undefined);
    private _azureBlobStorage;
    get azureBlobStorage(): DataAzurermWindowsWebAppLogsHttpLogsAzureBlobStorageList;
    private _fileSystem;
    get fileSystem(): DataAzurermWindowsWebAppLogsHttpLogsFileSystemList;
}
export declare class DataAzurermWindowsWebAppLogsHttpLogsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppLogsHttpLogsOutputReference;
}
export interface DataAzurermWindowsWebAppLogs {
}
export declare function dataAzurermWindowsWebAppLogsToTerraform(struct?: DataAzurermWindowsWebAppLogs): any;
export declare function dataAzurermWindowsWebAppLogsToHclTerraform(struct?: DataAzurermWindowsWebAppLogs): any;
export declare class DataAzurermWindowsWebAppLogsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppLogs | undefined;
    set internalValue(value: DataAzurermWindowsWebAppLogs | undefined);
    private _applicationLogs;
    get applicationLogs(): DataAzurermWindowsWebAppLogsApplicationLogsList;
    get detailedErrorMessages(): cdktf.IResolvable;
    get failedRequestTracing(): cdktf.IResolvable;
    private _httpLogs;
    get httpLogs(): DataAzurermWindowsWebAppLogsHttpLogsList;
}
export declare class DataAzurermWindowsWebAppLogsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppLogsOutputReference;
}
export interface DataAzurermWindowsWebAppSiteConfigApplicationStack {
}
export declare function dataAzurermWindowsWebAppSiteConfigApplicationStackToTerraform(struct?: DataAzurermWindowsWebAppSiteConfigApplicationStack): any;
export declare function dataAzurermWindowsWebAppSiteConfigApplicationStackToHclTerraform(struct?: DataAzurermWindowsWebAppSiteConfigApplicationStack): any;
export declare class DataAzurermWindowsWebAppSiteConfigApplicationStackOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppSiteConfigApplicationStack | undefined;
    set internalValue(value: DataAzurermWindowsWebAppSiteConfigApplicationStack | undefined);
    get currentStack(): string;
    get dockerImageName(): string;
    get dockerRegistryPassword(): string;
    get dockerRegistryUrl(): string;
    get dockerRegistryUsername(): string;
    get dotnetCoreVersion(): string;
    get dotnetVersion(): string;
    get javaContainer(): string;
    get javaContainerVersion(): string;
    get javaEmbeddedServerEnabled(): cdktf.IResolvable;
    get javaVersion(): string;
    get nodeVersion(): string;
    get phpVersion(): string;
    get python(): cdktf.IResolvable;
    get pythonVersion(): string;
    get tomcatVersion(): string;
}
export declare class DataAzurermWindowsWebAppSiteConfigApplicationStackList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppSiteConfigApplicationStackOutputReference;
}
export interface DataAzurermWindowsWebAppSiteConfigAutoHealSettingActionCustomAction {
}
export declare function dataAzurermWindowsWebAppSiteConfigAutoHealSettingActionCustomActionToTerraform(struct?: DataAzurermWindowsWebAppSiteConfigAutoHealSettingActionCustomAction): any;
export declare function dataAzurermWindowsWebAppSiteConfigAutoHealSettingActionCustomActionToHclTerraform(struct?: DataAzurermWindowsWebAppSiteConfigAutoHealSettingActionCustomAction): any;
export declare class DataAzurermWindowsWebAppSiteConfigAutoHealSettingActionCustomActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppSiteConfigAutoHealSettingActionCustomAction | undefined;
    set internalValue(value: DataAzurermWindowsWebAppSiteConfigAutoHealSettingActionCustomAction | undefined);
    get executable(): string;
    get parameters(): string;
}
export declare class DataAzurermWindowsWebAppSiteConfigAutoHealSettingActionCustomActionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppSiteConfigAutoHealSettingActionCustomActionOutputReference;
}
export interface DataAzurermWindowsWebAppSiteConfigAutoHealSettingAction {
}
export declare function dataAzurermWindowsWebAppSiteConfigAutoHealSettingActionToTerraform(struct?: DataAzurermWindowsWebAppSiteConfigAutoHealSettingAction): any;
export declare function dataAzurermWindowsWebAppSiteConfigAutoHealSettingActionToHclTerraform(struct?: DataAzurermWindowsWebAppSiteConfigAutoHealSettingAction): any;
export declare class DataAzurermWindowsWebAppSiteConfigAutoHealSettingActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppSiteConfigAutoHealSettingAction | undefined;
    set internalValue(value: DataAzurermWindowsWebAppSiteConfigAutoHealSettingAction | undefined);
    get actionType(): string;
    private _customAction;
    get customAction(): DataAzurermWindowsWebAppSiteConfigAutoHealSettingActionCustomActionList;
    get minimumProcessExecutionTime(): string;
}
export declare class DataAzurermWindowsWebAppSiteConfigAutoHealSettingActionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppSiteConfigAutoHealSettingActionOutputReference;
}
export interface DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerRequests {
}
export declare function dataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerRequestsToTerraform(struct?: DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerRequests): any;
export declare function dataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerRequestsToHclTerraform(struct?: DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerRequests): any;
export declare class DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerRequestsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerRequests | undefined;
    set internalValue(value: DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerRequests | undefined);
    get count(): number;
    get interval(): string;
}
export declare class DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerRequestsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerRequestsOutputReference;
}
export interface DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequest {
}
export declare function dataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequestToTerraform(struct?: DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequest): any;
export declare function dataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequestToHclTerraform(struct?: DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequest): any;
export declare class DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequestOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequest | undefined;
    set internalValue(value: DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequest | undefined);
    get count(): number;
    get interval(): string;
    get timeTaken(): string;
}
export declare class DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequestList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequestOutputReference;
}
export interface DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequestWithPath {
}
export declare function dataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequestWithPathToTerraform(struct?: DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequestWithPath): any;
export declare function dataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequestWithPathToHclTerraform(struct?: DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequestWithPath): any;
export declare class DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequestWithPathOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequestWithPath | undefined;
    set internalValue(value: DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequestWithPath | undefined);
    get count(): number;
    get interval(): string;
    get path(): string;
    get timeTaken(): string;
}
export declare class DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequestWithPathList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequestWithPathOutputReference;
}
export interface DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerStatusCode {
}
export declare function dataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerStatusCodeToTerraform(struct?: DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerStatusCode): any;
export declare function dataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerStatusCodeToHclTerraform(struct?: DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerStatusCode): any;
export declare class DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerStatusCodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerStatusCode | undefined;
    set internalValue(value: DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerStatusCode | undefined);
    get count(): number;
    get interval(): string;
    get path(): string;
    get statusCodeRange(): string;
    get subStatus(): number;
    get win32StatusCode(): number;
}
export declare class DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerStatusCodeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerStatusCodeOutputReference;
}
export interface DataAzurermWindowsWebAppSiteConfigAutoHealSettingTrigger {
}
export declare function dataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerToTerraform(struct?: DataAzurermWindowsWebAppSiteConfigAutoHealSettingTrigger): any;
export declare function dataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerToHclTerraform(struct?: DataAzurermWindowsWebAppSiteConfigAutoHealSettingTrigger): any;
export declare class DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppSiteConfigAutoHealSettingTrigger | undefined;
    set internalValue(value: DataAzurermWindowsWebAppSiteConfigAutoHealSettingTrigger | undefined);
    get privateMemoryKb(): number;
    private _requests;
    get requests(): DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerRequestsList;
    private _slowRequest;
    get slowRequest(): DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequestList;
    private _slowRequestWithPath;
    get slowRequestWithPath(): DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequestWithPathList;
    private _statusCode;
    get statusCode(): DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerStatusCodeList;
}
export declare class DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerOutputReference;
}
export interface DataAzurermWindowsWebAppSiteConfigAutoHealSetting {
}
export declare function dataAzurermWindowsWebAppSiteConfigAutoHealSettingToTerraform(struct?: DataAzurermWindowsWebAppSiteConfigAutoHealSetting): any;
export declare function dataAzurermWindowsWebAppSiteConfigAutoHealSettingToHclTerraform(struct?: DataAzurermWindowsWebAppSiteConfigAutoHealSetting): any;
export declare class DataAzurermWindowsWebAppSiteConfigAutoHealSettingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppSiteConfigAutoHealSetting | undefined;
    set internalValue(value: DataAzurermWindowsWebAppSiteConfigAutoHealSetting | undefined);
    private _action;
    get action(): DataAzurermWindowsWebAppSiteConfigAutoHealSettingActionList;
    private _trigger;
    get trigger(): DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerList;
}
export declare class DataAzurermWindowsWebAppSiteConfigAutoHealSettingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppSiteConfigAutoHealSettingOutputReference;
}
export interface DataAzurermWindowsWebAppSiteConfigCors {
}
export declare function dataAzurermWindowsWebAppSiteConfigCorsToTerraform(struct?: DataAzurermWindowsWebAppSiteConfigCors): any;
export declare function dataAzurermWindowsWebAppSiteConfigCorsToHclTerraform(struct?: DataAzurermWindowsWebAppSiteConfigCors): any;
export declare class DataAzurermWindowsWebAppSiteConfigCorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppSiteConfigCors | undefined;
    set internalValue(value: DataAzurermWindowsWebAppSiteConfigCors | undefined);
    get allowedOrigins(): string[];
    get supportCredentials(): cdktf.IResolvable;
}
export declare class DataAzurermWindowsWebAppSiteConfigCorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppSiteConfigCorsOutputReference;
}
export interface DataAzurermWindowsWebAppSiteConfigHandlerMapping {
}
export declare function dataAzurermWindowsWebAppSiteConfigHandlerMappingToTerraform(struct?: DataAzurermWindowsWebAppSiteConfigHandlerMapping): any;
export declare function dataAzurermWindowsWebAppSiteConfigHandlerMappingToHclTerraform(struct?: DataAzurermWindowsWebAppSiteConfigHandlerMapping): any;
export declare class DataAzurermWindowsWebAppSiteConfigHandlerMappingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppSiteConfigHandlerMapping | undefined;
    set internalValue(value: DataAzurermWindowsWebAppSiteConfigHandlerMapping | undefined);
    get arguments(): string;
    get extension(): string;
    get scriptProcessorPath(): string;
}
export declare class DataAzurermWindowsWebAppSiteConfigHandlerMappingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppSiteConfigHandlerMappingOutputReference;
}
export interface DataAzurermWindowsWebAppSiteConfigIpRestrictionHeaders {
}
export declare function dataAzurermWindowsWebAppSiteConfigIpRestrictionHeadersToTerraform(struct?: DataAzurermWindowsWebAppSiteConfigIpRestrictionHeaders): any;
export declare function dataAzurermWindowsWebAppSiteConfigIpRestrictionHeadersToHclTerraform(struct?: DataAzurermWindowsWebAppSiteConfigIpRestrictionHeaders): any;
export declare class DataAzurermWindowsWebAppSiteConfigIpRestrictionHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppSiteConfigIpRestrictionHeaders | undefined;
    set internalValue(value: DataAzurermWindowsWebAppSiteConfigIpRestrictionHeaders | undefined);
    get xAzureFdid(): string[];
    get xFdHealthProbe(): string[];
    get xForwardedFor(): string[];
    get xForwardedHost(): string[];
}
export declare class DataAzurermWindowsWebAppSiteConfigIpRestrictionHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppSiteConfigIpRestrictionHeadersOutputReference;
}
export interface DataAzurermWindowsWebAppSiteConfigIpRestriction {
}
export declare function dataAzurermWindowsWebAppSiteConfigIpRestrictionToTerraform(struct?: DataAzurermWindowsWebAppSiteConfigIpRestriction): any;
export declare function dataAzurermWindowsWebAppSiteConfigIpRestrictionToHclTerraform(struct?: DataAzurermWindowsWebAppSiteConfigIpRestriction): any;
export declare class DataAzurermWindowsWebAppSiteConfigIpRestrictionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppSiteConfigIpRestriction | undefined;
    set internalValue(value: DataAzurermWindowsWebAppSiteConfigIpRestriction | undefined);
    get action(): string;
    get description(): string;
    private _headers;
    get headers(): DataAzurermWindowsWebAppSiteConfigIpRestrictionHeadersList;
    get ipAddress(): string;
    get name(): string;
    get priority(): number;
    get serviceTag(): string;
    get virtualNetworkSubnetId(): string;
}
export declare class DataAzurermWindowsWebAppSiteConfigIpRestrictionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppSiteConfigIpRestrictionOutputReference;
}
export interface DataAzurermWindowsWebAppSiteConfigScmIpRestrictionHeaders {
}
export declare function dataAzurermWindowsWebAppSiteConfigScmIpRestrictionHeadersToTerraform(struct?: DataAzurermWindowsWebAppSiteConfigScmIpRestrictionHeaders): any;
export declare function dataAzurermWindowsWebAppSiteConfigScmIpRestrictionHeadersToHclTerraform(struct?: DataAzurermWindowsWebAppSiteConfigScmIpRestrictionHeaders): any;
export declare class DataAzurermWindowsWebAppSiteConfigScmIpRestrictionHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppSiteConfigScmIpRestrictionHeaders | undefined;
    set internalValue(value: DataAzurermWindowsWebAppSiteConfigScmIpRestrictionHeaders | undefined);
    get xAzureFdid(): string[];
    get xFdHealthProbe(): string[];
    get xForwardedFor(): string[];
    get xForwardedHost(): string[];
}
export declare class DataAzurermWindowsWebAppSiteConfigScmIpRestrictionHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppSiteConfigScmIpRestrictionHeadersOutputReference;
}
export interface DataAzurermWindowsWebAppSiteConfigScmIpRestriction {
}
export declare function dataAzurermWindowsWebAppSiteConfigScmIpRestrictionToTerraform(struct?: DataAzurermWindowsWebAppSiteConfigScmIpRestriction): any;
export declare function dataAzurermWindowsWebAppSiteConfigScmIpRestrictionToHclTerraform(struct?: DataAzurermWindowsWebAppSiteConfigScmIpRestriction): any;
export declare class DataAzurermWindowsWebAppSiteConfigScmIpRestrictionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppSiteConfigScmIpRestriction | undefined;
    set internalValue(value: DataAzurermWindowsWebAppSiteConfigScmIpRestriction | undefined);
    get action(): string;
    get description(): string;
    private _headers;
    get headers(): DataAzurermWindowsWebAppSiteConfigScmIpRestrictionHeadersList;
    get ipAddress(): string;
    get name(): string;
    get priority(): number;
    get serviceTag(): string;
    get virtualNetworkSubnetId(): string;
}
export declare class DataAzurermWindowsWebAppSiteConfigScmIpRestrictionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppSiteConfigScmIpRestrictionOutputReference;
}
export interface DataAzurermWindowsWebAppSiteConfigVirtualApplicationVirtualDirectory {
}
export declare function dataAzurermWindowsWebAppSiteConfigVirtualApplicationVirtualDirectoryToTerraform(struct?: DataAzurermWindowsWebAppSiteConfigVirtualApplicationVirtualDirectory): any;
export declare function dataAzurermWindowsWebAppSiteConfigVirtualApplicationVirtualDirectoryToHclTerraform(struct?: DataAzurermWindowsWebAppSiteConfigVirtualApplicationVirtualDirectory): any;
export declare class DataAzurermWindowsWebAppSiteConfigVirtualApplicationVirtualDirectoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppSiteConfigVirtualApplicationVirtualDirectory | undefined;
    set internalValue(value: DataAzurermWindowsWebAppSiteConfigVirtualApplicationVirtualDirectory | undefined);
    get physicalPath(): string;
    get virtualPath(): string;
}
export declare class DataAzurermWindowsWebAppSiteConfigVirtualApplicationVirtualDirectoryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppSiteConfigVirtualApplicationVirtualDirectoryOutputReference;
}
export interface DataAzurermWindowsWebAppSiteConfigVirtualApplication {
}
export declare function dataAzurermWindowsWebAppSiteConfigVirtualApplicationToTerraform(struct?: DataAzurermWindowsWebAppSiteConfigVirtualApplication): any;
export declare function dataAzurermWindowsWebAppSiteConfigVirtualApplicationToHclTerraform(struct?: DataAzurermWindowsWebAppSiteConfigVirtualApplication): any;
export declare class DataAzurermWindowsWebAppSiteConfigVirtualApplicationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppSiteConfigVirtualApplication | undefined;
    set internalValue(value: DataAzurermWindowsWebAppSiteConfigVirtualApplication | undefined);
    get physicalPath(): string;
    get preload(): cdktf.IResolvable;
    private _virtualDirectory;
    get virtualDirectory(): DataAzurermWindowsWebAppSiteConfigVirtualApplicationVirtualDirectoryList;
    get virtualPath(): string;
}
export declare class DataAzurermWindowsWebAppSiteConfigVirtualApplicationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppSiteConfigVirtualApplicationOutputReference;
}
export interface DataAzurermWindowsWebAppSiteConfig {
}
export declare function dataAzurermWindowsWebAppSiteConfigToTerraform(struct?: DataAzurermWindowsWebAppSiteConfig): any;
export declare function dataAzurermWindowsWebAppSiteConfigToHclTerraform(struct?: DataAzurermWindowsWebAppSiteConfig): any;
export declare class DataAzurermWindowsWebAppSiteConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppSiteConfig | undefined;
    set internalValue(value: DataAzurermWindowsWebAppSiteConfig | undefined);
    get alwaysOn(): cdktf.IResolvable;
    get apiDefinitionUrl(): string;
    get apiManagementApiId(): string;
    get appCommandLine(): string;
    private _applicationStack;
    get applicationStack(): DataAzurermWindowsWebAppSiteConfigApplicationStackList;
    private _autoHealSetting;
    get autoHealSetting(): DataAzurermWindowsWebAppSiteConfigAutoHealSettingList;
    get containerRegistryManagedIdentityClientId(): string;
    get containerRegistryUseManagedIdentity(): cdktf.IResolvable;
    private _cors;
    get cors(): DataAzurermWindowsWebAppSiteConfigCorsList;
    get defaultDocuments(): string[];
    get detailedErrorLoggingEnabled(): cdktf.IResolvable;
    get ftpsState(): string;
    private _handlerMapping;
    get handlerMapping(): DataAzurermWindowsWebAppSiteConfigHandlerMappingList;
    get healthCheckEvictionTimeInMin(): number;
    get healthCheckPath(): string;
    get http2Enabled(): cdktf.IResolvable;
    private _ipRestriction;
    get ipRestriction(): DataAzurermWindowsWebAppSiteConfigIpRestrictionList;
    get ipRestrictionDefaultAction(): string;
    get loadBalancingMode(): string;
    get localMysqlEnabled(): cdktf.IResolvable;
    get managedPipelineMode(): string;
    get minimumTlsVersion(): string;
    get remoteDebuggingEnabled(): cdktf.IResolvable;
    get remoteDebuggingVersion(): string;
    private _scmIpRestriction;
    get scmIpRestriction(): DataAzurermWindowsWebAppSiteConfigScmIpRestrictionList;
    get scmIpRestrictionDefaultAction(): string;
    get scmMinimumTlsVersion(): string;
    get scmType(): string;
    get scmUseMainIpRestriction(): cdktf.IResolvable;
    get use32BitWorker(): cdktf.IResolvable;
    private _virtualApplication;
    get virtualApplication(): DataAzurermWindowsWebAppSiteConfigVirtualApplicationList;
    get vnetRouteAllEnabled(): cdktf.IResolvable;
    get websocketsEnabled(): cdktf.IResolvable;
    get windowsFxVersion(): string;
    get workerCount(): number;
}
export declare class DataAzurermWindowsWebAppSiteConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppSiteConfigOutputReference;
}
export interface DataAzurermWindowsWebAppSiteCredential {
}
export declare function dataAzurermWindowsWebAppSiteCredentialToTerraform(struct?: DataAzurermWindowsWebAppSiteCredential): any;
export declare function dataAzurermWindowsWebAppSiteCredentialToHclTerraform(struct?: DataAzurermWindowsWebAppSiteCredential): any;
export declare class DataAzurermWindowsWebAppSiteCredentialOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppSiteCredential | undefined;
    set internalValue(value: DataAzurermWindowsWebAppSiteCredential | undefined);
    get name(): string;
    get password(): string;
}
export declare class DataAzurermWindowsWebAppSiteCredentialList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppSiteCredentialOutputReference;
}
export interface DataAzurermWindowsWebAppStickySettings {
}
export declare function dataAzurermWindowsWebAppStickySettingsToTerraform(struct?: DataAzurermWindowsWebAppStickySettings): any;
export declare function dataAzurermWindowsWebAppStickySettingsToHclTerraform(struct?: DataAzurermWindowsWebAppStickySettings): any;
export declare class DataAzurermWindowsWebAppStickySettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppStickySettings | undefined;
    set internalValue(value: DataAzurermWindowsWebAppStickySettings | undefined);
    get appSettingNames(): string[];
    get connectionStringNames(): string[];
}
export declare class DataAzurermWindowsWebAppStickySettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppStickySettingsOutputReference;
}
export interface DataAzurermWindowsWebAppStorageAccount {
}
export declare function dataAzurermWindowsWebAppStorageAccountToTerraform(struct?: DataAzurermWindowsWebAppStorageAccount): any;
export declare function dataAzurermWindowsWebAppStorageAccountToHclTerraform(struct?: DataAzurermWindowsWebAppStorageAccount): any;
export declare class DataAzurermWindowsWebAppStorageAccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppStorageAccount | undefined;
    set internalValue(value: DataAzurermWindowsWebAppStorageAccount | undefined);
    get accessKey(): string;
    get accountName(): string;
    get mountPath(): string;
    get name(): string;
    get shareName(): string;
    get type(): string;
}
export declare class DataAzurermWindowsWebAppStorageAccountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppStorageAccountOutputReference;
}
export interface DataAzurermWindowsWebAppTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/windows_web_app#read DataAzurermWindowsWebApp#read}
    */
    readonly read?: string;
}
export declare function dataAzurermWindowsWebAppTimeoutsToTerraform(struct?: DataAzurermWindowsWebAppTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermWindowsWebAppTimeoutsToHclTerraform(struct?: DataAzurermWindowsWebAppTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermWindowsWebAppTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermWindowsWebAppTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermWindowsWebAppTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/windows_web_app azurerm_windows_web_app}
*/
export declare class DataAzurermWindowsWebApp extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_windows_web_app";
    /**
    * Generates CDKTF code for importing a DataAzurermWindowsWebApp resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermWindowsWebApp to import
    * @param importFromId The id of the existing DataAzurermWindowsWebApp that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/windows_web_app#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermWindowsWebApp to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/data-sources/windows_web_app azurerm_windows_web_app} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermWindowsWebAppConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermWindowsWebAppConfig);
    private _appSettings;
    get appSettings(): cdktf.StringMap;
    private _authSettings;
    get authSettings(): DataAzurermWindowsWebAppAuthSettingsList;
    private _authSettingsV2;
    get authSettingsV2(): DataAzurermWindowsWebAppAuthSettingsV2List;
    private _backup;
    get backup(): DataAzurermWindowsWebAppBackupList;
    get clientAffinityEnabled(): cdktf.IResolvable;
    get clientCertificateEnabled(): cdktf.IResolvable;
    get clientCertificateExclusionPaths(): string;
    get clientCertificateMode(): string;
    private _connectionString;
    get connectionString(): DataAzurermWindowsWebAppConnectionStringList;
    get customDomainVerificationId(): string;
    get defaultHostname(): string;
    get enabled(): cdktf.IResolvable;
    get ftpPublishBasicAuthenticationEnabled(): cdktf.IResolvable;
    get hostingEnvironmentId(): string;
    get httpsOnly(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identity;
    get identity(): DataAzurermWindowsWebAppIdentityList;
    get kind(): string;
    get location(): string;
    private _logs;
    get logs(): DataAzurermWindowsWebAppLogsList;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outboundIpAddressList(): string[];
    get outboundIpAddresses(): string;
    get possibleOutboundIpAddressList(): string[];
    get possibleOutboundIpAddresses(): string;
    get publicNetworkAccessEnabled(): cdktf.IResolvable;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get servicePlanId(): string;
    private _siteConfig;
    get siteConfig(): DataAzurermWindowsWebAppSiteConfigList;
    private _siteCredential;
    get siteCredential(): DataAzurermWindowsWebAppSiteCredentialList;
    private _stickySettings;
    get stickySettings(): DataAzurermWindowsWebAppStickySettingsList;
    private _storageAccount;
    get storageAccount(): DataAzurermWindowsWebAppStorageAccountList;
    private _tags;
    get tags(): cdktf.StringMap;
    get virtualNetworkBackupRestoreEnabled(): cdktf.IResolvable;
    get virtualNetworkSubnetId(): string;
    get webdeployPublishBasicAuthenticationEnabled(): cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermWindowsWebAppTimeoutsOutputReference;
    putTimeouts(value: DataAzurermWindowsWebAppTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermWindowsWebAppTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
