/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataFactoryFlowletDataFlowConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#annotations DataFactoryFlowletDataFlow#annotations}
    */
    readonly annotations?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#data_factory_id DataFactoryFlowletDataFlow#data_factory_id}
    */
    readonly dataFactoryId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#description DataFactoryFlowletDataFlow#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#folder DataFactoryFlowletDataFlow#folder}
    */
    readonly folder?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#id DataFactoryFlowletDataFlow#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#name DataFactoryFlowletDataFlow#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#script DataFactoryFlowletDataFlow#script}
    */
    readonly script?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#script_lines DataFactoryFlowletDataFlow#script_lines}
    */
    readonly scriptLines?: string[];
    /**
    * sink block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#sink DataFactoryFlowletDataFlow#sink}
    */
    readonly sink?: DataFactoryFlowletDataFlowSink[] | cdktf.IResolvable;
    /**
    * source block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#source DataFactoryFlowletDataFlow#source}
    */
    readonly source?: DataFactoryFlowletDataFlowSource[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#timeouts DataFactoryFlowletDataFlow#timeouts}
    */
    readonly timeouts?: DataFactoryFlowletDataFlowTimeouts;
    /**
    * transformation block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#transformation DataFactoryFlowletDataFlow#transformation}
    */
    readonly transformation?: DataFactoryFlowletDataFlowTransformation[] | cdktf.IResolvable;
}
export interface DataFactoryFlowletDataFlowSinkDataset {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#name DataFactoryFlowletDataFlow#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#parameters DataFactoryFlowletDataFlow#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
}
export declare function dataFactoryFlowletDataFlowSinkDatasetToTerraform(struct?: DataFactoryFlowletDataFlowSinkDatasetOutputReference | DataFactoryFlowletDataFlowSinkDataset): any;
export declare function dataFactoryFlowletDataFlowSinkDatasetToHclTerraform(struct?: DataFactoryFlowletDataFlowSinkDatasetOutputReference | DataFactoryFlowletDataFlowSinkDataset): any;
export declare class DataFactoryFlowletDataFlowSinkDatasetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryFlowletDataFlowSinkDataset | undefined;
    set internalValue(value: DataFactoryFlowletDataFlowSinkDataset | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
}
export interface DataFactoryFlowletDataFlowSinkFlowlet {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#dataset_parameters DataFactoryFlowletDataFlow#dataset_parameters}
    */
    readonly datasetParameters?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#name DataFactoryFlowletDataFlow#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#parameters DataFactoryFlowletDataFlow#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
}
export declare function dataFactoryFlowletDataFlowSinkFlowletToTerraform(struct?: DataFactoryFlowletDataFlowSinkFlowletOutputReference | DataFactoryFlowletDataFlowSinkFlowlet): any;
export declare function dataFactoryFlowletDataFlowSinkFlowletToHclTerraform(struct?: DataFactoryFlowletDataFlowSinkFlowletOutputReference | DataFactoryFlowletDataFlowSinkFlowlet): any;
export declare class DataFactoryFlowletDataFlowSinkFlowletOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryFlowletDataFlowSinkFlowlet | undefined;
    set internalValue(value: DataFactoryFlowletDataFlowSinkFlowlet | undefined);
    private _datasetParameters?;
    get datasetParameters(): string;
    set datasetParameters(value: string);
    resetDatasetParameters(): void;
    get datasetParametersInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
}
export interface DataFactoryFlowletDataFlowSinkLinkedService {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#name DataFactoryFlowletDataFlow#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#parameters DataFactoryFlowletDataFlow#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
}
export declare function dataFactoryFlowletDataFlowSinkLinkedServiceToTerraform(struct?: DataFactoryFlowletDataFlowSinkLinkedServiceOutputReference | DataFactoryFlowletDataFlowSinkLinkedService): any;
export declare function dataFactoryFlowletDataFlowSinkLinkedServiceToHclTerraform(struct?: DataFactoryFlowletDataFlowSinkLinkedServiceOutputReference | DataFactoryFlowletDataFlowSinkLinkedService): any;
export declare class DataFactoryFlowletDataFlowSinkLinkedServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryFlowletDataFlowSinkLinkedService | undefined;
    set internalValue(value: DataFactoryFlowletDataFlowSinkLinkedService | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
}
export interface DataFactoryFlowletDataFlowSinkRejectedLinkedService {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#name DataFactoryFlowletDataFlow#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#parameters DataFactoryFlowletDataFlow#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
}
export declare function dataFactoryFlowletDataFlowSinkRejectedLinkedServiceToTerraform(struct?: DataFactoryFlowletDataFlowSinkRejectedLinkedServiceOutputReference | DataFactoryFlowletDataFlowSinkRejectedLinkedService): any;
export declare function dataFactoryFlowletDataFlowSinkRejectedLinkedServiceToHclTerraform(struct?: DataFactoryFlowletDataFlowSinkRejectedLinkedServiceOutputReference | DataFactoryFlowletDataFlowSinkRejectedLinkedService): any;
export declare class DataFactoryFlowletDataFlowSinkRejectedLinkedServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryFlowletDataFlowSinkRejectedLinkedService | undefined;
    set internalValue(value: DataFactoryFlowletDataFlowSinkRejectedLinkedService | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
}
export interface DataFactoryFlowletDataFlowSinkSchemaLinkedService {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#name DataFactoryFlowletDataFlow#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#parameters DataFactoryFlowletDataFlow#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
}
export declare function dataFactoryFlowletDataFlowSinkSchemaLinkedServiceToTerraform(struct?: DataFactoryFlowletDataFlowSinkSchemaLinkedServiceOutputReference | DataFactoryFlowletDataFlowSinkSchemaLinkedService): any;
export declare function dataFactoryFlowletDataFlowSinkSchemaLinkedServiceToHclTerraform(struct?: DataFactoryFlowletDataFlowSinkSchemaLinkedServiceOutputReference | DataFactoryFlowletDataFlowSinkSchemaLinkedService): any;
export declare class DataFactoryFlowletDataFlowSinkSchemaLinkedServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryFlowletDataFlowSinkSchemaLinkedService | undefined;
    set internalValue(value: DataFactoryFlowletDataFlowSinkSchemaLinkedService | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
}
export interface DataFactoryFlowletDataFlowSink {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#description DataFactoryFlowletDataFlow#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#name DataFactoryFlowletDataFlow#name}
    */
    readonly name: string;
    /**
    * dataset block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#dataset DataFactoryFlowletDataFlow#dataset}
    */
    readonly dataset?: DataFactoryFlowletDataFlowSinkDataset;
    /**
    * flowlet block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#flowlet DataFactoryFlowletDataFlow#flowlet}
    */
    readonly flowlet?: DataFactoryFlowletDataFlowSinkFlowlet;
    /**
    * linked_service block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#linked_service DataFactoryFlowletDataFlow#linked_service}
    */
    readonly linkedService?: DataFactoryFlowletDataFlowSinkLinkedService;
    /**
    * rejected_linked_service block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#rejected_linked_service DataFactoryFlowletDataFlow#rejected_linked_service}
    */
    readonly rejectedLinkedService?: DataFactoryFlowletDataFlowSinkRejectedLinkedService;
    /**
    * schema_linked_service block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#schema_linked_service DataFactoryFlowletDataFlow#schema_linked_service}
    */
    readonly schemaLinkedService?: DataFactoryFlowletDataFlowSinkSchemaLinkedService;
}
export declare function dataFactoryFlowletDataFlowSinkToTerraform(struct?: DataFactoryFlowletDataFlowSink | cdktf.IResolvable): any;
export declare function dataFactoryFlowletDataFlowSinkToHclTerraform(struct?: DataFactoryFlowletDataFlowSink | cdktf.IResolvable): any;
export declare class DataFactoryFlowletDataFlowSinkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataFactoryFlowletDataFlowSink | cdktf.IResolvable | undefined;
    set internalValue(value: DataFactoryFlowletDataFlowSink | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _dataset;
    get dataset(): DataFactoryFlowletDataFlowSinkDatasetOutputReference;
    putDataset(value: DataFactoryFlowletDataFlowSinkDataset): void;
    resetDataset(): void;
    get datasetInput(): DataFactoryFlowletDataFlowSinkDataset | undefined;
    private _flowlet;
    get flowlet(): DataFactoryFlowletDataFlowSinkFlowletOutputReference;
    putFlowlet(value: DataFactoryFlowletDataFlowSinkFlowlet): void;
    resetFlowlet(): void;
    get flowletInput(): DataFactoryFlowletDataFlowSinkFlowlet | undefined;
    private _linkedService;
    get linkedService(): DataFactoryFlowletDataFlowSinkLinkedServiceOutputReference;
    putLinkedService(value: DataFactoryFlowletDataFlowSinkLinkedService): void;
    resetLinkedService(): void;
    get linkedServiceInput(): DataFactoryFlowletDataFlowSinkLinkedService | undefined;
    private _rejectedLinkedService;
    get rejectedLinkedService(): DataFactoryFlowletDataFlowSinkRejectedLinkedServiceOutputReference;
    putRejectedLinkedService(value: DataFactoryFlowletDataFlowSinkRejectedLinkedService): void;
    resetRejectedLinkedService(): void;
    get rejectedLinkedServiceInput(): DataFactoryFlowletDataFlowSinkRejectedLinkedService | undefined;
    private _schemaLinkedService;
    get schemaLinkedService(): DataFactoryFlowletDataFlowSinkSchemaLinkedServiceOutputReference;
    putSchemaLinkedService(value: DataFactoryFlowletDataFlowSinkSchemaLinkedService): void;
    resetSchemaLinkedService(): void;
    get schemaLinkedServiceInput(): DataFactoryFlowletDataFlowSinkSchemaLinkedService | undefined;
}
export declare class DataFactoryFlowletDataFlowSinkList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataFactoryFlowletDataFlowSink[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataFactoryFlowletDataFlowSinkOutputReference;
}
export interface DataFactoryFlowletDataFlowSourceDataset {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#name DataFactoryFlowletDataFlow#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#parameters DataFactoryFlowletDataFlow#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
}
export declare function dataFactoryFlowletDataFlowSourceDatasetToTerraform(struct?: DataFactoryFlowletDataFlowSourceDatasetOutputReference | DataFactoryFlowletDataFlowSourceDataset): any;
export declare function dataFactoryFlowletDataFlowSourceDatasetToHclTerraform(struct?: DataFactoryFlowletDataFlowSourceDatasetOutputReference | DataFactoryFlowletDataFlowSourceDataset): any;
export declare class DataFactoryFlowletDataFlowSourceDatasetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryFlowletDataFlowSourceDataset | undefined;
    set internalValue(value: DataFactoryFlowletDataFlowSourceDataset | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
}
export interface DataFactoryFlowletDataFlowSourceFlowlet {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#dataset_parameters DataFactoryFlowletDataFlow#dataset_parameters}
    */
    readonly datasetParameters?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#name DataFactoryFlowletDataFlow#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#parameters DataFactoryFlowletDataFlow#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
}
export declare function dataFactoryFlowletDataFlowSourceFlowletToTerraform(struct?: DataFactoryFlowletDataFlowSourceFlowletOutputReference | DataFactoryFlowletDataFlowSourceFlowlet): any;
export declare function dataFactoryFlowletDataFlowSourceFlowletToHclTerraform(struct?: DataFactoryFlowletDataFlowSourceFlowletOutputReference | DataFactoryFlowletDataFlowSourceFlowlet): any;
export declare class DataFactoryFlowletDataFlowSourceFlowletOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryFlowletDataFlowSourceFlowlet | undefined;
    set internalValue(value: DataFactoryFlowletDataFlowSourceFlowlet | undefined);
    private _datasetParameters?;
    get datasetParameters(): string;
    set datasetParameters(value: string);
    resetDatasetParameters(): void;
    get datasetParametersInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
}
export interface DataFactoryFlowletDataFlowSourceLinkedService {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#name DataFactoryFlowletDataFlow#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#parameters DataFactoryFlowletDataFlow#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
}
export declare function dataFactoryFlowletDataFlowSourceLinkedServiceToTerraform(struct?: DataFactoryFlowletDataFlowSourceLinkedServiceOutputReference | DataFactoryFlowletDataFlowSourceLinkedService): any;
export declare function dataFactoryFlowletDataFlowSourceLinkedServiceToHclTerraform(struct?: DataFactoryFlowletDataFlowSourceLinkedServiceOutputReference | DataFactoryFlowletDataFlowSourceLinkedService): any;
export declare class DataFactoryFlowletDataFlowSourceLinkedServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryFlowletDataFlowSourceLinkedService | undefined;
    set internalValue(value: DataFactoryFlowletDataFlowSourceLinkedService | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
}
export interface DataFactoryFlowletDataFlowSourceRejectedLinkedService {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#name DataFactoryFlowletDataFlow#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#parameters DataFactoryFlowletDataFlow#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
}
export declare function dataFactoryFlowletDataFlowSourceRejectedLinkedServiceToTerraform(struct?: DataFactoryFlowletDataFlowSourceRejectedLinkedServiceOutputReference | DataFactoryFlowletDataFlowSourceRejectedLinkedService): any;
export declare function dataFactoryFlowletDataFlowSourceRejectedLinkedServiceToHclTerraform(struct?: DataFactoryFlowletDataFlowSourceRejectedLinkedServiceOutputReference | DataFactoryFlowletDataFlowSourceRejectedLinkedService): any;
export declare class DataFactoryFlowletDataFlowSourceRejectedLinkedServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryFlowletDataFlowSourceRejectedLinkedService | undefined;
    set internalValue(value: DataFactoryFlowletDataFlowSourceRejectedLinkedService | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
}
export interface DataFactoryFlowletDataFlowSourceSchemaLinkedService {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#name DataFactoryFlowletDataFlow#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#parameters DataFactoryFlowletDataFlow#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
}
export declare function dataFactoryFlowletDataFlowSourceSchemaLinkedServiceToTerraform(struct?: DataFactoryFlowletDataFlowSourceSchemaLinkedServiceOutputReference | DataFactoryFlowletDataFlowSourceSchemaLinkedService): any;
export declare function dataFactoryFlowletDataFlowSourceSchemaLinkedServiceToHclTerraform(struct?: DataFactoryFlowletDataFlowSourceSchemaLinkedServiceOutputReference | DataFactoryFlowletDataFlowSourceSchemaLinkedService): any;
export declare class DataFactoryFlowletDataFlowSourceSchemaLinkedServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryFlowletDataFlowSourceSchemaLinkedService | undefined;
    set internalValue(value: DataFactoryFlowletDataFlowSourceSchemaLinkedService | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
}
export interface DataFactoryFlowletDataFlowSource {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#description DataFactoryFlowletDataFlow#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#name DataFactoryFlowletDataFlow#name}
    */
    readonly name: string;
    /**
    * dataset block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#dataset DataFactoryFlowletDataFlow#dataset}
    */
    readonly dataset?: DataFactoryFlowletDataFlowSourceDataset;
    /**
    * flowlet block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#flowlet DataFactoryFlowletDataFlow#flowlet}
    */
    readonly flowlet?: DataFactoryFlowletDataFlowSourceFlowlet;
    /**
    * linked_service block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#linked_service DataFactoryFlowletDataFlow#linked_service}
    */
    readonly linkedService?: DataFactoryFlowletDataFlowSourceLinkedService;
    /**
    * rejected_linked_service block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#rejected_linked_service DataFactoryFlowletDataFlow#rejected_linked_service}
    */
    readonly rejectedLinkedService?: DataFactoryFlowletDataFlowSourceRejectedLinkedService;
    /**
    * schema_linked_service block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#schema_linked_service DataFactoryFlowletDataFlow#schema_linked_service}
    */
    readonly schemaLinkedService?: DataFactoryFlowletDataFlowSourceSchemaLinkedService;
}
export declare function dataFactoryFlowletDataFlowSourceToTerraform(struct?: DataFactoryFlowletDataFlowSource | cdktf.IResolvable): any;
export declare function dataFactoryFlowletDataFlowSourceToHclTerraform(struct?: DataFactoryFlowletDataFlowSource | cdktf.IResolvable): any;
export declare class DataFactoryFlowletDataFlowSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataFactoryFlowletDataFlowSource | cdktf.IResolvable | undefined;
    set internalValue(value: DataFactoryFlowletDataFlowSource | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _dataset;
    get dataset(): DataFactoryFlowletDataFlowSourceDatasetOutputReference;
    putDataset(value: DataFactoryFlowletDataFlowSourceDataset): void;
    resetDataset(): void;
    get datasetInput(): DataFactoryFlowletDataFlowSourceDataset | undefined;
    private _flowlet;
    get flowlet(): DataFactoryFlowletDataFlowSourceFlowletOutputReference;
    putFlowlet(value: DataFactoryFlowletDataFlowSourceFlowlet): void;
    resetFlowlet(): void;
    get flowletInput(): DataFactoryFlowletDataFlowSourceFlowlet | undefined;
    private _linkedService;
    get linkedService(): DataFactoryFlowletDataFlowSourceLinkedServiceOutputReference;
    putLinkedService(value: DataFactoryFlowletDataFlowSourceLinkedService): void;
    resetLinkedService(): void;
    get linkedServiceInput(): DataFactoryFlowletDataFlowSourceLinkedService | undefined;
    private _rejectedLinkedService;
    get rejectedLinkedService(): DataFactoryFlowletDataFlowSourceRejectedLinkedServiceOutputReference;
    putRejectedLinkedService(value: DataFactoryFlowletDataFlowSourceRejectedLinkedService): void;
    resetRejectedLinkedService(): void;
    get rejectedLinkedServiceInput(): DataFactoryFlowletDataFlowSourceRejectedLinkedService | undefined;
    private _schemaLinkedService;
    get schemaLinkedService(): DataFactoryFlowletDataFlowSourceSchemaLinkedServiceOutputReference;
    putSchemaLinkedService(value: DataFactoryFlowletDataFlowSourceSchemaLinkedService): void;
    resetSchemaLinkedService(): void;
    get schemaLinkedServiceInput(): DataFactoryFlowletDataFlowSourceSchemaLinkedService | undefined;
}
export declare class DataFactoryFlowletDataFlowSourceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataFactoryFlowletDataFlowSource[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataFactoryFlowletDataFlowSourceOutputReference;
}
export interface DataFactoryFlowletDataFlowTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#create DataFactoryFlowletDataFlow#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#delete DataFactoryFlowletDataFlow#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#read DataFactoryFlowletDataFlow#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#update DataFactoryFlowletDataFlow#update}
    */
    readonly update?: string;
}
export declare function dataFactoryFlowletDataFlowTimeoutsToTerraform(struct?: DataFactoryFlowletDataFlowTimeouts | cdktf.IResolvable): any;
export declare function dataFactoryFlowletDataFlowTimeoutsToHclTerraform(struct?: DataFactoryFlowletDataFlowTimeouts | cdktf.IResolvable): any;
export declare class DataFactoryFlowletDataFlowTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryFlowletDataFlowTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataFactoryFlowletDataFlowTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface DataFactoryFlowletDataFlowTransformationDataset {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#name DataFactoryFlowletDataFlow#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#parameters DataFactoryFlowletDataFlow#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
}
export declare function dataFactoryFlowletDataFlowTransformationDatasetToTerraform(struct?: DataFactoryFlowletDataFlowTransformationDatasetOutputReference | DataFactoryFlowletDataFlowTransformationDataset): any;
export declare function dataFactoryFlowletDataFlowTransformationDatasetToHclTerraform(struct?: DataFactoryFlowletDataFlowTransformationDatasetOutputReference | DataFactoryFlowletDataFlowTransformationDataset): any;
export declare class DataFactoryFlowletDataFlowTransformationDatasetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryFlowletDataFlowTransformationDataset | undefined;
    set internalValue(value: DataFactoryFlowletDataFlowTransformationDataset | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
}
export interface DataFactoryFlowletDataFlowTransformationFlowlet {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#dataset_parameters DataFactoryFlowletDataFlow#dataset_parameters}
    */
    readonly datasetParameters?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#name DataFactoryFlowletDataFlow#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#parameters DataFactoryFlowletDataFlow#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
}
export declare function dataFactoryFlowletDataFlowTransformationFlowletToTerraform(struct?: DataFactoryFlowletDataFlowTransformationFlowletOutputReference | DataFactoryFlowletDataFlowTransformationFlowlet): any;
export declare function dataFactoryFlowletDataFlowTransformationFlowletToHclTerraform(struct?: DataFactoryFlowletDataFlowTransformationFlowletOutputReference | DataFactoryFlowletDataFlowTransformationFlowlet): any;
export declare class DataFactoryFlowletDataFlowTransformationFlowletOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryFlowletDataFlowTransformationFlowlet | undefined;
    set internalValue(value: DataFactoryFlowletDataFlowTransformationFlowlet | undefined);
    private _datasetParameters?;
    get datasetParameters(): string;
    set datasetParameters(value: string);
    resetDatasetParameters(): void;
    get datasetParametersInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
}
export interface DataFactoryFlowletDataFlowTransformationLinkedService {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#name DataFactoryFlowletDataFlow#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#parameters DataFactoryFlowletDataFlow#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
}
export declare function dataFactoryFlowletDataFlowTransformationLinkedServiceToTerraform(struct?: DataFactoryFlowletDataFlowTransformationLinkedServiceOutputReference | DataFactoryFlowletDataFlowTransformationLinkedService): any;
export declare function dataFactoryFlowletDataFlowTransformationLinkedServiceToHclTerraform(struct?: DataFactoryFlowletDataFlowTransformationLinkedServiceOutputReference | DataFactoryFlowletDataFlowTransformationLinkedService): any;
export declare class DataFactoryFlowletDataFlowTransformationLinkedServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryFlowletDataFlowTransformationLinkedService | undefined;
    set internalValue(value: DataFactoryFlowletDataFlowTransformationLinkedService | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
}
export interface DataFactoryFlowletDataFlowTransformation {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#description DataFactoryFlowletDataFlow#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#name DataFactoryFlowletDataFlow#name}
    */
    readonly name: string;
    /**
    * dataset block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#dataset DataFactoryFlowletDataFlow#dataset}
    */
    readonly dataset?: DataFactoryFlowletDataFlowTransformationDataset;
    /**
    * flowlet block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#flowlet DataFactoryFlowletDataFlow#flowlet}
    */
    readonly flowlet?: DataFactoryFlowletDataFlowTransformationFlowlet;
    /**
    * linked_service block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#linked_service DataFactoryFlowletDataFlow#linked_service}
    */
    readonly linkedService?: DataFactoryFlowletDataFlowTransformationLinkedService;
}
export declare function dataFactoryFlowletDataFlowTransformationToTerraform(struct?: DataFactoryFlowletDataFlowTransformation | cdktf.IResolvable): any;
export declare function dataFactoryFlowletDataFlowTransformationToHclTerraform(struct?: DataFactoryFlowletDataFlowTransformation | cdktf.IResolvable): any;
export declare class DataFactoryFlowletDataFlowTransformationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataFactoryFlowletDataFlowTransformation | cdktf.IResolvable | undefined;
    set internalValue(value: DataFactoryFlowletDataFlowTransformation | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _dataset;
    get dataset(): DataFactoryFlowletDataFlowTransformationDatasetOutputReference;
    putDataset(value: DataFactoryFlowletDataFlowTransformationDataset): void;
    resetDataset(): void;
    get datasetInput(): DataFactoryFlowletDataFlowTransformationDataset | undefined;
    private _flowlet;
    get flowlet(): DataFactoryFlowletDataFlowTransformationFlowletOutputReference;
    putFlowlet(value: DataFactoryFlowletDataFlowTransformationFlowlet): void;
    resetFlowlet(): void;
    get flowletInput(): DataFactoryFlowletDataFlowTransformationFlowlet | undefined;
    private _linkedService;
    get linkedService(): DataFactoryFlowletDataFlowTransformationLinkedServiceOutputReference;
    putLinkedService(value: DataFactoryFlowletDataFlowTransformationLinkedService): void;
    resetLinkedService(): void;
    get linkedServiceInput(): DataFactoryFlowletDataFlowTransformationLinkedService | undefined;
}
export declare class DataFactoryFlowletDataFlowTransformationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataFactoryFlowletDataFlowTransformation[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataFactoryFlowletDataFlowTransformationOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow azurerm_data_factory_flowlet_data_flow}
*/
export declare class DataFactoryFlowletDataFlow extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_data_factory_flowlet_data_flow";
    /**
    * Generates CDKTF code for importing a DataFactoryFlowletDataFlow resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataFactoryFlowletDataFlow to import
    * @param importFromId The id of the existing DataFactoryFlowletDataFlow that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataFactoryFlowletDataFlow to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_factory_flowlet_data_flow azurerm_data_factory_flowlet_data_flow} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataFactoryFlowletDataFlowConfig
    */
    constructor(scope: Construct, id: string, config: DataFactoryFlowletDataFlowConfig);
    private _annotations?;
    get annotations(): string[];
    set annotations(value: string[]);
    resetAnnotations(): void;
    get annotationsInput(): string[] | undefined;
    private _dataFactoryId?;
    get dataFactoryId(): string;
    set dataFactoryId(value: string);
    get dataFactoryIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _folder?;
    get folder(): string;
    set folder(value: string);
    resetFolder(): void;
    get folderInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _script?;
    get script(): string;
    set script(value: string);
    resetScript(): void;
    get scriptInput(): string | undefined;
    private _scriptLines?;
    get scriptLines(): string[];
    set scriptLines(value: string[]);
    resetScriptLines(): void;
    get scriptLinesInput(): string[] | undefined;
    private _sink;
    get sink(): DataFactoryFlowletDataFlowSinkList;
    putSink(value: DataFactoryFlowletDataFlowSink[] | cdktf.IResolvable): void;
    resetSink(): void;
    get sinkInput(): cdktf.IResolvable | DataFactoryFlowletDataFlowSink[] | undefined;
    private _source;
    get source(): DataFactoryFlowletDataFlowSourceList;
    putSource(value: DataFactoryFlowletDataFlowSource[] | cdktf.IResolvable): void;
    resetSource(): void;
    get sourceInput(): cdktf.IResolvable | DataFactoryFlowletDataFlowSource[] | undefined;
    private _timeouts;
    get timeouts(): DataFactoryFlowletDataFlowTimeoutsOutputReference;
    putTimeouts(value: DataFactoryFlowletDataFlowTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataFactoryFlowletDataFlowTimeouts | undefined;
    private _transformation;
    get transformation(): DataFactoryFlowletDataFlowTransformationList;
    putTransformation(value: DataFactoryFlowletDataFlowTransformation[] | cdktf.IResolvable): void;
    resetTransformation(): void;
    get transformationInput(): cdktf.IResolvable | DataFactoryFlowletDataFlowTransformation[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
