/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataProtectionBackupPolicyMysqlFlexibleServerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_protection_backup_policy_mysql_flexible_server#backup_repeating_time_intervals DataProtectionBackupPolicyMysqlFlexibleServer#backup_repeating_time_intervals}
    */
    readonly backupRepeatingTimeIntervals: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_protection_backup_policy_mysql_flexible_server#id DataProtectionBackupPolicyMysqlFlexibleServer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_protection_backup_policy_mysql_flexible_server#name DataProtectionBackupPolicyMysqlFlexibleServer#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_protection_backup_policy_mysql_flexible_server#time_zone DataProtectionBackupPolicyMysqlFlexibleServer#time_zone}
    */
    readonly timeZone?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_protection_backup_policy_mysql_flexible_server#vault_id DataProtectionBackupPolicyMysqlFlexibleServer#vault_id}
    */
    readonly vaultId: string;
    /**
    * default_retention_rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_protection_backup_policy_mysql_flexible_server#default_retention_rule DataProtectionBackupPolicyMysqlFlexibleServer#default_retention_rule}
    */
    readonly defaultRetentionRule: DataProtectionBackupPolicyMysqlFlexibleServerDefaultRetentionRule;
    /**
    * retention_rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_protection_backup_policy_mysql_flexible_server#retention_rule DataProtectionBackupPolicyMysqlFlexibleServer#retention_rule}
    */
    readonly retentionRule?: DataProtectionBackupPolicyMysqlFlexibleServerRetentionRule[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_protection_backup_policy_mysql_flexible_server#timeouts DataProtectionBackupPolicyMysqlFlexibleServer#timeouts}
    */
    readonly timeouts?: DataProtectionBackupPolicyMysqlFlexibleServerTimeouts;
}
export interface DataProtectionBackupPolicyMysqlFlexibleServerDefaultRetentionRuleLifeCycle {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_protection_backup_policy_mysql_flexible_server#data_store_type DataProtectionBackupPolicyMysqlFlexibleServer#data_store_type}
    */
    readonly dataStoreType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_protection_backup_policy_mysql_flexible_server#duration DataProtectionBackupPolicyMysqlFlexibleServer#duration}
    */
    readonly duration: string;
}
export declare function dataProtectionBackupPolicyMysqlFlexibleServerDefaultRetentionRuleLifeCycleToTerraform(struct?: DataProtectionBackupPolicyMysqlFlexibleServerDefaultRetentionRuleLifeCycle | cdktf.IResolvable): any;
export declare function dataProtectionBackupPolicyMysqlFlexibleServerDefaultRetentionRuleLifeCycleToHclTerraform(struct?: DataProtectionBackupPolicyMysqlFlexibleServerDefaultRetentionRuleLifeCycle | cdktf.IResolvable): any;
export declare class DataProtectionBackupPolicyMysqlFlexibleServerDefaultRetentionRuleLifeCycleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataProtectionBackupPolicyMysqlFlexibleServerDefaultRetentionRuleLifeCycle | cdktf.IResolvable | undefined;
    set internalValue(value: DataProtectionBackupPolicyMysqlFlexibleServerDefaultRetentionRuleLifeCycle | cdktf.IResolvable | undefined);
    private _dataStoreType?;
    get dataStoreType(): string;
    set dataStoreType(value: string);
    get dataStoreTypeInput(): string | undefined;
    private _duration?;
    get duration(): string;
    set duration(value: string);
    get durationInput(): string | undefined;
}
export declare class DataProtectionBackupPolicyMysqlFlexibleServerDefaultRetentionRuleLifeCycleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataProtectionBackupPolicyMysqlFlexibleServerDefaultRetentionRuleLifeCycle[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataProtectionBackupPolicyMysqlFlexibleServerDefaultRetentionRuleLifeCycleOutputReference;
}
export interface DataProtectionBackupPolicyMysqlFlexibleServerDefaultRetentionRule {
    /**
    * life_cycle block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_protection_backup_policy_mysql_flexible_server#life_cycle DataProtectionBackupPolicyMysqlFlexibleServer#life_cycle}
    */
    readonly lifeCycle: DataProtectionBackupPolicyMysqlFlexibleServerDefaultRetentionRuleLifeCycle[] | cdktf.IResolvable;
}
export declare function dataProtectionBackupPolicyMysqlFlexibleServerDefaultRetentionRuleToTerraform(struct?: DataProtectionBackupPolicyMysqlFlexibleServerDefaultRetentionRuleOutputReference | DataProtectionBackupPolicyMysqlFlexibleServerDefaultRetentionRule): any;
export declare function dataProtectionBackupPolicyMysqlFlexibleServerDefaultRetentionRuleToHclTerraform(struct?: DataProtectionBackupPolicyMysqlFlexibleServerDefaultRetentionRuleOutputReference | DataProtectionBackupPolicyMysqlFlexibleServerDefaultRetentionRule): any;
export declare class DataProtectionBackupPolicyMysqlFlexibleServerDefaultRetentionRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataProtectionBackupPolicyMysqlFlexibleServerDefaultRetentionRule | undefined;
    set internalValue(value: DataProtectionBackupPolicyMysqlFlexibleServerDefaultRetentionRule | undefined);
    private _lifeCycle;
    get lifeCycle(): DataProtectionBackupPolicyMysqlFlexibleServerDefaultRetentionRuleLifeCycleList;
    putLifeCycle(value: DataProtectionBackupPolicyMysqlFlexibleServerDefaultRetentionRuleLifeCycle[] | cdktf.IResolvable): void;
    get lifeCycleInput(): cdktf.IResolvable | DataProtectionBackupPolicyMysqlFlexibleServerDefaultRetentionRuleLifeCycle[] | undefined;
}
export interface DataProtectionBackupPolicyMysqlFlexibleServerRetentionRuleCriteria {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_protection_backup_policy_mysql_flexible_server#absolute_criteria DataProtectionBackupPolicyMysqlFlexibleServer#absolute_criteria}
    */
    readonly absoluteCriteria?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_protection_backup_policy_mysql_flexible_server#days_of_week DataProtectionBackupPolicyMysqlFlexibleServer#days_of_week}
    */
    readonly daysOfWeek?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_protection_backup_policy_mysql_flexible_server#months_of_year DataProtectionBackupPolicyMysqlFlexibleServer#months_of_year}
    */
    readonly monthsOfYear?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_protection_backup_policy_mysql_flexible_server#scheduled_backup_times DataProtectionBackupPolicyMysqlFlexibleServer#scheduled_backup_times}
    */
    readonly scheduledBackupTimes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_protection_backup_policy_mysql_flexible_server#weeks_of_month DataProtectionBackupPolicyMysqlFlexibleServer#weeks_of_month}
    */
    readonly weeksOfMonth?: string[];
}
export declare function dataProtectionBackupPolicyMysqlFlexibleServerRetentionRuleCriteriaToTerraform(struct?: DataProtectionBackupPolicyMysqlFlexibleServerRetentionRuleCriteriaOutputReference | DataProtectionBackupPolicyMysqlFlexibleServerRetentionRuleCriteria): any;
export declare function dataProtectionBackupPolicyMysqlFlexibleServerRetentionRuleCriteriaToHclTerraform(struct?: DataProtectionBackupPolicyMysqlFlexibleServerRetentionRuleCriteriaOutputReference | DataProtectionBackupPolicyMysqlFlexibleServerRetentionRuleCriteria): any;
export declare class DataProtectionBackupPolicyMysqlFlexibleServerRetentionRuleCriteriaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataProtectionBackupPolicyMysqlFlexibleServerRetentionRuleCriteria | undefined;
    set internalValue(value: DataProtectionBackupPolicyMysqlFlexibleServerRetentionRuleCriteria | undefined);
    private _absoluteCriteria?;
    get absoluteCriteria(): string;
    set absoluteCriteria(value: string);
    resetAbsoluteCriteria(): void;
    get absoluteCriteriaInput(): string | undefined;
    private _daysOfWeek?;
    get daysOfWeek(): string[];
    set daysOfWeek(value: string[]);
    resetDaysOfWeek(): void;
    get daysOfWeekInput(): string[] | undefined;
    private _monthsOfYear?;
    get monthsOfYear(): string[];
    set monthsOfYear(value: string[]);
    resetMonthsOfYear(): void;
    get monthsOfYearInput(): string[] | undefined;
    private _scheduledBackupTimes?;
    get scheduledBackupTimes(): string[];
    set scheduledBackupTimes(value: string[]);
    resetScheduledBackupTimes(): void;
    get scheduledBackupTimesInput(): string[] | undefined;
    private _weeksOfMonth?;
    get weeksOfMonth(): string[];
    set weeksOfMonth(value: string[]);
    resetWeeksOfMonth(): void;
    get weeksOfMonthInput(): string[] | undefined;
}
export interface DataProtectionBackupPolicyMysqlFlexibleServerRetentionRuleLifeCycle {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_protection_backup_policy_mysql_flexible_server#data_store_type DataProtectionBackupPolicyMysqlFlexibleServer#data_store_type}
    */
    readonly dataStoreType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_protection_backup_policy_mysql_flexible_server#duration DataProtectionBackupPolicyMysqlFlexibleServer#duration}
    */
    readonly duration: string;
}
export declare function dataProtectionBackupPolicyMysqlFlexibleServerRetentionRuleLifeCycleToTerraform(struct?: DataProtectionBackupPolicyMysqlFlexibleServerRetentionRuleLifeCycle | cdktf.IResolvable): any;
export declare function dataProtectionBackupPolicyMysqlFlexibleServerRetentionRuleLifeCycleToHclTerraform(struct?: DataProtectionBackupPolicyMysqlFlexibleServerRetentionRuleLifeCycle | cdktf.IResolvable): any;
export declare class DataProtectionBackupPolicyMysqlFlexibleServerRetentionRuleLifeCycleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataProtectionBackupPolicyMysqlFlexibleServerRetentionRuleLifeCycle | cdktf.IResolvable | undefined;
    set internalValue(value: DataProtectionBackupPolicyMysqlFlexibleServerRetentionRuleLifeCycle | cdktf.IResolvable | undefined);
    private _dataStoreType?;
    get dataStoreType(): string;
    set dataStoreType(value: string);
    get dataStoreTypeInput(): string | undefined;
    private _duration?;
    get duration(): string;
    set duration(value: string);
    get durationInput(): string | undefined;
}
export declare class DataProtectionBackupPolicyMysqlFlexibleServerRetentionRuleLifeCycleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataProtectionBackupPolicyMysqlFlexibleServerRetentionRuleLifeCycle[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataProtectionBackupPolicyMysqlFlexibleServerRetentionRuleLifeCycleOutputReference;
}
export interface DataProtectionBackupPolicyMysqlFlexibleServerRetentionRule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_protection_backup_policy_mysql_flexible_server#name DataProtectionBackupPolicyMysqlFlexibleServer#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_protection_backup_policy_mysql_flexible_server#priority DataProtectionBackupPolicyMysqlFlexibleServer#priority}
    */
    readonly priority: number;
    /**
    * criteria block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_protection_backup_policy_mysql_flexible_server#criteria DataProtectionBackupPolicyMysqlFlexibleServer#criteria}
    */
    readonly criteria: DataProtectionBackupPolicyMysqlFlexibleServerRetentionRuleCriteria;
    /**
    * life_cycle block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_protection_backup_policy_mysql_flexible_server#life_cycle DataProtectionBackupPolicyMysqlFlexibleServer#life_cycle}
    */
    readonly lifeCycle: DataProtectionBackupPolicyMysqlFlexibleServerRetentionRuleLifeCycle[] | cdktf.IResolvable;
}
export declare function dataProtectionBackupPolicyMysqlFlexibleServerRetentionRuleToTerraform(struct?: DataProtectionBackupPolicyMysqlFlexibleServerRetentionRule | cdktf.IResolvable): any;
export declare function dataProtectionBackupPolicyMysqlFlexibleServerRetentionRuleToHclTerraform(struct?: DataProtectionBackupPolicyMysqlFlexibleServerRetentionRule | cdktf.IResolvable): any;
export declare class DataProtectionBackupPolicyMysqlFlexibleServerRetentionRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataProtectionBackupPolicyMysqlFlexibleServerRetentionRule | cdktf.IResolvable | undefined;
    set internalValue(value: DataProtectionBackupPolicyMysqlFlexibleServerRetentionRule | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    get priorityInput(): number | undefined;
    private _criteria;
    get criteria(): DataProtectionBackupPolicyMysqlFlexibleServerRetentionRuleCriteriaOutputReference;
    putCriteria(value: DataProtectionBackupPolicyMysqlFlexibleServerRetentionRuleCriteria): void;
    get criteriaInput(): DataProtectionBackupPolicyMysqlFlexibleServerRetentionRuleCriteria | undefined;
    private _lifeCycle;
    get lifeCycle(): DataProtectionBackupPolicyMysqlFlexibleServerRetentionRuleLifeCycleList;
    putLifeCycle(value: DataProtectionBackupPolicyMysqlFlexibleServerRetentionRuleLifeCycle[] | cdktf.IResolvable): void;
    get lifeCycleInput(): cdktf.IResolvable | DataProtectionBackupPolicyMysqlFlexibleServerRetentionRuleLifeCycle[] | undefined;
}
export declare class DataProtectionBackupPolicyMysqlFlexibleServerRetentionRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataProtectionBackupPolicyMysqlFlexibleServerRetentionRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataProtectionBackupPolicyMysqlFlexibleServerRetentionRuleOutputReference;
}
export interface DataProtectionBackupPolicyMysqlFlexibleServerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_protection_backup_policy_mysql_flexible_server#create DataProtectionBackupPolicyMysqlFlexibleServer#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_protection_backup_policy_mysql_flexible_server#delete DataProtectionBackupPolicyMysqlFlexibleServer#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_protection_backup_policy_mysql_flexible_server#read DataProtectionBackupPolicyMysqlFlexibleServer#read}
    */
    readonly read?: string;
}
export declare function dataProtectionBackupPolicyMysqlFlexibleServerTimeoutsToTerraform(struct?: DataProtectionBackupPolicyMysqlFlexibleServerTimeouts | cdktf.IResolvable): any;
export declare function dataProtectionBackupPolicyMysqlFlexibleServerTimeoutsToHclTerraform(struct?: DataProtectionBackupPolicyMysqlFlexibleServerTimeouts | cdktf.IResolvable): any;
export declare class DataProtectionBackupPolicyMysqlFlexibleServerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataProtectionBackupPolicyMysqlFlexibleServerTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataProtectionBackupPolicyMysqlFlexibleServerTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_protection_backup_policy_mysql_flexible_server azurerm_data_protection_backup_policy_mysql_flexible_server}
*/
export declare class DataProtectionBackupPolicyMysqlFlexibleServer extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_data_protection_backup_policy_mysql_flexible_server";
    /**
    * Generates CDKTF code for importing a DataProtectionBackupPolicyMysqlFlexibleServer resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataProtectionBackupPolicyMysqlFlexibleServer to import
    * @param importFromId The id of the existing DataProtectionBackupPolicyMysqlFlexibleServer that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_protection_backup_policy_mysql_flexible_server#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataProtectionBackupPolicyMysqlFlexibleServer to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/data_protection_backup_policy_mysql_flexible_server azurerm_data_protection_backup_policy_mysql_flexible_server} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataProtectionBackupPolicyMysqlFlexibleServerConfig
    */
    constructor(scope: Construct, id: string, config: DataProtectionBackupPolicyMysqlFlexibleServerConfig);
    private _backupRepeatingTimeIntervals?;
    get backupRepeatingTimeIntervals(): string[];
    set backupRepeatingTimeIntervals(value: string[]);
    get backupRepeatingTimeIntervalsInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _timeZone?;
    get timeZone(): string;
    set timeZone(value: string);
    resetTimeZone(): void;
    get timeZoneInput(): string | undefined;
    private _vaultId?;
    get vaultId(): string;
    set vaultId(value: string);
    get vaultIdInput(): string | undefined;
    private _defaultRetentionRule;
    get defaultRetentionRule(): DataProtectionBackupPolicyMysqlFlexibleServerDefaultRetentionRuleOutputReference;
    putDefaultRetentionRule(value: DataProtectionBackupPolicyMysqlFlexibleServerDefaultRetentionRule): void;
    get defaultRetentionRuleInput(): DataProtectionBackupPolicyMysqlFlexibleServerDefaultRetentionRule | undefined;
    private _retentionRule;
    get retentionRule(): DataProtectionBackupPolicyMysqlFlexibleServerRetentionRuleList;
    putRetentionRule(value: DataProtectionBackupPolicyMysqlFlexibleServerRetentionRule[] | cdktf.IResolvable): void;
    resetRetentionRule(): void;
    get retentionRuleInput(): cdktf.IResolvable | DataProtectionBackupPolicyMysqlFlexibleServerRetentionRule[] | undefined;
    private _timeouts;
    get timeouts(): DataProtectionBackupPolicyMysqlFlexibleServerTimeoutsOutputReference;
    putTimeouts(value: DataProtectionBackupPolicyMysqlFlexibleServerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataProtectionBackupPolicyMysqlFlexibleServerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
