/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DevCenterAttachedNetworkConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/dev_center_attached_network#dev_center_id DevCenterAttachedNetwork#dev_center_id}
    */
    readonly devCenterId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/dev_center_attached_network#id DevCenterAttachedNetwork#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/dev_center_attached_network#name DevCenterAttachedNetwork#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/dev_center_attached_network#network_connection_id DevCenterAttachedNetwork#network_connection_id}
    */
    readonly networkConnectionId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/dev_center_attached_network#timeouts DevCenterAttachedNetwork#timeouts}
    */
    readonly timeouts?: DevCenterAttachedNetworkTimeouts;
}
export interface DevCenterAttachedNetworkTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/dev_center_attached_network#create DevCenterAttachedNetwork#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/dev_center_attached_network#delete DevCenterAttachedNetwork#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/dev_center_attached_network#read DevCenterAttachedNetwork#read}
    */
    readonly read?: string;
}
export declare function devCenterAttachedNetworkTimeoutsToTerraform(struct?: DevCenterAttachedNetworkTimeouts | cdktf.IResolvable): any;
export declare function devCenterAttachedNetworkTimeoutsToHclTerraform(struct?: DevCenterAttachedNetworkTimeouts | cdktf.IResolvable): any;
export declare class DevCenterAttachedNetworkTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DevCenterAttachedNetworkTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DevCenterAttachedNetworkTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/dev_center_attached_network azurerm_dev_center_attached_network}
*/
export declare class DevCenterAttachedNetwork extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_dev_center_attached_network";
    /**
    * Generates CDKTF code for importing a DevCenterAttachedNetwork resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DevCenterAttachedNetwork to import
    * @param importFromId The id of the existing DevCenterAttachedNetwork that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/dev_center_attached_network#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DevCenterAttachedNetwork to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/dev_center_attached_network azurerm_dev_center_attached_network} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DevCenterAttachedNetworkConfig
    */
    constructor(scope: Construct, id: string, config: DevCenterAttachedNetworkConfig);
    private _devCenterId?;
    get devCenterId(): string;
    set devCenterId(value: string);
    get devCenterIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkConnectionId?;
    get networkConnectionId(): string;
    set networkConnectionId(value: string);
    get networkConnectionIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): DevCenterAttachedNetworkTimeoutsOutputReference;
    putTimeouts(value: DevCenterAttachedNetworkTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DevCenterAttachedNetworkTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
