/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DigitalTwinsInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/digital_twins_instance#id DigitalTwinsInstance#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/digital_twins_instance#location DigitalTwinsInstance#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/digital_twins_instance#name DigitalTwinsInstance#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/digital_twins_instance#resource_group_name DigitalTwinsInstance#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/digital_twins_instance#tags DigitalTwinsInstance#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/digital_twins_instance#identity DigitalTwinsInstance#identity}
    */
    readonly identity?: DigitalTwinsInstanceIdentity;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/digital_twins_instance#timeouts DigitalTwinsInstance#timeouts}
    */
    readonly timeouts?: DigitalTwinsInstanceTimeouts;
}
export interface DigitalTwinsInstanceIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/digital_twins_instance#identity_ids DigitalTwinsInstance#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/digital_twins_instance#type DigitalTwinsInstance#type}
    */
    readonly type: string;
}
export declare function digitalTwinsInstanceIdentityToTerraform(struct?: DigitalTwinsInstanceIdentityOutputReference | DigitalTwinsInstanceIdentity): any;
export declare function digitalTwinsInstanceIdentityToHclTerraform(struct?: DigitalTwinsInstanceIdentityOutputReference | DigitalTwinsInstanceIdentity): any;
export declare class DigitalTwinsInstanceIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DigitalTwinsInstanceIdentity | undefined;
    set internalValue(value: DigitalTwinsInstanceIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface DigitalTwinsInstanceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/digital_twins_instance#create DigitalTwinsInstance#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/digital_twins_instance#delete DigitalTwinsInstance#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/digital_twins_instance#read DigitalTwinsInstance#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/digital_twins_instance#update DigitalTwinsInstance#update}
    */
    readonly update?: string;
}
export declare function digitalTwinsInstanceTimeoutsToTerraform(struct?: DigitalTwinsInstanceTimeouts | cdktf.IResolvable): any;
export declare function digitalTwinsInstanceTimeoutsToHclTerraform(struct?: DigitalTwinsInstanceTimeouts | cdktf.IResolvable): any;
export declare class DigitalTwinsInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DigitalTwinsInstanceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DigitalTwinsInstanceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/digital_twins_instance azurerm_digital_twins_instance}
*/
export declare class DigitalTwinsInstance extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_digital_twins_instance";
    /**
    * Generates CDKTF code for importing a DigitalTwinsInstance resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DigitalTwinsInstance to import
    * @param importFromId The id of the existing DigitalTwinsInstance that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/digital_twins_instance#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DigitalTwinsInstance to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/digital_twins_instance azurerm_digital_twins_instance} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DigitalTwinsInstanceConfig
    */
    constructor(scope: Construct, id: string, config: DigitalTwinsInstanceConfig);
    get hostName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _identity;
    get identity(): DigitalTwinsInstanceIdentityOutputReference;
    putIdentity(value: DigitalTwinsInstanceIdentity): void;
    resetIdentity(): void;
    get identityInput(): DigitalTwinsInstanceIdentity | undefined;
    private _timeouts;
    get timeouts(): DigitalTwinsInstanceTimeoutsOutputReference;
    putTimeouts(value: DigitalTwinsInstanceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DigitalTwinsInstanceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
