/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface HealthcareDicomServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/healthcare_dicom_service#data_partitions_enabled HealthcareDicomService#data_partitions_enabled}
    */
    readonly dataPartitionsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/healthcare_dicom_service#encryption_key_url HealthcareDicomService#encryption_key_url}
    */
    readonly encryptionKeyUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/healthcare_dicom_service#id HealthcareDicomService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/healthcare_dicom_service#location HealthcareDicomService#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/healthcare_dicom_service#name HealthcareDicomService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/healthcare_dicom_service#public_network_access_enabled HealthcareDicomService#public_network_access_enabled}
    */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/healthcare_dicom_service#tags HealthcareDicomService#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/healthcare_dicom_service#workspace_id HealthcareDicomService#workspace_id}
    */
    readonly workspaceId: string;
    /**
    * cors block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/healthcare_dicom_service#cors HealthcareDicomService#cors}
    */
    readonly cors?: HealthcareDicomServiceCors;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/healthcare_dicom_service#identity HealthcareDicomService#identity}
    */
    readonly identity?: HealthcareDicomServiceIdentity;
    /**
    * storage block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/healthcare_dicom_service#storage HealthcareDicomService#storage}
    */
    readonly storage?: HealthcareDicomServiceStorage;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/healthcare_dicom_service#timeouts HealthcareDicomService#timeouts}
    */
    readonly timeouts?: HealthcareDicomServiceTimeouts;
}
export interface HealthcareDicomServiceAuthentication {
}
export declare function healthcareDicomServiceAuthenticationToTerraform(struct?: HealthcareDicomServiceAuthentication): any;
export declare function healthcareDicomServiceAuthenticationToHclTerraform(struct?: HealthcareDicomServiceAuthentication): any;
export declare class HealthcareDicomServiceAuthenticationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HealthcareDicomServiceAuthentication | undefined;
    set internalValue(value: HealthcareDicomServiceAuthentication | undefined);
    get audience(): string[];
    get authority(): string;
}
export declare class HealthcareDicomServiceAuthenticationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HealthcareDicomServiceAuthenticationOutputReference;
}
export interface HealthcareDicomServicePrivateEndpoint {
}
export declare function healthcareDicomServicePrivateEndpointToTerraform(struct?: HealthcareDicomServicePrivateEndpoint): any;
export declare function healthcareDicomServicePrivateEndpointToHclTerraform(struct?: HealthcareDicomServicePrivateEndpoint): any;
export declare class HealthcareDicomServicePrivateEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HealthcareDicomServicePrivateEndpoint | undefined;
    set internalValue(value: HealthcareDicomServicePrivateEndpoint | undefined);
    get id(): string;
    get name(): string;
}
export declare class HealthcareDicomServicePrivateEndpointList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HealthcareDicomServicePrivateEndpointOutputReference;
}
export interface HealthcareDicomServiceCors {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/healthcare_dicom_service#allow_credentials HealthcareDicomService#allow_credentials}
    */
    readonly allowCredentials?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/healthcare_dicom_service#allowed_headers HealthcareDicomService#allowed_headers}
    */
    readonly allowedHeaders?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/healthcare_dicom_service#allowed_methods HealthcareDicomService#allowed_methods}
    */
    readonly allowedMethods?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/healthcare_dicom_service#allowed_origins HealthcareDicomService#allowed_origins}
    */
    readonly allowedOrigins?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/healthcare_dicom_service#max_age_in_seconds HealthcareDicomService#max_age_in_seconds}
    */
    readonly maxAgeInSeconds?: number;
}
export declare function healthcareDicomServiceCorsToTerraform(struct?: HealthcareDicomServiceCorsOutputReference | HealthcareDicomServiceCors): any;
export declare function healthcareDicomServiceCorsToHclTerraform(struct?: HealthcareDicomServiceCorsOutputReference | HealthcareDicomServiceCors): any;
export declare class HealthcareDicomServiceCorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HealthcareDicomServiceCors | undefined;
    set internalValue(value: HealthcareDicomServiceCors | undefined);
    private _allowCredentials?;
    get allowCredentials(): boolean | cdktf.IResolvable;
    set allowCredentials(value: boolean | cdktf.IResolvable);
    resetAllowCredentials(): void;
    get allowCredentialsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowedHeaders?;
    get allowedHeaders(): string[];
    set allowedHeaders(value: string[]);
    resetAllowedHeaders(): void;
    get allowedHeadersInput(): string[] | undefined;
    private _allowedMethods?;
    get allowedMethods(): string[];
    set allowedMethods(value: string[]);
    resetAllowedMethods(): void;
    get allowedMethodsInput(): string[] | undefined;
    private _allowedOrigins?;
    get allowedOrigins(): string[];
    set allowedOrigins(value: string[]);
    resetAllowedOrigins(): void;
    get allowedOriginsInput(): string[] | undefined;
    private _maxAgeInSeconds?;
    get maxAgeInSeconds(): number;
    set maxAgeInSeconds(value: number);
    resetMaxAgeInSeconds(): void;
    get maxAgeInSecondsInput(): number | undefined;
}
export interface HealthcareDicomServiceIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/healthcare_dicom_service#identity_ids HealthcareDicomService#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/healthcare_dicom_service#type HealthcareDicomService#type}
    */
    readonly type: string;
}
export declare function healthcareDicomServiceIdentityToTerraform(struct?: HealthcareDicomServiceIdentityOutputReference | HealthcareDicomServiceIdentity): any;
export declare function healthcareDicomServiceIdentityToHclTerraform(struct?: HealthcareDicomServiceIdentityOutputReference | HealthcareDicomServiceIdentity): any;
export declare class HealthcareDicomServiceIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HealthcareDicomServiceIdentity | undefined;
    set internalValue(value: HealthcareDicomServiceIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface HealthcareDicomServiceStorage {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/healthcare_dicom_service#file_system_name HealthcareDicomService#file_system_name}
    */
    readonly fileSystemName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/healthcare_dicom_service#storage_account_id HealthcareDicomService#storage_account_id}
    */
    readonly storageAccountId: string;
}
export declare function healthcareDicomServiceStorageToTerraform(struct?: HealthcareDicomServiceStorageOutputReference | HealthcareDicomServiceStorage): any;
export declare function healthcareDicomServiceStorageToHclTerraform(struct?: HealthcareDicomServiceStorageOutputReference | HealthcareDicomServiceStorage): any;
export declare class HealthcareDicomServiceStorageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HealthcareDicomServiceStorage | undefined;
    set internalValue(value: HealthcareDicomServiceStorage | undefined);
    private _fileSystemName?;
    get fileSystemName(): string;
    set fileSystemName(value: string);
    get fileSystemNameInput(): string | undefined;
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    get storageAccountIdInput(): string | undefined;
}
export interface HealthcareDicomServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/healthcare_dicom_service#create HealthcareDicomService#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/healthcare_dicom_service#delete HealthcareDicomService#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/healthcare_dicom_service#read HealthcareDicomService#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/healthcare_dicom_service#update HealthcareDicomService#update}
    */
    readonly update?: string;
}
export declare function healthcareDicomServiceTimeoutsToTerraform(struct?: HealthcareDicomServiceTimeouts | cdktf.IResolvable): any;
export declare function healthcareDicomServiceTimeoutsToHclTerraform(struct?: HealthcareDicomServiceTimeouts | cdktf.IResolvable): any;
export declare class HealthcareDicomServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HealthcareDicomServiceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: HealthcareDicomServiceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/healthcare_dicom_service azurerm_healthcare_dicom_service}
*/
export declare class HealthcareDicomService extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_healthcare_dicom_service";
    /**
    * Generates CDKTF code for importing a HealthcareDicomService resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the HealthcareDicomService to import
    * @param importFromId The id of the existing HealthcareDicomService that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/healthcare_dicom_service#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the HealthcareDicomService to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/healthcare_dicom_service azurerm_healthcare_dicom_service} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options HealthcareDicomServiceConfig
    */
    constructor(scope: Construct, id: string, config: HealthcareDicomServiceConfig);
    private _authentication;
    get authentication(): HealthcareDicomServiceAuthenticationList;
    private _dataPartitionsEnabled?;
    get dataPartitionsEnabled(): boolean | cdktf.IResolvable;
    set dataPartitionsEnabled(value: boolean | cdktf.IResolvable);
    resetDataPartitionsEnabled(): void;
    get dataPartitionsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _encryptionKeyUrl?;
    get encryptionKeyUrl(): string;
    set encryptionKeyUrl(value: string);
    resetEncryptionKeyUrl(): void;
    get encryptionKeyUrlInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _privateEndpoint;
    get privateEndpoint(): HealthcareDicomServicePrivateEndpointList;
    private _publicNetworkAccessEnabled?;
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    resetPublicNetworkAccessEnabled(): void;
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get serviceUrl(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _workspaceId?;
    get workspaceId(): string;
    set workspaceId(value: string);
    get workspaceIdInput(): string | undefined;
    private _cors;
    get cors(): HealthcareDicomServiceCorsOutputReference;
    putCors(value: HealthcareDicomServiceCors): void;
    resetCors(): void;
    get corsInput(): HealthcareDicomServiceCors | undefined;
    private _identity;
    get identity(): HealthcareDicomServiceIdentityOutputReference;
    putIdentity(value: HealthcareDicomServiceIdentity): void;
    resetIdentity(): void;
    get identityInput(): HealthcareDicomServiceIdentity | undefined;
    private _storage;
    get storage(): HealthcareDicomServiceStorageOutputReference;
    putStorage(value: HealthcareDicomServiceStorage): void;
    resetStorage(): void;
    get storageInput(): HealthcareDicomServiceStorage | undefined;
    private _timeouts;
    get timeouts(): HealthcareDicomServiceTimeoutsOutputReference;
    putTimeouts(value: HealthcareDicomServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | HealthcareDicomServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
