/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IothubFileUploadAConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/iothub_file_upload#authentication_type IothubFileUploadA#authentication_type}
    */
    readonly authenticationType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/iothub_file_upload#connection_string IothubFileUploadA#connection_string}
    */
    readonly connectionString: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/iothub_file_upload#container_name IothubFileUploadA#container_name}
    */
    readonly containerName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/iothub_file_upload#default_ttl IothubFileUploadA#default_ttl}
    */
    readonly defaultTtl?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/iothub_file_upload#id IothubFileUploadA#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/iothub_file_upload#identity_id IothubFileUploadA#identity_id}
    */
    readonly identityId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/iothub_file_upload#iothub_id IothubFileUploadA#iothub_id}
    */
    readonly iothubId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/iothub_file_upload#lock_duration IothubFileUploadA#lock_duration}
    */
    readonly lockDuration?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/iothub_file_upload#max_delivery_count IothubFileUploadA#max_delivery_count}
    */
    readonly maxDeliveryCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/iothub_file_upload#notifications_enabled IothubFileUploadA#notifications_enabled}
    */
    readonly notificationsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/iothub_file_upload#sas_ttl IothubFileUploadA#sas_ttl}
    */
    readonly sasTtl?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/iothub_file_upload#timeouts IothubFileUploadA#timeouts}
    */
    readonly timeouts?: IothubFileUploadTimeouts;
}
export interface IothubFileUploadTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/iothub_file_upload#create IothubFileUploadA#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/iothub_file_upload#delete IothubFileUploadA#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/iothub_file_upload#read IothubFileUploadA#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/iothub_file_upload#update IothubFileUploadA#update}
    */
    readonly update?: string;
}
export declare function iothubFileUploadTimeoutsToTerraform(struct?: IothubFileUploadTimeouts | cdktf.IResolvable): any;
export declare function iothubFileUploadTimeoutsToHclTerraform(struct?: IothubFileUploadTimeouts | cdktf.IResolvable): any;
export declare class IothubFileUploadTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IothubFileUploadTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: IothubFileUploadTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/iothub_file_upload azurerm_iothub_file_upload}
*/
export declare class IothubFileUploadA extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_iothub_file_upload";
    /**
    * Generates CDKTF code for importing a IothubFileUploadA resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the IothubFileUploadA to import
    * @param importFromId The id of the existing IothubFileUploadA that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/iothub_file_upload#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the IothubFileUploadA to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/iothub_file_upload azurerm_iothub_file_upload} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IothubFileUploadAConfig
    */
    constructor(scope: Construct, id: string, config: IothubFileUploadAConfig);
    private _authenticationType?;
    get authenticationType(): string;
    set authenticationType(value: string);
    resetAuthenticationType(): void;
    get authenticationTypeInput(): string | undefined;
    private _connectionString?;
    get connectionString(): string;
    set connectionString(value: string);
    get connectionStringInput(): string | undefined;
    private _containerName?;
    get containerName(): string;
    set containerName(value: string);
    get containerNameInput(): string | undefined;
    private _defaultTtl?;
    get defaultTtl(): string;
    set defaultTtl(value: string);
    resetDefaultTtl(): void;
    get defaultTtlInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identityId?;
    get identityId(): string;
    set identityId(value: string);
    resetIdentityId(): void;
    get identityIdInput(): string | undefined;
    private _iothubId?;
    get iothubId(): string;
    set iothubId(value: string);
    get iothubIdInput(): string | undefined;
    private _lockDuration?;
    get lockDuration(): string;
    set lockDuration(value: string);
    resetLockDuration(): void;
    get lockDurationInput(): string | undefined;
    private _maxDeliveryCount?;
    get maxDeliveryCount(): number;
    set maxDeliveryCount(value: number);
    resetMaxDeliveryCount(): void;
    get maxDeliveryCountInput(): number | undefined;
    private _notificationsEnabled?;
    get notificationsEnabled(): boolean | cdktf.IResolvable;
    set notificationsEnabled(value: boolean | cdktf.IResolvable);
    resetNotificationsEnabled(): void;
    get notificationsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _sasTtl?;
    get sasTtl(): string;
    set sasTtl(value: string);
    resetSasTtl(): void;
    get sasTtlInput(): string | undefined;
    private _timeouts;
    get timeouts(): IothubFileUploadTimeoutsOutputReference;
    putTimeouts(value: IothubFileUploadTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | IothubFileUploadTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
