/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LbNatPoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/lb_nat_pool#backend_port LbNatPool#backend_port}
    */
    readonly backendPort: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/lb_nat_pool#floating_ip_enabled LbNatPool#floating_ip_enabled}
    */
    readonly floatingIpEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/lb_nat_pool#frontend_ip_configuration_name LbNatPool#frontend_ip_configuration_name}
    */
    readonly frontendIpConfigurationName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/lb_nat_pool#frontend_port_end LbNatPool#frontend_port_end}
    */
    readonly frontendPortEnd: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/lb_nat_pool#frontend_port_start LbNatPool#frontend_port_start}
    */
    readonly frontendPortStart: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/lb_nat_pool#id LbNatPool#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/lb_nat_pool#idle_timeout_in_minutes LbNatPool#idle_timeout_in_minutes}
    */
    readonly idleTimeoutInMinutes?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/lb_nat_pool#loadbalancer_id LbNatPool#loadbalancer_id}
    */
    readonly loadbalancerId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/lb_nat_pool#name LbNatPool#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/lb_nat_pool#protocol LbNatPool#protocol}
    */
    readonly protocol: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/lb_nat_pool#resource_group_name LbNatPool#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/lb_nat_pool#tcp_reset_enabled LbNatPool#tcp_reset_enabled}
    */
    readonly tcpResetEnabled?: boolean | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/lb_nat_pool#timeouts LbNatPool#timeouts}
    */
    readonly timeouts?: LbNatPoolTimeouts;
}
export interface LbNatPoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/lb_nat_pool#create LbNatPool#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/lb_nat_pool#delete LbNatPool#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/lb_nat_pool#read LbNatPool#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/lb_nat_pool#update LbNatPool#update}
    */
    readonly update?: string;
}
export declare function lbNatPoolTimeoutsToTerraform(struct?: LbNatPoolTimeouts | cdktf.IResolvable): any;
export declare function lbNatPoolTimeoutsToHclTerraform(struct?: LbNatPoolTimeouts | cdktf.IResolvable): any;
export declare class LbNatPoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LbNatPoolTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: LbNatPoolTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/lb_nat_pool azurerm_lb_nat_pool}
*/
export declare class LbNatPool extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_lb_nat_pool";
    /**
    * Generates CDKTF code for importing a LbNatPool resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the LbNatPool to import
    * @param importFromId The id of the existing LbNatPool that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/lb_nat_pool#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the LbNatPool to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/lb_nat_pool azurerm_lb_nat_pool} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LbNatPoolConfig
    */
    constructor(scope: Construct, id: string, config: LbNatPoolConfig);
    private _backendPort?;
    get backendPort(): number;
    set backendPort(value: number);
    get backendPortInput(): number | undefined;
    private _floatingIpEnabled?;
    get floatingIpEnabled(): boolean | cdktf.IResolvable;
    set floatingIpEnabled(value: boolean | cdktf.IResolvable);
    resetFloatingIpEnabled(): void;
    get floatingIpEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get frontendIpConfigurationId(): string;
    private _frontendIpConfigurationName?;
    get frontendIpConfigurationName(): string;
    set frontendIpConfigurationName(value: string);
    get frontendIpConfigurationNameInput(): string | undefined;
    private _frontendPortEnd?;
    get frontendPortEnd(): number;
    set frontendPortEnd(value: number);
    get frontendPortEndInput(): number | undefined;
    private _frontendPortStart?;
    get frontendPortStart(): number;
    set frontendPortStart(value: number);
    get frontendPortStartInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _idleTimeoutInMinutes?;
    get idleTimeoutInMinutes(): number;
    set idleTimeoutInMinutes(value: number);
    resetIdleTimeoutInMinutes(): void;
    get idleTimeoutInMinutesInput(): number | undefined;
    private _loadbalancerId?;
    get loadbalancerId(): string;
    set loadbalancerId(value: string);
    get loadbalancerIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tcpResetEnabled?;
    get tcpResetEnabled(): boolean | cdktf.IResolvable;
    set tcpResetEnabled(value: boolean | cdktf.IResolvable);
    resetTcpResetEnabled(): void;
    get tcpResetEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    get timeouts(): LbNatPoolTimeoutsOutputReference;
    putTimeouts(value: LbNatPoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | LbNatPoolTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
