/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MapsAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/maps_account#id MapsAccount#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/maps_account#local_authentication_enabled MapsAccount#local_authentication_enabled}
    */
    readonly localAuthenticationEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/maps_account#location MapsAccount#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/maps_account#name MapsAccount#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/maps_account#resource_group_name MapsAccount#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/maps_account#sku_name MapsAccount#sku_name}
    */
    readonly skuName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/maps_account#tags MapsAccount#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * cors block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/maps_account#cors MapsAccount#cors}
    */
    readonly cors?: MapsAccountCors;
    /**
    * data_store block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/maps_account#data_store MapsAccount#data_store}
    */
    readonly dataStore?: MapsAccountDataStore[] | cdktf.IResolvable;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/maps_account#identity MapsAccount#identity}
    */
    readonly identity?: MapsAccountIdentity;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/maps_account#timeouts MapsAccount#timeouts}
    */
    readonly timeouts?: MapsAccountTimeouts;
}
export interface MapsAccountCors {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/maps_account#allowed_origins MapsAccount#allowed_origins}
    */
    readonly allowedOrigins: string[];
}
export declare function mapsAccountCorsToTerraform(struct?: MapsAccountCorsOutputReference | MapsAccountCors): any;
export declare function mapsAccountCorsToHclTerraform(struct?: MapsAccountCorsOutputReference | MapsAccountCors): any;
export declare class MapsAccountCorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MapsAccountCors | undefined;
    set internalValue(value: MapsAccountCors | undefined);
    private _allowedOrigins?;
    get allowedOrigins(): string[];
    set allowedOrigins(value: string[]);
    get allowedOriginsInput(): string[] | undefined;
}
export interface MapsAccountDataStore {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/maps_account#storage_account_id MapsAccount#storage_account_id}
    */
    readonly storageAccountId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/maps_account#unique_name MapsAccount#unique_name}
    */
    readonly uniqueName: string;
}
export declare function mapsAccountDataStoreToTerraform(struct?: MapsAccountDataStore | cdktf.IResolvable): any;
export declare function mapsAccountDataStoreToHclTerraform(struct?: MapsAccountDataStore | cdktf.IResolvable): any;
export declare class MapsAccountDataStoreOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MapsAccountDataStore | cdktf.IResolvable | undefined;
    set internalValue(value: MapsAccountDataStore | cdktf.IResolvable | undefined);
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    resetStorageAccountId(): void;
    get storageAccountIdInput(): string | undefined;
    private _uniqueName?;
    get uniqueName(): string;
    set uniqueName(value: string);
    get uniqueNameInput(): string | undefined;
}
export declare class MapsAccountDataStoreList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MapsAccountDataStore[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MapsAccountDataStoreOutputReference;
}
export interface MapsAccountIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/maps_account#identity_ids MapsAccount#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/maps_account#type MapsAccount#type}
    */
    readonly type: string;
}
export declare function mapsAccountIdentityToTerraform(struct?: MapsAccountIdentityOutputReference | MapsAccountIdentity): any;
export declare function mapsAccountIdentityToHclTerraform(struct?: MapsAccountIdentityOutputReference | MapsAccountIdentity): any;
export declare class MapsAccountIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MapsAccountIdentity | undefined;
    set internalValue(value: MapsAccountIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface MapsAccountTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/maps_account#create MapsAccount#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/maps_account#delete MapsAccount#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/maps_account#read MapsAccount#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/maps_account#update MapsAccount#update}
    */
    readonly update?: string;
}
export declare function mapsAccountTimeoutsToTerraform(struct?: MapsAccountTimeouts | cdktf.IResolvable): any;
export declare function mapsAccountTimeoutsToHclTerraform(struct?: MapsAccountTimeouts | cdktf.IResolvable): any;
export declare class MapsAccountTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MapsAccountTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MapsAccountTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/maps_account azurerm_maps_account}
*/
export declare class MapsAccount extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_maps_account";
    /**
    * Generates CDKTF code for importing a MapsAccount resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MapsAccount to import
    * @param importFromId The id of the existing MapsAccount that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/maps_account#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MapsAccount to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/maps_account azurerm_maps_account} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MapsAccountConfig
    */
    constructor(scope: Construct, id: string, config: MapsAccountConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _localAuthenticationEnabled?;
    get localAuthenticationEnabled(): boolean | cdktf.IResolvable;
    set localAuthenticationEnabled(value: boolean | cdktf.IResolvable);
    resetLocalAuthenticationEnabled(): void;
    get localAuthenticationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get primaryAccessKey(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get secondaryAccessKey(): string;
    private _skuName?;
    get skuName(): string;
    set skuName(value: string);
    get skuNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get xMsClientId(): string;
    private _cors;
    get cors(): MapsAccountCorsOutputReference;
    putCors(value: MapsAccountCors): void;
    resetCors(): void;
    get corsInput(): MapsAccountCors | undefined;
    private _dataStore;
    get dataStore(): MapsAccountDataStoreList;
    putDataStore(value: MapsAccountDataStore[] | cdktf.IResolvable): void;
    resetDataStore(): void;
    get dataStoreInput(): cdktf.IResolvable | MapsAccountDataStore[] | undefined;
    private _identity;
    get identity(): MapsAccountIdentityOutputReference;
    putIdentity(value: MapsAccountIdentity): void;
    resetIdentity(): void;
    get identityInput(): MapsAccountIdentity | undefined;
    private _timeouts;
    get timeouts(): MapsAccountTimeoutsOutputReference;
    putTimeouts(value: MapsAccountTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MapsAccountTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
