/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkWatcherFlowLogConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/network_watcher_flow_log#enabled NetworkWatcherFlowLog#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/network_watcher_flow_log#id NetworkWatcherFlowLog#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/network_watcher_flow_log#location NetworkWatcherFlowLog#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/network_watcher_flow_log#name NetworkWatcherFlowLog#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/network_watcher_flow_log#network_security_group_id NetworkWatcherFlowLog#network_security_group_id}
    */
    readonly networkSecurityGroupId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/network_watcher_flow_log#network_watcher_name NetworkWatcherFlowLog#network_watcher_name}
    */
    readonly networkWatcherName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/network_watcher_flow_log#resource_group_name NetworkWatcherFlowLog#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/network_watcher_flow_log#storage_account_id NetworkWatcherFlowLog#storage_account_id}
    */
    readonly storageAccountId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/network_watcher_flow_log#tags NetworkWatcherFlowLog#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/network_watcher_flow_log#target_resource_id NetworkWatcherFlowLog#target_resource_id}
    */
    readonly targetResourceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/network_watcher_flow_log#version NetworkWatcherFlowLog#version}
    */
    readonly version?: number;
    /**
    * retention_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/network_watcher_flow_log#retention_policy NetworkWatcherFlowLog#retention_policy}
    */
    readonly retentionPolicy: NetworkWatcherFlowLogRetentionPolicy;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/network_watcher_flow_log#timeouts NetworkWatcherFlowLog#timeouts}
    */
    readonly timeouts?: NetworkWatcherFlowLogTimeouts;
    /**
    * traffic_analytics block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/network_watcher_flow_log#traffic_analytics NetworkWatcherFlowLog#traffic_analytics}
    */
    readonly trafficAnalytics?: NetworkWatcherFlowLogTrafficAnalytics;
}
export interface NetworkWatcherFlowLogRetentionPolicy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/network_watcher_flow_log#days NetworkWatcherFlowLog#days}
    */
    readonly days: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/network_watcher_flow_log#enabled NetworkWatcherFlowLog#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function networkWatcherFlowLogRetentionPolicyToTerraform(struct?: NetworkWatcherFlowLogRetentionPolicyOutputReference | NetworkWatcherFlowLogRetentionPolicy): any;
export declare function networkWatcherFlowLogRetentionPolicyToHclTerraform(struct?: NetworkWatcherFlowLogRetentionPolicyOutputReference | NetworkWatcherFlowLogRetentionPolicy): any;
export declare class NetworkWatcherFlowLogRetentionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkWatcherFlowLogRetentionPolicy | undefined;
    set internalValue(value: NetworkWatcherFlowLogRetentionPolicy | undefined);
    private _days?;
    get days(): number;
    set days(value: number);
    get daysInput(): number | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface NetworkWatcherFlowLogTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/network_watcher_flow_log#create NetworkWatcherFlowLog#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/network_watcher_flow_log#delete NetworkWatcherFlowLog#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/network_watcher_flow_log#read NetworkWatcherFlowLog#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/network_watcher_flow_log#update NetworkWatcherFlowLog#update}
    */
    readonly update?: string;
}
export declare function networkWatcherFlowLogTimeoutsToTerraform(struct?: NetworkWatcherFlowLogTimeouts | cdktf.IResolvable): any;
export declare function networkWatcherFlowLogTimeoutsToHclTerraform(struct?: NetworkWatcherFlowLogTimeouts | cdktf.IResolvable): any;
export declare class NetworkWatcherFlowLogTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkWatcherFlowLogTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: NetworkWatcherFlowLogTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface NetworkWatcherFlowLogTrafficAnalytics {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/network_watcher_flow_log#enabled NetworkWatcherFlowLog#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/network_watcher_flow_log#interval_in_minutes NetworkWatcherFlowLog#interval_in_minutes}
    */
    readonly intervalInMinutes?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/network_watcher_flow_log#workspace_id NetworkWatcherFlowLog#workspace_id}
    */
    readonly workspaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/network_watcher_flow_log#workspace_region NetworkWatcherFlowLog#workspace_region}
    */
    readonly workspaceRegion: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/network_watcher_flow_log#workspace_resource_id NetworkWatcherFlowLog#workspace_resource_id}
    */
    readonly workspaceResourceId: string;
}
export declare function networkWatcherFlowLogTrafficAnalyticsToTerraform(struct?: NetworkWatcherFlowLogTrafficAnalyticsOutputReference | NetworkWatcherFlowLogTrafficAnalytics): any;
export declare function networkWatcherFlowLogTrafficAnalyticsToHclTerraform(struct?: NetworkWatcherFlowLogTrafficAnalyticsOutputReference | NetworkWatcherFlowLogTrafficAnalytics): any;
export declare class NetworkWatcherFlowLogTrafficAnalyticsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkWatcherFlowLogTrafficAnalytics | undefined;
    set internalValue(value: NetworkWatcherFlowLogTrafficAnalytics | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _intervalInMinutes?;
    get intervalInMinutes(): number;
    set intervalInMinutes(value: number);
    resetIntervalInMinutes(): void;
    get intervalInMinutesInput(): number | undefined;
    private _workspaceId?;
    get workspaceId(): string;
    set workspaceId(value: string);
    get workspaceIdInput(): string | undefined;
    private _workspaceRegion?;
    get workspaceRegion(): string;
    set workspaceRegion(value: string);
    get workspaceRegionInput(): string | undefined;
    private _workspaceResourceId?;
    get workspaceResourceId(): string;
    set workspaceResourceId(value: string);
    get workspaceResourceIdInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/network_watcher_flow_log azurerm_network_watcher_flow_log}
*/
export declare class NetworkWatcherFlowLog extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_network_watcher_flow_log";
    /**
    * Generates CDKTF code for importing a NetworkWatcherFlowLog resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the NetworkWatcherFlowLog to import
    * @param importFromId The id of the existing NetworkWatcherFlowLog that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/network_watcher_flow_log#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the NetworkWatcherFlowLog to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/network_watcher_flow_log azurerm_network_watcher_flow_log} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkWatcherFlowLogConfig
    */
    constructor(scope: Construct, id: string, config: NetworkWatcherFlowLogConfig);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkSecurityGroupId?;
    get networkSecurityGroupId(): string;
    set networkSecurityGroupId(value: string);
    resetNetworkSecurityGroupId(): void;
    get networkSecurityGroupIdInput(): string | undefined;
    private _networkWatcherName?;
    get networkWatcherName(): string;
    set networkWatcherName(value: string);
    get networkWatcherNameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    get storageAccountIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _targetResourceId?;
    get targetResourceId(): string;
    set targetResourceId(value: string);
    resetTargetResourceId(): void;
    get targetResourceIdInput(): string | undefined;
    private _version?;
    get version(): number;
    set version(value: number);
    resetVersion(): void;
    get versionInput(): number | undefined;
    private _retentionPolicy;
    get retentionPolicy(): NetworkWatcherFlowLogRetentionPolicyOutputReference;
    putRetentionPolicy(value: NetworkWatcherFlowLogRetentionPolicy): void;
    get retentionPolicyInput(): NetworkWatcherFlowLogRetentionPolicy | undefined;
    private _timeouts;
    get timeouts(): NetworkWatcherFlowLogTimeoutsOutputReference;
    putTimeouts(value: NetworkWatcherFlowLogTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | NetworkWatcherFlowLogTimeouts | undefined;
    private _trafficAnalytics;
    get trafficAnalytics(): NetworkWatcherFlowLogTrafficAnalyticsOutputReference;
    putTrafficAnalytics(value: NetworkWatcherFlowLogTrafficAnalytics): void;
    resetTrafficAnalytics(): void;
    get trafficAnalyticsInput(): NetworkWatcherFlowLogTrafficAnalytics | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
