/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ResourceGroupCostManagementViewConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_cost_management_view#accumulated ResourceGroupCostManagementView#accumulated}
    */
    readonly accumulated: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_cost_management_view#chart_type ResourceGroupCostManagementView#chart_type}
    */
    readonly chartType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_cost_management_view#display_name ResourceGroupCostManagementView#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_cost_management_view#id ResourceGroupCostManagementView#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_cost_management_view#name ResourceGroupCostManagementView#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_cost_management_view#report_type ResourceGroupCostManagementView#report_type}
    */
    readonly reportType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_cost_management_view#resource_group_id ResourceGroupCostManagementView#resource_group_id}
    */
    readonly resourceGroupId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_cost_management_view#timeframe ResourceGroupCostManagementView#timeframe}
    */
    readonly timeframe: string;
    /**
    * dataset block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_cost_management_view#dataset ResourceGroupCostManagementView#dataset}
    */
    readonly dataset: ResourceGroupCostManagementViewDataset;
    /**
    * kpi block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_cost_management_view#kpi ResourceGroupCostManagementView#kpi}
    */
    readonly kpi?: ResourceGroupCostManagementViewKpi[] | cdktf.IResolvable;
    /**
    * pivot block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_cost_management_view#pivot ResourceGroupCostManagementView#pivot}
    */
    readonly pivot?: ResourceGroupCostManagementViewPivot[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_cost_management_view#timeouts ResourceGroupCostManagementView#timeouts}
    */
    readonly timeouts?: ResourceGroupCostManagementViewTimeouts;
}
export interface ResourceGroupCostManagementViewDatasetAggregation {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_cost_management_view#column_name ResourceGroupCostManagementView#column_name}
    */
    readonly columnName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_cost_management_view#name ResourceGroupCostManagementView#name}
    */
    readonly name: string;
}
export declare function resourceGroupCostManagementViewDatasetAggregationToTerraform(struct?: ResourceGroupCostManagementViewDatasetAggregation | cdktf.IResolvable): any;
export declare function resourceGroupCostManagementViewDatasetAggregationToHclTerraform(struct?: ResourceGroupCostManagementViewDatasetAggregation | cdktf.IResolvable): any;
export declare class ResourceGroupCostManagementViewDatasetAggregationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ResourceGroupCostManagementViewDatasetAggregation | cdktf.IResolvable | undefined;
    set internalValue(value: ResourceGroupCostManagementViewDatasetAggregation | cdktf.IResolvable | undefined);
    private _columnName?;
    get columnName(): string;
    set columnName(value: string);
    get columnNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class ResourceGroupCostManagementViewDatasetAggregationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ResourceGroupCostManagementViewDatasetAggregation[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ResourceGroupCostManagementViewDatasetAggregationOutputReference;
}
export interface ResourceGroupCostManagementViewDatasetGrouping {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_cost_management_view#name ResourceGroupCostManagementView#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_cost_management_view#type ResourceGroupCostManagementView#type}
    */
    readonly type: string;
}
export declare function resourceGroupCostManagementViewDatasetGroupingToTerraform(struct?: ResourceGroupCostManagementViewDatasetGrouping | cdktf.IResolvable): any;
export declare function resourceGroupCostManagementViewDatasetGroupingToHclTerraform(struct?: ResourceGroupCostManagementViewDatasetGrouping | cdktf.IResolvable): any;
export declare class ResourceGroupCostManagementViewDatasetGroupingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ResourceGroupCostManagementViewDatasetGrouping | cdktf.IResolvable | undefined;
    set internalValue(value: ResourceGroupCostManagementViewDatasetGrouping | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class ResourceGroupCostManagementViewDatasetGroupingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ResourceGroupCostManagementViewDatasetGrouping[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ResourceGroupCostManagementViewDatasetGroupingOutputReference;
}
export interface ResourceGroupCostManagementViewDatasetSorting {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_cost_management_view#direction ResourceGroupCostManagementView#direction}
    */
    readonly direction: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_cost_management_view#name ResourceGroupCostManagementView#name}
    */
    readonly name: string;
}
export declare function resourceGroupCostManagementViewDatasetSortingToTerraform(struct?: ResourceGroupCostManagementViewDatasetSorting | cdktf.IResolvable): any;
export declare function resourceGroupCostManagementViewDatasetSortingToHclTerraform(struct?: ResourceGroupCostManagementViewDatasetSorting | cdktf.IResolvable): any;
export declare class ResourceGroupCostManagementViewDatasetSortingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ResourceGroupCostManagementViewDatasetSorting | cdktf.IResolvable | undefined;
    set internalValue(value: ResourceGroupCostManagementViewDatasetSorting | cdktf.IResolvable | undefined);
    private _direction?;
    get direction(): string;
    set direction(value: string);
    get directionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class ResourceGroupCostManagementViewDatasetSortingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ResourceGroupCostManagementViewDatasetSorting[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ResourceGroupCostManagementViewDatasetSortingOutputReference;
}
export interface ResourceGroupCostManagementViewDataset {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_cost_management_view#granularity ResourceGroupCostManagementView#granularity}
    */
    readonly granularity: string;
    /**
    * aggregation block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_cost_management_view#aggregation ResourceGroupCostManagementView#aggregation}
    */
    readonly aggregation: ResourceGroupCostManagementViewDatasetAggregation[] | cdktf.IResolvable;
    /**
    * grouping block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_cost_management_view#grouping ResourceGroupCostManagementView#grouping}
    */
    readonly grouping?: ResourceGroupCostManagementViewDatasetGrouping[] | cdktf.IResolvable;
    /**
    * sorting block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_cost_management_view#sorting ResourceGroupCostManagementView#sorting}
    */
    readonly sorting?: ResourceGroupCostManagementViewDatasetSorting[] | cdktf.IResolvable;
}
export declare function resourceGroupCostManagementViewDatasetToTerraform(struct?: ResourceGroupCostManagementViewDatasetOutputReference | ResourceGroupCostManagementViewDataset): any;
export declare function resourceGroupCostManagementViewDatasetToHclTerraform(struct?: ResourceGroupCostManagementViewDatasetOutputReference | ResourceGroupCostManagementViewDataset): any;
export declare class ResourceGroupCostManagementViewDatasetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ResourceGroupCostManagementViewDataset | undefined;
    set internalValue(value: ResourceGroupCostManagementViewDataset | undefined);
    private _granularity?;
    get granularity(): string;
    set granularity(value: string);
    get granularityInput(): string | undefined;
    private _aggregation;
    get aggregation(): ResourceGroupCostManagementViewDatasetAggregationList;
    putAggregation(value: ResourceGroupCostManagementViewDatasetAggregation[] | cdktf.IResolvable): void;
    get aggregationInput(): cdktf.IResolvable | ResourceGroupCostManagementViewDatasetAggregation[] | undefined;
    private _grouping;
    get grouping(): ResourceGroupCostManagementViewDatasetGroupingList;
    putGrouping(value: ResourceGroupCostManagementViewDatasetGrouping[] | cdktf.IResolvable): void;
    resetGrouping(): void;
    get groupingInput(): cdktf.IResolvable | ResourceGroupCostManagementViewDatasetGrouping[] | undefined;
    private _sorting;
    get sorting(): ResourceGroupCostManagementViewDatasetSortingList;
    putSorting(value: ResourceGroupCostManagementViewDatasetSorting[] | cdktf.IResolvable): void;
    resetSorting(): void;
    get sortingInput(): cdktf.IResolvable | ResourceGroupCostManagementViewDatasetSorting[] | undefined;
}
export interface ResourceGroupCostManagementViewKpi {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_cost_management_view#type ResourceGroupCostManagementView#type}
    */
    readonly type: string;
}
export declare function resourceGroupCostManagementViewKpiToTerraform(struct?: ResourceGroupCostManagementViewKpi | cdktf.IResolvable): any;
export declare function resourceGroupCostManagementViewKpiToHclTerraform(struct?: ResourceGroupCostManagementViewKpi | cdktf.IResolvable): any;
export declare class ResourceGroupCostManagementViewKpiOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ResourceGroupCostManagementViewKpi | cdktf.IResolvable | undefined;
    set internalValue(value: ResourceGroupCostManagementViewKpi | cdktf.IResolvable | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class ResourceGroupCostManagementViewKpiList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ResourceGroupCostManagementViewKpi[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ResourceGroupCostManagementViewKpiOutputReference;
}
export interface ResourceGroupCostManagementViewPivot {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_cost_management_view#name ResourceGroupCostManagementView#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_cost_management_view#type ResourceGroupCostManagementView#type}
    */
    readonly type: string;
}
export declare function resourceGroupCostManagementViewPivotToTerraform(struct?: ResourceGroupCostManagementViewPivot | cdktf.IResolvable): any;
export declare function resourceGroupCostManagementViewPivotToHclTerraform(struct?: ResourceGroupCostManagementViewPivot | cdktf.IResolvable): any;
export declare class ResourceGroupCostManagementViewPivotOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ResourceGroupCostManagementViewPivot | cdktf.IResolvable | undefined;
    set internalValue(value: ResourceGroupCostManagementViewPivot | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class ResourceGroupCostManagementViewPivotList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ResourceGroupCostManagementViewPivot[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ResourceGroupCostManagementViewPivotOutputReference;
}
export interface ResourceGroupCostManagementViewTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_cost_management_view#create ResourceGroupCostManagementView#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_cost_management_view#delete ResourceGroupCostManagementView#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_cost_management_view#read ResourceGroupCostManagementView#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_cost_management_view#update ResourceGroupCostManagementView#update}
    */
    readonly update?: string;
}
export declare function resourceGroupCostManagementViewTimeoutsToTerraform(struct?: ResourceGroupCostManagementViewTimeouts | cdktf.IResolvable): any;
export declare function resourceGroupCostManagementViewTimeoutsToHclTerraform(struct?: ResourceGroupCostManagementViewTimeouts | cdktf.IResolvable): any;
export declare class ResourceGroupCostManagementViewTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ResourceGroupCostManagementViewTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ResourceGroupCostManagementViewTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_cost_management_view azurerm_resource_group_cost_management_view}
*/
export declare class ResourceGroupCostManagementView extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_resource_group_cost_management_view";
    /**
    * Generates CDKTF code for importing a ResourceGroupCostManagementView resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ResourceGroupCostManagementView to import
    * @param importFromId The id of the existing ResourceGroupCostManagementView that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_cost_management_view#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ResourceGroupCostManagementView to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_cost_management_view azurerm_resource_group_cost_management_view} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ResourceGroupCostManagementViewConfig
    */
    constructor(scope: Construct, id: string, config: ResourceGroupCostManagementViewConfig);
    private _accumulated?;
    get accumulated(): boolean | cdktf.IResolvable;
    set accumulated(value: boolean | cdktf.IResolvable);
    get accumulatedInput(): boolean | cdktf.IResolvable | undefined;
    private _chartType?;
    get chartType(): string;
    set chartType(value: string);
    get chartTypeInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _reportType?;
    get reportType(): string;
    set reportType(value: string);
    get reportTypeInput(): string | undefined;
    private _resourceGroupId?;
    get resourceGroupId(): string;
    set resourceGroupId(value: string);
    get resourceGroupIdInput(): string | undefined;
    private _timeframe?;
    get timeframe(): string;
    set timeframe(value: string);
    get timeframeInput(): string | undefined;
    private _dataset;
    get dataset(): ResourceGroupCostManagementViewDatasetOutputReference;
    putDataset(value: ResourceGroupCostManagementViewDataset): void;
    get datasetInput(): ResourceGroupCostManagementViewDataset | undefined;
    private _kpi;
    get kpi(): ResourceGroupCostManagementViewKpiList;
    putKpi(value: ResourceGroupCostManagementViewKpi[] | cdktf.IResolvable): void;
    resetKpi(): void;
    get kpiInput(): cdktf.IResolvable | ResourceGroupCostManagementViewKpi[] | undefined;
    private _pivot;
    get pivot(): ResourceGroupCostManagementViewPivotList;
    putPivot(value: ResourceGroupCostManagementViewPivot[] | cdktf.IResolvable): void;
    resetPivot(): void;
    get pivotInput(): cdktf.IResolvable | ResourceGroupCostManagementViewPivot[] | undefined;
    private _timeouts;
    get timeouts(): ResourceGroupCostManagementViewTimeoutsOutputReference;
    putTimeouts(value: ResourceGroupCostManagementViewTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ResourceGroupCostManagementViewTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
