/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ResourceGroupPolicyExemptionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_policy_exemption#description ResourceGroupPolicyExemption#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_policy_exemption#display_name ResourceGroupPolicyExemption#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_policy_exemption#exemption_category ResourceGroupPolicyExemption#exemption_category}
    */
    readonly exemptionCategory: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_policy_exemption#expires_on ResourceGroupPolicyExemption#expires_on}
    */
    readonly expiresOn?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_policy_exemption#id ResourceGroupPolicyExemption#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_policy_exemption#metadata ResourceGroupPolicyExemption#metadata}
    */
    readonly metadata?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_policy_exemption#name ResourceGroupPolicyExemption#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_policy_exemption#policy_assignment_id ResourceGroupPolicyExemption#policy_assignment_id}
    */
    readonly policyAssignmentId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_policy_exemption#policy_definition_reference_ids ResourceGroupPolicyExemption#policy_definition_reference_ids}
    */
    readonly policyDefinitionReferenceIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_policy_exemption#resource_group_id ResourceGroupPolicyExemption#resource_group_id}
    */
    readonly resourceGroupId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_policy_exemption#timeouts ResourceGroupPolicyExemption#timeouts}
    */
    readonly timeouts?: ResourceGroupPolicyExemptionTimeouts;
}
export interface ResourceGroupPolicyExemptionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_policy_exemption#create ResourceGroupPolicyExemption#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_policy_exemption#delete ResourceGroupPolicyExemption#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_policy_exemption#read ResourceGroupPolicyExemption#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_policy_exemption#update ResourceGroupPolicyExemption#update}
    */
    readonly update?: string;
}
export declare function resourceGroupPolicyExemptionTimeoutsToTerraform(struct?: ResourceGroupPolicyExemptionTimeouts | cdktf.IResolvable): any;
export declare function resourceGroupPolicyExemptionTimeoutsToHclTerraform(struct?: ResourceGroupPolicyExemptionTimeouts | cdktf.IResolvable): any;
export declare class ResourceGroupPolicyExemptionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ResourceGroupPolicyExemptionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ResourceGroupPolicyExemptionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_policy_exemption azurerm_resource_group_policy_exemption}
*/
export declare class ResourceGroupPolicyExemption extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_resource_group_policy_exemption";
    /**
    * Generates CDKTF code for importing a ResourceGroupPolicyExemption resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ResourceGroupPolicyExemption to import
    * @param importFromId The id of the existing ResourceGroupPolicyExemption that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_policy_exemption#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ResourceGroupPolicyExemption to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/resource_group_policy_exemption azurerm_resource_group_policy_exemption} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ResourceGroupPolicyExemptionConfig
    */
    constructor(scope: Construct, id: string, config: ResourceGroupPolicyExemptionConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _exemptionCategory?;
    get exemptionCategory(): string;
    set exemptionCategory(value: string);
    get exemptionCategoryInput(): string | undefined;
    private _expiresOn?;
    get expiresOn(): string;
    set expiresOn(value: string);
    resetExpiresOn(): void;
    get expiresOnInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metadata?;
    get metadata(): string;
    set metadata(value: string);
    resetMetadata(): void;
    get metadataInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _policyAssignmentId?;
    get policyAssignmentId(): string;
    set policyAssignmentId(value: string);
    get policyAssignmentIdInput(): string | undefined;
    private _policyDefinitionReferenceIds?;
    get policyDefinitionReferenceIds(): string[];
    set policyDefinitionReferenceIds(value: string[]);
    resetPolicyDefinitionReferenceIds(): void;
    get policyDefinitionReferenceIdsInput(): string[] | undefined;
    private _resourceGroupId?;
    get resourceGroupId(): string;
    set resourceGroupId(value: string);
    get resourceGroupIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): ResourceGroupPolicyExemptionTimeoutsOutputReference;
    putTimeouts(value: ResourceGroupPolicyExemptionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ResourceGroupPolicyExemptionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
