/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServicebusTopicConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/servicebus_topic#auto_delete_on_idle ServicebusTopic#auto_delete_on_idle}
    */
    readonly autoDeleteOnIdle?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/servicebus_topic#batched_operations_enabled ServicebusTopic#batched_operations_enabled}
    */
    readonly batchedOperationsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/servicebus_topic#default_message_ttl ServicebusTopic#default_message_ttl}
    */
    readonly defaultMessageTtl?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/servicebus_topic#duplicate_detection_history_time_window ServicebusTopic#duplicate_detection_history_time_window}
    */
    readonly duplicateDetectionHistoryTimeWindow?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/servicebus_topic#express_enabled ServicebusTopic#express_enabled}
    */
    readonly expressEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/servicebus_topic#id ServicebusTopic#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/servicebus_topic#max_message_size_in_kilobytes ServicebusTopic#max_message_size_in_kilobytes}
    */
    readonly maxMessageSizeInKilobytes?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/servicebus_topic#max_size_in_megabytes ServicebusTopic#max_size_in_megabytes}
    */
    readonly maxSizeInMegabytes?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/servicebus_topic#name ServicebusTopic#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/servicebus_topic#namespace_id ServicebusTopic#namespace_id}
    */
    readonly namespaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/servicebus_topic#partitioning_enabled ServicebusTopic#partitioning_enabled}
    */
    readonly partitioningEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/servicebus_topic#requires_duplicate_detection ServicebusTopic#requires_duplicate_detection}
    */
    readonly requiresDuplicateDetection?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/servicebus_topic#status ServicebusTopic#status}
    */
    readonly status?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/servicebus_topic#support_ordering ServicebusTopic#support_ordering}
    */
    readonly supportOrdering?: boolean | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/servicebus_topic#timeouts ServicebusTopic#timeouts}
    */
    readonly timeouts?: ServicebusTopicTimeouts;
}
export interface ServicebusTopicTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/servicebus_topic#create ServicebusTopic#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/servicebus_topic#delete ServicebusTopic#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/servicebus_topic#read ServicebusTopic#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/servicebus_topic#update ServicebusTopic#update}
    */
    readonly update?: string;
}
export declare function servicebusTopicTimeoutsToTerraform(struct?: ServicebusTopicTimeouts | cdktf.IResolvable): any;
export declare function servicebusTopicTimeoutsToHclTerraform(struct?: ServicebusTopicTimeouts | cdktf.IResolvable): any;
export declare class ServicebusTopicTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServicebusTopicTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ServicebusTopicTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/servicebus_topic azurerm_servicebus_topic}
*/
export declare class ServicebusTopic extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_servicebus_topic";
    /**
    * Generates CDKTF code for importing a ServicebusTopic resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ServicebusTopic to import
    * @param importFromId The id of the existing ServicebusTopic that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/servicebus_topic#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ServicebusTopic to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/servicebus_topic azurerm_servicebus_topic} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServicebusTopicConfig
    */
    constructor(scope: Construct, id: string, config: ServicebusTopicConfig);
    private _autoDeleteOnIdle?;
    get autoDeleteOnIdle(): string;
    set autoDeleteOnIdle(value: string);
    resetAutoDeleteOnIdle(): void;
    get autoDeleteOnIdleInput(): string | undefined;
    private _batchedOperationsEnabled?;
    get batchedOperationsEnabled(): boolean | cdktf.IResolvable;
    set batchedOperationsEnabled(value: boolean | cdktf.IResolvable);
    resetBatchedOperationsEnabled(): void;
    get batchedOperationsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _defaultMessageTtl?;
    get defaultMessageTtl(): string;
    set defaultMessageTtl(value: string);
    resetDefaultMessageTtl(): void;
    get defaultMessageTtlInput(): string | undefined;
    private _duplicateDetectionHistoryTimeWindow?;
    get duplicateDetectionHistoryTimeWindow(): string;
    set duplicateDetectionHistoryTimeWindow(value: string);
    resetDuplicateDetectionHistoryTimeWindow(): void;
    get duplicateDetectionHistoryTimeWindowInput(): string | undefined;
    private _expressEnabled?;
    get expressEnabled(): boolean | cdktf.IResolvable;
    set expressEnabled(value: boolean | cdktf.IResolvable);
    resetExpressEnabled(): void;
    get expressEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _maxMessageSizeInKilobytes?;
    get maxMessageSizeInKilobytes(): number;
    set maxMessageSizeInKilobytes(value: number);
    resetMaxMessageSizeInKilobytes(): void;
    get maxMessageSizeInKilobytesInput(): number | undefined;
    private _maxSizeInMegabytes?;
    get maxSizeInMegabytes(): number;
    set maxSizeInMegabytes(value: number);
    resetMaxSizeInMegabytes(): void;
    get maxSizeInMegabytesInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespaceId?;
    get namespaceId(): string;
    set namespaceId(value: string);
    get namespaceIdInput(): string | undefined;
    private _partitioningEnabled?;
    get partitioningEnabled(): boolean | cdktf.IResolvable;
    set partitioningEnabled(value: boolean | cdktf.IResolvable);
    resetPartitioningEnabled(): void;
    get partitioningEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _requiresDuplicateDetection?;
    get requiresDuplicateDetection(): boolean | cdktf.IResolvable;
    set requiresDuplicateDetection(value: boolean | cdktf.IResolvable);
    resetRequiresDuplicateDetection(): void;
    get requiresDuplicateDetectionInput(): boolean | cdktf.IResolvable | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _supportOrdering?;
    get supportOrdering(): boolean | cdktf.IResolvable;
    set supportOrdering(value: boolean | cdktf.IResolvable);
    resetSupportOrdering(): void;
    get supportOrderingInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    get timeouts(): ServicebusTopicTimeoutsOutputReference;
    putTimeouts(value: ServicebusTopicTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ServicebusTopicTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
