/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SharedImageConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/shared_image#accelerated_network_support_enabled SharedImage#accelerated_network_support_enabled}
    */
    readonly acceleratedNetworkSupportEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/shared_image#architecture SharedImage#architecture}
    */
    readonly architecture?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/shared_image#confidential_vm_enabled SharedImage#confidential_vm_enabled}
    */
    readonly confidentialVmEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/shared_image#confidential_vm_supported SharedImage#confidential_vm_supported}
    */
    readonly confidentialVmSupported?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/shared_image#description SharedImage#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/shared_image#disk_controller_type_nvme_enabled SharedImage#disk_controller_type_nvme_enabled}
    */
    readonly diskControllerTypeNvmeEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/shared_image#disk_types_not_allowed SharedImage#disk_types_not_allowed}
    */
    readonly diskTypesNotAllowed?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/shared_image#end_of_life_date SharedImage#end_of_life_date}
    */
    readonly endOfLifeDate?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/shared_image#eula SharedImage#eula}
    */
    readonly eula?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/shared_image#gallery_name SharedImage#gallery_name}
    */
    readonly galleryName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/shared_image#hibernation_enabled SharedImage#hibernation_enabled}
    */
    readonly hibernationEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/shared_image#hyper_v_generation SharedImage#hyper_v_generation}
    */
    readonly hyperVGeneration?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/shared_image#id SharedImage#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/shared_image#location SharedImage#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/shared_image#max_recommended_memory_in_gb SharedImage#max_recommended_memory_in_gb}
    */
    readonly maxRecommendedMemoryInGb?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/shared_image#max_recommended_vcpu_count SharedImage#max_recommended_vcpu_count}
    */
    readonly maxRecommendedVcpuCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/shared_image#min_recommended_memory_in_gb SharedImage#min_recommended_memory_in_gb}
    */
    readonly minRecommendedMemoryInGb?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/shared_image#min_recommended_vcpu_count SharedImage#min_recommended_vcpu_count}
    */
    readonly minRecommendedVcpuCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/shared_image#name SharedImage#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/shared_image#os_type SharedImage#os_type}
    */
    readonly osType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/shared_image#privacy_statement_uri SharedImage#privacy_statement_uri}
    */
    readonly privacyStatementUri?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/shared_image#release_note_uri SharedImage#release_note_uri}
    */
    readonly releaseNoteUri?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/shared_image#resource_group_name SharedImage#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/shared_image#specialized SharedImage#specialized}
    */
    readonly specialized?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/shared_image#tags SharedImage#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/shared_image#trusted_launch_enabled SharedImage#trusted_launch_enabled}
    */
    readonly trustedLaunchEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/shared_image#trusted_launch_supported SharedImage#trusted_launch_supported}
    */
    readonly trustedLaunchSupported?: boolean | cdktf.IResolvable;
    /**
    * identifier block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/shared_image#identifier SharedImage#identifier}
    */
    readonly identifier: SharedImageIdentifier;
    /**
    * purchase_plan block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/shared_image#purchase_plan SharedImage#purchase_plan}
    */
    readonly purchasePlan?: SharedImagePurchasePlan;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/shared_image#timeouts SharedImage#timeouts}
    */
    readonly timeouts?: SharedImageTimeouts;
}
export interface SharedImageIdentifier {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/shared_image#offer SharedImage#offer}
    */
    readonly offer: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/shared_image#publisher SharedImage#publisher}
    */
    readonly publisher: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/shared_image#sku SharedImage#sku}
    */
    readonly sku: string;
}
export declare function sharedImageIdentifierToTerraform(struct?: SharedImageIdentifierOutputReference | SharedImageIdentifier): any;
export declare function sharedImageIdentifierToHclTerraform(struct?: SharedImageIdentifierOutputReference | SharedImageIdentifier): any;
export declare class SharedImageIdentifierOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SharedImageIdentifier | undefined;
    set internalValue(value: SharedImageIdentifier | undefined);
    private _offer?;
    get offer(): string;
    set offer(value: string);
    get offerInput(): string | undefined;
    private _publisher?;
    get publisher(): string;
    set publisher(value: string);
    get publisherInput(): string | undefined;
    private _sku?;
    get sku(): string;
    set sku(value: string);
    get skuInput(): string | undefined;
}
export interface SharedImagePurchasePlan {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/shared_image#name SharedImage#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/shared_image#product SharedImage#product}
    */
    readonly product?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/shared_image#publisher SharedImage#publisher}
    */
    readonly publisher?: string;
}
export declare function sharedImagePurchasePlanToTerraform(struct?: SharedImagePurchasePlanOutputReference | SharedImagePurchasePlan): any;
export declare function sharedImagePurchasePlanToHclTerraform(struct?: SharedImagePurchasePlanOutputReference | SharedImagePurchasePlan): any;
export declare class SharedImagePurchasePlanOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SharedImagePurchasePlan | undefined;
    set internalValue(value: SharedImagePurchasePlan | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _product?;
    get product(): string;
    set product(value: string);
    resetProduct(): void;
    get productInput(): string | undefined;
    private _publisher?;
    get publisher(): string;
    set publisher(value: string);
    resetPublisher(): void;
    get publisherInput(): string | undefined;
}
export interface SharedImageTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/shared_image#create SharedImage#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/shared_image#delete SharedImage#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/shared_image#read SharedImage#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/shared_image#update SharedImage#update}
    */
    readonly update?: string;
}
export declare function sharedImageTimeoutsToTerraform(struct?: SharedImageTimeouts | cdktf.IResolvable): any;
export declare function sharedImageTimeoutsToHclTerraform(struct?: SharedImageTimeouts | cdktf.IResolvable): any;
export declare class SharedImageTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SharedImageTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SharedImageTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/shared_image azurerm_shared_image}
*/
export declare class SharedImage extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_shared_image";
    /**
    * Generates CDKTF code for importing a SharedImage resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SharedImage to import
    * @param importFromId The id of the existing SharedImage that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/shared_image#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SharedImage to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/shared_image azurerm_shared_image} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SharedImageConfig
    */
    constructor(scope: Construct, id: string, config: SharedImageConfig);
    private _acceleratedNetworkSupportEnabled?;
    get acceleratedNetworkSupportEnabled(): boolean | cdktf.IResolvable;
    set acceleratedNetworkSupportEnabled(value: boolean | cdktf.IResolvable);
    resetAcceleratedNetworkSupportEnabled(): void;
    get acceleratedNetworkSupportEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _architecture?;
    get architecture(): string;
    set architecture(value: string);
    resetArchitecture(): void;
    get architectureInput(): string | undefined;
    private _confidentialVmEnabled?;
    get confidentialVmEnabled(): boolean | cdktf.IResolvable;
    set confidentialVmEnabled(value: boolean | cdktf.IResolvable);
    resetConfidentialVmEnabled(): void;
    get confidentialVmEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _confidentialVmSupported?;
    get confidentialVmSupported(): boolean | cdktf.IResolvable;
    set confidentialVmSupported(value: boolean | cdktf.IResolvable);
    resetConfidentialVmSupported(): void;
    get confidentialVmSupportedInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _diskControllerTypeNvmeEnabled?;
    get diskControllerTypeNvmeEnabled(): boolean | cdktf.IResolvable;
    set diskControllerTypeNvmeEnabled(value: boolean | cdktf.IResolvable);
    resetDiskControllerTypeNvmeEnabled(): void;
    get diskControllerTypeNvmeEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _diskTypesNotAllowed?;
    get diskTypesNotAllowed(): string[];
    set diskTypesNotAllowed(value: string[]);
    resetDiskTypesNotAllowed(): void;
    get diskTypesNotAllowedInput(): string[] | undefined;
    private _endOfLifeDate?;
    get endOfLifeDate(): string;
    set endOfLifeDate(value: string);
    resetEndOfLifeDate(): void;
    get endOfLifeDateInput(): string | undefined;
    private _eula?;
    get eula(): string;
    set eula(value: string);
    resetEula(): void;
    get eulaInput(): string | undefined;
    private _galleryName?;
    get galleryName(): string;
    set galleryName(value: string);
    get galleryNameInput(): string | undefined;
    private _hibernationEnabled?;
    get hibernationEnabled(): boolean | cdktf.IResolvable;
    set hibernationEnabled(value: boolean | cdktf.IResolvable);
    resetHibernationEnabled(): void;
    get hibernationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _hyperVGeneration?;
    get hyperVGeneration(): string;
    set hyperVGeneration(value: string);
    resetHyperVGeneration(): void;
    get hyperVGenerationInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _maxRecommendedMemoryInGb?;
    get maxRecommendedMemoryInGb(): number;
    set maxRecommendedMemoryInGb(value: number);
    resetMaxRecommendedMemoryInGb(): void;
    get maxRecommendedMemoryInGbInput(): number | undefined;
    private _maxRecommendedVcpuCount?;
    get maxRecommendedVcpuCount(): number;
    set maxRecommendedVcpuCount(value: number);
    resetMaxRecommendedVcpuCount(): void;
    get maxRecommendedVcpuCountInput(): number | undefined;
    private _minRecommendedMemoryInGb?;
    get minRecommendedMemoryInGb(): number;
    set minRecommendedMemoryInGb(value: number);
    resetMinRecommendedMemoryInGb(): void;
    get minRecommendedMemoryInGbInput(): number | undefined;
    private _minRecommendedVcpuCount?;
    get minRecommendedVcpuCount(): number;
    set minRecommendedVcpuCount(value: number);
    resetMinRecommendedVcpuCount(): void;
    get minRecommendedVcpuCountInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _osType?;
    get osType(): string;
    set osType(value: string);
    get osTypeInput(): string | undefined;
    private _privacyStatementUri?;
    get privacyStatementUri(): string;
    set privacyStatementUri(value: string);
    resetPrivacyStatementUri(): void;
    get privacyStatementUriInput(): string | undefined;
    private _releaseNoteUri?;
    get releaseNoteUri(): string;
    set releaseNoteUri(value: string);
    resetReleaseNoteUri(): void;
    get releaseNoteUriInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _specialized?;
    get specialized(): boolean | cdktf.IResolvable;
    set specialized(value: boolean | cdktf.IResolvable);
    resetSpecialized(): void;
    get specializedInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _trustedLaunchEnabled?;
    get trustedLaunchEnabled(): boolean | cdktf.IResolvable;
    set trustedLaunchEnabled(value: boolean | cdktf.IResolvable);
    resetTrustedLaunchEnabled(): void;
    get trustedLaunchEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _trustedLaunchSupported?;
    get trustedLaunchSupported(): boolean | cdktf.IResolvable;
    set trustedLaunchSupported(value: boolean | cdktf.IResolvable);
    resetTrustedLaunchSupported(): void;
    get trustedLaunchSupportedInput(): boolean | cdktf.IResolvable | undefined;
    private _identifier;
    get identifier(): SharedImageIdentifierOutputReference;
    putIdentifier(value: SharedImageIdentifier): void;
    get identifierInput(): SharedImageIdentifier | undefined;
    private _purchasePlan;
    get purchasePlan(): SharedImagePurchasePlanOutputReference;
    putPurchasePlan(value: SharedImagePurchasePlan): void;
    resetPurchasePlan(): void;
    get purchasePlanInput(): SharedImagePurchasePlan | undefined;
    private _timeouts;
    get timeouts(): SharedImageTimeoutsOutputReference;
    putTimeouts(value: SharedImageTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SharedImageTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
