/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StackHciDeploymentSettingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#arc_resource_ids StackHciDeploymentSetting#arc_resource_ids}
    */
    readonly arcResourceIds: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#id StackHciDeploymentSetting#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#stack_hci_cluster_id StackHciDeploymentSetting#stack_hci_cluster_id}
    */
    readonly stackHciClusterId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#version StackHciDeploymentSetting#version}
    */
    readonly version: string;
    /**
    * scale_unit block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#scale_unit StackHciDeploymentSetting#scale_unit}
    */
    readonly scaleUnit: StackHciDeploymentSettingScaleUnit[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#timeouts StackHciDeploymentSetting#timeouts}
    */
    readonly timeouts?: StackHciDeploymentSettingTimeouts;
}
export interface StackHciDeploymentSettingScaleUnitCluster {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#azure_service_endpoint StackHciDeploymentSetting#azure_service_endpoint}
    */
    readonly azureServiceEndpoint: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#cloud_account_name StackHciDeploymentSetting#cloud_account_name}
    */
    readonly cloudAccountName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#name StackHciDeploymentSetting#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#witness_path StackHciDeploymentSetting#witness_path}
    */
    readonly witnessPath: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#witness_type StackHciDeploymentSetting#witness_type}
    */
    readonly witnessType: string;
}
export declare function stackHciDeploymentSettingScaleUnitClusterToTerraform(struct?: StackHciDeploymentSettingScaleUnitClusterOutputReference | StackHciDeploymentSettingScaleUnitCluster): any;
export declare function stackHciDeploymentSettingScaleUnitClusterToHclTerraform(struct?: StackHciDeploymentSettingScaleUnitClusterOutputReference | StackHciDeploymentSettingScaleUnitCluster): any;
export declare class StackHciDeploymentSettingScaleUnitClusterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StackHciDeploymentSettingScaleUnitCluster | undefined;
    set internalValue(value: StackHciDeploymentSettingScaleUnitCluster | undefined);
    private _azureServiceEndpoint?;
    get azureServiceEndpoint(): string;
    set azureServiceEndpoint(value: string);
    get azureServiceEndpointInput(): string | undefined;
    private _cloudAccountName?;
    get cloudAccountName(): string;
    set cloudAccountName(value: string);
    get cloudAccountNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _witnessPath?;
    get witnessPath(): string;
    set witnessPath(value: string);
    get witnessPathInput(): string | undefined;
    private _witnessType?;
    get witnessType(): string;
    set witnessType(value: string);
    get witnessTypeInput(): string | undefined;
}
export interface StackHciDeploymentSettingScaleUnitHostNetworkIntentAdapterPropertyOverride {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#jumbo_packet StackHciDeploymentSetting#jumbo_packet}
    */
    readonly jumboPacket?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#network_direct StackHciDeploymentSetting#network_direct}
    */
    readonly networkDirect?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#network_direct_technology StackHciDeploymentSetting#network_direct_technology}
    */
    readonly networkDirectTechnology?: string;
}
export declare function stackHciDeploymentSettingScaleUnitHostNetworkIntentAdapterPropertyOverrideToTerraform(struct?: StackHciDeploymentSettingScaleUnitHostNetworkIntentAdapterPropertyOverrideOutputReference | StackHciDeploymentSettingScaleUnitHostNetworkIntentAdapterPropertyOverride): any;
export declare function stackHciDeploymentSettingScaleUnitHostNetworkIntentAdapterPropertyOverrideToHclTerraform(struct?: StackHciDeploymentSettingScaleUnitHostNetworkIntentAdapterPropertyOverrideOutputReference | StackHciDeploymentSettingScaleUnitHostNetworkIntentAdapterPropertyOverride): any;
export declare class StackHciDeploymentSettingScaleUnitHostNetworkIntentAdapterPropertyOverrideOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StackHciDeploymentSettingScaleUnitHostNetworkIntentAdapterPropertyOverride | undefined;
    set internalValue(value: StackHciDeploymentSettingScaleUnitHostNetworkIntentAdapterPropertyOverride | undefined);
    private _jumboPacket?;
    get jumboPacket(): string;
    set jumboPacket(value: string);
    resetJumboPacket(): void;
    get jumboPacketInput(): string | undefined;
    private _networkDirect?;
    get networkDirect(): string;
    set networkDirect(value: string);
    resetNetworkDirect(): void;
    get networkDirectInput(): string | undefined;
    private _networkDirectTechnology?;
    get networkDirectTechnology(): string;
    set networkDirectTechnology(value: string);
    resetNetworkDirectTechnology(): void;
    get networkDirectTechnologyInput(): string | undefined;
}
export interface StackHciDeploymentSettingScaleUnitHostNetworkIntentQosPolicyOverride {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#bandwidth_percentage_smb StackHciDeploymentSetting#bandwidth_percentage_smb}
    */
    readonly bandwidthPercentageSmb?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#priority_value8021_action_cluster StackHciDeploymentSetting#priority_value8021_action_cluster}
    */
    readonly priorityValue8021ActionCluster?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#priority_value8021_action_smb StackHciDeploymentSetting#priority_value8021_action_smb}
    */
    readonly priorityValue8021ActionSmb?: string;
}
export declare function stackHciDeploymentSettingScaleUnitHostNetworkIntentQosPolicyOverrideToTerraform(struct?: StackHciDeploymentSettingScaleUnitHostNetworkIntentQosPolicyOverrideOutputReference | StackHciDeploymentSettingScaleUnitHostNetworkIntentQosPolicyOverride): any;
export declare function stackHciDeploymentSettingScaleUnitHostNetworkIntentQosPolicyOverrideToHclTerraform(struct?: StackHciDeploymentSettingScaleUnitHostNetworkIntentQosPolicyOverrideOutputReference | StackHciDeploymentSettingScaleUnitHostNetworkIntentQosPolicyOverride): any;
export declare class StackHciDeploymentSettingScaleUnitHostNetworkIntentQosPolicyOverrideOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StackHciDeploymentSettingScaleUnitHostNetworkIntentQosPolicyOverride | undefined;
    set internalValue(value: StackHciDeploymentSettingScaleUnitHostNetworkIntentQosPolicyOverride | undefined);
    private _bandwidthPercentageSmb?;
    get bandwidthPercentageSmb(): string;
    set bandwidthPercentageSmb(value: string);
    resetBandwidthPercentageSmb(): void;
    get bandwidthPercentageSmbInput(): string | undefined;
    private _priorityValue8021ActionCluster?;
    get priorityValue8021ActionCluster(): string;
    set priorityValue8021ActionCluster(value: string);
    resetPriorityValue8021ActionCluster(): void;
    get priorityValue8021ActionClusterInput(): string | undefined;
    private _priorityValue8021ActionSmb?;
    get priorityValue8021ActionSmb(): string;
    set priorityValue8021ActionSmb(value: string);
    resetPriorityValue8021ActionSmb(): void;
    get priorityValue8021ActionSmbInput(): string | undefined;
}
export interface StackHciDeploymentSettingScaleUnitHostNetworkIntentVirtualSwitchConfigurationOverride {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#enable_iov StackHciDeploymentSetting#enable_iov}
    */
    readonly enableIov?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#load_balancing_algorithm StackHciDeploymentSetting#load_balancing_algorithm}
    */
    readonly loadBalancingAlgorithm?: string;
}
export declare function stackHciDeploymentSettingScaleUnitHostNetworkIntentVirtualSwitchConfigurationOverrideToTerraform(struct?: StackHciDeploymentSettingScaleUnitHostNetworkIntentVirtualSwitchConfigurationOverrideOutputReference | StackHciDeploymentSettingScaleUnitHostNetworkIntentVirtualSwitchConfigurationOverride): any;
export declare function stackHciDeploymentSettingScaleUnitHostNetworkIntentVirtualSwitchConfigurationOverrideToHclTerraform(struct?: StackHciDeploymentSettingScaleUnitHostNetworkIntentVirtualSwitchConfigurationOverrideOutputReference | StackHciDeploymentSettingScaleUnitHostNetworkIntentVirtualSwitchConfigurationOverride): any;
export declare class StackHciDeploymentSettingScaleUnitHostNetworkIntentVirtualSwitchConfigurationOverrideOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StackHciDeploymentSettingScaleUnitHostNetworkIntentVirtualSwitchConfigurationOverride | undefined;
    set internalValue(value: StackHciDeploymentSettingScaleUnitHostNetworkIntentVirtualSwitchConfigurationOverride | undefined);
    private _enableIov?;
    get enableIov(): string;
    set enableIov(value: string);
    resetEnableIov(): void;
    get enableIovInput(): string | undefined;
    private _loadBalancingAlgorithm?;
    get loadBalancingAlgorithm(): string;
    set loadBalancingAlgorithm(value: string);
    resetLoadBalancingAlgorithm(): void;
    get loadBalancingAlgorithmInput(): string | undefined;
}
export interface StackHciDeploymentSettingScaleUnitHostNetworkIntent {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#adapter StackHciDeploymentSetting#adapter}
    */
    readonly adapter: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#adapter_property_override_enabled StackHciDeploymentSetting#adapter_property_override_enabled}
    */
    readonly adapterPropertyOverrideEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#name StackHciDeploymentSetting#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#qos_policy_override_enabled StackHciDeploymentSetting#qos_policy_override_enabled}
    */
    readonly qosPolicyOverrideEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#traffic_type StackHciDeploymentSetting#traffic_type}
    */
    readonly trafficType: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#virtual_switch_configuration_override_enabled StackHciDeploymentSetting#virtual_switch_configuration_override_enabled}
    */
    readonly virtualSwitchConfigurationOverrideEnabled?: boolean | cdktf.IResolvable;
    /**
    * adapter_property_override block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#adapter_property_override StackHciDeploymentSetting#adapter_property_override}
    */
    readonly adapterPropertyOverride?: StackHciDeploymentSettingScaleUnitHostNetworkIntentAdapterPropertyOverride;
    /**
    * qos_policy_override block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#qos_policy_override StackHciDeploymentSetting#qos_policy_override}
    */
    readonly qosPolicyOverride?: StackHciDeploymentSettingScaleUnitHostNetworkIntentQosPolicyOverride;
    /**
    * virtual_switch_configuration_override block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#virtual_switch_configuration_override StackHciDeploymentSetting#virtual_switch_configuration_override}
    */
    readonly virtualSwitchConfigurationOverride?: StackHciDeploymentSettingScaleUnitHostNetworkIntentVirtualSwitchConfigurationOverride;
}
export declare function stackHciDeploymentSettingScaleUnitHostNetworkIntentToTerraform(struct?: StackHciDeploymentSettingScaleUnitHostNetworkIntent | cdktf.IResolvable): any;
export declare function stackHciDeploymentSettingScaleUnitHostNetworkIntentToHclTerraform(struct?: StackHciDeploymentSettingScaleUnitHostNetworkIntent | cdktf.IResolvable): any;
export declare class StackHciDeploymentSettingScaleUnitHostNetworkIntentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StackHciDeploymentSettingScaleUnitHostNetworkIntent | cdktf.IResolvable | undefined;
    set internalValue(value: StackHciDeploymentSettingScaleUnitHostNetworkIntent | cdktf.IResolvable | undefined);
    private _adapter?;
    get adapter(): string[];
    set adapter(value: string[]);
    get adapterInput(): string[] | undefined;
    private _adapterPropertyOverrideEnabled?;
    get adapterPropertyOverrideEnabled(): boolean | cdktf.IResolvable;
    set adapterPropertyOverrideEnabled(value: boolean | cdktf.IResolvable);
    resetAdapterPropertyOverrideEnabled(): void;
    get adapterPropertyOverrideEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _qosPolicyOverrideEnabled?;
    get qosPolicyOverrideEnabled(): boolean | cdktf.IResolvable;
    set qosPolicyOverrideEnabled(value: boolean | cdktf.IResolvable);
    resetQosPolicyOverrideEnabled(): void;
    get qosPolicyOverrideEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _trafficType?;
    get trafficType(): string[];
    set trafficType(value: string[]);
    get trafficTypeInput(): string[] | undefined;
    private _virtualSwitchConfigurationOverrideEnabled?;
    get virtualSwitchConfigurationOverrideEnabled(): boolean | cdktf.IResolvable;
    set virtualSwitchConfigurationOverrideEnabled(value: boolean | cdktf.IResolvable);
    resetVirtualSwitchConfigurationOverrideEnabled(): void;
    get virtualSwitchConfigurationOverrideEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _adapterPropertyOverride;
    get adapterPropertyOverride(): StackHciDeploymentSettingScaleUnitHostNetworkIntentAdapterPropertyOverrideOutputReference;
    putAdapterPropertyOverride(value: StackHciDeploymentSettingScaleUnitHostNetworkIntentAdapterPropertyOverride): void;
    resetAdapterPropertyOverride(): void;
    get adapterPropertyOverrideInput(): StackHciDeploymentSettingScaleUnitHostNetworkIntentAdapterPropertyOverride | undefined;
    private _qosPolicyOverride;
    get qosPolicyOverride(): StackHciDeploymentSettingScaleUnitHostNetworkIntentQosPolicyOverrideOutputReference;
    putQosPolicyOverride(value: StackHciDeploymentSettingScaleUnitHostNetworkIntentQosPolicyOverride): void;
    resetQosPolicyOverride(): void;
    get qosPolicyOverrideInput(): StackHciDeploymentSettingScaleUnitHostNetworkIntentQosPolicyOverride | undefined;
    private _virtualSwitchConfigurationOverride;
    get virtualSwitchConfigurationOverride(): StackHciDeploymentSettingScaleUnitHostNetworkIntentVirtualSwitchConfigurationOverrideOutputReference;
    putVirtualSwitchConfigurationOverride(value: StackHciDeploymentSettingScaleUnitHostNetworkIntentVirtualSwitchConfigurationOverride): void;
    resetVirtualSwitchConfigurationOverride(): void;
    get virtualSwitchConfigurationOverrideInput(): StackHciDeploymentSettingScaleUnitHostNetworkIntentVirtualSwitchConfigurationOverride | undefined;
}
export declare class StackHciDeploymentSettingScaleUnitHostNetworkIntentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StackHciDeploymentSettingScaleUnitHostNetworkIntent[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StackHciDeploymentSettingScaleUnitHostNetworkIntentOutputReference;
}
export interface StackHciDeploymentSettingScaleUnitHostNetworkStorageNetwork {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#name StackHciDeploymentSetting#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#network_adapter_name StackHciDeploymentSetting#network_adapter_name}
    */
    readonly networkAdapterName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#vlan_id StackHciDeploymentSetting#vlan_id}
    */
    readonly vlanId: string;
}
export declare function stackHciDeploymentSettingScaleUnitHostNetworkStorageNetworkToTerraform(struct?: StackHciDeploymentSettingScaleUnitHostNetworkStorageNetwork | cdktf.IResolvable): any;
export declare function stackHciDeploymentSettingScaleUnitHostNetworkStorageNetworkToHclTerraform(struct?: StackHciDeploymentSettingScaleUnitHostNetworkStorageNetwork | cdktf.IResolvable): any;
export declare class StackHciDeploymentSettingScaleUnitHostNetworkStorageNetworkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StackHciDeploymentSettingScaleUnitHostNetworkStorageNetwork | cdktf.IResolvable | undefined;
    set internalValue(value: StackHciDeploymentSettingScaleUnitHostNetworkStorageNetwork | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkAdapterName?;
    get networkAdapterName(): string;
    set networkAdapterName(value: string);
    get networkAdapterNameInput(): string | undefined;
    private _vlanId?;
    get vlanId(): string;
    set vlanId(value: string);
    get vlanIdInput(): string | undefined;
}
export declare class StackHciDeploymentSettingScaleUnitHostNetworkStorageNetworkList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StackHciDeploymentSettingScaleUnitHostNetworkStorageNetwork[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StackHciDeploymentSettingScaleUnitHostNetworkStorageNetworkOutputReference;
}
export interface StackHciDeploymentSettingScaleUnitHostNetwork {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#storage_auto_ip_enabled StackHciDeploymentSetting#storage_auto_ip_enabled}
    */
    readonly storageAutoIpEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#storage_connectivity_switchless_enabled StackHciDeploymentSetting#storage_connectivity_switchless_enabled}
    */
    readonly storageConnectivitySwitchlessEnabled?: boolean | cdktf.IResolvable;
    /**
    * intent block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#intent StackHciDeploymentSetting#intent}
    */
    readonly intent: StackHciDeploymentSettingScaleUnitHostNetworkIntent[] | cdktf.IResolvable;
    /**
    * storage_network block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#storage_network StackHciDeploymentSetting#storage_network}
    */
    readonly storageNetwork: StackHciDeploymentSettingScaleUnitHostNetworkStorageNetwork[] | cdktf.IResolvable;
}
export declare function stackHciDeploymentSettingScaleUnitHostNetworkToTerraform(struct?: StackHciDeploymentSettingScaleUnitHostNetworkOutputReference | StackHciDeploymentSettingScaleUnitHostNetwork): any;
export declare function stackHciDeploymentSettingScaleUnitHostNetworkToHclTerraform(struct?: StackHciDeploymentSettingScaleUnitHostNetworkOutputReference | StackHciDeploymentSettingScaleUnitHostNetwork): any;
export declare class StackHciDeploymentSettingScaleUnitHostNetworkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StackHciDeploymentSettingScaleUnitHostNetwork | undefined;
    set internalValue(value: StackHciDeploymentSettingScaleUnitHostNetwork | undefined);
    private _storageAutoIpEnabled?;
    get storageAutoIpEnabled(): boolean | cdktf.IResolvable;
    set storageAutoIpEnabled(value: boolean | cdktf.IResolvable);
    resetStorageAutoIpEnabled(): void;
    get storageAutoIpEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _storageConnectivitySwitchlessEnabled?;
    get storageConnectivitySwitchlessEnabled(): boolean | cdktf.IResolvable;
    set storageConnectivitySwitchlessEnabled(value: boolean | cdktf.IResolvable);
    resetStorageConnectivitySwitchlessEnabled(): void;
    get storageConnectivitySwitchlessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _intent;
    get intent(): StackHciDeploymentSettingScaleUnitHostNetworkIntentList;
    putIntent(value: StackHciDeploymentSettingScaleUnitHostNetworkIntent[] | cdktf.IResolvable): void;
    get intentInput(): cdktf.IResolvable | StackHciDeploymentSettingScaleUnitHostNetworkIntent[] | undefined;
    private _storageNetwork;
    get storageNetwork(): StackHciDeploymentSettingScaleUnitHostNetworkStorageNetworkList;
    putStorageNetwork(value: StackHciDeploymentSettingScaleUnitHostNetworkStorageNetwork[] | cdktf.IResolvable): void;
    get storageNetworkInput(): cdktf.IResolvable | StackHciDeploymentSettingScaleUnitHostNetworkStorageNetwork[] | undefined;
}
export interface StackHciDeploymentSettingScaleUnitInfrastructureNetworkIpPool {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#ending_address StackHciDeploymentSetting#ending_address}
    */
    readonly endingAddress: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#starting_address StackHciDeploymentSetting#starting_address}
    */
    readonly startingAddress: string;
}
export declare function stackHciDeploymentSettingScaleUnitInfrastructureNetworkIpPoolToTerraform(struct?: StackHciDeploymentSettingScaleUnitInfrastructureNetworkIpPool | cdktf.IResolvable): any;
export declare function stackHciDeploymentSettingScaleUnitInfrastructureNetworkIpPoolToHclTerraform(struct?: StackHciDeploymentSettingScaleUnitInfrastructureNetworkIpPool | cdktf.IResolvable): any;
export declare class StackHciDeploymentSettingScaleUnitInfrastructureNetworkIpPoolOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StackHciDeploymentSettingScaleUnitInfrastructureNetworkIpPool | cdktf.IResolvable | undefined;
    set internalValue(value: StackHciDeploymentSettingScaleUnitInfrastructureNetworkIpPool | cdktf.IResolvable | undefined);
    private _endingAddress?;
    get endingAddress(): string;
    set endingAddress(value: string);
    get endingAddressInput(): string | undefined;
    private _startingAddress?;
    get startingAddress(): string;
    set startingAddress(value: string);
    get startingAddressInput(): string | undefined;
}
export declare class StackHciDeploymentSettingScaleUnitInfrastructureNetworkIpPoolList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StackHciDeploymentSettingScaleUnitInfrastructureNetworkIpPool[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StackHciDeploymentSettingScaleUnitInfrastructureNetworkIpPoolOutputReference;
}
export interface StackHciDeploymentSettingScaleUnitInfrastructureNetwork {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#dhcp_enabled StackHciDeploymentSetting#dhcp_enabled}
    */
    readonly dhcpEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#dns_server StackHciDeploymentSetting#dns_server}
    */
    readonly dnsServer: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#gateway StackHciDeploymentSetting#gateway}
    */
    readonly gateway: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#subnet_mask StackHciDeploymentSetting#subnet_mask}
    */
    readonly subnetMask: string;
    /**
    * ip_pool block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#ip_pool StackHciDeploymentSetting#ip_pool}
    */
    readonly ipPool: StackHciDeploymentSettingScaleUnitInfrastructureNetworkIpPool[] | cdktf.IResolvable;
}
export declare function stackHciDeploymentSettingScaleUnitInfrastructureNetworkToTerraform(struct?: StackHciDeploymentSettingScaleUnitInfrastructureNetwork | cdktf.IResolvable): any;
export declare function stackHciDeploymentSettingScaleUnitInfrastructureNetworkToHclTerraform(struct?: StackHciDeploymentSettingScaleUnitInfrastructureNetwork | cdktf.IResolvable): any;
export declare class StackHciDeploymentSettingScaleUnitInfrastructureNetworkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StackHciDeploymentSettingScaleUnitInfrastructureNetwork | cdktf.IResolvable | undefined;
    set internalValue(value: StackHciDeploymentSettingScaleUnitInfrastructureNetwork | cdktf.IResolvable | undefined);
    private _dhcpEnabled?;
    get dhcpEnabled(): boolean | cdktf.IResolvable;
    set dhcpEnabled(value: boolean | cdktf.IResolvable);
    resetDhcpEnabled(): void;
    get dhcpEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _dnsServer?;
    get dnsServer(): string[];
    set dnsServer(value: string[]);
    get dnsServerInput(): string[] | undefined;
    private _gateway?;
    get gateway(): string;
    set gateway(value: string);
    get gatewayInput(): string | undefined;
    private _subnetMask?;
    get subnetMask(): string;
    set subnetMask(value: string);
    get subnetMaskInput(): string | undefined;
    private _ipPool;
    get ipPool(): StackHciDeploymentSettingScaleUnitInfrastructureNetworkIpPoolList;
    putIpPool(value: StackHciDeploymentSettingScaleUnitInfrastructureNetworkIpPool[] | cdktf.IResolvable): void;
    get ipPoolInput(): cdktf.IResolvable | StackHciDeploymentSettingScaleUnitInfrastructureNetworkIpPool[] | undefined;
}
export declare class StackHciDeploymentSettingScaleUnitInfrastructureNetworkList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StackHciDeploymentSettingScaleUnitInfrastructureNetwork[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StackHciDeploymentSettingScaleUnitInfrastructureNetworkOutputReference;
}
export interface StackHciDeploymentSettingScaleUnitOptionalService {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#custom_location StackHciDeploymentSetting#custom_location}
    */
    readonly customLocation: string;
}
export declare function stackHciDeploymentSettingScaleUnitOptionalServiceToTerraform(struct?: StackHciDeploymentSettingScaleUnitOptionalServiceOutputReference | StackHciDeploymentSettingScaleUnitOptionalService): any;
export declare function stackHciDeploymentSettingScaleUnitOptionalServiceToHclTerraform(struct?: StackHciDeploymentSettingScaleUnitOptionalServiceOutputReference | StackHciDeploymentSettingScaleUnitOptionalService): any;
export declare class StackHciDeploymentSettingScaleUnitOptionalServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StackHciDeploymentSettingScaleUnitOptionalService | undefined;
    set internalValue(value: StackHciDeploymentSettingScaleUnitOptionalService | undefined);
    private _customLocation?;
    get customLocation(): string;
    set customLocation(value: string);
    get customLocationInput(): string | undefined;
}
export interface StackHciDeploymentSettingScaleUnitPhysicalNode {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#ipv4_address StackHciDeploymentSetting#ipv4_address}
    */
    readonly ipv4Address: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#name StackHciDeploymentSetting#name}
    */
    readonly name: string;
}
export declare function stackHciDeploymentSettingScaleUnitPhysicalNodeToTerraform(struct?: StackHciDeploymentSettingScaleUnitPhysicalNode | cdktf.IResolvable): any;
export declare function stackHciDeploymentSettingScaleUnitPhysicalNodeToHclTerraform(struct?: StackHciDeploymentSettingScaleUnitPhysicalNode | cdktf.IResolvable): any;
export declare class StackHciDeploymentSettingScaleUnitPhysicalNodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StackHciDeploymentSettingScaleUnitPhysicalNode | cdktf.IResolvable | undefined;
    set internalValue(value: StackHciDeploymentSettingScaleUnitPhysicalNode | cdktf.IResolvable | undefined);
    private _ipv4Address?;
    get ipv4Address(): string;
    set ipv4Address(value: string);
    get ipv4AddressInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class StackHciDeploymentSettingScaleUnitPhysicalNodeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StackHciDeploymentSettingScaleUnitPhysicalNode[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StackHciDeploymentSettingScaleUnitPhysicalNodeOutputReference;
}
export interface StackHciDeploymentSettingScaleUnitStorage {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#configuration_mode StackHciDeploymentSetting#configuration_mode}
    */
    readonly configurationMode: string;
}
export declare function stackHciDeploymentSettingScaleUnitStorageToTerraform(struct?: StackHciDeploymentSettingScaleUnitStorageOutputReference | StackHciDeploymentSettingScaleUnitStorage): any;
export declare function stackHciDeploymentSettingScaleUnitStorageToHclTerraform(struct?: StackHciDeploymentSettingScaleUnitStorageOutputReference | StackHciDeploymentSettingScaleUnitStorage): any;
export declare class StackHciDeploymentSettingScaleUnitStorageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StackHciDeploymentSettingScaleUnitStorage | undefined;
    set internalValue(value: StackHciDeploymentSettingScaleUnitStorage | undefined);
    private _configurationMode?;
    get configurationMode(): string;
    set configurationMode(value: string);
    get configurationModeInput(): string | undefined;
}
export interface StackHciDeploymentSettingScaleUnit {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#active_directory_organizational_unit_path StackHciDeploymentSetting#active_directory_organizational_unit_path}
    */
    readonly activeDirectoryOrganizationalUnitPath: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#bitlocker_boot_volume_enabled StackHciDeploymentSetting#bitlocker_boot_volume_enabled}
    */
    readonly bitlockerBootVolumeEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#bitlocker_data_volume_enabled StackHciDeploymentSetting#bitlocker_data_volume_enabled}
    */
    readonly bitlockerDataVolumeEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#credential_guard_enabled StackHciDeploymentSetting#credential_guard_enabled}
    */
    readonly credentialGuardEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#domain_fqdn StackHciDeploymentSetting#domain_fqdn}
    */
    readonly domainFqdn: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#drift_control_enabled StackHciDeploymentSetting#drift_control_enabled}
    */
    readonly driftControlEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#drtm_protection_enabled StackHciDeploymentSetting#drtm_protection_enabled}
    */
    readonly drtmProtectionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#episodic_data_upload_enabled StackHciDeploymentSetting#episodic_data_upload_enabled}
    */
    readonly episodicDataUploadEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#eu_location_enabled StackHciDeploymentSetting#eu_location_enabled}
    */
    readonly euLocationEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#hvci_protection_enabled StackHciDeploymentSetting#hvci_protection_enabled}
    */
    readonly hvciProtectionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#name_prefix StackHciDeploymentSetting#name_prefix}
    */
    readonly namePrefix: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#secrets_location StackHciDeploymentSetting#secrets_location}
    */
    readonly secretsLocation: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#side_channel_mitigation_enabled StackHciDeploymentSetting#side_channel_mitigation_enabled}
    */
    readonly sideChannelMitigationEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#smb_cluster_encryption_enabled StackHciDeploymentSetting#smb_cluster_encryption_enabled}
    */
    readonly smbClusterEncryptionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#smb_signing_enabled StackHciDeploymentSetting#smb_signing_enabled}
    */
    readonly smbSigningEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#streaming_data_client_enabled StackHciDeploymentSetting#streaming_data_client_enabled}
    */
    readonly streamingDataClientEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#wdac_enabled StackHciDeploymentSetting#wdac_enabled}
    */
    readonly wdacEnabled?: boolean | cdktf.IResolvable;
    /**
    * cluster block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#cluster StackHciDeploymentSetting#cluster}
    */
    readonly cluster: StackHciDeploymentSettingScaleUnitCluster;
    /**
    * host_network block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#host_network StackHciDeploymentSetting#host_network}
    */
    readonly hostNetwork: StackHciDeploymentSettingScaleUnitHostNetwork;
    /**
    * infrastructure_network block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#infrastructure_network StackHciDeploymentSetting#infrastructure_network}
    */
    readonly infrastructureNetwork: StackHciDeploymentSettingScaleUnitInfrastructureNetwork[] | cdktf.IResolvable;
    /**
    * optional_service block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#optional_service StackHciDeploymentSetting#optional_service}
    */
    readonly optionalService: StackHciDeploymentSettingScaleUnitOptionalService;
    /**
    * physical_node block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#physical_node StackHciDeploymentSetting#physical_node}
    */
    readonly physicalNode: StackHciDeploymentSettingScaleUnitPhysicalNode[] | cdktf.IResolvable;
    /**
    * storage block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#storage StackHciDeploymentSetting#storage}
    */
    readonly storage: StackHciDeploymentSettingScaleUnitStorage;
}
export declare function stackHciDeploymentSettingScaleUnitToTerraform(struct?: StackHciDeploymentSettingScaleUnit | cdktf.IResolvable): any;
export declare function stackHciDeploymentSettingScaleUnitToHclTerraform(struct?: StackHciDeploymentSettingScaleUnit | cdktf.IResolvable): any;
export declare class StackHciDeploymentSettingScaleUnitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StackHciDeploymentSettingScaleUnit | cdktf.IResolvable | undefined;
    set internalValue(value: StackHciDeploymentSettingScaleUnit | cdktf.IResolvable | undefined);
    private _activeDirectoryOrganizationalUnitPath?;
    get activeDirectoryOrganizationalUnitPath(): string;
    set activeDirectoryOrganizationalUnitPath(value: string);
    get activeDirectoryOrganizationalUnitPathInput(): string | undefined;
    private _bitlockerBootVolumeEnabled?;
    get bitlockerBootVolumeEnabled(): boolean | cdktf.IResolvable;
    set bitlockerBootVolumeEnabled(value: boolean | cdktf.IResolvable);
    resetBitlockerBootVolumeEnabled(): void;
    get bitlockerBootVolumeEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _bitlockerDataVolumeEnabled?;
    get bitlockerDataVolumeEnabled(): boolean | cdktf.IResolvable;
    set bitlockerDataVolumeEnabled(value: boolean | cdktf.IResolvable);
    resetBitlockerDataVolumeEnabled(): void;
    get bitlockerDataVolumeEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _credentialGuardEnabled?;
    get credentialGuardEnabled(): boolean | cdktf.IResolvable;
    set credentialGuardEnabled(value: boolean | cdktf.IResolvable);
    resetCredentialGuardEnabled(): void;
    get credentialGuardEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _domainFqdn?;
    get domainFqdn(): string;
    set domainFqdn(value: string);
    get domainFqdnInput(): string | undefined;
    private _driftControlEnabled?;
    get driftControlEnabled(): boolean | cdktf.IResolvable;
    set driftControlEnabled(value: boolean | cdktf.IResolvable);
    resetDriftControlEnabled(): void;
    get driftControlEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _drtmProtectionEnabled?;
    get drtmProtectionEnabled(): boolean | cdktf.IResolvable;
    set drtmProtectionEnabled(value: boolean | cdktf.IResolvable);
    resetDrtmProtectionEnabled(): void;
    get drtmProtectionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _episodicDataUploadEnabled?;
    get episodicDataUploadEnabled(): boolean | cdktf.IResolvable;
    set episodicDataUploadEnabled(value: boolean | cdktf.IResolvable);
    resetEpisodicDataUploadEnabled(): void;
    get episodicDataUploadEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _euLocationEnabled?;
    get euLocationEnabled(): boolean | cdktf.IResolvable;
    set euLocationEnabled(value: boolean | cdktf.IResolvable);
    resetEuLocationEnabled(): void;
    get euLocationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _hvciProtectionEnabled?;
    get hvciProtectionEnabled(): boolean | cdktf.IResolvable;
    set hvciProtectionEnabled(value: boolean | cdktf.IResolvable);
    resetHvciProtectionEnabled(): void;
    get hvciProtectionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _namePrefix?;
    get namePrefix(): string;
    set namePrefix(value: string);
    get namePrefixInput(): string | undefined;
    private _secretsLocation?;
    get secretsLocation(): string;
    set secretsLocation(value: string);
    get secretsLocationInput(): string | undefined;
    private _sideChannelMitigationEnabled?;
    get sideChannelMitigationEnabled(): boolean | cdktf.IResolvable;
    set sideChannelMitigationEnabled(value: boolean | cdktf.IResolvable);
    resetSideChannelMitigationEnabled(): void;
    get sideChannelMitigationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _smbClusterEncryptionEnabled?;
    get smbClusterEncryptionEnabled(): boolean | cdktf.IResolvable;
    set smbClusterEncryptionEnabled(value: boolean | cdktf.IResolvable);
    resetSmbClusterEncryptionEnabled(): void;
    get smbClusterEncryptionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _smbSigningEnabled?;
    get smbSigningEnabled(): boolean | cdktf.IResolvable;
    set smbSigningEnabled(value: boolean | cdktf.IResolvable);
    resetSmbSigningEnabled(): void;
    get smbSigningEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _streamingDataClientEnabled?;
    get streamingDataClientEnabled(): boolean | cdktf.IResolvable;
    set streamingDataClientEnabled(value: boolean | cdktf.IResolvable);
    resetStreamingDataClientEnabled(): void;
    get streamingDataClientEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _wdacEnabled?;
    get wdacEnabled(): boolean | cdktf.IResolvable;
    set wdacEnabled(value: boolean | cdktf.IResolvable);
    resetWdacEnabled(): void;
    get wdacEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _cluster;
    get cluster(): StackHciDeploymentSettingScaleUnitClusterOutputReference;
    putCluster(value: StackHciDeploymentSettingScaleUnitCluster): void;
    get clusterInput(): StackHciDeploymentSettingScaleUnitCluster | undefined;
    private _hostNetwork;
    get hostNetwork(): StackHciDeploymentSettingScaleUnitHostNetworkOutputReference;
    putHostNetwork(value: StackHciDeploymentSettingScaleUnitHostNetwork): void;
    get hostNetworkInput(): StackHciDeploymentSettingScaleUnitHostNetwork | undefined;
    private _infrastructureNetwork;
    get infrastructureNetwork(): StackHciDeploymentSettingScaleUnitInfrastructureNetworkList;
    putInfrastructureNetwork(value: StackHciDeploymentSettingScaleUnitInfrastructureNetwork[] | cdktf.IResolvable): void;
    get infrastructureNetworkInput(): cdktf.IResolvable | StackHciDeploymentSettingScaleUnitInfrastructureNetwork[] | undefined;
    private _optionalService;
    get optionalService(): StackHciDeploymentSettingScaleUnitOptionalServiceOutputReference;
    putOptionalService(value: StackHciDeploymentSettingScaleUnitOptionalService): void;
    get optionalServiceInput(): StackHciDeploymentSettingScaleUnitOptionalService | undefined;
    private _physicalNode;
    get physicalNode(): StackHciDeploymentSettingScaleUnitPhysicalNodeList;
    putPhysicalNode(value: StackHciDeploymentSettingScaleUnitPhysicalNode[] | cdktf.IResolvable): void;
    get physicalNodeInput(): cdktf.IResolvable | StackHciDeploymentSettingScaleUnitPhysicalNode[] | undefined;
    private _storage;
    get storage(): StackHciDeploymentSettingScaleUnitStorageOutputReference;
    putStorage(value: StackHciDeploymentSettingScaleUnitStorage): void;
    get storageInput(): StackHciDeploymentSettingScaleUnitStorage | undefined;
}
export declare class StackHciDeploymentSettingScaleUnitList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StackHciDeploymentSettingScaleUnit[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StackHciDeploymentSettingScaleUnitOutputReference;
}
export interface StackHciDeploymentSettingTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#create StackHciDeploymentSetting#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#delete StackHciDeploymentSetting#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#read StackHciDeploymentSetting#read}
    */
    readonly read?: string;
}
export declare function stackHciDeploymentSettingTimeoutsToTerraform(struct?: StackHciDeploymentSettingTimeouts | cdktf.IResolvable): any;
export declare function stackHciDeploymentSettingTimeoutsToHclTerraform(struct?: StackHciDeploymentSettingTimeouts | cdktf.IResolvable): any;
export declare class StackHciDeploymentSettingTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StackHciDeploymentSettingTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: StackHciDeploymentSettingTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting azurerm_stack_hci_deployment_setting}
*/
export declare class StackHciDeploymentSetting extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_stack_hci_deployment_setting";
    /**
    * Generates CDKTF code for importing a StackHciDeploymentSetting resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the StackHciDeploymentSetting to import
    * @param importFromId The id of the existing StackHciDeploymentSetting that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the StackHciDeploymentSetting to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_deployment_setting azurerm_stack_hci_deployment_setting} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StackHciDeploymentSettingConfig
    */
    constructor(scope: Construct, id: string, config: StackHciDeploymentSettingConfig);
    private _arcResourceIds?;
    get arcResourceIds(): string[];
    set arcResourceIds(value: string[]);
    get arcResourceIdsInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _stackHciClusterId?;
    get stackHciClusterId(): string;
    set stackHciClusterId(value: string);
    get stackHciClusterIdInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
    private _scaleUnit;
    get scaleUnit(): StackHciDeploymentSettingScaleUnitList;
    putScaleUnit(value: StackHciDeploymentSettingScaleUnit[] | cdktf.IResolvable): void;
    get scaleUnitInput(): cdktf.IResolvable | StackHciDeploymentSettingScaleUnit[] | undefined;
    private _timeouts;
    get timeouts(): StackHciDeploymentSettingTimeoutsOutputReference;
    putTimeouts(value: StackHciDeploymentSettingTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | StackHciDeploymentSettingTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
