/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StackHciLogicalNetworkConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_logical_network#custom_location_id StackHciLogicalNetwork#custom_location_id}
    */
    readonly customLocationId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_logical_network#dns_servers StackHciLogicalNetwork#dns_servers}
    */
    readonly dnsServers?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_logical_network#id StackHciLogicalNetwork#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_logical_network#location StackHciLogicalNetwork#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_logical_network#name StackHciLogicalNetwork#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_logical_network#resource_group_name StackHciLogicalNetwork#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_logical_network#tags StackHciLogicalNetwork#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_logical_network#virtual_switch_name StackHciLogicalNetwork#virtual_switch_name}
    */
    readonly virtualSwitchName: string;
    /**
    * subnet block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_logical_network#subnet StackHciLogicalNetwork#subnet}
    */
    readonly subnet: StackHciLogicalNetworkSubnet;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_logical_network#timeouts StackHciLogicalNetwork#timeouts}
    */
    readonly timeouts?: StackHciLogicalNetworkTimeouts;
}
export interface StackHciLogicalNetworkSubnetIpPool {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_logical_network#end StackHciLogicalNetwork#end}
    */
    readonly end: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_logical_network#start StackHciLogicalNetwork#start}
    */
    readonly start: string;
}
export declare function stackHciLogicalNetworkSubnetIpPoolToTerraform(struct?: StackHciLogicalNetworkSubnetIpPool | cdktf.IResolvable): any;
export declare function stackHciLogicalNetworkSubnetIpPoolToHclTerraform(struct?: StackHciLogicalNetworkSubnetIpPool | cdktf.IResolvable): any;
export declare class StackHciLogicalNetworkSubnetIpPoolOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StackHciLogicalNetworkSubnetIpPool | cdktf.IResolvable | undefined;
    set internalValue(value: StackHciLogicalNetworkSubnetIpPool | cdktf.IResolvable | undefined);
    private _end?;
    get end(): string;
    set end(value: string);
    get endInput(): string | undefined;
    private _start?;
    get start(): string;
    set start(value: string);
    get startInput(): string | undefined;
}
export declare class StackHciLogicalNetworkSubnetIpPoolList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StackHciLogicalNetworkSubnetIpPool[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StackHciLogicalNetworkSubnetIpPoolOutputReference;
}
export interface StackHciLogicalNetworkSubnetRoute {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_logical_network#address_prefix StackHciLogicalNetwork#address_prefix}
    */
    readonly addressPrefix: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_logical_network#name StackHciLogicalNetwork#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_logical_network#next_hop_ip_address StackHciLogicalNetwork#next_hop_ip_address}
    */
    readonly nextHopIpAddress: string;
}
export declare function stackHciLogicalNetworkSubnetRouteToTerraform(struct?: StackHciLogicalNetworkSubnetRouteOutputReference | StackHciLogicalNetworkSubnetRoute): any;
export declare function stackHciLogicalNetworkSubnetRouteToHclTerraform(struct?: StackHciLogicalNetworkSubnetRouteOutputReference | StackHciLogicalNetworkSubnetRoute): any;
export declare class StackHciLogicalNetworkSubnetRouteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StackHciLogicalNetworkSubnetRoute | undefined;
    set internalValue(value: StackHciLogicalNetworkSubnetRoute | undefined);
    private _addressPrefix?;
    get addressPrefix(): string;
    set addressPrefix(value: string);
    get addressPrefixInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _nextHopIpAddress?;
    get nextHopIpAddress(): string;
    set nextHopIpAddress(value: string);
    get nextHopIpAddressInput(): string | undefined;
}
export interface StackHciLogicalNetworkSubnet {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_logical_network#address_prefix StackHciLogicalNetwork#address_prefix}
    */
    readonly addressPrefix?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_logical_network#ip_allocation_method StackHciLogicalNetwork#ip_allocation_method}
    */
    readonly ipAllocationMethod: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_logical_network#vlan_id StackHciLogicalNetwork#vlan_id}
    */
    readonly vlanId?: number;
    /**
    * ip_pool block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_logical_network#ip_pool StackHciLogicalNetwork#ip_pool}
    */
    readonly ipPool?: StackHciLogicalNetworkSubnetIpPool[] | cdktf.IResolvable;
    /**
    * route block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_logical_network#route StackHciLogicalNetwork#route}
    */
    readonly route?: StackHciLogicalNetworkSubnetRoute;
}
export declare function stackHciLogicalNetworkSubnetToTerraform(struct?: StackHciLogicalNetworkSubnetOutputReference | StackHciLogicalNetworkSubnet): any;
export declare function stackHciLogicalNetworkSubnetToHclTerraform(struct?: StackHciLogicalNetworkSubnetOutputReference | StackHciLogicalNetworkSubnet): any;
export declare class StackHciLogicalNetworkSubnetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StackHciLogicalNetworkSubnet | undefined;
    set internalValue(value: StackHciLogicalNetworkSubnet | undefined);
    private _addressPrefix?;
    get addressPrefix(): string;
    set addressPrefix(value: string);
    resetAddressPrefix(): void;
    get addressPrefixInput(): string | undefined;
    private _ipAllocationMethod?;
    get ipAllocationMethod(): string;
    set ipAllocationMethod(value: string);
    get ipAllocationMethodInput(): string | undefined;
    private _vlanId?;
    get vlanId(): number;
    set vlanId(value: number);
    resetVlanId(): void;
    get vlanIdInput(): number | undefined;
    private _ipPool;
    get ipPool(): StackHciLogicalNetworkSubnetIpPoolList;
    putIpPool(value: StackHciLogicalNetworkSubnetIpPool[] | cdktf.IResolvable): void;
    resetIpPool(): void;
    get ipPoolInput(): cdktf.IResolvable | StackHciLogicalNetworkSubnetIpPool[] | undefined;
    private _route;
    get route(): StackHciLogicalNetworkSubnetRouteOutputReference;
    putRoute(value: StackHciLogicalNetworkSubnetRoute): void;
    resetRoute(): void;
    get routeInput(): StackHciLogicalNetworkSubnetRoute | undefined;
}
export interface StackHciLogicalNetworkTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_logical_network#create StackHciLogicalNetwork#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_logical_network#delete StackHciLogicalNetwork#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_logical_network#read StackHciLogicalNetwork#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_logical_network#update StackHciLogicalNetwork#update}
    */
    readonly update?: string;
}
export declare function stackHciLogicalNetworkTimeoutsToTerraform(struct?: StackHciLogicalNetworkTimeouts | cdktf.IResolvable): any;
export declare function stackHciLogicalNetworkTimeoutsToHclTerraform(struct?: StackHciLogicalNetworkTimeouts | cdktf.IResolvable): any;
export declare class StackHciLogicalNetworkTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StackHciLogicalNetworkTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: StackHciLogicalNetworkTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_logical_network azurerm_stack_hci_logical_network}
*/
export declare class StackHciLogicalNetwork extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_stack_hci_logical_network";
    /**
    * Generates CDKTF code for importing a StackHciLogicalNetwork resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the StackHciLogicalNetwork to import
    * @param importFromId The id of the existing StackHciLogicalNetwork that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_logical_network#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the StackHciLogicalNetwork to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/stack_hci_logical_network azurerm_stack_hci_logical_network} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StackHciLogicalNetworkConfig
    */
    constructor(scope: Construct, id: string, config: StackHciLogicalNetworkConfig);
    private _customLocationId?;
    get customLocationId(): string;
    set customLocationId(value: string);
    get customLocationIdInput(): string | undefined;
    private _dnsServers?;
    get dnsServers(): string[];
    set dnsServers(value: string[]);
    resetDnsServers(): void;
    get dnsServersInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _virtualSwitchName?;
    get virtualSwitchName(): string;
    set virtualSwitchName(value: string);
    get virtualSwitchNameInput(): string | undefined;
    private _subnet;
    get subnet(): StackHciLogicalNetworkSubnetOutputReference;
    putSubnet(value: StackHciLogicalNetworkSubnet): void;
    get subnetInput(): StackHciLogicalNetworkSubnet | undefined;
    private _timeouts;
    get timeouts(): StackHciLogicalNetworkTimeoutsOutputReference;
    putTimeouts(value: StackHciLogicalNetworkTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | StackHciLogicalNetworkTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
