/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VirtualMachineScaleSetStandbyPoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/virtual_machine_scale_set_standby_pool#attached_virtual_machine_scale_set_id VirtualMachineScaleSetStandbyPool#attached_virtual_machine_scale_set_id}
    */
    readonly attachedVirtualMachineScaleSetId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/virtual_machine_scale_set_standby_pool#id VirtualMachineScaleSetStandbyPool#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/virtual_machine_scale_set_standby_pool#location VirtualMachineScaleSetStandbyPool#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/virtual_machine_scale_set_standby_pool#name VirtualMachineScaleSetStandbyPool#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/virtual_machine_scale_set_standby_pool#resource_group_name VirtualMachineScaleSetStandbyPool#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/virtual_machine_scale_set_standby_pool#tags VirtualMachineScaleSetStandbyPool#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/virtual_machine_scale_set_standby_pool#virtual_machine_state VirtualMachineScaleSetStandbyPool#virtual_machine_state}
    */
    readonly virtualMachineState: string;
    /**
    * elasticity_profile block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/virtual_machine_scale_set_standby_pool#elasticity_profile VirtualMachineScaleSetStandbyPool#elasticity_profile}
    */
    readonly elasticityProfile: VirtualMachineScaleSetStandbyPoolElasticityProfile;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/virtual_machine_scale_set_standby_pool#timeouts VirtualMachineScaleSetStandbyPool#timeouts}
    */
    readonly timeouts?: VirtualMachineScaleSetStandbyPoolTimeouts;
}
export interface VirtualMachineScaleSetStandbyPoolElasticityProfile {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/virtual_machine_scale_set_standby_pool#max_ready_capacity VirtualMachineScaleSetStandbyPool#max_ready_capacity}
    */
    readonly maxReadyCapacity: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/virtual_machine_scale_set_standby_pool#min_ready_capacity VirtualMachineScaleSetStandbyPool#min_ready_capacity}
    */
    readonly minReadyCapacity: number;
}
export declare function virtualMachineScaleSetStandbyPoolElasticityProfileToTerraform(struct?: VirtualMachineScaleSetStandbyPoolElasticityProfileOutputReference | VirtualMachineScaleSetStandbyPoolElasticityProfile): any;
export declare function virtualMachineScaleSetStandbyPoolElasticityProfileToHclTerraform(struct?: VirtualMachineScaleSetStandbyPoolElasticityProfileOutputReference | VirtualMachineScaleSetStandbyPoolElasticityProfile): any;
export declare class VirtualMachineScaleSetStandbyPoolElasticityProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualMachineScaleSetStandbyPoolElasticityProfile | undefined;
    set internalValue(value: VirtualMachineScaleSetStandbyPoolElasticityProfile | undefined);
    private _maxReadyCapacity?;
    get maxReadyCapacity(): number;
    set maxReadyCapacity(value: number);
    get maxReadyCapacityInput(): number | undefined;
    private _minReadyCapacity?;
    get minReadyCapacity(): number;
    set minReadyCapacity(value: number);
    get minReadyCapacityInput(): number | undefined;
}
export interface VirtualMachineScaleSetStandbyPoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/virtual_machine_scale_set_standby_pool#create VirtualMachineScaleSetStandbyPool#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/virtual_machine_scale_set_standby_pool#delete VirtualMachineScaleSetStandbyPool#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/virtual_machine_scale_set_standby_pool#read VirtualMachineScaleSetStandbyPool#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/virtual_machine_scale_set_standby_pool#update VirtualMachineScaleSetStandbyPool#update}
    */
    readonly update?: string;
}
export declare function virtualMachineScaleSetStandbyPoolTimeoutsToTerraform(struct?: VirtualMachineScaleSetStandbyPoolTimeouts | cdktf.IResolvable): any;
export declare function virtualMachineScaleSetStandbyPoolTimeoutsToHclTerraform(struct?: VirtualMachineScaleSetStandbyPoolTimeouts | cdktf.IResolvable): any;
export declare class VirtualMachineScaleSetStandbyPoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualMachineScaleSetStandbyPoolTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: VirtualMachineScaleSetStandbyPoolTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/virtual_machine_scale_set_standby_pool azurerm_virtual_machine_scale_set_standby_pool}
*/
export declare class VirtualMachineScaleSetStandbyPool extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_virtual_machine_scale_set_standby_pool";
    /**
    * Generates CDKTF code for importing a VirtualMachineScaleSetStandbyPool resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the VirtualMachineScaleSetStandbyPool to import
    * @param importFromId The id of the existing VirtualMachineScaleSetStandbyPool that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/virtual_machine_scale_set_standby_pool#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the VirtualMachineScaleSetStandbyPool to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.38.1/docs/resources/virtual_machine_scale_set_standby_pool azurerm_virtual_machine_scale_set_standby_pool} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VirtualMachineScaleSetStandbyPoolConfig
    */
    constructor(scope: Construct, id: string, config: VirtualMachineScaleSetStandbyPoolConfig);
    private _attachedVirtualMachineScaleSetId?;
    get attachedVirtualMachineScaleSetId(): string;
    set attachedVirtualMachineScaleSetId(value: string);
    get attachedVirtualMachineScaleSetIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _virtualMachineState?;
    get virtualMachineState(): string;
    set virtualMachineState(value: string);
    get virtualMachineStateInput(): string | undefined;
    private _elasticityProfile;
    get elasticityProfile(): VirtualMachineScaleSetStandbyPoolElasticityProfileOutputReference;
    putElasticityProfile(value: VirtualMachineScaleSetStandbyPoolElasticityProfile): void;
    get elasticityProfileInput(): VirtualMachineScaleSetStandbyPoolElasticityProfile | undefined;
    private _timeouts;
    get timeouts(): VirtualMachineScaleSetStandbyPoolTimeoutsOutputReference;
    putTimeouts(value: VirtualMachineScaleSetStandbyPoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | VirtualMachineScaleSetStandbyPoolTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
