"""Code generated by Speakeasy (https://speakeasyapi.dev). DO NOT EDIT."""

from __future__ import annotations
import dataclasses
import dateutil.parser
from .location import Location
from dataclasses_json import Undefined, dataclass_json
from datetime import datetime
from shippo import utils
from typing import List, Optional


@dataclass_json(undefined=Undefined.EXCLUDE)
@dataclasses.dataclass
class PickupBase:
    carrier_account: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('carrier_account') }})
    r"""The object ID of your USPS or DHL Express carrier account.
    You can retrieve this from your Rate requests or our <a href=\"#tag/Carrier-Accounts/\">Carrier Accounts</a> endpoint.
    """
    location: Location = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('location') }})
    r"""Location where the parcel(s) will be picked up."""
    requested_end_time: datetime = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('requested_end_time'), 'encoder': utils.datetimeisoformat(False), 'decoder': dateutil.parser.isoparse }})
    r"""The latest that you requested your parcels to be available for pickup.
    Expressed in the timezone specified in the response.
    """
    requested_start_time: datetime = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('requested_start_time'), 'encoder': utils.datetimeisoformat(False), 'decoder': dateutil.parser.isoparse }})
    r"""The earliest that you requested your parcels to be ready for pickup.
    Expressed in the timezone specified in the response.
    """
    transactions: List[str] = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('transactions') }})
    r"""The transaction(s) object ID(s) for the parcel(s) that need to be picked up."""
    metadata: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('metadata'), 'exclude': lambda f: f is None }})
    r"""A string of up to 100 characters that can be filled with any additional information you
    want to attach to the object.
    """
    

