import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ConsumptionBudgetSubscriptionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription#amount ConsumptionBudgetSubscription#amount}
    */
    readonly amount: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription#etag ConsumptionBudgetSubscription#etag}
    */
    readonly etag?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription#name ConsumptionBudgetSubscription#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription#subscription_id ConsumptionBudgetSubscription#subscription_id}
    */
    readonly subscriptionId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription#time_grain ConsumptionBudgetSubscription#time_grain}
    */
    readonly timeGrain?: string;
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription#filter ConsumptionBudgetSubscription#filter}
    */
    readonly filter?: ConsumptionBudgetSubscriptionFilter;
    /**
    * notification block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription#notification ConsumptionBudgetSubscription#notification}
    */
    readonly notification: ConsumptionBudgetSubscriptionNotification[] | cdktf.IResolvable;
    /**
    * time_period block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription#time_period ConsumptionBudgetSubscription#time_period}
    */
    readonly timePeriod: ConsumptionBudgetSubscriptionTimePeriod;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription#timeouts ConsumptionBudgetSubscription#timeouts}
    */
    readonly timeouts?: ConsumptionBudgetSubscriptionTimeouts;
}
export interface ConsumptionBudgetSubscriptionFilterDimension {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription#name ConsumptionBudgetSubscription#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription#operator ConsumptionBudgetSubscription#operator}
    */
    readonly operator?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription#values ConsumptionBudgetSubscription#values}
    */
    readonly values: string[];
}
export declare function consumptionBudgetSubscriptionFilterDimensionToTerraform(struct?: ConsumptionBudgetSubscriptionFilterDimension | cdktf.IResolvable): any;
export interface ConsumptionBudgetSubscriptionFilterNotDimension {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription#name ConsumptionBudgetSubscription#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription#operator ConsumptionBudgetSubscription#operator}
    */
    readonly operator?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription#values ConsumptionBudgetSubscription#values}
    */
    readonly values: string[];
}
export declare function consumptionBudgetSubscriptionFilterNotDimensionToTerraform(struct?: ConsumptionBudgetSubscriptionFilterNotDimensionOutputReference | ConsumptionBudgetSubscriptionFilterNotDimension): any;
export declare class ConsumptionBudgetSubscriptionFilterNotDimensionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ConsumptionBudgetSubscriptionFilterNotDimension | undefined;
    set internalValue(value: ConsumptionBudgetSubscriptionFilterNotDimension | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface ConsumptionBudgetSubscriptionFilterNotTag {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription#name ConsumptionBudgetSubscription#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription#operator ConsumptionBudgetSubscription#operator}
    */
    readonly operator?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription#values ConsumptionBudgetSubscription#values}
    */
    readonly values: string[];
}
export declare function consumptionBudgetSubscriptionFilterNotTagToTerraform(struct?: ConsumptionBudgetSubscriptionFilterNotTagOutputReference | ConsumptionBudgetSubscriptionFilterNotTag): any;
export declare class ConsumptionBudgetSubscriptionFilterNotTagOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ConsumptionBudgetSubscriptionFilterNotTag | undefined;
    set internalValue(value: ConsumptionBudgetSubscriptionFilterNotTag | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface ConsumptionBudgetSubscriptionFilterNot {
    /**
    * dimension block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription#dimension ConsumptionBudgetSubscription#dimension}
    */
    readonly dimension?: ConsumptionBudgetSubscriptionFilterNotDimension;
    /**
    * tag block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription#tag ConsumptionBudgetSubscription#tag}
    */
    readonly tag?: ConsumptionBudgetSubscriptionFilterNotTag;
}
export declare function consumptionBudgetSubscriptionFilterNotToTerraform(struct?: ConsumptionBudgetSubscriptionFilterNotOutputReference | ConsumptionBudgetSubscriptionFilterNot): any;
export declare class ConsumptionBudgetSubscriptionFilterNotOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ConsumptionBudgetSubscriptionFilterNot | undefined;
    set internalValue(value: ConsumptionBudgetSubscriptionFilterNot | undefined);
    private _dimension;
    get dimension(): ConsumptionBudgetSubscriptionFilterNotDimensionOutputReference;
    putDimension(value: ConsumptionBudgetSubscriptionFilterNotDimension): void;
    resetDimension(): void;
    get dimensionInput(): ConsumptionBudgetSubscriptionFilterNotDimension | undefined;
    private _tag;
    get tag(): ConsumptionBudgetSubscriptionFilterNotTagOutputReference;
    putTag(value: ConsumptionBudgetSubscriptionFilterNotTag): void;
    resetTag(): void;
    get tagInput(): ConsumptionBudgetSubscriptionFilterNotTag | undefined;
}
export interface ConsumptionBudgetSubscriptionFilterTag {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription#name ConsumptionBudgetSubscription#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription#operator ConsumptionBudgetSubscription#operator}
    */
    readonly operator?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription#values ConsumptionBudgetSubscription#values}
    */
    readonly values: string[];
}
export declare function consumptionBudgetSubscriptionFilterTagToTerraform(struct?: ConsumptionBudgetSubscriptionFilterTag | cdktf.IResolvable): any;
export interface ConsumptionBudgetSubscriptionFilter {
    /**
    * dimension block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription#dimension ConsumptionBudgetSubscription#dimension}
    */
    readonly dimension?: ConsumptionBudgetSubscriptionFilterDimension[] | cdktf.IResolvable;
    /**
    * not block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription#not ConsumptionBudgetSubscription#not}
    */
    readonly not?: ConsumptionBudgetSubscriptionFilterNot;
    /**
    * tag block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription#tag ConsumptionBudgetSubscription#tag}
    */
    readonly tag?: ConsumptionBudgetSubscriptionFilterTag[] | cdktf.IResolvable;
}
export declare function consumptionBudgetSubscriptionFilterToTerraform(struct?: ConsumptionBudgetSubscriptionFilterOutputReference | ConsumptionBudgetSubscriptionFilter): any;
export declare class ConsumptionBudgetSubscriptionFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ConsumptionBudgetSubscriptionFilter | undefined;
    set internalValue(value: ConsumptionBudgetSubscriptionFilter | undefined);
    private _dimension?;
    get dimension(): ConsumptionBudgetSubscriptionFilterDimension[] | cdktf.IResolvable;
    set dimension(value: ConsumptionBudgetSubscriptionFilterDimension[] | cdktf.IResolvable);
    resetDimension(): void;
    get dimensionInput(): cdktf.IResolvable | ConsumptionBudgetSubscriptionFilterDimension[] | undefined;
    private _not;
    get not(): ConsumptionBudgetSubscriptionFilterNotOutputReference;
    putNot(value: ConsumptionBudgetSubscriptionFilterNot): void;
    resetNot(): void;
    get notInput(): ConsumptionBudgetSubscriptionFilterNot | undefined;
    private _tag?;
    get tag(): ConsumptionBudgetSubscriptionFilterTag[] | cdktf.IResolvable;
    set tag(value: ConsumptionBudgetSubscriptionFilterTag[] | cdktf.IResolvable);
    resetTag(): void;
    get tagInput(): cdktf.IResolvable | ConsumptionBudgetSubscriptionFilterTag[] | undefined;
}
export interface ConsumptionBudgetSubscriptionNotification {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription#contact_emails ConsumptionBudgetSubscription#contact_emails}
    */
    readonly contactEmails?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription#contact_groups ConsumptionBudgetSubscription#contact_groups}
    */
    readonly contactGroups?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription#contact_roles ConsumptionBudgetSubscription#contact_roles}
    */
    readonly contactRoles?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription#enabled ConsumptionBudgetSubscription#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription#operator ConsumptionBudgetSubscription#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription#threshold ConsumptionBudgetSubscription#threshold}
    */
    readonly threshold: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription#threshold_type ConsumptionBudgetSubscription#threshold_type}
    */
    readonly thresholdType?: string;
}
export declare function consumptionBudgetSubscriptionNotificationToTerraform(struct?: ConsumptionBudgetSubscriptionNotification | cdktf.IResolvable): any;
export interface ConsumptionBudgetSubscriptionTimePeriod {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription#end_date ConsumptionBudgetSubscription#end_date}
    */
    readonly endDate?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription#start_date ConsumptionBudgetSubscription#start_date}
    */
    readonly startDate: string;
}
export declare function consumptionBudgetSubscriptionTimePeriodToTerraform(struct?: ConsumptionBudgetSubscriptionTimePeriodOutputReference | ConsumptionBudgetSubscriptionTimePeriod): any;
export declare class ConsumptionBudgetSubscriptionTimePeriodOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ConsumptionBudgetSubscriptionTimePeriod | undefined;
    set internalValue(value: ConsumptionBudgetSubscriptionTimePeriod | undefined);
    private _endDate?;
    get endDate(): string;
    set endDate(value: string);
    resetEndDate(): void;
    get endDateInput(): string | undefined;
    private _startDate?;
    get startDate(): string;
    set startDate(value: string);
    get startDateInput(): string | undefined;
}
export interface ConsumptionBudgetSubscriptionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription#create ConsumptionBudgetSubscription#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription#delete ConsumptionBudgetSubscription#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription#read ConsumptionBudgetSubscription#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription#update ConsumptionBudgetSubscription#update}
    */
    readonly update?: string;
}
export declare function consumptionBudgetSubscriptionTimeoutsToTerraform(struct?: ConsumptionBudgetSubscriptionTimeoutsOutputReference | ConsumptionBudgetSubscriptionTimeouts | cdktf.IResolvable): any;
export declare class ConsumptionBudgetSubscriptionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ConsumptionBudgetSubscriptionTimeouts | undefined;
    set internalValue(value: ConsumptionBudgetSubscriptionTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription azurerm_consumption_budget_subscription}
*/
export declare class ConsumptionBudgetSubscription extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_consumption_budget_subscription";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription azurerm_consumption_budget_subscription} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ConsumptionBudgetSubscriptionConfig
    */
    constructor(scope: Construct, id: string, config: ConsumptionBudgetSubscriptionConfig);
    private _amount?;
    get amount(): number;
    set amount(value: number);
    get amountInput(): number | undefined;
    private _etag?;
    get etag(): string;
    set etag(value: string);
    resetEtag(): void;
    get etagInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _subscriptionId?;
    get subscriptionId(): string;
    set subscriptionId(value: string);
    get subscriptionIdInput(): string | undefined;
    private _timeGrain?;
    get timeGrain(): string;
    set timeGrain(value: string);
    resetTimeGrain(): void;
    get timeGrainInput(): string | undefined;
    private _filter;
    get filter(): ConsumptionBudgetSubscriptionFilterOutputReference;
    putFilter(value: ConsumptionBudgetSubscriptionFilter): void;
    resetFilter(): void;
    get filterInput(): ConsumptionBudgetSubscriptionFilter | undefined;
    private _notification?;
    get notification(): ConsumptionBudgetSubscriptionNotification[] | cdktf.IResolvable;
    set notification(value: ConsumptionBudgetSubscriptionNotification[] | cdktf.IResolvable);
    get notificationInput(): cdktf.IResolvable | ConsumptionBudgetSubscriptionNotification[] | undefined;
    private _timePeriod;
    get timePeriod(): ConsumptionBudgetSubscriptionTimePeriodOutputReference;
    putTimePeriod(value: ConsumptionBudgetSubscriptionTimePeriod): void;
    get timePeriodInput(): ConsumptionBudgetSubscriptionTimePeriod | undefined;
    private _timeouts;
    get timeouts(): ConsumptionBudgetSubscriptionTimeoutsOutputReference;
    putTimeouts(value: ConsumptionBudgetSubscriptionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ConsumptionBudgetSubscriptionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
