import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataLakeAnalyticsAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_analytics_account#default_store_account_name DataLakeAnalyticsAccount#default_store_account_name}
    */
    readonly defaultStoreAccountName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_analytics_account#location DataLakeAnalyticsAccount#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_analytics_account#name DataLakeAnalyticsAccount#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_analytics_account#resource_group_name DataLakeAnalyticsAccount#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_analytics_account#tags DataLakeAnalyticsAccount#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_analytics_account#tier DataLakeAnalyticsAccount#tier}
    */
    readonly tier?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_analytics_account#timeouts DataLakeAnalyticsAccount#timeouts}
    */
    readonly timeouts?: DataLakeAnalyticsAccountTimeouts;
}
export interface DataLakeAnalyticsAccountTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_analytics_account#create DataLakeAnalyticsAccount#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_analytics_account#delete DataLakeAnalyticsAccount#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_analytics_account#read DataLakeAnalyticsAccount#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_analytics_account#update DataLakeAnalyticsAccount#update}
    */
    readonly update?: string;
}
export declare function dataLakeAnalyticsAccountTimeoutsToTerraform(struct?: DataLakeAnalyticsAccountTimeoutsOutputReference | DataLakeAnalyticsAccountTimeouts | cdktf.IResolvable): any;
export declare class DataLakeAnalyticsAccountTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataLakeAnalyticsAccountTimeouts | undefined;
    set internalValue(value: DataLakeAnalyticsAccountTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_analytics_account azurerm_data_lake_analytics_account}
*/
export declare class DataLakeAnalyticsAccount extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_data_lake_analytics_account";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_analytics_account azurerm_data_lake_analytics_account} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataLakeAnalyticsAccountConfig
    */
    constructor(scope: Construct, id: string, config: DataLakeAnalyticsAccountConfig);
    private _defaultStoreAccountName?;
    get defaultStoreAccountName(): string;
    set defaultStoreAccountName(value: string);
    get defaultStoreAccountNameInput(): string | undefined;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tier?;
    get tier(): string;
    set tier(value: string);
    resetTier(): void;
    get tierInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataLakeAnalyticsAccountTimeoutsOutputReference;
    putTimeouts(value: DataLakeAnalyticsAccountTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataLakeAnalyticsAccountTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
