import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataLakeStoreConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store#encryption_state DataLakeStore#encryption_state}
    */
    readonly encryptionState?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store#encryption_type DataLakeStore#encryption_type}
    */
    readonly encryptionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store#firewall_allow_azure_ips DataLakeStore#firewall_allow_azure_ips}
    */
    readonly firewallAllowAzureIps?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store#firewall_state DataLakeStore#firewall_state}
    */
    readonly firewallState?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store#location DataLakeStore#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store#name DataLakeStore#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store#resource_group_name DataLakeStore#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store#tags DataLakeStore#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store#tier DataLakeStore#tier}
    */
    readonly tier?: string;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store#identity DataLakeStore#identity}
    */
    readonly identity?: DataLakeStoreIdentity;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store#timeouts DataLakeStore#timeouts}
    */
    readonly timeouts?: DataLakeStoreTimeouts;
}
export interface DataLakeStoreIdentity {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store#type DataLakeStore#type}
    */
    readonly type: string;
}
export declare function dataLakeStoreIdentityToTerraform(struct?: DataLakeStoreIdentityOutputReference | DataLakeStoreIdentity): any;
export declare class DataLakeStoreIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataLakeStoreIdentity | undefined;
    set internalValue(value: DataLakeStoreIdentity | undefined);
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface DataLakeStoreTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store#create DataLakeStore#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store#delete DataLakeStore#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store#read DataLakeStore#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store#update DataLakeStore#update}
    */
    readonly update?: string;
}
export declare function dataLakeStoreTimeoutsToTerraform(struct?: DataLakeStoreTimeoutsOutputReference | DataLakeStoreTimeouts | cdktf.IResolvable): any;
export declare class DataLakeStoreTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataLakeStoreTimeouts | undefined;
    set internalValue(value: DataLakeStoreTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store azurerm_data_lake_store}
*/
export declare class DataLakeStore extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_data_lake_store";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store azurerm_data_lake_store} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataLakeStoreConfig
    */
    constructor(scope: Construct, id: string, config: DataLakeStoreConfig);
    private _encryptionState?;
    get encryptionState(): string;
    set encryptionState(value: string);
    resetEncryptionState(): void;
    get encryptionStateInput(): string | undefined;
    private _encryptionType?;
    get encryptionType(): string;
    set encryptionType(value: string);
    resetEncryptionType(): void;
    get encryptionTypeInput(): string | undefined;
    get endpoint(): string;
    private _firewallAllowAzureIps?;
    get firewallAllowAzureIps(): string;
    set firewallAllowAzureIps(value: string);
    resetFirewallAllowAzureIps(): void;
    get firewallAllowAzureIpsInput(): string | undefined;
    private _firewallState?;
    get firewallState(): string;
    set firewallState(value: string);
    resetFirewallState(): void;
    get firewallStateInput(): string | undefined;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tier?;
    get tier(): string;
    set tier(value: string);
    resetTier(): void;
    get tierInput(): string | undefined;
    private _identity;
    get identity(): DataLakeStoreIdentityOutputReference;
    putIdentity(value: DataLakeStoreIdentity): void;
    resetIdentity(): void;
    get identityInput(): DataLakeStoreIdentity | undefined;
    private _timeouts;
    get timeouts(): DataLakeStoreTimeoutsOutputReference;
    putTimeouts(value: DataLakeStoreTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataLakeStoreTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
