import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataShareDatasetDataLakeGen1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_data_lake_gen1#data_lake_store_id DataShareDatasetDataLakeGen1#data_lake_store_id}
    */
    readonly dataLakeStoreId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_data_lake_gen1#data_share_id DataShareDatasetDataLakeGen1#data_share_id}
    */
    readonly dataShareId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_data_lake_gen1#file_name DataShareDatasetDataLakeGen1#file_name}
    */
    readonly fileName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_data_lake_gen1#folder_path DataShareDatasetDataLakeGen1#folder_path}
    */
    readonly folderPath: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_data_lake_gen1#name DataShareDatasetDataLakeGen1#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_data_lake_gen1#timeouts DataShareDatasetDataLakeGen1#timeouts}
    */
    readonly timeouts?: DataShareDatasetDataLakeGen1Timeouts;
}
export interface DataShareDatasetDataLakeGen1Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_data_lake_gen1#create DataShareDatasetDataLakeGen1#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_data_lake_gen1#delete DataShareDatasetDataLakeGen1#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_data_lake_gen1#read DataShareDatasetDataLakeGen1#read}
    */
    readonly read?: string;
}
export declare function dataShareDatasetDataLakeGen1TimeoutsToTerraform(struct?: DataShareDatasetDataLakeGen1TimeoutsOutputReference | DataShareDatasetDataLakeGen1Timeouts | cdktf.IResolvable): any;
export declare class DataShareDatasetDataLakeGen1TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataShareDatasetDataLakeGen1Timeouts | undefined;
    set internalValue(value: DataShareDatasetDataLakeGen1Timeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_data_lake_gen1 azurerm_data_share_dataset_data_lake_gen1}
*/
export declare class DataShareDatasetDataLakeGen1 extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_data_share_dataset_data_lake_gen1";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_data_lake_gen1 azurerm_data_share_dataset_data_lake_gen1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataShareDatasetDataLakeGen1Config
    */
    constructor(scope: Construct, id: string, config: DataShareDatasetDataLakeGen1Config);
    private _dataLakeStoreId?;
    get dataLakeStoreId(): string;
    set dataLakeStoreId(value: string);
    get dataLakeStoreIdInput(): string | undefined;
    private _dataShareId?;
    get dataShareId(): string;
    set dataShareId(value: string);
    get dataShareIdInput(): string | undefined;
    get displayName(): string;
    private _fileName?;
    get fileName(): string;
    set fileName(value: string);
    resetFileName(): void;
    get fileNameInput(): string | undefined;
    private _folderPath?;
    get folderPath(): string;
    set folderPath(value: string);
    get folderPathInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataShareDatasetDataLakeGen1TimeoutsOutputReference;
    putTimeouts(value: DataShareDatasetDataLakeGen1Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataShareDatasetDataLakeGen1Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
