import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IothubFallbackRouteAConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_fallback_route#condition IothubFallbackRouteA#condition}
    */
    readonly condition?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_fallback_route#enabled IothubFallbackRouteA#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_fallback_route#endpoint_names IothubFallbackRouteA#endpoint_names}
    */
    readonly endpointNames: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_fallback_route#iothub_name IothubFallbackRouteA#iothub_name}
    */
    readonly iothubName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_fallback_route#resource_group_name IothubFallbackRouteA#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_fallback_route#source IothubFallbackRouteA#source}
    */
    readonly source?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_fallback_route#timeouts IothubFallbackRouteA#timeouts}
    */
    readonly timeouts?: IothubFallbackRouteTimeouts;
}
export interface IothubFallbackRouteTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_fallback_route#create IothubFallbackRouteA#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_fallback_route#delete IothubFallbackRouteA#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_fallback_route#read IothubFallbackRouteA#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_fallback_route#update IothubFallbackRouteA#update}
    */
    readonly update?: string;
}
export declare function iothubFallbackRouteTimeoutsToTerraform(struct?: IothubFallbackRouteTimeoutsOutputReference | IothubFallbackRouteTimeouts | cdktf.IResolvable): any;
export declare class IothubFallbackRouteTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IothubFallbackRouteTimeouts | undefined;
    set internalValue(value: IothubFallbackRouteTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_fallback_route azurerm_iothub_fallback_route}
*/
export declare class IothubFallbackRouteA extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_iothub_fallback_route";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_fallback_route azurerm_iothub_fallback_route} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IothubFallbackRouteAConfig
    */
    constructor(scope: Construct, id: string, config: IothubFallbackRouteAConfig);
    private _condition?;
    get condition(): string;
    set condition(value: string);
    resetCondition(): void;
    get conditionInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _endpointNames?;
    get endpointNames(): string[];
    set endpointNames(value: string[]);
    get endpointNamesInput(): string[] | undefined;
    get id(): string;
    private _iothubName?;
    get iothubName(): string;
    set iothubName(value: string);
    get iothubNameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    resetSource(): void;
    get sourceInput(): string | undefined;
    private _timeouts;
    get timeouts(): IothubFallbackRouteTimeoutsOutputReference;
    putTimeouts(value: IothubFallbackRouteTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): IothubFallbackRouteTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
