import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MssqlFirewallRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_firewall_rule#end_ip_address MssqlFirewallRule#end_ip_address}
    */
    readonly endIpAddress: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_firewall_rule#name MssqlFirewallRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_firewall_rule#server_id MssqlFirewallRule#server_id}
    */
    readonly serverId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_firewall_rule#start_ip_address MssqlFirewallRule#start_ip_address}
    */
    readonly startIpAddress: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_firewall_rule#timeouts MssqlFirewallRule#timeouts}
    */
    readonly timeouts?: MssqlFirewallRuleTimeouts;
}
export interface MssqlFirewallRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_firewall_rule#create MssqlFirewallRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_firewall_rule#delete MssqlFirewallRule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_firewall_rule#read MssqlFirewallRule#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_firewall_rule#update MssqlFirewallRule#update}
    */
    readonly update?: string;
}
export declare function mssqlFirewallRuleTimeoutsToTerraform(struct?: MssqlFirewallRuleTimeoutsOutputReference | MssqlFirewallRuleTimeouts | cdktf.IResolvable): any;
export declare class MssqlFirewallRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MssqlFirewallRuleTimeouts | undefined;
    set internalValue(value: MssqlFirewallRuleTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_firewall_rule azurerm_mssql_firewall_rule}
*/
export declare class MssqlFirewallRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_mssql_firewall_rule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_firewall_rule azurerm_mssql_firewall_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MssqlFirewallRuleConfig
    */
    constructor(scope: Construct, id: string, config: MssqlFirewallRuleConfig);
    private _endIpAddress?;
    get endIpAddress(): string;
    set endIpAddress(value: string);
    get endIpAddressInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _serverId?;
    get serverId(): string;
    set serverId(value: string);
    get serverIdInput(): string | undefined;
    private _startIpAddress?;
    get startIpAddress(): string;
    set startIpAddress(value: string);
    get startIpAddressInput(): string | undefined;
    private _timeouts;
    get timeouts(): MssqlFirewallRuleTimeoutsOutputReference;
    putTimeouts(value: MssqlFirewallRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): MssqlFirewallRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
