import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VirtualDesktopHostPoolRegistrationInfoAConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_host_pool_registration_info#expiration_date VirtualDesktopHostPoolRegistrationInfoA#expiration_date}
    */
    readonly expirationDate: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_host_pool_registration_info#hostpool_id VirtualDesktopHostPoolRegistrationInfoA#hostpool_id}
    */
    readonly hostpoolId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_host_pool_registration_info#timeouts VirtualDesktopHostPoolRegistrationInfoA#timeouts}
    */
    readonly timeouts?: VirtualDesktopHostPoolRegistrationInfoTimeouts;
}
export interface VirtualDesktopHostPoolRegistrationInfoTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_host_pool_registration_info#create VirtualDesktopHostPoolRegistrationInfoA#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_host_pool_registration_info#delete VirtualDesktopHostPoolRegistrationInfoA#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_host_pool_registration_info#read VirtualDesktopHostPoolRegistrationInfoA#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_host_pool_registration_info#update VirtualDesktopHostPoolRegistrationInfoA#update}
    */
    readonly update?: string;
}
export declare function virtualDesktopHostPoolRegistrationInfoTimeoutsToTerraform(struct?: VirtualDesktopHostPoolRegistrationInfoTimeoutsOutputReference | VirtualDesktopHostPoolRegistrationInfoTimeouts | cdktf.IResolvable): any;
export declare class VirtualDesktopHostPoolRegistrationInfoTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualDesktopHostPoolRegistrationInfoTimeouts | undefined;
    set internalValue(value: VirtualDesktopHostPoolRegistrationInfoTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_host_pool_registration_info azurerm_virtual_desktop_host_pool_registration_info}
*/
export declare class VirtualDesktopHostPoolRegistrationInfoA extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_virtual_desktop_host_pool_registration_info";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_host_pool_registration_info azurerm_virtual_desktop_host_pool_registration_info} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VirtualDesktopHostPoolRegistrationInfoAConfig
    */
    constructor(scope: Construct, id: string, config: VirtualDesktopHostPoolRegistrationInfoAConfig);
    private _expirationDate?;
    get expirationDate(): string;
    set expirationDate(value: string);
    get expirationDateInput(): string | undefined;
    private _hostpoolId?;
    get hostpoolId(): string;
    set hostpoolId(value: string);
    get hostpoolIdInput(): string | undefined;
    get id(): string;
    get token(): string;
    private _timeouts;
    get timeouts(): VirtualDesktopHostPoolRegistrationInfoTimeoutsOutputReference;
    putTimeouts(value: VirtualDesktopHostPoolRegistrationInfoTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): VirtualDesktopHostPoolRegistrationInfoTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
