import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VirtualNetworkDnsServersConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_dns_servers#dns_servers VirtualNetworkDnsServers#dns_servers}
    */
    readonly dnsServers?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_dns_servers#virtual_network_id VirtualNetworkDnsServers#virtual_network_id}
    */
    readonly virtualNetworkId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_dns_servers#timeouts VirtualNetworkDnsServers#timeouts}
    */
    readonly timeouts?: VirtualNetworkDnsServersTimeouts;
}
export interface VirtualNetworkDnsServersTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_dns_servers#create VirtualNetworkDnsServers#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_dns_servers#delete VirtualNetworkDnsServers#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_dns_servers#read VirtualNetworkDnsServers#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_dns_servers#update VirtualNetworkDnsServers#update}
    */
    readonly update?: string;
}
export declare function virtualNetworkDnsServersTimeoutsToTerraform(struct?: VirtualNetworkDnsServersTimeoutsOutputReference | VirtualNetworkDnsServersTimeouts | cdktf.IResolvable): any;
export declare class VirtualNetworkDnsServersTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualNetworkDnsServersTimeouts | undefined;
    set internalValue(value: VirtualNetworkDnsServersTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_dns_servers azurerm_virtual_network_dns_servers}
*/
export declare class VirtualNetworkDnsServers extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_virtual_network_dns_servers";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_dns_servers azurerm_virtual_network_dns_servers} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VirtualNetworkDnsServersConfig
    */
    constructor(scope: Construct, id: string, config: VirtualNetworkDnsServersConfig);
    private _dnsServers?;
    get dnsServers(): string[];
    set dnsServers(value: string[]);
    resetDnsServers(): void;
    get dnsServersInput(): string[] | undefined;
    get id(): string;
    private _virtualNetworkId?;
    get virtualNetworkId(): string;
    set virtualNetworkId(value: string);
    get virtualNetworkIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): VirtualNetworkDnsServersTimeoutsOutputReference;
    putTimeouts(value: VirtualNetworkDnsServersTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): VirtualNetworkDnsServersTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
